<?php
/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
if(ZIBANMA_SYS_LINK != 'zibanma_com'){
	die('access deny');
}
class ZibanmaPage{
	private static $_page;
	private $links = array();
	
	private function __construct(){}
	
	public static function get_instance(){
		if(!(self::$_page instanceof self)){
			self::$_page = new self();
		}
		return self::$_page;
	}
	
	/**
	 * @param Object $set
	 * @param array $url
	 * @param Common $common
	 */
	public function links($set, $url, $common){
		$set->page_count = $set->count>0 ? ceil($set->count/$set->page_size) : 0;
		$url[2] = $set->category_id;
		$this->links[] = '<a href="'.$common->get_rewriter_url_arr($url).'">首页</a>';
		if($set->page_current > 1){
			$url[3] = $set->page_current-1;
			$this->links[] = '<a href="'.$common->get_rewriter_url_arr($url).'">上一页</a>';
		}else{
			$this->links[] = '<a href="javascript:void(0);">上一页</a>';
		}
		if($set->page_current < $set->page_count){
			$url[3] = $set->page_current+1;
			$this->links[] = '<a href="'.$common->get_rewriter_url_arr($url).'">下一页</a>';
		}else{
			$this->links[] = '<a href="javascript:void(0);">下一页</a>';
		}
		$url[3] = $set->page_count;
		$this->links[] = '<a href="'.$common->get_rewriter_url_arr($url).'">尾页</a>';
		return implode('&nbsp;&nbsp;', $this->links);
	}
}
?>