<?php
/**
 * 紫斑马软件
 * @author afan
 * @link http://www.zibanma.com
 */
if(ZIBANMA_SYS_LINK != 'zibanma_com'){
	die('access deny');
}
class ZibanmaRequest{
	private $_server_url;
	
	public function __construct(){
		$this->get_server_url();
	}
	
	public function get($get=''){
		$return = array();
		if($get==''){
			foreach ($_GET as $gk=>$gv){
				$return[$gk] = trim($gv);
			}
		}else{
			$return[$get] = trim($_GET[$get]);
		}
		return $return;
	}
	
	public function post($post=''){
		$return = array();
		if($post==''){
			foreach ($_POST as $pk=>$pv){
				$return[$pk] = trim($pv);
			}
		}else{
			$return[$post] = trim($_POST[$post]);
		}
		return $return;
	}
	
	public function get_server_url(){
		if(!$this->_server_url){
			$this->_server_url = $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
		}
	}
	
	public function get_parameter(){
		if(ZIBANMA_CONFIG_REWRITER == 1){
			return $this->get_rewriter_on();
		}
		if(ZIBANMA_CONFIG_REWRITER == 0){
			return $this->get_rewriter_off();
		}
		return 'error:ZIBANMA_CONFIG_REWRITER';
	}
	
	public function get_rewriter_off(){
		$param = explode('?', $this->_server_url);
		$param = explode('-', $param[1]);
		if(is_array($param) && $param[0]){
			return $param;
		}else{
			return array('home', 'index');
		}
		/*
		if(strpos($this->_server_url, '?') !== false){
			return explode('-', substr($this->_server_url, strpos($this->_server_url, '?')+1, strlen($this->_server_url)));
		}else{
			return array('home', 'index');
		}
		*/
	}
	
	public function get_rewriter_on(){
		$param = explode('/', $this->_server_url);
		$param = explode('-', $param[1]);
		if(is_array($param) && $param[0]){
			return $param;
		}else{
			return array('home', 'index');
		}
		
		/*
		if(in_array(substr($this->_server_url, strpos($this->_server_url, '/')+1, strlen($this->_server_url)), array('', 'index.html', 'index.php'))){
			return array('home', 'index');
		}
		if(strpos($this->_server_url, '/') !== false){
			return explode('-', substr($this->_server_url, strpos($this->_server_url, '/')+1, strlen($this->_server_url)));
		}else{
			return null;
		}
		*/
	}
	
}
?>