<?php
class ZibanmaThumbnail{
	private $src_path;
	private $src_width;
	private $src_height;
	private $src_type;
	private $dst_width;
	private $dst_height;
	private $dst_dir;
	private $image_handle;
	private $image_true_color;
	private $thumb_extends;
	private $thumb_name;
	private $thumb_path;
	private $thumb_status = false;
	
	public function __construct($dst_height=120,$dst_width=180){
		$this->set_dst_height($dst_height);
		$this->set_dst_width($dst_width);
	}
	
	public function set_dst_height($dst_height){
		$this->dst_height = $dst_height;
	}
	
	public function set_dst_width($dst_width){
		$this->dst_width = $dst_width;
	}
	
	public function build($srcPath){
		$arr = GetImageSize($srcPath);
		$this->src_path = $srcPath;
		$this->src_width = $arr[0];
		$this->src_height = $arr[1];
		$this->src_type = $arr[2];
		$this->dst_dir = dirname($srcPath);
		$this->image_handle();
		$this->image_true_color();
		$this->set_thumb_name();
		$this->create_thumbnail();
	}
	
	public function set_thumb_extends($extends){
		$this->thumb_extends = $extends;
	}
	
	public function image_handle(){
		switch($this->src_type){
			case 1:
				$this->image_handle = @ImageCreateFromGIF($this->src_path);
				$this->set_thumb_extends('.gif');
			break;
			case 2:
				$this->image_handle = @ImageCreateFromJPEG($this->src_path);
				$this->set_thumb_extends('.jpg');
			break;
			case 3:
				$this->image_handle = @ImageCreateFromPNG($this->src_path);
				$this->set_thumb_extends('.png');
			break;
		}
	}
	
	public function image_true_color(){
		$this->image_true_color = ImageCreateTrueColor($this->dst_width, $this->dst_height);
	}
	
	public function set_thumb_name(){
		$path = explode('.', basename($this->src_path));
		$path[0] = $path[0].'_small';
		$this->thumb_name = $this->dst_dir.DIRECTORY_SEPARATOR.implode('.', $path);
	}
	
	public function create_thumbnail(){
		imagecopyresized($this->image_true_color, $this->image_handle, 0, 0, 0, 0, $this->dst_width, $this->dst_height, $this->src_width, $this->src_height);
    	switch ($this->thumb_extends){
    		case '.gif' :
    			imagegif($this->image_true_color, $this->thumb_name);
    		break;
    		case '.jpg' :
    			imagejpeg($this->image_true_color, $this->thumb_name);
    		break;
    		case '.png' :
    			imagepng($this->image_true_color, $this->thumb_name);
    		break;
    	}
    	$this->thumb_status = true;
	}
	
	public function get_status(){
		return $this->thumb_status;
	}
}
?>