---
layout: post
title: 正则表达式的常用元素
description:组成正则表达式的常用元素有(来自vim-help手册)
keywords:vim,正则表达式 
author: 网络技术
date: 2012-10-08
category:软件使用 
tags:vim
id:vim_replace
---

## 1、替换（substitute）
 [range] s/pattern/string/ [c,e,g,i]5.1

 range 指的是范围，1,7 指从第一行至第七行，1,$ 指从第一行至最后一行，也就是整篇文章，也可以 % 代表。还记得吗？ % 是目前编辑的文章，# 是前一次编辑的文章。

- pattern 就是要被替换掉的字串，可以用 regexp 来表示。
- string 将 pattern 由 string 所取代。
- c confirm，每次替换前会询问。
- e 不显示 error。
- g globe，不询问，整行替换。
- i ignore 不分大小写。
- g 大概都是要加的，否则只会替换每一行的第一个符合字串。可以合起来用，如 cgi，表示不分大小写，整行替换，替换前要询问是否替换。
- [实例] :%s/Edwin/Edward/g
- 这样整篇文章的 Edwin 就会替换成 Edward。
- 更进阶的搜寻、替换的例子在说明 regexp 的时候还会再详述。目前只知道最基本的用法就可以了！其实光这样就非常好用了。:-)

##  2、替换说明（示例 ）
- VIM中常用的替换模式总结。
- 1，简单替换表达式
- 替换命令可以在全文中用一个单词替换另一个单词：
- :%s/four/4/g
- “%” 范围前缀表示在所有行中执行替换。最后的 “g” 标记表示替换行中的所有匹配点。如果仅仅对当前行进行操作，那么只要去掉%即可
- 如果你有一个象 “thirtyfour” 这样的单词，上面的命令会出错。这种情况下，这个单词会被替换成”thirty4″。要解决这个问题，用 “\<” 来指定匹配单词开头：
- :%s/\” 来解决这个问题：
- :%s/\/4/g
- 如果你在编码，你可能只想替换注释中的 “four”，而保留代码中的。由于这很难指定，可以在替换命令中加一个 “c” 标记，这样，Vim 会在每次替换前提示你：
- :%s/\/4/gc

### 2，删除多余的空格
- 要删除这些每行后面多余的空格，可以执行如下命令：
- :%s/\s\+$//
- 命令前面指明范围是 “%”，所以这会作用于整个文件。”substitute” 命令的匹配模式是
- “\s\+$”。这表示行末（$）前的一个或者多个（\+）空格（\s）。替换命令的 “to” 部分是空的：”//”。这样就会删除那些匹配的空白字符。
### 3，匹配重复性模式
- 星号项 “*” 规定在它前面的项可以重复任意次。因此:
- /a*
- 匹配 “a”，”aa”，”aaa”，等等。但也匹配 “” (空字串)，因为零次也包含在内。星号 “*” 仅仅应用于那个紧邻在它前面的项。因此 “ab*” 匹配 “a”，”ab”，”abb”,”abbb”，等等。如要多次重复整个字符串，那么该字符串必须被组成一个项。组成一项的方法就是在它前面加 “\(”，后面加 “\)”。因此这个命令:
- /\(ab\)*
- 匹配: “ab”，”abab”，”ababab”，等等。而且也匹配 “”。
- 要避免匹配空字串，使用 “\+”。这表示前面一项可以被匹配一次或多次。
- /ab\+
- 匹配 “ab”，”abb”，”abbb”，等等。它不匹配 后面没有跟随 “b” 的 “a”。
- 要匹配一个可选项，用 “\=”。 例如:
- /folders\=
- 匹配 “folder” 和 “folders”。
- 4，指定重复次数
- 要匹配某一项的特定次数重复，使用 “\{n,m}” 这样的形式。其中 “n” 和 “m” 都是数字。在它前面的那个项将被重复 “n” 到 “m” 次 (|inclusive| 包含 “n” 和 “m”)。例如:
- /ab\{3,5}
- 匹配 “abbb”，”abbbb” 以及 “abbbbb”。
- 当 “n” 省略时，被默认为零。当 “m” 省略时，被默认为无限大。当 “,m” 省略时，就表示重复正好 “n” 次。例如:
- 模式 匹配次数
- \{,4} 0，1，2，3 或 4
- \{3,} 3，4，5，等等
- \{0,1} 0 或 1，同 \=
- \{0,} 0 或 更多，同 *
- \{1,} 1 或 更多，同 \+
- \{3} 3
- 5，多选一匹配
- 在一个查找模式中，”或” 运算符是 “\|”。例如:
- /foo\|bar
- 这个命令匹配了 “foo” 或 “bar”。更多的抉择可以连在后面:
- /one\|two\|three
- 匹配 “one”，”two” 或 “three”。
- 如要匹配其多次重复，那么整个抉择结构须置于 “\(” 和 “\)” 之间:
- /\(foo\|bar\)\+
- 这个命令匹配 “foo”，”foobar”，”foofoo”，”barfoobar”，等等。
- 再举个例子:
- /end\(if\|while\|for\)
- 这个命令匹配 “endif”，”endwhile” 和 “endfor”。

### 另外这里列出多种vim替换实例
- :s/vivian/sky/ 替换当前行第一个 vivian 为 sky
- :s/vivian/sky/g 替换当前行所有 vivian 为 sky
- :n,$s/vivian/sky/ 替换第 n 行开始到最后一行中每一行的第一个 vivian 为 sky
- :n,$s/vivian/sky/g 替换第 n 行开始到最后一行中每一行所有 vivian 为 sky
- n 为数字，若 n 为 .，表示从当前行开始到最后一行
- :%s/vivian/sky/（等同于 :g/vivian/s//sky/） 替换每一行的第一个 vivian 为 sky
- :%s/vivian/sky/g（等同于 :g/vivian/s//sky/g） 替换每一行中所有 vivian 为 sky
- 可以使用 # 作为分隔符，此时中间出现的 / 不会作为分隔符
- :s#vivian/#sky/# 替换当前行第一个 vivian/ 为 sky/
- :%s+/oradata/apras/+/user01/apras1+ （使用+ 来 替换 / ）： /oradata/apras/替换成/user01/apras1/
- 1.:s/vivian/sky/ 替换当前行第一个 vivian 为 sky
- :s/vivian/sky/g 替换当前行所有 vivian 为 sky
- 2. :n,$s/vivian/sky/ 替换第 n 行开始到最后一行中每一行的第一个 vivian 为 sky
- :n,$s/vivian/sky/g 替换第 n 行开始到最后一行中每一行所有 vivian 为 sky
- (n 为数字，若 n 为 .，表示从当前行开始到最后一行)
- 3. :%s/vivian/sky/（等同于 :g/vivian/s//sky/） 替换每一行的第一个 vivian 为 sky
- :%s/vivian/sky/g（等同于 :g/vivian/s//sky/g） 替换每一行中所有 vivian 为 sky
- 4. 可以使用 # 作为分隔符，此时中间出现的 / 不会作为分隔符
- :s#vivian/#sky/# 替换当前行第一个 vivian/ 为 sky/
- 5. 删除文本中的^M
- 问题描述：对于换行,window下用回车换行(0A0D)来表示，linux下是回车(0A)来表示。这样，将window上的文件拷到unix上用时，总会有个^M.请写个用在unix下的过滤windows文件的换行符(0D)的shell或c程序。
- · 使用命令：cat filename1 | tr -d “^V^M” > newfile；
- · 使用命令：sed -e “s/^V^M//” filename > outputfilename。需要注意的是在1、2两种方法中，^V和^M指的是Ctrl+V和Ctrl+M。你必须要手工进行输入，而不是粘贴。
- · 在vi中处理：首先使用vi打开文件，然后按ESC键，接着输入命令：%s/^V^M//。
- · :%s/^M$//g
- 如果上述方法无用，则正确的解决办法是：
- · tr -d “\r” < src >dest
- · tr -d “\015″ dest
- · strings A>B
- 6. 其它
- 利用 :s 命令可以实现字符串的替换。具体的用法包括：
- :s/str1/str2/ 用字符串 str2 替换行中首次出现的字符串 str1
- :s/str1/str2/g 用字符串 str2 替换行中所有出现的字符串 str1
- :.,$ s/str1/str2/g 用字符串 str2 替换正文当前行到末尾所有出现的字符串 str1
- :1,$ s/str1/str2/g 用字符串 str2 替换正文中所有出现的字符串 str1
- :g/str1/s//str2/g 功能同上
- 从上述替换命令可以看到：g 放在命令末尾，表示对搜索字符串的每次出现进行替换；不加 g，表示只对搜索
- 字符串的首次出现进行替换；g 放在命令开头，表示对正文中所有包含搜索字符串的行进行替换操作。
