---
layout: post
title: Vim高级编辑之正则表达式技巧
description:Vim高级编辑技巧,正确利用正则表达式
keywords:vim,正则表达式 
author: 网络技术
date: 2012-10-08
category:软件使用 
tags:vim
id:vim_special
---

Vim，即Vi IMproved，是一个Vi的增强版，Linux下最为常用的编辑器之一。然而，它强大的功能是它不仅仅是一个编辑器。
花点时间学习一下Vim的使用，可以事半功倍。随着使用，就会发现Vim的强大。
Vim高级编辑要用到正则表达式的各种技巧，先简单介绍基本的原字符集及其含义：
 
^ --只匹配行首
$ --只匹配行尾
* --匹配0个或多个单字符
[] --匹配[]内字符，可以是一个单字符，也可以是字符序列，可是用-表示[]内字符序列范围，
     如用[1-5]表示[12345]。
. --匹配任意单字符
^$ --匹配空行
    在vi中也可以使用这些正则表达式。它也有它自己的语法格式，不过匹配方式类似，比较一下很容易看出。下面给出几个常用的操作：
 
1. 把文件内容反转，第一行成为最后一行，第二行成为倒数第二行，以此类推 :g/^/m0
1. 在整个文件中替换特定字符串 :%s/原文件的内容/替换成的内容/g
1. 例如：去掉文件中的"^M"等控制符 :1,$s/^M//g (或者:%s/^M//g)
1. 在每一行文本前加同样的字符 :%s/^/要加的内容/g
1. 在每一行文本后加同样的字符 :%s/$/要加的内容/g
1. 在第2行行首加入内容 :2s/^/要加的内容/g
1. 在第1，2行行首加入内容 :1,2s/^/要加的内容/g
1. 删除第1，2行行首的内容 :1,2s/^要删除的内容/g
1. 删除第2行行尾的内容 :2s/要删除的内容$/g
1. 删除第5行包含的字符串 :5s/要删除的字符串/g
1.删除从当前行开始到最后一行的所有内容 :[dot][comma]$d【注意，冒号后面紧跟“点”（表示当前行），然后跟一个“逗号”，加“$”（表示最后一行），d表示删除。】
 
    这些技巧要总结规律性，而且要在每天操作时使用，熟悉得成为手指的本能。只是看是不可能学会的。正如林锐博士所言，学了不一定懂了，懂了不一定会用。勤加练习！
 
 
2007-10-10补记 使用vi进行文本操作的技巧
 
1、基本操作
 
    dd  删除当前行
    ndd 删除当前行以下n行（包括当前行在内）
    p   粘贴
    yy  复制当前行
    nyy 复制当前行以下n行（包括当前行在内）
 
    dd和ndd也可以认为是“剪切”。
 
2、技巧
 
    :n,m co k  复制n到m行，粘贴到k行处（从下一行开始）
    :n,m m k   剪切n到m行，粘贴到k行处（从下一行开始）
    :n,m d     删除n到m行
 
    注意的是，m必须大于n，而且m、n、k都在正文行号之内。比如说，如果文件有10行，而你的操作中出现了11，就会出现错误。m可以用特殊符号$，代表到结尾处。
 
    如果要处理的文本比较多，那么可以采用标号的方法。具体如下：
 
    光标移到起始行，输入ma
    光标移到结束行，输入mb
    光标移到粘贴行，输入mc
 
    然后 :'a,'b co 'c，就实现了复制粘贴。如果把co改为m，就实现了剪切粘贴。
