<?php
/*
  本页：
     Tcms CMS 文件管理类
	 作者:三木
  说明：
     #方法：
         名称                    访问             简介
         -----------------------------------------------------------------
         init                    允许            文件管理类初始化
         createfolder            允许            在当前位置创建目录
         moveitem                允许            移动文件、目录
         deleteitem              允许            删除文件、目录
         subitems                允许            获得当前目录下子目录集、文件集
         formatpath              允许            格式化当前目录串
         getfileex               允许            获得文件扩展名
         fileico                 允许            获得文件扩展名对应的图标
         
  
     #属性：
         名称                     读/写           简介
         -----------------------------------------------------------------
         currpath                读/写            当前访问目录（不含根目录）
         currindex               读/写            当前访问目录索引（既目录权限Xml文档内Index域）
         currroot                读/-             当前访问目录－根目录
         currurl                 读/-             当前访问目录－对应Url
         currtitle               读/-             当前访问目录－标题
         visupath                读/-             完整目录（未转换）
         reapath                 读/-             完整目录（转换后）
         visiturl                读/-             完整目录的可访问地址
         folderitems             读/-             目录权限列表
         currfolderitem          读/-             正在访问的目录权限
         isroot                  读/-             当前是否在根目录位置
         upLoadfext              读/-             允许上传的文件扩展名
         editfext                读/-             允许编辑的文件扩展名
         havefolderitem          读/-             是否具有目录权限列表
         isavailable             读/-             当前访问的目录是否存在
         enableupload            读/-             是否允许上传
         enableedit              读/-             是否允许编辑
         enabledelete            读/-             是否允许删除
         enablemove              读/-             是否允许移动
         enablecreate            读/-             是否允许创建
*/
class CFileSys {
	public $currpath, $currindex, $currtitle, $currname, $currroot, $currurl;
	public $enableupload, $uploadfsize, $uploadfext, $enableedit, $editfext;
	public $imgwaterenable, $imgwaterpos, $imgwaterpath;
	public $enabledelete, $enablemove, $enablecreate, $strautocreate;
	public $visupath, $reapath, $visiturl, $folderitems, $currfolderitem;
	public $isroot, $isavailable, $havefolderitem;
	public $parentpath;
	public $isftp,$ftpcontent,$ftpresult;
	
	private $XMLdoc;
	private $mfolderitems, $mcurrindex, $mcurrpath;
	private $mcurrfolderitem;
	
	function __construct() {
		global $admin;
		$this->XMLdoc = new DOMDocument();
		if($admin->folderlist!='') {
			$this->XMLdoc->loadXML($admin->folderlist);
			$this->mfolderitems = $this->XMLdoc->getElementsByTagName('item');
			$this->folderitems = $this->mfolderitems;
			$this->havefolderitem = true;
		}
	}
/*
    方法:初始化文件系统类
    返回:bool(true:初始化成功 false:初始化失败)
    取得当前所在目录项Xml节点对象'
*/
	public function init() {
		global $cfg,$flib;
		$this->mcurrindex = (is_numeric($this->currindex))?intval($this->currindex):-1;
		$this->currindex = $this->mcurrindex;
		$this->mcurrpath = $this->formatpath($this->currpath);
		$this->currpath = $this->mcurrpath;
		if ($this->currindex == -1){return false;exit();}
		$xpath = new DOMXPath($this->XMLdoc);
		//搜索文件夹
		$query = "//file/item[index[.='{$this->currindex}']]";
		$this->mcurrfolderitem = $xpath->query($query);
		$flag=0;
		foreach ($this->mcurrfolderitem as $node){$flag++;}
		//如果文件夹不存在
		if(!$flag){return false;exit();}
		//文件夹存在
		$this->currtitle = $this->mcurrfolderitem->item(0)->getElementsByTagName('title')->item(0)->nodeValue;
		$this->currname	 = $this->mcurrfolderitem->item(0)->getElementsByTagName('name')->item(0)->nodeValue;
		$this->currroot	 = $flib->creat_path($this->mcurrfolderitem->item(0)->getElementsByTagName('path')->item(0)->nodeValue);
		$this->currurl	 = $flib->creat_url($this->mcurrfolderitem->item(0)->getElementsByTagName('url')->item(0)->nodeValue);
		$this->enableupload = $this->mcurrfolderitem->item(0)->getElementsByTagName('upload')->item(0)->getAttribute('enable');
		$this->uploadfsize 	= $this->mcurrfolderitem->item(0)->getElementsByTagName('upload')->item(0)->getAttribute('size');
		$this->uploadfsize	= (is_numeric($this->uploadfsize))?$this->uploadfsize:0;
		$this->uploadfext 	= $this->mcurrfolderitem->item(0)->getElementsByTagName('upload')->item(0)->nodeValue;
		
		$this->imgwaterenable = $this->mcurrfolderitem->item(0)->getElementsByTagName('imgwater')->item(0)->getAttribute('enable');
		$this->imgwaterpos = $this->mcurrfolderitem->item(0)->getElementsByTagName('imgwater')->item(0)->getAttribute('pos');
		$this->imgwaterpath = $flib->creat_path($this->mcurrfolderitem->item(0)->getElementsByTagName('imgwater')->item(0)->nodeValue);
		
		$this->enableedit	= ($this->mcurrfolderitem->item(0)->getElementsByTagName('edit')->item(0)->getAttribute('enable')=='1')?true:false;
		$this->editfext		= $this->mcurrfolderitem->item(0)->getElementsByTagName('edit')->item(0)->nodeValue;
		
		$this->enabledelete = ($this->mcurrfolderitem->item(0)->getElementsByTagName('folder')->item(0)->getAttribute('delete')=='1')?true:false;
		$this->enablemove	= ($this->mcurrfolderitem->item(0)->getElementsByTagName('folder')->item(0)->getAttribute('move')=='1')?true:false;
		$this->enablecreate	= ($this->mcurrfolderitem->item(0)->getElementsByTagName('folder')->item(0)->getAttribute('create')=='1')?true:false;
		$this->strautocreate= $this->mcurrfolderitem->item(0)->getElementsByTagName('folder')->item(0)->getAttribute('autocreate');
		
		if($this->currroot==''){return false;exit();}
		//判断文件夹是否为FTP远程文件夹
		if(substr($this->currroot,0,3)=='ftp'){
			$this->isftp = 1;
			$arrftpconnect = explode(':',$this->currroot);
			$this->ftpconnect = @ftp_connect($arrftpconnect[1]);
			if(!$this->ftpconnect)return false;
			$this->ftpresult = @ftp_login($this->ftpconnect, $arrftpconnect[2], $arrftpconnect[3]);
			if(!$this->ftpresult)return false;
			//分析最终目录路径
			if($this->currpath=='') {
				$this->visupath = '/';
				$this->visiturl = $this->currurl;
			}else{
				$this->visupath = '/'.$this->currpath.'/';
				$this->visiturl = $this->currurl.$this->currpath.'/';
			}
			$this->reapath = $this->visupath;
			$this->isroot = ($this->currpath=='')?true:false;
			$this->parentpath = ($this->isroot)?'':mb_substr($this->currpath,0,mb_strrpos($this->currpath,'/'));
			//判断目录存在
			$this->isavailable = ftp_chdir($this->ftpconnect,$this->reapath);
			return true;
		}else{
			$this->isftp = 0;
			//分析最终目录路径
			if($this->currpath=='') {
				$this->visupath = $this->currroot;
				$this->visiturl = $this->currurl;
			}else{
				$this->visupath = $this->currroot.$this->currpath.'/';
				$this->visiturl = $this->currurl.$this->currpath.'/';
			}
			$this->reapath = $cfg->webroot.$this->visupath;
			$this->isroot = ($this->currpath=='')?true:false;
			$this->parentpath = ($this->isroot)?'':mb_substr($this->currpath,0,mb_strrpos($this->currpath,'/'));
			//判断目录存在
			if(!is_dir($this->reapath))$flib->rmkdir($this->reapath);
			$this->isavailable = is_dir($this->reapath);
			return true;
		}
	}

/*
    '方法:移动文件、目录
    '参数:文件、目录名称, 目标位置
*/
	public function moveitem($fname,$target)
	{
		global $cfg;
		$tmppath1 = $this->reapath.$this->formatpath($fname);
		$tmppath2 = $cfg->webroot.$this->currroot.$this->formatpath($target).'/'.$this->formatpath($fname);
		return @rename($tmppath1,$tmppath2);
	}
/*
    方法:在当前位置创建目录
    参数:目录名称
*/
	public function createfolder($pathname)
	{
		global $flib;
		return $flib->rmkdir($this->reapath.$this->formatpath($pathname));
	}
	
/*
    '方法:删除文件、目录
    '参数:文件、目录名称
*/
	public function deleteitem($fname)
	{
		$tmppath = $this->reapath.$this->formatpath($fname);
		if(is_dir($tmppath))return @rmdir($tmppath);
		if(is_file($tmppath))return unlink($tmppath);
	}
/*
    函数:格式化为标准目录串
    返回:目录串
      防止非法用使用../等符号跳过mCurrRoot目录
      去除目录两边斜杆
*/
	public function formatpath($path)
	{
		$path = str_replace("\\",'/',$path);
		$path = str_replace('../','',$path);
		if(mb_substr($path,0,1)=='/')$path=mb_substr($path,1);
		if(mb_substr($path,-1,1)=='/')$path=mb_substr($path,-2);
		return $path;
	}
	
/*
    方法:取得指定目录内目录集对象
    参数:
       返回对象类型(1: 返回文件集 2:返回目录集)
    返回:
       失败则返回Nothing（详细使用参见Microsoft Windows Script 文档）
*/
	public function subitems($t){
		if($this->isftp){
			switch($t){
				case 'folder':
					$directories = ftp_nlist($this->ftpconnect,".");
					$res_subitems = array();
					foreach($directories as $value){
						if($this->is_ftpdir($value))$res_subitems[] = $value ;
					}
					break;
				case 'file':
					$directories = ftp_nlist($this->ftpconnect,".");
					$res_subitems = array();
					foreach($directories as $value){
						if(!$this->is_ftpdir($value))$res_subitems[] = $value ;
					}
					break;
				default:
					$res_subitems = array();
					break;
			}
		} else {
			switch($t){
				case 'folder':
					$target = $this->reapath;
					$weeds = array('.', '..');
					$directories = array_diff(scandir($target), $weeds);
					$res_subitems = array();
					foreach($directories as $value){
						if(is_dir($target.$value))$res_subitems[] = $value ;
					}
					break;
				case 'file':
					$target = $this->reapath;
					$weeds = array('.', '..');
					$directories = array_diff(scandir($target), $weeds);
					$res_subitems = array();
					foreach($directories as $value){
						if(is_file($target.$value))$res_subitems[] = $value ;
					}
					break;
				default:
					$res_subitems = array();
					break;
			}
		}
		return $res_subitems;
	}
	public function is_ftpdir($file) {if(ftp_size($this->ftpconnect, $file) == -1) { return true; } else { return false; }}
/*
	方法:获得文件扩展名及图标
*/
	public function getfileex($filename){
		return strtolower(mb_substr($filename,mb_strrpos($filename,'.')+1));
	}
	public function fileico($f_name){
		$ex = strtolower($this->getfileex($f_name));
		switch($ex){
			case 'doc':$ico = 'f_doc.gif';break;
			case 'txt':$ico = 'f_txt.gif';break;
			case 'mp3':$ico = 'f_mp3.gif';break;
			case 'gif':$ico = 'f_pic.gif';break;
			case 'bmp':$ico = 'f_pic.gif';break;
			case 'jpg':$ico = 'f_pic.gif';break;
			case 'ico':$ico = 'f_pic.gif';break;
			case 'rar':$ico = 'f_rar.gif';break;
			case 'zip':$ico = 'f_rar.gif';break;
			case 'php':$ico = 'f_php.gif';break;
			case 'xml':$ico = 'f_php.gif';break;
			case 'jsp':$ico = 'f_php.gif';break;
			case 'asp':$ico = 'f_php.gif';break;
			case 'css':$ico = 'f_php.gif';break;
			case 'js':$ico = 'f_php.gif';break;
			case 'htm':$ico = 'f_htm.gif';break;
			case 'html':$ico = 'f_htm.gif';break;
			case 'shtml':$ico = 'f_htm.gif';break;
			case 'asf':$ico = 'f_media.gif';break;
			case 'wmv':$ico = 'f_media.gif';break;
			case 'mdb':$ico = 'f_mdb.gif';break;
			case 'exe':$ico = 'f_exe.gif';break;
			case 'com':$ico = 'f_exe.gif';break;
			case 'bat':$ico = 'f_exe.gif';break;
			case 'swf':$ico = 'f_swf.gif';break;
			case 'fla':$ico = 'f_swf.gif';break;
			case 'rm':$ico = 'f_rm.gif';break;
			case 'rmvb':$ico = 'f_rm.gif';break;
			case 'dll':$ico = 'f_dll.gif';break;
			case 'sys':$ico = 'f_dll.gif';break;
			case 'dbx':$ico = 'f_dbx.gif';break;
			case 'cat':$ico = 'f_cat.gif';break;
			case 'pdf':$ico = 'f_pdf.gif';break;
			case 'hlp':$ico = 'f_hlp.gif';break;
			case 'htt':$ico = 'f_htt.gif';break;
			case 'png':$ico = 'f_png.gif';break;
			case 'chm':$ico = 'f_chm.gif';break;
			case 'nfo':$ico = 'f_nfo.gif';break;
			case 'reg':$ico = 'f_reg.gif';break;
			case 'key':$ico = 'f_reg.gif';break;
			case 'cpp':$ico = 'f_cpp.gif';break;
			case 'h':$ico = 'f_h.gif';break;
			case 'frm':$ico = 'f_frm.gif';break;
			case 'bas':$ico = 'f_bas.gif';break;
			case 'ctl':$ico = 'f_ctl.gif';break;
			case 'vbg':$ico = 'f_vbg.gif';break;
			case 'vbp':$ico = 'f_vbp.gif';break;
			default:$ico = 'unknow.gif';break;
		}
		return $ico;
	}
// 视图模式的文件的路径,图片类型的文件获得文件路径,其它类型获得图标文件路径
	public function fileview($f_name){
		$ex = strtolower($this->getfileex($f_name));
		switch($ex){
			case 'doc':$ico = '../images/fl_view/f_doc.gif';break;
			case 'txt':$ico = '../images/fl_view/f_txt.gif';break;
			case 'mp3':$ico = '../images/fl_view/f_mp3.gif';break;
			case 'gif':$ico = $this->visiturl.$f_name;break;
			case 'bmp':$ico = $this->visiturl.$f_name;break;
			case 'jpg':$ico = $this->visiturl.$f_name;break;
			case 'png':$ico = $this->visiturl.$f_name;break;
			case 'jpeg':$ico = $this->visiturl.$f_name;break;
			case 'ico':$ico = '../images/fl_view/f_pic.gif';break;
			case 'rar':$ico = '../images/fl_view/f_rar.gif';break;
			case 'zip':$ico = '../images/fl_view/f_rar.gif';break;
			case 'php':$ico = '../images/fl_view/f_php.gif';break;
			case 'xml':$ico = '../images/fl_view/f_php.gif';break;
			case 'jsp':$ico = '../images/fl_view/f_php.gif';break;
			case 'asp':$ico = '../images/fl_view/f_php.gif';break;
			case 'css':$ico = '../images/fl_view/f_php.gif';break;
			case 'js' :$ico = '../images/fl_view/f_php.gif';break;
			case 'htm':$ico = '../images/fl_view/f_htm.gif';break;
			case 'html':$ico = '../images/fl_view/f_htm.gif';break;
			case 'shtml':$ico = '../images/fl_view/f_htm.gif';break;
			case 'asf':$ico = '../images/fl_view/f_media.gif';break;
			case 'wmv':$ico = '../images/fl_view/f_media.gif';break;
			case 'mdb':$ico = '../images/fl_view/f_mdb.gif';break;
			case 'exe':$ico = '../images/fl_view/f_exe.gif';break;
			case 'com':$ico = '../images/fl_view/f_exe.gif';break;
			case 'bat':$ico = '../images/fl_view/f_exe.gif';break;
			case 'swf':$ico = '../images/fl_view/f_swf.gif';break;
			case 'fla':$ico = '../images/fl_view/f_swf.gif';break;
			case 'rm':$ico = '../images/fl_view/f_rm.gif';break;
			case 'rmvb':$ico = '../images/fl_view/f_rm.gif';break;
			case 'dll':$ico = '../images/fl_view/f_dll.gif';break;
			case 'sys':$ico = '../images/fl_view/f_dll.gif';break;
			case 'dbx':$ico = '../images/fl_view/f_dbx.gif';break;
			case 'cat':$ico = '../images/fl_view/f_cat.gif';break;
			case 'pdf':$ico = '../images/fl_view/f_pdf.gif';break;
			case 'hlp':$ico = '../images/fl_view/f_hlp.gif';break;
			case 'htt':$ico = '../images/fl_view/f_htt.gif';break;
			case 'png':$ico = '../images/fl_view/f_png.gif';break;
			case 'chm':$ico = '../images/fl_view/f_chm.gif';break;
			case 'nfo':$ico = '../images/fl_view/f_nfo.gif';break;
			case 'reg':$ico = '../images/fl_view/f_reg.gif';break;
			case 'key':$ico = '../images/fl_view/f_reg.gif';break;
			case 'cpp':$ico = '../images/fl_view/f_cpp.gif';break;
			case 'h':$ico = '../images/fl_view/f_h.gif';break;
			case 'frm':$ico = '../images/fl_view/f_frm.gif';break;
			case 'bas':$ico = '../images/fl_view/f_bas.gif';break;
			case 'ctl':$ico = '../images/fl_view/f_ctl.gif';break;
			case 'vbg':$ico = '../images/fl_view/f_vbg.gif';break;
			case 'vbp':$ico = '../images/fl_view/f_vbp.gif';break;
			default:$ico = '../images/fl_view/unknow.gif';break;
		}
		return $ico;
	}
	
	public function setwater($imgSrc,$markImg,$markPos=0) {
		global $cfg;
		if(!file_exists($imgSrc) || empty($imgSrc))return;
		$srcInfo = @getimagesize($imgSrc);
		$srcImg_w = $srcInfo[0];
		$srcImg_h = $srcInfo[1];
		if($srcImg_w < $cfg->imgwater_minw)return;
		if($srcImg_h < $cfg->imgwater_minh)return;
		switch ($srcInfo[2]) { 
			case 1:$srcim =imagecreatefromgif($imgSrc);break; 
			case 2:$srcim =imagecreatefromjpeg($imgSrc);break; 
			case 3:$srcim =imagecreatefrompng($imgSrc);break; 
			default:return;break; 
		}
		if(!file_exists($markImg) || empty($markImg))return;
		$markImgInfo = @getimagesize($markImg);
		$markImg_w = $markImgInfo[0];
		$markImg_h = $markImgInfo[1];
		if($srcImg_w < $markImg_w || $srcImg_h < $markImg_h)return;
		switch ($markImgInfo[2]) { 
			case 1:$markim =imagecreatefromgif($markImg);break; 
			case 2:$markim =imagecreatefromjpeg($markImg);break; 
			case 3:$markim =imagecreatefrompng($markImg);break; 
			default:return;	break;  
		}
		$logow = $markImg_w;
		$logoh = $markImg_h;
		if($markPos == 0) $markPos = rand(1, 9);
		switch($markPos) {
			case 1:$x = +5;$y = +5;break;
			case 2:$x = ($srcImg_w - $logow) / 2;$y = +5;break;
			case 3:$x = $srcImg_w - $logow - 5;$y = +15;break;
			case 4:$x = +5;$y = ($srcImg_h - $logoh) / 2;break;
			case 5:$x = ($srcImg_w - $logow) / 2;$y = ($srcImg_h - $logoh) / 2;break;
			case 6:$x = $srcImg_w - $logow - 5;$y = ($srcImg_h - $logoh) / 2;break;
			case 7:$x = +5;$y = $srcImg_h - $logoh - 5;break;
			case 8:$x = ($srcImg_w - $logow) / 2;$y = $srcImg_h - $logoh - 5;break;
			case 9:$x = $srcImg_w - $logow - 5;$y = $srcImg_h - $logoh -5;break;
			default:  return; break; 
		}
		$dst_img = @imagecreatetruecolor($srcImg_w, $srcImg_h);
		imagecopy ( $dst_img, $srcim, 0, 0, 0, 0, $srcImg_w, $srcImg_h);
		imagecopy($dst_img, $markim, $x, $y, 0, 0, $logow, $logoh);
		imagedestroy($markim);
		switch ($srcInfo[2]) { 
			case 1:imagegif($dst_img, $imgSrc);break; 
			case 2:imagejpeg($dst_img, $imgSrc);break; 
			case 3:imagepng($dst_img, $imgSrc);break;
			default:return;break;  
		}
		imagedestroy($dst_img);
		imagedestroy($srcim);
	}
}
?>