<?php
/*
	TCMS 通用函数类文件
	作者:三木
*/
class FunctionLib
{
	/*返回毫秒数*/
	public function microtime_float(){
    	list($usec, $sec) = explode(" ", microtime());
	    return ((float)$usec + (float)$sec);
	}
	/*函数:测试字符串长度*/
	public function str_len ($str){
    	return mb_strlen(stripslashes($str),'UTF-8');
	}
	/*函数:整数判断*/
	public function isint ($x){
    	return (is_numeric($x) ? intval($x) == $x : false);
	}
	/*函数:Cookie写  参数:Cookie名, Cookie值, 有效时间 */
	public function setcookies($key,$val,$exptime){
		if($exptime==0){
			setcookie('CACO_'.$key,$val,0);
		}else{
			setcookie('CACO_'.$key,$val,time()+$exptime);
		}
	}
	/*函数:Cookie读  参数:Cookie名  返回:cookie值*/
	public function getcookies($key)
	{	return (isset($_COOKIE["CACO_".$key]))?$_COOKIE["CACO_".$key]:'';	}	
	/*函数:Cookie写  参数:Cookie名, Cookie值, 有效时间 */
	public function setcookies_uid($key,$val,$exptime){
		global $admin;
		if($exptime==0){
			setcookie($admin->userid.'_CACO_'.$key,$val,0);
		}else{
			setcookie($admin->userid.'_CACO_'.$key,$val,time()+$exptime);
		}
	}
	/*函数:Cookie读  参数:Cookie名  返回:cookie值*/
	public function getcookies_uid($key){
		global $admin;
		return (isset($_COOKIE[$admin->userid.'_CACO_'.$key]))?$_COOKIE[$admin->userid.'_CACO_'.$key]:'';
	}	
	/*函数:验证组织编码  参数:字符串  返回:bool (true:有效的权限标识名)*/
	public function check_coding($str){
		$regex = "/^[0-9]{2}$/";
		return preg_match($regex,$str)?1:0;
	}
	/*函数:验证YYYY-MM-DD的日期格式*/
	public function check_date($str){
    	$regex = "/^(\d{4})\-(\d{2})\-(\d{2})$/";
		return preg_match($regex,$str)?1:0;
	}
	/*函数:验证YYYY-MM-DD HH:mm:ss的日期格式*/
	public function check_alldate($str){
    	$regex = "/^(\d{4})\-(\d{2})\-(\d{2}) (\d{2})\:(\d{2})\:(\d{2})$/";
		return preg_match($regex,$str)?1:0;
	}
	/*函数:验证全数据字符串  参数:字符串  返回:bool (true:有效的权限标识名)*/
	public function check_numstr($str){
		$regex = "/^[0-9_]{1,10}$/";
		return preg_match($regex,$str)?1:0;
	}
	/*函数:验证权限标识Key格式  参数:用户名  返回:bool (true:有效的权限标识名)*/
	public function check_popedomkey($str){
		$regex = "/^[A-Z0-9_]{2,50}$/";
		return preg_match($regex,$str)?1:0;
	}
	/*函数:验证用户名格式有效性  参数:用户名  返回:bool (true:有效的用户名)*/
	public function check_username($str){
		$regex ="/^[a-z0-9]{2,50}$/";
		return preg_match($regex,$str)?1:0;
	}
	/*函数:小写字母及下划线  参数:用户名  返回:bool (true:有效的用户名)*/
	public function check_atoz($str){
		$regex ="/^[a-z_]{2,}$/";
		return preg_match($regex,$str)?1:0;
	}
	/*函数:过滤Html标签  参数:字符串  返回:过滤后字符串*/
    public function filterhtml($str){
		$regex = "/<.+?>/";
		return preg_replace($regex,"",$str);
	}
	/*函数:创建含有{uid}{webpath}变量的path路径  参数:path,classid*/
	public function creat_path($pathurl,$classid=0){
		global $mysql,$cfg,$admin;
		if($pathurl=='')return '';
		if($this->isint($classid)===false)return '';
		$tmppathurl = $pathurl;
		if(strpos($tmppathurl,'{uid}')!==false)$tmppathurl = str_replace('{uid}',$admin->userid,$tmppathurl);
		if(strpos($tmppathurl,'{webpath}')!==false){
			$root_classid = $this->get_rootclassid($classid);
			$sql = "SELECT replace_path FROM ".DB_FIXTABLE."resclass_list WHERE id = $root_classid LIMIT 0,1";
			$result = $mysql->sql_query($sql);
			$row = $mysql->sql_fetchrow($result);
			if($row)$tmppathurl = str_replace('{webpath}',$row[0],$tmppathurl);
		}
		if(strpos($tmppathurl,'{webpath:parent}')!==false){
			$parent_classid = $this->get_fatherclassid($classid);
			$sql = "SELECT replace_path FROM ".DB_FIXTABLE."resclass_list WHERE id = parent_classid LIMIT 0,1";
			$result = $mysql->sql_query($sql);
			$row = $mysql->sql_fetchrow($result);
			if($row)$tmppathurl = str_replace('{webpath:parent}',$row[0],$tmppathurl);
		}
		if(preg_match_all ("/{webpath:([0-9]{1,})}/",$pathurl,$tmppath_tag,PREG_SET_ORDER)){
			$root_classid = $tmppath_tag[0][1];
			if($this->isint($root_classid)){
				$sql = "SELECT replace_path FROM ".DB_FIXTABLE."resclass_list WHERE id= $root_classid LIMIT 0,1";
				$result = $mysql->sql_query($sql);
				$row = $mysql->sql_fetchrow($result);
				if($row)$tmppathurl = str_replace($tmppath_tag[0][0],$row[0],$tmppathurl);
			}
		}
		return $tmppathurl;
	}
	/*函数:创建含有{uid}{weburl}{xxgkurl}{class}变量的URL路径  参数:url,classid*/
	public function creat_url($pathurl,$classid=0){
		global $mysql,$cfg,$admin;
		if($pathurl=='')return '';
		if($this->isint($classid)===false)return '';
		$tmppathurl = $pathurl;
		if(strpos($tmppathurl,'{class}')!==false)$tmppathurl = str_replace('{class}',$classid,$tmppathurl);
		if(strpos($tmppathurl,'{xxgkurl}')!==false)$tmppathurl = str_replace('{xxgkurl}',$cfg->xxgkurl,$tmppathurl);
		if(strpos($tmppathurl,'{uid}')!==false)$tmppathurl = str_replace('{uid}',$admin->userid,$tmppathurl);
		if(strpos($tmppathurl,'{weburl}')!==false){
			$root_classid = $this->get_rootclassid($classid);
			$sql = "SELECT home_url FROM ".DB_FIXTABLE."resclass_list WHERE id = $root_classid LIMIT 0,1";
			$result = $mysql->sql_query($sql);
			$row = $mysql->sql_fetchrow($result);
			if($row)$tmppathurl = str_replace('{weburl}',$row[0],$tmppathurl);
		}
		if(strpos($tmppathurl,'{weburl:parent}')!==false){
			$parent_classid = $this->get_fatherclassid($classid);
			$sql = "SELECT home_url FROM ".DB_FIXTABLE."resclass_list WHERE id = parent_classid LIMIT 0,1";
			$result = $mysql->sql_query($sql);
			$row = $mysql->sql_fetchrow($result);
			if($row)$tmppathurl = str_replace('{weburl:parent}',$row[0],$tmppathurl);
		}
		if(preg_match_all ("/{weburl:([0-9]{1,})}/",$pathurl,$tmppath_tag,PREG_SET_ORDER)){
			$root_classid = $tmppath_tag[0][1];
			if($this->isint($root_classid)){
				$sql = "SELECT home_url FROM ".DB_FIXTABLE."resclass_list WHERE id= $root_classid LIMIT 0,1";
				$result = $mysql->sql_query($sql);
				$row = $mysql->sql_fetchrow($result);
				if($row)$tmppathurl = str_replace($tmppath_tag[0][0],$row[0],$tmppathurl);
			}
		}
		return $tmppathurl;
	}
	/*函数：支持数组的ADDSLASHES*/
	public function saddslashes($string){ 
		if(is_array($string)) { 
			foreach($string as $key => $val) { 
				$string[$key] = $this->saddslashes($val); 
			} 
		}else{ 
			$string = addslashes($string); 
		} 
		return $string; 
	}
	/*函数:计算占用空间  参数:数字单位字节  返回:B KB MB GB*/
    public function todatalength($str){
		if($this->isint ($str)){
		 if($str < 1024) return strval($str).'B';
		 elseif($str < 1024*1024) return strval(intval($str/1024)).'KB';
		 elseif($str < 1024*1024*1024) return strval(intval($str/1024/1024)).'MB';
		 else return strval(intval($str/1024/1024/1024)).'GB';
		}else{
		 return '0B';
		}
	}
	/*
		函数:判断路径类型
		返回:
		   1   物理路径
		   2   站点虚路径
		   3   网络路径
	*/
	public function chkpathtype($strpath)
	{
		$regex1 = "/^[c-z]{1,1}\:.+$/";
		if(preg_match($regex1,$strpath))return 1;
		$regex3 = "/^(?:http|https){1,1}\:.+$/";
		if(preg_match($regex3,$strpath))return 3;
		return 2;
	}
	/*重复创建文件夹*/
	public function rmkdir($path){
		$isok = true;
		if(strpos($path,"\\")!==false)$path = str_replace("\\","/",$path);
		$exp=explode("/",$path);
		$way='';
		foreach($exp as $n)	{
			$way.=$n.'/';
			if(!is_dir($way))$isok = mkdir($way);
		}
		return $isok;
	}
	/*
		函数:通用信息提示框
		参数:
		   提示内容
		   返回地址,详细值类型如下:
			   "#"      只提示，其它不做任何操作
			   "BACK"   提示后返回前一页
			   "CLOSE"  提示后关闭窗口
			   "网址"    提示后返回指定页面
		   是否父窗口'
	*/
	public function alert($str,$backurl,$topwindow){
		echo ($str!="")?"<script>alert(\"{$str}\");":"<script>";
		$winname=($topwindow==1)?"top":"self";
		switch($backurl){
			case "#":break;
			case "BACK":echo "{$winname}.history.back();";break;
			case "CLOSE":echo "window.close();";break;
			default:
				if($backurl!="")echo "{$winname}.location.href = \"{$backurl}\";";
		}
		echo "</script>";
	}
	/*函数:日制记录 参数:日制内容*/
	public function addlog($msg){
		global $cfg,$admin,$mysql;
		$msg = htmlentities($msg,ENT_QUOTES,"UTF-8");
        $sql = "INSERT INTO ".DB_FIXTABLE."sys_log (remark,creator,ip,addtime) VALUES ('$msg','$admin->username','$admin->userip','$cfg->nowtime')";
		$mysql->sql_query($sql);
	}
	/*函数:创建一个唯一的记录Id 参数:键值*/
	public function createrecordid($auto_name){
		global $mysql;
		$sql = "SELECT auto_value FROM ".DB_FIXTABLE."auto_id WHERE auto_name = '$auto_name' LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		if($row) {
			$tmprid = $row['auto_value'] + 1;
			$sql = "UPDATE ".DB_FIXTABLE."auto_id SET auto_value = '$tmprid' WHERE auto_name = '$auto_name'";
		}else{
			$tmprid = 1;
			$sql = "INSERT INTO ".DB_FIXTABLE."auto_id (auto_name, auto_value) VALUES ('$auto_name','$tmprid')";
		}
		$mysql->sql_query($sql);
		return $tmprid;
	}
	/*函数:克隆一个频道中的数据栏目  参数:原频道的父ID，新频道的父ID*/
	public function cloneclass($parent,$newparent){
		global $cfg,$mysql;
		$sql = "SELECT id,parent,title,home_url,remark,coding,creator,show_order,isshow,iswrite_res,template_id,directory_rule,replace_path,replace_path_url,filename_rule,type_mode,addtime FROM ".DB_FIXTABLE."resclass_list WHERE parent = $parent ORDER BY show_order desc";
		$result = $mysql->sql_query($sql);
		while($row= $mysql->sql_fetchrow($result)){
			$row = $this->saddslashes($row);
			$cid_clone = $this->createrecordid('class_id');
			$sql_clone = "INSERT INTO ".DB_FIXTABLE."resclass_list(id,parent,title,home_url,remark,coding,creator,show_order,isshow,iswrite_res,template_id,directory_rule,replace_path,replace_path_url,filename_rule,type_mode,addtime) VALUES ('$cid_clone','$newparent','$row[2]','$row[3]','$row[4]','$row[5]','$row[6]','$row[7]','$row[8]','$row[9]','$row[10]','$row[11]','$row[12]','$row[13]','$row[14]','$row[15]','$cfg->nowtime')";
			$mysql->sql_query($sql_clone);
			$this->cloneclass($row[0],$cid_clone);
		}
		return;
	}
	/*
       频道标志位，总长度设定为20位，从右往左使用。多个分类标志以;号分隔
       数据格式为：
              内容Id,10位长度标志位,根节点标志,子频道标志
       例如：
              12,0000011111,0,0;13,0000011111,1,0;21,0000000110,1,1
	*/	
	public function resclasspopedom_process($objname){
		$rcpopedom = ((isset($_POST['oRcTables']))?$_POST['oRcTables']:'');
		if($rcpopedom == '')return;
		$arrrcpopedom = explode(',',$rcpopedom);
		$arrnum = count($arrrcpopedom);
		$result = '';
		for($i=0;$i<$arrnum;$i++){
			$result.= ($result=='')?'':';';
			$result.= $arrrcpopedom[$i].',000000000'.$this->requestrcflag($objname,$arrrcpopedom[$i],11).$this->requestrcflag($objname,$arrrcpopedom[$i],10).$this->requestrcflag($objname,$arrrcpopedom[$i],9).$this->requestrcflag($objname,$arrrcpopedom[$i],8).$this->requestrcflag($objname,$arrrcpopedom[$i],7).$this->requestrcflag($objname,$arrrcpopedom[$i],6).$this->requestrcflag($objname,$arrrcpopedom[$i],5).$this->requestrcflag($objname,$arrrcpopedom[$i],4).$this->requestrcflag($objname,$arrrcpopedom[$i],3).$this->requestrcflag($objname,$arrrcpopedom[$i],2).$this->requestrcflag($objname,$arrrcpopedom[$i],1).','.$this->requestrcrootnodeflag($objname,$arrrcpopedom[$i]).','.$this->requestrcchildnodeflag($objname,$arrrcpopedom[$i]);
		}
		return $result;
	}
	public function requestrcflag($objname,$rcid,$flag){
		return (((isset($_POST['flag'.$flag.'_'.$rcid.$objname]))?$_POST['flag'.$flag.'_'.$rcid.$objname]:'')=='1')?'1':'0';
	}
	public function requestrcrootnodeflag($objname,$rcid){
		return (((isset($_POST['root_'.$rcid.$objname]))?$_POST['root_'.$rcid.$objname]:'')=='1')?'1':'0';
	}
	public function requestrcchildnodeflag($objname,$rcid){
		return (((isset($_POST['child_'.$rcid.$objname]))?$_POST['child_'.$rcid.$objname]:'')=='1')?'1':'0';
	}
	
	public function popeflag_or($popeflag1,$popeflag2){
		if($popeflag1=='' || $popeflag2=='')return '00000000000000000000';
		$tmppopeflag = '';
		for($i=0;$i<20;$i++){$tmppopeflag .= (substr($popeflag1,$i,1)=='1' || substr($popeflag2,$i,1)=='1')?'1':'0';}
		return $tmppopeflag;
	}
	/*函数:取得当前所在频道的根频道ID  参数:分类Id*/
	public function get_rootclassid($id){
		global $mysql;
		if($this->isint($id)===false)return $id;
		$sql = "SELECT parent FROM ".DB_FIXTABLE."resclass_list WHERE id = $id LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		if(!$row)return $id;
		if($row[0]==0)return $id;
		return $this->get_rootclassid($row[0]);
	}
	/* 函数:取得当前所在频道的父频道ID  参数:分类Id*/
	public function get_fatherclassid($id){
		global $mysql;
		if($this->isint($id)===false)return $id;
		$sql = "SELECT parent FROM ".DB_FIXTABLE."resclass_list WHERE id = $id LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		if(!$row)return $id;
		return $row[0];
	}
	/*函数：取得指定频道的子目录权限	 参数：频道ID*/
	public function path_resclasssub($id){
		global $admin,$mysql;
		if($this->isint($id)===false)return $id;
		if($id==0)return 0;
		$sql = "SELECT id,parent FROM ".DB_FIXTABLE."resclass_list WHERE id = $id LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		if($row) {
			$sql1 = "SELECT sub_flag FROM ".DB_FIXTABLE."manage_online WHERE mid = $admin->userid AND class_id={$row[0]} LIMIT 0,1";
			$result1 = $mysql->sql_query($sql1);
			$row1 = $mysql->sql_fetchrow($result1);
			if($row1){
				return $row1['sub_flag'];
			}else{
				return $this->path_resclasssub($row['parent']);	
			}
		}else{
			return 0;
		}
	}
	/*函数:取得当前所在频道的父路径 参数:分类Id*/
	public function path_resclasslist($id,$url='',$root=1){
		global $mysql;
		if ($id==0)return ($root)?(($url=='')?'根频道':"<a href=\"{$url}parent=0\">根频道</a>"):'';
		$sql = "SELECT id, parent, title FROM ".DB_FIXTABLE."resclass_list WHERE id = $id LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		if(!$row)return;
		$pid = $row['parent'];
		$title = $row['title'];
		$urltitle = (($url=='')?$title:"<a href=\"".$url."parent=".$id."\">".$title.'</a>');
		return $this->path_resclasslist($pid,$url,$root).(($this->path_resclasslist($pid,$url,$root)=='')?'':" &gt;&gt; ").$urltitle;
	}
	/*函数:取得当前所在内容特性的父路径 参数:分类Id*/
	public function path_speciallist($id,$url='',$root=1){
		global $mysql;
		if ($id==0)return ($root)?(($url=='')?'根特性':"<a href=\"{$url}parent=0\">根特性</a>"):'';
		$sql = "SELECT id, parent, title FROM ".DB_FIXTABLE."special_list WHERE id = $id LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		if(!$row)return;
		$pid = $row['parent'];
		$title = $row['title'];
		$urltitle = (($url=='')?$title:"<a href=\"".$url."parent=".$id."\">".$title.'</a>');
		return $this->path_speciallist($pid,$url,$root).(($this->path_speciallist($pid,$url,$root)=='')?'':" &gt;&gt; ").$urltitle;
	}
	/*函数:取得当前所在权限列表的父路径 参数:权限Id*/
	public function path_popedomlist($id,$url){
		global $mysql;
		if($id==0)return "<a href=\"{$url}parent=0\">根权限</a>" ;
		$sql = "SELECT id, parent, title, pope_key FROM ".DB_FIXTABLE."popedom_list WHERE id = $id LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		if(!$row)return;
		$pid = $row['parent'];
		$title = $row['title'];
		$pkey = $row['pope_key'].'_';
		return $this->path_popedomlist($pid, $url)." &gt;&gt; <a href=\"".$url."parent=".$id ."&pkey=".$pkey."\">" . $title .'</a>';
	}
	/*函数:内容子特性ID列表 参数:特性Id 返回:ID列，如: 23,23,11,32*/
	public function childenlist_s($parent){
		if(!$this->isint($parent))return '';
		global $mysql;
		$sql = "SELECT id FROM ".DB_FIXTABLE."special_list WHERE parent = $parent";
		$result = $mysql->sql_query($sql);
		$tempchildenlist1='';
		while($row=$mysql->sql_fetchrow($result)){
			$tempid = $row['id'];
			$tempchildenlist2 = $this->childenlist_s($tempid);
			$tempchildenlist1 .=(($tempchildenlist1=='')?'':',').$tempid;
			if($tempchildenlist2!='')$tempchildenlist1 .=','.$tempchildenlist2;			
		}
		return $tempchildenlist1;
	}
	/*函数:计算子分类数量	参数：分类ID列表	返回：数量值*/
	public function countspeciallist($speciallist){
		if($speciallist=='')return 0;
		global $mysql;
		$classcount = 0;
		$specialcount = 0;
		if($speciallist=='0'){
			$sql = "SELECT id FROM ".DB_FIXTABLE."special_list"; 
			$result = $mysql->sql_query($sql);
			$numcount = $mysql->sql_numrows($result);
			return $numcount;
		}
		$sql = "SELECT id FROM ".DB_FIXTABLE."special_list WHERE id IN ($speciallist)"; 
		$result = $mysql->sql_query($sql);
		while($row = $mysql->sql_fetchrow($result)){
			$specialcount += $this->countspecialchildenlist($row[0]) +1;
			if($specialcount > 300)break;
		}
		return $specialcount;
	}
	public function countspecialchildenlist($parent){
		global $mysql;
		$specialcount = 0;
		$sql = "SELECT id FROM ".DB_FIXTABLE."special_list WHERE parent = $parent";
		$result = $mysql->sql_query($sql);
		while($row=$mysql->sql_fetchrow($result)){
			$specialcount += $this->countspecialchildenlist($row[0]) +1;
		}
		return $specialcount;
	}
	/*函数:内容子分类ID列表 参数:频道Id 返回:ID列，如: 23,23,11,32*/
	public function childenlist($parent){
		if(!$this->isint($parent))return '';
		global $mysql;
		$sql = "SELECT id FROM ".DB_FIXTABLE."resclass_list WHERE parent = $parent";
		$result = $mysql->sql_query($sql);
		$tempchildenlist1='';
		while($row=$mysql->sql_fetchrow($result)){
			$tempid = $row['id'];
			$tempchildenlist2 = $this->childenlist($tempid);
			$tempchildenlist1 .=(($tempchildenlist1=='')?'':',').$tempid;
			if($tempchildenlist2!='')$tempchildenlist1 .=','.$tempchildenlist2;			
		}
		return $tempchildenlist1;
	}
	/*
		函数:内容子分类ID列表--有可见权限的子分类
		参数:
		返回:ID列，如: 23,23,11,32
	*/
	public function childenlist_online($parent){
		if(!$this->isint($parent))return '';
		global $mysql,$admin;
		$tempchildenlist1='';
		$sub_class = $this->path_resclasssub($parent);
		if($sub_class==1){
			$sql = "SELECT id FROM ".DB_FIXTABLE."resclass_list WHERE parent = $parent";
			$result = $mysql->sql_query($sql);
			while($row=$mysql->sql_fetchrow($result)){
				$tempid = $row['id'];
				$tempchildenlist2 = $this->childenlist_online($tempid);
				$tempchildenlist1 .=(($tempchildenlist1=='')?'':',').$tempid;
				if($tempchildenlist2!='')$tempchildenlist1 .=','.$tempchildenlist2;			
			}
			return $tempchildenlist1;
		}elseif($sub_class==0){
			$sql = "SELECT class_id FROM ".DB_FIXTABLE."manage_online WHERE mid = $admin->userid AND class_pid = $parent";
			$result = $mysql->sql_query($sql);
			while($row=$mysql->sql_fetchrow($result)){
				$tempid = $row['class_id'];
				$tempchildenlist2 = $this->childenlist_online($tempid);
				$tempchildenlist1 .=(($tempchildenlist1=='')?'':',').$tempid;
				if($tempchildenlist2!='')$tempchildenlist1 .=','.$tempchildenlist2;			
			}
		}
		return $tempchildenlist1;
	}
	/*
		函数:计算子分类数量
		参数：分类ID列表
		返回：数量值
	*/
	public function countclasslist($classlist){
		if($classlist=='')return 0;
		global $mysql;
		$classcount = 0;
		$sql = "SELECT id FROM ".DB_FIXTABLE."resclass_list WHERE id IN ($classlist)"; 
		$result = $mysql->sql_query($sql);
		while($row = $mysql->sql_fetchrow($result)){
			$classcount += $this->countchildenlist($row[0]) +1;
			if($classcount > 500)break;
		}
		return $classcount;
	}
	public function countchildenlist($parent){
		global $mysql;
		$classcount = 0;
		$sql = "SELECT id FROM ".DB_FIXTABLE."resclass_list WHERE parent = $parent";
		$result = $mysql->sql_query($sql);
		while($row=$mysql->sql_fetchrow($result)){
			$classcount += $this->countchildenlist($row[0]) +1;
		}
		return $classcount;
	}
	/*
		函数:判断内容子分类
		参数:
		返回:0,1
	*/
	public function ischildenlist($parent,$name='class'){
		global $mysql;
		switch($name){
			case 'class':
				$sql = "SELECT id FROM ".DB_FIXTABLE."resclass_list WHERE parent = $parent LIMIT 0,1";
				break;
			case 'special':
				$sql = "SELECT id FROM ".DB_FIXTABLE."special_list WHERE parent = $parent LIMIT 0,1";
				break;
		}
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		return $row;
	}
	/*
		函数:内容父分类ID列表
		参数:
		返回:ID列，如: 23,23,11,32
	*/
	public function fatherlist($cid){
		if(!$this->isint($cid))return '';
		global $mysql;
		$sql = "SELECT parent FROM ".DB_FIXTABLE."resclass_list WHERE id = $cid";
		$result = $mysql->sql_query($sql);
		$tempfatherlist1='';
		while($row=$mysql->sql_fetchrow($result)){
			$tempparent = $row['parent'];
			$tempfatherlist2 = $this->fatherlist($tempparent);
			$tempfatherlist1 .=(($tempfatherlist1=='')?'':',').$tempparent;
			if($tempfatherlist2!='')$tempfatherlist1 .=','.$tempfatherlist2;			
		}
		return $tempfatherlist1;
	}
	/*
		函数:自动获得字符串中某张图片的URL
		参数:字符串,序号
		返回:图片地址
	*/
	public function auto_small_img($content='',$issmall_img=1){
		$small_img = '';
		$content = stripslashes($content);
		if(!$this->isint($issmall_img))return $small_img;
		if($content=='' || $issmall_img<=0)return $small_img;
		preg_match_all("/<img.+src=\"(.+)\"/Ui",$content,$result,PREG_SET_ORDER);
		$issmall_img--;
		$small_img = ($issmall_img<count($result))?$result[$issmall_img][1]:'';
		return $small_img;
	}
	/*
		函数:自动获得图片模型图片列表中某张图片的URL
		参数:字符串,序号
		返回:图片地址
	*/
	public function auto_small_img_pic($content='',$issmall_img=1){
		$small_img = '';
		$content = stripslashes($content);
		if(!$this->isint($issmall_img))return $small_img;
		if($content=='' || $issmall_img<=0)return $small_img;
		$result = explode('##CACOCMSPIC##',$content);
		$issmall_img--;
		$small_img = ($issmall_img<count($result))?$result[$issmall_img]:'';
		return $small_img;
	}
	/*
		函数:获得内容共享的频道列表
		参数:内容id
		返回:共享频道列表
	*/
	public function getshareclassidlist($resid){
		global $mysql;
		$classidlist = '';
		if(!$this->isint($resid))return $classidlist;
		if($resid<=0)return $classidlist;
		$sql = "SELECT class_id FROM ".DB_FIXTABLE."resource_list WHERE shareid = $resid";
		$result = $mysql->sql_query($sql);
		while($row=$mysql->sql_fetchrow($result)){
			$classidlist .= (($classidlist=='')?'':',').$row['class_id'];
		}
		return $classidlist;
	}
	/*
		函数:检查频道数据的写入性
		参数:频道id
		返回:可写 1 不可写 0
	*/
	public function checkclassiswrite($classid)
	{
		global $mysql;
		if(!$this->isint($classid))return 0;
		$sql = "SELECT iswrite_res FROM ".DB_FIXTABLE."resclass_list WHERE id = $classid LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row=$mysql->sql_fetchrow($result);
		if(!$row)return 0;
		return ($row['iswrite_res'])?1:0;
	}
	/*函数:替换标题中的()为（）*/
	public function strtitle($str)
	{
		if(strpos($str,'(')!==false)$str = str_replace('(','（',$str);
		if(strpos($str,')')!==false)$str = str_replace(')','）',$str);
		if(strpos($str,'|')!==false)$str = str_replace('|','｜',$str);
		if(strpos($str,'"')!==false)$str = str_replace('"',"'",$str);
		return $str;
	}
	/*
		国务院编码规范
		函数:生成内容的编号/日期串/日期索引
		参数:添加日期,频道ID
		返回:内容的编号/日期串/日期索引
	*/
	public function makerescoding($cid,$restime,$creator,$resid=0)
	{
		global $admin,$mysql;
		//获得内容年月
		$resdatestr = date('Y',$restime);
		//获得当前频道的根频道
		$rootcid = $this->get_rootclassid($cid);		
		//内容如果是已经存在的数据
		if($resid>0){
			$sql2 = "SELECT root_class_id,coding,resdate,resindex FROM ".DB_FIXTABLE."resource_xxgk WHERE res_id = $resid";
			$result2 = $mysql->sql_query($sql2);
			$row2 = $mysql->sql_fetchrow($result2);
			//如果已经存在索引编码 并且编码长度为20位
			if(strlen($row2['coding'])==20){
				if($row2['resdate']==$resdatestr && $row2['root_class_id']==$rootcid)return array($row2['coding'],$row2['resdate'],$row2['resindex']);
			}
		}
		//获得流水号
		$sql1 = "SELECT rx.resindex FROM ".DB_FIXTABLE."resource_list rl LEFT JOIN ".DB_FIXTABLE."resource_xxgk rx ON rl.id=rx.res_id WHERE rx.root_class_id = '$rootcid' AND rx.resdate = '$resdatestr' ORDER BY rx.resindex DESC LIMIT 0,1";
		$result1 = $mysql->sql_query($sql1);
		$row1 = $mysql->sql_fetchrow($result1);
		$newresindex = ($row1)?$row1[0]+1:1;
		$sql = "SELECT coding FROM ".DB_FIXTABLE."manage_base WHERE title = '$creator' LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		//如果创建人不存在,赋值组织编码为01
		$organ_id = ($row)?(($row[0]=='' || is_null($row[0]))?'01':$row[0]):'01';
		//获得频道编码
		$classcoding = $this->fathercodinglist($cid);
		$classcoding1 = mb_substr($classcoding,0,9);
		$rescoding = $classcoding1.'/'.$resdatestr.'-'.sprintf("%05d",$newresindex);
		return array($rescoding,$resdatestr,$newresindex);
	}


	/*
	安徽省编码规划
    函数:生成内容的编号/日期串/日期索引
    参数:添加日期,频道ID
    返回:内容的编号/日期串/日期索引

	public function makerescoding($cid,$restime,$creator,$resid=0)
	{
		global $admin,$mysql;
		//获得内容年月
		$resdatestr = date('Y',$restime).date('m',$restime);
		
		//内容如果是已经存在的数据
		if($resid>0){
			$sql2 = "SELECT rl.class_id,rx.coding,rx.resdate,rx.resindex FROM ".DB_FIXTABLE."resource_list rl LEFT JOIN ".DB_FIXTABLE."resource_xxgk rx ON rl.id=rx.res_id WHERE rl.id = $resid";
			$result2 = $mysql->sql_query($sql2);
			$row2 = $mysql->sql_fetchrow($result2);
			//如果已经存在索引编码
			if($row2['coding']!=''){
				if($row2['resdate']==$resdatestr && $row2['class_id']==$cid)return array($row2['coding'],$row2['resdate'],$row2['resindex']);
			}
		}

		//获得流水号
		$sql1 = "SELECT rx.resindex FROM ".DB_FIXTABLE."resource_list rl LEFT JOIN ".DB_FIXTABLE."resource_xxgk rx ON rl.id=rx.res_id WHERE rl.class_id = '$cid' AND rx.resdate = '$resdatestr' ORDER BY rx.resindex DESC LIMIT 0,1";
		$result1 = $mysql->sql_query($sql1);
		$row1 = $mysql->sql_fetchrow($result1);
		$newresindex = ($row1)?$row1[0]+1:1;

		$sql = "SELECT coding FROM ".DB_FIXTABLE."manage_base WHERE title = '$creator' LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		//如果创建人不存在,赋值组织编码为01
		$organ_id = ($row)?(($row[0]=='' || is_null($row[0]))?'01':$row[0]):'01';
		//获得频道编码
		$classcoding = $this->fathercodinglist($cid);
		$classcoding1 = mb_substr($classcoding,0,5);
		$classcoding2 = mb_substr($classcoding,5);
		$rescoding = $classcoding1.$organ_id.$classcoding2.$resdatestr.sprintf("%03d",$newresindex);

		return array($rescoding,$resdatestr,$newresindex);
	}
	*/
	/*
		函数:内容频道编码列表
		参数:内容频道ID
		返回:ID列，如: 23231132
	*/
	public function fathercodinglist($cid){
		if(!$this->isint($cid))return '';
		global $mysql;
		$sql = "SELECT parent,coding FROM ".DB_FIXTABLE."resclass_list WHERE id = $cid";
		$result = $mysql->sql_query($sql);
		$tempcodinglist1='';
		while($row=$mysql->sql_fetchrow($result)){
			$tempcodinglist2 = $this->fathercodinglist($row['parent']);
			$tempcodinglist1 = $tempcodinglist2.$row['coding'].$tempcodinglist1;
		}
		return $tempcodinglist1;
	}
	/*
		函数：检测碎片列表的合法性
		参数：碎片列表
		返回：合法碎片列表，无，返回空
	*/
	public function checksliceid($slice_id_list) {
		global $mysql;
		if($slice_id_list == '')return '';
		$re_slice_id_list = '';
		$sql = "SELECT id FROM ".DB_FIXTABLE."slice_list WHERE id IN($slice_id_list) ORDER BY ID ASC";
		$result = $mysql->sql_query($sql);
		while($row= $mysql->sql_fetchrow($result)) {
			$re_slice_id_list .= (($re_slice_id_list=='')?'':',').$row[0]; 	
		}
		return $re_slice_id_list;
	}
	/*
		函数：保存模板文件
	*/
	public function saveslicecontent($fpath,$sflag,$eflag,$strhtml) {
		global $tpl;
		$tpl->opentemplate($fpath);
		$tpl->startelement = $sflag;
		$tpl->endelement = $eflag;
		$tpl->value = $strhtml;
		$tpl->replacetemplate();
		$tpl->save();
	}
	/*
		函数：更新碎片
		参数：碎片ID列表
	*/
	public function executeslicebyid($idlist) {
		global $mysql,$cfg,$sparser,$creator;
		$sql = "SELECT sl.slice_type,sl.class_id,sl.start_flag,sl.end_flag,si.slice_data,si.file_path FROM ".DB_FIXTABLE."slice_list AS sl LEFT JOIN ".DB_FIXTABLE."slice_info AS si ON sl.id=si.id WHERE si.id IN($idlist)";
		$result = $mysql->sql_query($sql);
		while($row = $mysql->sql_fetchrow($result))	{
			switch($row['slice_type']) {
				case 1:$tmpcontent = $sparser->compile($row['slice_data'],$row['class_id']);break;	/*动态碎片*/
				case 2:$tmpcontent = "\n".$row['slice_data']."\n";break;	/*手工碎片*/
				case 3:$tmpcontent = file_get_contents($row['slice_data']);break;	/*静态碎片*/
				default:$tmpcontent = '';break;		/*其它类型*/
			}
			$file_path_real = $this->creat_path($row['file_path'],$row['class_id']);
			$arr_file_path = explode(';',$file_path_real);
			foreach($arr_file_path as $value) {
				$fpath = $cfg->webroot.$value;
				$this->saveslicecontent($fpath,$row['start_flag'],$row['end_flag'],$tmpcontent);
			}
		}
		$sql = "UPDATE ".DB_FIXTABLE."slice_list SET last_updata_date='$cfg->nowtime', last_updata_user='$creator' WHERE id IN ($idlist)";
		$mysql->sql_query($sql);
	}
	/*
		函数:字节方式截取字条串函数
		参数:字符串，保留字节，增加字符
	*/
	public function utf_substr($str,$len,$sadd='…'){ 
		$ok_str = $str;
		$ok_str_1 = '';
		$ok_str_1_len = $len-2;
		for($i=0;$i<$len;$i++){ 
			$temp_str=substr($str,0,1); 
			if(ord($temp_str) > 127){ 
				$i++; 
				if($i<$len){ 
					$new_str[]=substr($str,0,3); 
					$str=substr($str,3); 
				} 
			}else{ 
				$new_str[]=substr($str,0,1); 
				$str=substr($str,1); 
			}
			if($i <= $ok_str_1_len)$re_str_1 = join($new_str);
		} 
		$re_str = join($new_str);
		return ($re_str == $ok_str)?($re_str):($re_str_1.$sadd);
	} 
}
?>