<?php
/*
	TCMS 用户管理类文件
	作者:三木
*/
class Manager
{
	public $userid,$username,$userip,$remark,$logined,$popedomlist,$folderlist;
	public $websitepath,$rootnodelist,$rootspeciallist,$speciallist;
	
	function __construct()
	{
		$this->get_userid();
		$this->get_username();
		$this->get_userip();
		$this->get_logintype();
		$this->get_logined();
		$this->get_popedomlist();
		$this->get_folderlist();
		$this->get_websitepath();
		$this->get_rootnodelist();
		$this->get_rootspeciallist();
		$this->get_speciallist();
		$this->get_rootspeciallist_r();
		$this->get_speciallist_r();
	}
	// 设置SESSION变量：用户ID
	public function get_userid()
	{return $this->userid=(isset($_SESSION['caco_manager_userid']))?$_SESSION['caco_manager_userid']:0;}
	public function set_userid($val)
	{$_SESSION['caco_manager_userid']=$val;}
	
	// 设置SESSION变量：用户名
	public function get_username()
	{return $this->username=(isset($_SESSION['caco_manager_username']))?$_SESSION['caco_manager_username']:'';}
	public function set_username($val)
	{$_SESSION['caco_manager_username']=$val;}
	
	// 设置SESSION变量：用户IP地址
	public function get_userip()
	{return $this->userip=(isset($_SESSION['caco_manager_userip']))?$_SESSION['caco_manager_userip']:'';}
	public function set_userip($val)
	{$_SESSION['caco_manager_userip']=$val;}
	
	// 设置SESSION变量：用户备注
	public function get_logintype()
	{return $this->logintype=(isset($_SESSION['caco_manager_logintype']))?$_SESSION['caco_manager_logintype']:'';}
	public function set_remark($val)
	{$_SESSION['caco_manager_logintype']=$val;}
	
	// 设置SESSION变量：用户登陆标志
	public function get_logined()
	{return $this->logined=(isset($_SESSION['caco_manager_logined']))?$_SESSION['caco_manager_logined']:0;}
	public function set_logined($val)
	{$_SESSION['caco_manager_logined']=$val;}
	
	// 设置SESSION变量：用户权限列表
	public function get_popedomlist()
	{return $this->popedomlist=(isset($_SESSION['caco_manager_popedomlist']))?$_SESSION['caco_manager_popedomlist']:'';}
	public function set_popedomlist($val)
	{$_SESSION['caco_manager_popedomlist']=$val;}
	
	// 设置SESSION变量：用户文件夹列表
	public function get_folderlist()
	{return $this->folderlist=(isset($_SESSION['caco_manager_folderlist']))?$_SESSION['caco_manager_folderlist']:'';}
	public function set_folderlist($val)
	{$_SESSION['caco_manager_folderlist']=$val;}
	
	// 设置SESSION变量：用户WEB站点
	public function get_websitepath()
	{return $this->websitepath=(isset($_SESSION['caco_manager_websitepath']))?$_SESSION['caco_manager_websitepath']:'';}
	public function set_websitepath($val)
	{$_SESSION['caco_manager_websitepath']=$val;}
	
	public function get_rootnodelist()
	{return $this->rootnodelist=(isset($_SESSION['caco_manager_rootnodelist']))?$_SESSION['caco_manager_rootnodelist']:'';}
	public function set_rootnodelist($val)
	{$_SESSION['caco_manager_rootnodelist']=$val;}

	// 设置SESSION变量：用户根特性
	public function get_rootspeciallist()
	{return $this->rootspeciallist=(isset($_SESSION['caco_manager_rootspeciallist']))?$_SESSION['caco_manager_rootspeciallist']:'';}
	public function set_rootspeciallist($val)
	{$_SESSION['caco_manager_rootspeciallist']=$val;}

	// 设置SESSION变量：用户特性列表
	public function get_speciallist()
	{return $this->speciallist=(isset($_SESSION['caco_manager_speciallist']))?$_SESSION['caco_manager_speciallist']:'';}
	public function set_speciallist($val)
	{$_SESSION['caco_manager_speciallist']=$val;}

	// 设置SESSION变量：用户可选择根特性
	public function get_rootspeciallist_r()
	{return $this->rootspeciallist_r=(isset($_SESSION['caco_manager_rootspeciallist_r']))?$_SESSION['caco_manager_rootspeciallist_r']:'';}
	public function set_rootspeciallist_r($val)
	{$_SESSION['caco_manager_rootspeciallist_r']=$val;}

	// 设置SESSION变量：用户可选择特性列表
	public function get_speciallist_r()
	{return $this->speciallist_r=(isset($_SESSION['caco_manager_speciallist_r']))?$_SESSION['caco_manager_speciallist_r']:'';}
	public function set_speciallist_r($val)
	{$_SESSION['caco_manager_speciallist_r']=$val;}
	
	/*
		函数:用户登录认证
		参数:用户名, 密码, 登录Ip
		返回: 0 : 用户不存在  1 : 登录成功  2 : 用户被禁止登录  3 : 密码有误  4 : 侍定...
	*/
	public function login($musername,$muserpass,$muserip)
	{
		global $cfg, $mysql;
		$musername = strtolower($musername);
		$sql = "SELECT m.id,m.title,m.pwd,m.disabled,m.login_type AS self_login_type,m.remark,m.errstart,m.errnum,i.folder_list AS self_folder_list,i.res_class_list AS self_res_class_list,i.pope_id_list AS self_pope_id_list,i.special_id_list AS self_special_id_list,i.special_id_listr AS self_special_id_listr,pr.login_type AS role_login_type,pi.folder_list AS role_folder_list,pi.res_class_list AS role_res_class_list,pi.pope_id_list AS role_pope_id_list,pi.special_id_list AS role_special_id_list,pi.special_id_listr AS role_special_id_listr FROM ".DB_FIXTABLE."manage_base m LEFT JOIN ".DB_FIXTABLE."manage_info i ON m.id = i.id LEFT JOIN ".DB_FIXTABLE."popedom_role pr ON m.pope_role = pr.id LEFT JOIN ".DB_FIXTABLE."popedom_info pi ON m.pope_role = pi.id Where m.title='$musername' limit 0,1";
		//echo $sql;exit;
		$result = $mysql->sql_query($sql);
		$row=$mysql->sql_fetchrow($result);
		if(!$row)return 0;
		if($row['disabled'])return 2;
		$muserpass = sha1($cfg->password_encodekey.$muserpass);
		if($row['pwd']!=$muserpass)
		{
			//如果错误监视启动时间变空,或监视数为0,则启动监视器
			if($row['errstart']==0 || $row['errnum']==0)
			{
				$sql = "Update ".DB_FIXTABLE."manage_base Set errstart = '$cfg->nowtime',errnum=1,err_total=err_total+1 Where title='$musername'";
				$mysql->sql_query($sql);
				return 3;
			}else{
				//是否在监视器有效时间范围内
				if(time()-$row['errstart'] <= $cfg->manager_range_errtimerang)
				{
					//用户错误登录次数是否走出上限,超出则封账号
					if($row['errnum'] >= $cfg->manager_limitloginerror)
					{
						$sql = "Update ".DB_FIXTABLE."manage_base Set errnum='0',disabled='1',err_total=err_total+1 Where title = '$musername'";
						$mysql->sql_query($sql);
						return 2;
					}else{
						$sql = "Update ".DB_FIXTABLE."manage_base Set errnum=errnum+1,err_total=err_total+1 Where title = '$musername'";
						$mysql->sql_query($sql);
						return 3;
					}
				}else{
					//监视器已超时,复位监视参数	
					$sql = "Update caco_manage_base Set errstart='$cfg->nowtime',errnum=1,err_total=err_total+1 Where title = '$musername'";
					$mysql->sql_query($sql);
					return 3;
				}
			}
		}
		$this->set_userid($row['id']);
		$this->set_username($musername);
		$this->set_userip($muserip);
		$this->set_logined(1);
		//相关权限处理
		$login_type = $row['role_login_type'] || $row['self_login_type'];
		$this->set_remark($login_type);
		$this->resclass_process($row['role_res_class_list'],$row['self_res_class_list'],$login_type);
		$this->popedomlist_process($row['role_pope_id_list'],$row['self_pope_id_list']);
		$this->specialList_process($row['role_special_id_list'],$row['self_special_id_list']);
		$this->specialList_process_r($row['role_special_id_listr'],$row['self_special_id_listr']);
		$this->folderlist_process($row['role_folder_list'],$row['self_folder_list']);

		//记录登录信息
		$sql = "Update ".DB_FIXTABLE."manage_base Set login_total=login_total+1,last_logintime2=last_logintime,last_logintime='$cfg->nowtime',last_loginip2=last_loginip,last_loginip='$muserip' Where title = '$musername'";
		$mysql->sql_query($sql);
		$sql = "Insert Into ".DB_FIXTABLE."login_log(title,login_time,login_ip)Values('$musername','$cfg->nowtime','$muserip')";
		$mysql->sql_query($sql);
		return 1;
	}
	/*	函数:初始化当前用户所具有的目录管理权限列表 */
	private function folderlist_process($role_folder_list,$self_folder_list)
	{
		if(is_null($role_folder_list))$role_folder_list='';
		if(is_null($self_folder_list))$self_folder_lsit='';
		if($role_folder_list=='' && $self_folder_list=='')return;
		global $flib;
		$xmldoc = new DOMDocument('1.0','utf-8');
		$xmldoc->loadXML("<?xml version=\"1.0\" encoding=\"utf-8\"?><file></file>");
		$root = $xmldoc->getElementsByTagName('file');

		$i=0;
		$website='';
		$tmpxmldoc = new DOMDocument();
		if($role_folder_list!='')
		{
			$tmpxmldoc->loadXML($role_folder_list);
			$tmpfile_items = $tmpxmldoc->getElementsByTagName('item');
			foreach($tmpfile_items as $tmpfile_item)
			{
				if($tmpfile_item->getElementsByTagName('name')->item(0)->nodeValue=='website')
				{
					$website .= (($website=='')?'':';').$flib->creat_path($tmpfile_item->getElementsByTagName('path')->item(0)->nodeValue);
				}
				$file_item = $xmldoc->importNode($tmpfile_item,true);;
				$elem1 = $xmldoc->createElement('index',$i);
				$file_item->appendChild($elem1);
				$root->item(0)->appendChild($file_item);
				$i++;
			}
		}
		if($self_folder_list!='')
		{
			$tmpxmldoc->loadXML($self_folder_list);
			$tmpfile_items = $tmpxmldoc->getElementsByTagName('item');
			foreach($tmpfile_items as $tmpfile_item)
			{
				if($tmpfile_item->getElementsByTagName('name')->item(0)->nodeValue=='website')
				{
					$website .= (($website=='')?'':';').$flib->creat_path($tmpfile_item->getElementsByTagName('path')->item(0)->nodeValue);
				}
				$file_item = $xmldoc->importNode($tmpfile_item,true);;
				$elem1 = $xmldoc->createElement('index',$i);
				$file_item->appendChild($elem1);
				$root->item(0)->appendChild($file_item);
				$i++;
			}
		}
		$this->set_folderlist($xmldoc->saveXML());
		$this->set_websitepath($website);
	}
	/* 函数:初始化当前用户可管理的资源特性列表*/
	private function specialList_process($role_special_list,$self_special_list)
	{
		global $flib;
		if(is_null($role_special_list))$role_special_list = '';
		if(is_null($self_special_list))$self_special_list = '';
		if($role_special_list=='' && $self_special_list=='')return;
		$tempspecial_idlist = $role_special_list;
		if($self_special_list!='')
		{
			if($tempspecial_idlist!='')$tempspecial_idlist.=',';
			$tempspecial_idlist.=$self_special_list;
		}
		
		$arrtempspecial_idlist = explode(',',$tempspecial_idlist);
		$num_arrtempspecial_idlist = count($arrtempspecial_idlist);
		$tempspecial_childen_idlist = '';
		for($i=0;$i<$num_arrtempspecial_idlist;$i++)
		{
			if($arrtempspecial_idlist[$i]==-1)
			{
				$tempspecial_idlist = -1;
				$tempspecial_childen_idlist = -1;
				break;
			}
			$tempspecial_childen_idlist1 = $flib->childenlist_s($arrtempspecial_idlist[$i]);
			$tempspecial_childen_idlist1 .= ($tempspecial_childen_idlist1=='')?'':',';
			$tempspecial_childen_idlist.= (($tempspecial_childen_idlist=='')?'':',').$tempspecial_childen_idlist1.$arrtempspecial_idlist[$i];
		}
		$this->set_rootspeciallist($tempspecial_idlist);
		$this->set_speciallist($tempspecial_childen_idlist);
		return;
	}
	/*函数:初始化当前用户可选择的资源特性列表*/
	private function specialList_process_r($role_special_list,$self_special_list)
	{
		global $flib;
		if(is_null($role_special_list))$role_special_list = '';
		if(is_null($self_special_list))$self_special_list = '';
		if($role_special_list=='' && $self_special_list=='')return;
		$tempspecial_idlist = $role_special_list;
		if($self_special_list!='')
		{
			if($tempspecial_idlist!='')$tempspecial_idlist.=',';
			$tempspecial_idlist.=$self_special_list;
		}
		
		$arrtempspecial_idlist = explode(',',$tempspecial_idlist);
		$num_arrtempspecial_idlist = count($arrtempspecial_idlist);
		$tempspecial_childen_idlist = '';
		for($i=0;$i<$num_arrtempspecial_idlist;$i++)
		{
			if($arrtempspecial_idlist[$i]==-1)
			{
				$tempspecial_idlist = -1;
				$tempspecial_childen_idlist = -1;
				break;
			}
			$tempspecial_childen_idlist1 = $flib->childenlist_s($arrtempspecial_idlist[$i]);
			$tempspecial_childen_idlist1 .= ($tempspecial_childen_idlist1=='')?'':',';
			$tempspecial_childen_idlist.= (($tempspecial_childen_idlist=='')?'':',').$tempspecial_childen_idlist1.$arrtempspecial_idlist[$i];
		}
		$this->set_rootspeciallist_r($tempspecial_idlist);
		$this->set_speciallist_r($tempspecial_childen_idlist);
		return;
	}

	/*'函数:初始化当前用户所具有的权限列表'*/	
	private function popedomlist_process($role_popedom_list,$self_popedom_list)
	{
		global $mysql;
		if(is_null($role_popedom_list))$role_popedom_list = '';
		if(is_null($self_popedom_list))$self_popedom_list = '';
		if($role_popedom_list=='' && $self_popedom_list=='')return;
		//是否具有所有管理员权限
		if($role_popedom_list=='-1' || $self_popedom_list=='-1'){$this->set_popedomlist('-1');return;}
		$temppopedom_idlist = $role_popedom_list;
		if($self_popedom_list!='')
		{
			if($temppopedom_idlist!='')$temppopedom_idlist.=',';
			$temppopedom_idlist.=$self_popedom_list;
		}
		//取出当前用户具有的权限Key列表，以逗号隔开
		$temppopedomlist = '';
		$sql = "SELECT pope_key FROM ".DB_FIXTABLE."popedom_list WHERE id IN ($temppopedom_idlist)";
		$result = $mysql->sql_query($sql);
		while($row = $mysql->sql_fetchrow($result))
		{
			$temppopedomlist .= ($temppopedomlist=='')?$row['pope_key']:','.$row['pope_key'];
		}
		$this->set_popedomlist($temppopedomlist);
		return;
	}

	/*
		频道权限处理函数
		参数:角色赋于的频道权限, 用户自身增回的频道权限
		说明:
			权限的设置原则依据：将各权限标识位进行或(OR)运算。
			举例：
				现有一大类:游戏新闻,其权限为:浏览、删除、添加
				在“游戏新闻”分类下有一子分类：国内游戏新闻,其权限为：添加、审核
				则，最终管理员将得到的“游戏新闻”权限为：浏览、删除、添加、添加、审核。
	*/
	private function resclass_process($role_res_class_list,$self_res_class_list,$login_type)
	{
		global $cfg, $mysql, $flib;
		if(is_null($role_res_class_list))$role_res_class_list = '';
		if(is_null($self_res_class_list))$self_res_class_list = '';
		if($role_res_class_list=='' && $self_res_class_list=='')return;
		$rcpopedom = $role_res_class_list;
		if($rcpopedom=='')
		{
			$rcpopedom .= $self_res_class_list;
		}else{
			$rcpopedom .= ($self_res_class_list=='')?$self_res_class_list:(';'.$self_res_class_list);
		}
		$sql = "DELETE FROM ".DB_FIXTABLE."manage_online WHERE mid='{$this->get_userid()}'";
		$mysql->sql_query($sql);
		$arrrcpopedom = explode(';',$rcpopedom);
		$count_arrrcpopedom = count($arrrcpopedom);
		$tmprootnodelist = '';
		//如设置即时权限验证,则不写入子频道信息
		if($login_type == 1)
		{
			for($i=0;$i<$count_arrrcpopedom;$i++)
			{
				$arrrcpopedomitem = explode(',',$arrrcpopedom[$i],4);
				$sql = "SELECT pope_flag,root_node,sub_flag FROM ".DB_FIXTABLE."manage_online WHERE mid={$this->get_userid()} AND class_id={$arrrcpopedomitem[0]} LIMIT 0,1";
				$result1 = $mysql->sql_query($sql);
				$row1 = $mysql->sql_fetchrow($result1);
				if($row1)
				{
					$tmppopeflag = $flib->popeflag_or($arrrcpopedomitem[1],$row1['pope_flag']);
					$tmprootflag = ($row['root_node'] || $arrrcpopedomitem[2])?1:0;
					$tmpsubflag = ($row['sub_flag'] || $arrrcpopedomitem[3])?1:0;
					$sql = "UPDATE ".DB_FIXTABLE."manage_online SET pope_flag='$tmppopeflag',root_node='$tmprootflag',sub_flag='$tmpsubflag' WHERE mid={$this->get_userid()} AND class_id={$arrrcpopedomitem[0]}";
					$result2 = $mysql->sql_query($sql);
				}else{
					$class_pid = $flib->get_fatherclassid($arrrcpopedomitem[0]);
					$sql = "INSERT INTO ".DB_FIXTABLE."manage_online (mid,class_pid,class_id,pope_flag,root_node,use_flag,sub_flag)VALUES('{$this->get_userid()}','$class_pid','$arrrcpopedomitem[0]','$arrrcpopedomitem[1]','$arrrcpopedomitem[2]','0','$arrrcpopedomitem[3]')";
					$mysql->sql_query($sql);
				}
				if($arrrcpopedomitem[2]==1)
				{
					if($tmprootnodelist!='')$tmprootnodelist .= ',';
					$tmprootnodelist .= $arrrcpopedomitem[0];
				}
			}
		}else{
			for($i=0;$i<$count_arrrcpopedom;$i++)
			{
				$arrrcpopedomitem = explode(',',$arrrcpopedom[$i],4);
				$sql = "SELECT pope_flag,root_node,sub_flag FROM ".DB_FIXTABLE."manage_online WHERE mid={$this->get_userid()} AND class_id={$arrrcpopedomitem[0]} LIMIT 0,1";
				$result1 = $mysql->sql_query($sql);
				$row1 = $mysql->sql_fetchrow($result1);
				if($row1)
				{
					$tmppopeflag = $flib->popeflag_or($arrrcpopedomitem[1],$row1['pope_flag']);
					$tmprootflag = ($row['root_node'] || $arrrcpopedomitem[2])?1:0;
					$tmpsubflag = ($row['sub_flag'] || $arrrcpopedomitem[3])?1:0;
					$sql = "UPDATE ".DB_FIXTABLE."manage_online SET pope_flag='$tmppopeflag',root_node='$tmprootflag',sub_flag='$tmpsubflag' WHERE mid={$this->get_userid()} AND class_id={$arrrcpopedomitem[0]}";
					$result2 = $mysql->sql_query($sql);
				}else{
					$class_pid = $flib->get_fatherclassid($arrrcpopedomitem[0]);
					$sql = "INSERT INTO ".DB_FIXTABLE."manage_online (mid,class_pid,class_id,pope_flag,root_node,use_flag,sub_flag)VALUES('{$this->get_userid()}','$class_pid','$arrrcpopedomitem[0]','$arrrcpopedomitem[1]','$arrrcpopedomitem[2]','1','$arrrcpopedomitem[3]')";
					$mysql->sql_query($sql);
				}
				if($arrrcpopedomitem[2]==1)
				{
					if($tmprootnodelist!='')$tmprootnodelist .= ',';
					$tmprootnodelist .= $arrrcpopedomitem[0];
				}
			}
			for($i=0;$i<$count_arrrcpopedom;$i++)
			{
				$arrrcpopedomitem = explode(',',$arrrcpopedom[$i],4);
				$this->resclass_process_search($arrrcpopedomitem[0],$arrrcpopedomitem[1],$arrrcpopedomitem[3]);
			}
		}
		$this->set_rootnodelist($tmprootnodelist);
		return;
	}
	/* 资源配置递归搜索，并处理权限标识位*/
	private function resclass_process_search($parent,$root_popeflag,$sub_flag)
	{
		global $cfg, $mysql, $flib;
		$sql = "SELECT id FROM ".DB_FIXTABLE."resclass_list WHERE parent=$parent";
		$result = $mysql->sql_query($sql);
		while($row = $mysql->sql_fetchrow($result))
		{
			$sql = "SELECT pope_flag,root_node,sub_flag FROM ".DB_FIXTABLE."manage_online WHERE mid={$this->get_userid()} AND class_id={$row['id']} LIMIT 0,1";
			$result1 = $mysql->sql_query($sql);
			$row1 = $mysql->sql_fetchrow($result1);
			if($row1)
			{
				//当前分类权限已经存在,则计算最终权限并更新
				$tmppopeflag = $flib->popeflag_or($root_popeflag,$row1['pope_flag']);
				$sql = "UPDATE ".DB_FIXTABLE."manage_online SET pope_flag='$tmppopeflag' WHERE mid={$this->get_userid()} AND class_id={$row['id']}";
				$result2 = $mysql->sql_query($sql);
				$this->resclass_process_search($row['id'],$tmppopeflag,$row1['sub_flag']);
			}else{
				//当前分类权限不存在,则插入新记录
				if($sub_flag==1)
				{
					$sql = "INSERT ".DB_FIXTABLE."manage_online (mid,class_pid,class_id,pope_flag,root_node,use_flag,sub_flag)VALUES('{$this->get_userid()}','$parent','{$row['id']}','$root_popeflag','0','1','1')";
					$result2 = $mysql->sql_query($sql);
					$this->resclass_process_search($row['id'],$root_popeflag,1);
				}
			}
		}
	}
	/*
		'函数:验证当前管理员是否有此权限
		'参数:权限标识
		'返回:bool (true:有权限)'
	*/
	public function checkpopedom($pope_key)
	{
		if($pope_key=='' || $this->get_popedomlist()=='')return false;
		if($this->get_popedomlist()=='-1')return true;
		return ((strstr(','.$this->get_popedomlist().',',','.$pope_key.','))?true:false);
	}
	
	/*
		实时处理指定频道的权限 -- 获得上级频道
	*/
	private function getparent_abouttheclass($classid)
	{
		global $mysql;
		$sql1 = "SELECT parent FROM ".DB_FIXTABLE."resclass_list WHERE id=$classid LIMIT 0,1";
		$result1 = $mysql->sql_query($sql1);
		$row1 = $mysql->sql_fetchrow($result1);
		if($row1)
		{
			$sql2 = 'SELECT id FROM '.DB_FIXTABLE.'resclass_list WHERE id='.$row1['parent'].' LIMIT 0,1';
			$result2 = $mysql->sql_query($sql2);
			$row2 = $mysql->sql_fetchrow($result2);
			if($row2)
			{
				return $row2['id'];;
			}else{
			
			}	return 0;
			
		}else{
			return 0;
		}
	}
	/*
		实时处理指定频道的子属性
	*/
	private function getsubflag_abouttheclass($classid)
	{
		global $mysql,$admin,$flib;
		$sql = "SELECT sub_flag FROM ".DB_FIXTABLE."manage_online WHERE class_id=$classid AND mid=$admin->userid LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		return ($row)?$row[0]:0;
	}
	/*
		实时处理指定频道的权限
	*/
	private function getpope_abouttheclass($classid)
	{
		global $mysql,$admin,$flib;
		$sql = "SELECT pope_flag,use_flag,sub_flag FROM ".DB_FIXTABLE."manage_online WHERE class_id=$classid AND mid=$admin->userid LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		if($row)
		{
			if($row['use_flag']==1)
			{
				return array($row['pope_flag'],$row['sub_flag']);
			}else{
				$parent_class = $this->getparent_abouttheclass($classid);
				if($parent_class)
				{
					$arr_parent_popeflag = $this->getpope_abouttheclass($parent_class);
					$parent_popeflag = $arr_parent_popeflag[0];
					$tmppopeflag = $flib->popeflag_or($parent_popeflag,$row['pope_flag']);
					/*
					if($arr_parent_popeflag[1]==1)
					{
						$tmppopeflag = $flib->popeflag_or($parent_popeflag,$row['pope_flag']);
					}elseif($arr_parent_popeflag[1]==0){
						$tmppopeflag = $row['pope_flag'];
					}
					*/
				}else{
					$tmppopeflag = $row['pope_flag'];
				}
				$sql1 = "UPDATE ".DB_FIXTABLE."manage_online SET pope_flag='$tmppopeflag',use_flag='1' WHERE mid='{$this->get_userid()}' AND class_id={$classid}";
				$result1 = $mysql->sql_query($sql1);
				return array($tmppopeflag,$row['sub_flag']);
			}
		}else{
				$tmppopeflag = '00000000000000000000';
				$tmpsubflag = 0;
				$parent_class = $this->getparent_abouttheclass($classid);
				if($parent_class)
				{
					$arr_parent_popeflag = $this->getpope_abouttheclass($parent_class);
					$parent_popeflag = $arr_parent_popeflag[0];
					if($arr_parent_popeflag[1]==1)
					{
						$tmppopeflag = $parent_popeflag;
						$tmpsubflag = $arr_parent_popeflag[1];
						$sql1 = "INSERT ".DB_FIXTABLE."manage_online (mid,class_pid,class_id,pope_flag,root_node,use_flag,sub_flag)VALUES('{$this->get_userid()}','{$parent_class}','{$classid}','$tmppopeflag','0','1','{$tmpsubflag}')";
						$result1 = $mysql->sql_query($sql1);
					}
				}		
				return array($tmppopeflag,$tmpsubflag);
		}
	}
	/*
		取得管理员对于指定频道的权限标识
	*/
	public function chkpope_abouttheclass($classid,$popename)
	{
		global $mysql,$admin,$flib;
		if(!$flib->isint($classid) || $popename=='')return false;
		if($admin->popedomlist == '-1')
		{
			$chkrcpopeflag = true;
		}else{
			$sql = "SELECT pope_flag FROM ".DB_FIXTABLE."manage_online WHERE class_id=$classid AND mid=$admin->userid AND use_flag=1 LIMIT 0,1";
			$result = $mysql->sql_query($sql);
			$row = $mysql->sql_fetchrow($result);
			if($row)
			{
				$popeflag = $row['pope_flag'];			
			}else{
				$sql_in = "SELECT id FROM ".DB_FIXTABLE."resclass_list WHERE id=$classid LIMIT 0,1";
				$result_in = $mysql->sql_query($sql_in);
				$row_in = $mysql->sql_fetchrow($result_in);
				if($row_in)
				{
					$arr_popeflag = $this->getpope_abouttheclass($classid);
					$popeflag = $arr_popeflag[0];
				}else{
					return false;
				}
			}
			switch($popename)
			{
        	    case 'view':		//浏览
            	    $flagpossition = 19;
					break;
	            case 'append':		//增加
    	            $flagpossition = 18;
					break;
            	case 'modify':		//修改
	                $flagpossition = 17;
					break;
        	    case 'delete':		//删除
            	    $flagpossition = 16;
					break;
	            case 'check':		//审核
    	            $flagpossition = 15;
					break;
	            case 'html':		//静态
    	            $flagpossition = 14;
					break;
	            case 'other':		//他人
    	            $flagpossition = 13;
					break;
            	case 'slice':		//碎片
	                $flagpossition = 12;
					break;
        	    case 'template':	//模板
            	    $flagpossition = 11;
					break;
	            case 'class':		//频道
    	            $flagpossition = 10;
					break;
            	default:
                	$flagpossition = -1;
					break;
			}
			$chkrcpopeflag = ($flagpossition==-1)?false:(substr($popeflag,$flagpossition,1)=='1');
		}		
		return $chkrcpopeflag;
	}
	
	/*
		取得管理员对于指定资源特性节点的权限标识
	*/
	public function chkpope_aboutthespecial($pope_key)
	{
		$temp_speciallist = $this->get_speciallist();
		if($pope_key=='' || $temp_speciallist=='')return false;
		if($temp_speciallist=='-1')return true;
		return ((strstr(','.$temp_speciallist.',',','.$pope_key.','))?true:false);
	}
	
	/*  函数:注销账号 */
	public function logoff()
	{
		$this->set_userid('');
		$this->set_username('');
		$this->set_userip('');
		$this->set_remark('');
		$this->set_logined('');
		$this->set_popedomlist('');
		$this->set_folderlist('');
		$this->set_websitepath('');
		$this->set_rootnodelist('');
		$this->set_rootspeciallist('');
		$this->set_speciallist('');
		session_unset();
		session_destroy();
	}
}
?>
