<?php
/*
	类名:Tcms-模板解析器
	简介:
	   分析资源模板内CACO标签，转换成最终数据保存到指定目录内。
	属性:
	   -
	方法:
   createres               创建资源
*/
class ResCreator {
	/*
		方法:创建资源(主方法)
		参数:
		   Resource    资源Rs记录对象
		   TContent    资源所将要套用的模板内容
		返回:
		   0   生成失败
		   1   生成成功
	*/
	public function createres($resinfo,$tempcontent) {
		//模板为空及生成目录不确定的资源不生成
		if($tempcontent=='' || $resinfo['directory_rule']=='' || $resinfo['filename_rule']=='' || is_null($resinfo['directory_rule']) or is_null( $resinfo['filename_rule'])) return 0;
		global $cfg,$mysql,$tparser,$flib;
		$resinfo['directory_rule'] = $flib->creat_path($resinfo['directory_rule'],$resinfo['class_id']);
		$resinfo['replace_path_url'] = $flib->creat_url($resinfo['replace_path_url'],$resinfo['class_id']);
		$resinfo['replace_path'] = $flib->creat_path($resinfo['replace_path'],$resinfo['class_id']);
		//具有跳链接的资源无需生成
		if($resinfo['go_url']!='') {
			$sql = "UPDATE ".DB_FIXTABLE."resource_list SET visit_url='".$resinfo['go_url']."',created=1 WHERE id=".$resinfo['id'];
			$mysql->sql_query($sql);
			return 1;
		}
		//解析模板 没有分页
		$tempcontent = $tparser->parser($resinfo,$tempcontent);
		$arrfileinfo = $this->path_parser($resinfo);
		$OK = file_put_contents($arrfileinfo[1],$tempcontent);
		if($OK){
			$sql = "UPDATE ".DB_FIXTABLE."resource_list SET file_path='".addslashes($arrfileinfo[1])."',visit_url='".$arrfileinfo[2]."',created=1 WHERE id=".$resinfo['id'];
			$mysql->sql_query($sql);
			$re_createres = 1;
		}else{
			$sql = "UPDATE ".DB_FIXTABLE."resource_list SET checked=0,created=0,file_path='',visit_url='' WHERE id=".$resinfo['id'];
			$mysql->sql_query($sql);
			$re_createres = 0;
		}
		return $re_createres;
	}
	/*
		方法:内容生成文件、目录规则解析
		参数:-
		返回:
		   路径信息数组
		   (0) 未转成实际路径的路径的路径信息
		   (1) 已转成实际路径的路径信息
		   (2) 内容对外访问用的Url信息
	*/
	private function path_parser($resinfo){
		global $flib,$cfg;
		$tmp_directory_rule		='';
		$tmp_directory_rule2	='';
		$tmp_filname_rule		='';
		$fileurl				='';
		$tmp_directory_rule = $resinfo['directory_rule'];
		if(strpos($tmp_directory_rule,'{class}')!==false)$tmp_directory_rule = str_replace('{class}',$resinfo['class_id'],$tmp_directory_rule);
		if(strpos($tmp_directory_rule,'{Y}')!==false)$tmp_directory_rule = str_replace('{Y}',date('Y',$resinfo['addtime']),$tmp_directory_rule);
		if(strpos($tmp_directory_rule,'{m}')!==false)$tmp_directory_rule = str_replace('{m}',date('m',$resinfo['addtime']),$tmp_directory_rule);
		if(strpos($tmp_directory_rule,'{d}')!==false)$tmp_directory_rule = str_replace('{d}',date('d',$resinfo['addtime']),$tmp_directory_rule);
		if(strpos($tmp_directory_rule,'{N}')!==false)$tmp_directory_rule = str_replace('{N}',date('N',$resinfo['addtime']),$tmp_directory_rule);
		
		$tmp_filname_rule	= $resinfo['filename_rule'];
		if(strpos($tmp_filname_rule,'{id}')!==false)$tmp_filname_rule	= str_replace('{id}',$resinfo['id'],$tmp_filname_rule);
		if(strpos($tmp_filname_rule,'{class}')!==false)$tmp_filname_rule	= str_replace('{class}',$resinfo['class_id'],$tmp_filname_rule);
		if(strpos($tmp_filname_rule,'{title}')!==false)$tmp_filname_rule	= str_replace('{title}',$resinfo['title'],$tmp_filname_rule);
		if(strpos($tmp_filname_rule,'{author}')!==false)$tmp_filname_rule	= str_replace('{author}',$resinfo['author'],$tmp_filname_rule);
		if($resinfo['replace_path']!='')
		{
			if($resinfo['replace_path']=='{head}')
			{
				$fileurl = $resinfo['replace_path_url'].$tmp_directory_rule;
			}else{
				$fileurl = str_replace($resinfo['replace_path'],$resinfo['replace_path_url'],$tmp_directory_rule);
			}
		}
		if(strpos($fileurl,"\\")!==false)$fileurl = str_replace("\\","/",$fileurl);
		if(strpos($tmp_directory_rule,"\\")!==false)$tmp_directory_rule = str_replace("\\","/",$tmp_directory_rule);
		$tmp_directory_rule2 = $cfg->webroot.$tmp_directory_rule;
		if(!file_exists($tmp_directory_rule2))$flib->rmkdir($tmp_directory_rule2);
		
		$arrfileinfo = array('');
		$arrfileinfo[0] = $tmp_directory_rule.'/'.$tmp_filname_rule;
		$arrfileinfo[1] = $tmp_directory_rule2.'/'.$tmp_filname_rule;
		$arrfileinfo[2] = $fileurl.'/'.$tmp_filname_rule;
		return $arrfileinfo;
	}
}
?>
