<?php
/*
	TCMS 碎片类文件
	作者:三木
*/
class SliceParser {
	private $XMLpath, $XMLdoc, $XMLroot, $XMLnode, $tparser;
    private $nodecommand, $commandtype, $commandtable, $classid;
    public $version, $author, $createtime, $description;

	function __construct(){
		$this->XMLdoc = new DOMDocument();
		$this->tparser = new TagParser();
	}

	public function compile($XMLval,$val=0){
		global $flib;
		$compile_val = '';
		if($XMLval=='' || is_null($XMLval))return $compile_val;
		$this->classid = ($flib->isint($val)===false)?0:$val;
		$this->XMLdoc->loadXML($XMLval);
		$this->XMLroot = $this->XMLdoc->getElementsByTagName('slice');
		$this->version = $this->XMLroot->item(0)->getAttribute('version');
		$this->author = $this->XMLroot->item(0)->getElementsByTagName('author')->item(0)->nodeValue;
		$this->createtime = $this->XMLroot->item(0)->getElementsByTagName('createtime')->item(0)->nodeValue;
		$this->description = $this->XMLroot->item(0)->getElementsByTagName('description')->item(0)->nodeValue;
		$this->nodecommand = $this->XMLroot->item(0)->getElementsByTagName('command');
		$this->commandtype = $this->nodecommand->item(0)->getAttribute('type');
		$this->commandtable = $this->nodecommand->item(0)->getAttribute('table');
		switch($this->commandtype.'_'.$this->commandtable){
			case 'loop_caco_resource_list':
				$compile_val = $this->loop_caco_resource();
				break;
			default:
				$compile_val = '';
				break;
		}
		return $compile_val;
	}

	private function loop_caco_resource(){
		global $flib,$admin,$mysql;
		$XMLparameter = $this->nodecommand->item(0)->getElementsByTagName('parameter');
		if($XMLparameter->item(0)->getAttribute('type')=='custome'){
			$sql = $XMLparameter->item(0)->getElementsByTagName('sql')->item(0)->nodeValue;
		}else{
			$sqlwhere='(rl.checked=1 AND rl.deleted=0 AND rl.created=1)';
			//处理频道列表
			$childidlist='';
			$idlist='';
			$XMLnode = $XMLparameter->item(0)->getElementsByTagName('class_list')->item(0)->getElementsByTagName('item');
			foreach($XMLnode as $value){
				$tempclassid = -1;
				switch($value->nodeValue){
					case '{classid}':$tempclassid = $this->classid;break;
					case '{classid:parent}':$tempclassid = $flib->get_fatherclassid($this->classid);break;
					case '{classid:root}':$tempclassid = $flib->get_rootclassid($this->classid);break;
					default:$tempclassid = ($flib->isint($value->nodeValue))?$value->nodeValue:-1;break;
				}
				$childidlist = ($value->getAttribute('child')=='1')?$flib->childenlist($tempclassid):'';
				$childidlist .= (($childidlist=='')?'':',').$tempclassid;
				$idlist .= (($idlist=='')?'':',').$childidlist;
			}
			$sqlwhere .= ($idlist=='')?'':" AND rl.class_id IN($idlist)";
			//处理Top参数
			$ptop = $XMLparameter->item(0)->getElementsByTagName('top')->item(0)->nodeValue;
			$sqllimit = ($ptop=='')?'':"LIMIT 0,$ptop";
			//正理特性列表
			$childidlist='';
			$idlist='';
			$tmpsql='';
			$XMLnode = $XMLparameter->item(0)->getElementsByTagName('special_list')->item(0)->getElementsByTagName('item');
			foreach($XMLnode as $value){
				$childidlist = ($value->getAttribute('child')=='1')?$flib->childenlist_s($value->nodeValue):'';
				$childidlist .= (($childidlist=='')?'':',').$value->nodeValue;
				$idlist .= (($idlist=='')?'':',').$childidlist;
			}
			if($idlist!=''){
				$arr_idlist = explode(',',$idlist);
				foreach($arr_idlist as $value){
					$tmpsql .= (($tmpsql=='')?'':' OR')." concat(',',rl.special,',') LIKE '%,$value,%'";
				}
			}
			$sqlwhere .= ($tmpsql=='')?'':" AND ($tmpsql)";
			
			//处理字段
			$tmpsql='';
			$XMLnode = $XMLparameter->item(0)->getElementsByTagName('filed_list')->item(0)->getElementsByTagName('item');
			foreach($XMLnode as $value){
				$tmpsql .= ($tmpsql=='')?'':' OR';
				switch($value->getAttribute('type')){
					case 'equal':$tmpsql .= ' '.$value->getAttribute('name').' = '.$value->nodeValue;break;
					case 'like' :$tmpsql .= ' '.$value->getAttribute('name').' LIKE '.$value->nodeValue;break;
					case 'in'   :$tmpsql .= ' '.$value->getAttribute('name').' IN '.$value->nodeValue;break;
					case 'great':$tmpsql .= ' '.$value->getAttribute('name').' > '.$value->nodeValue;break;
					case 'less' :$tmpsql .= ' '.$value->getAttribute('name').' < '.$value->nodeValue;break;
				}
			}
			$sqlwhere .= ($tmpsql=='')?'':" AND ($tmpsql)";
			//处理排序参数
			$XMLnode = $XMLparameter->item(0)->getElementsByTagName('orderby')->item(0)->getElementsByTagName('item');
			$porderby = '';
			foreach($XMLnode as $value){
				$porderby .= ($porderby=='')?'':','; 
				$porderby .= $value->getAttribute('name').(($value->getAttribute('method')=='desc')?' DESC':' ASC');
			}
			if($porderby!='')$porderby = ' ORDER BY '.$porderby;
			$sql  = "SELECT rl.id,rl.class_id,rl.title,rl.special,rl.short_content,rl.go_url,rl.keyword,rl.assessor,rl.creator,rl.author,rl.resfrom,rl.checked,rl.deleted,rl.created,rl.selftemplate_id,rl.relate_list,rl.file_path,rl.visit_url,rl.small_img,rl.addtime,rl.uptime,rl.total_hit,rl.istop,rl.shareid,rl.sharerale,rl.type_mode,";
			$sql .= "rx.root_class_id,rx.textnum,rx.coding,rx.resdate,rx.resindex,rx.scatname,rx.scatcode,rx.scatkey,";
			$sql .= "rp.pic_url,rp.pic_text,";
			$sql .= "rd.content,rd.content_size,";
			$sql .= "cl.title AS class_title,rcl.title AS root_class_title,cl.home_url,cl.template_id,cl.parent,cl.directory_rule,cl.replace_path,cl.replace_path_url,cl.filename_rule ";
			$sql .= "FROM ".DB_FIXTABLE."resource_list rl ";
			$sql .= "LEFT JOIN ".DB_FIXTABLE."resource_xxgk rx ON rl.id=rx.res_id ";
			$sql .= "LEFT JOIN ".DB_FIXTABLE."resource_pic rp ON rl.id=rp.res_id ";
			$sql .= "LEFT JOIN ".DB_FIXTABLE."resource_data rd ON rl.id=rd.res_id ";
			$sql .= "LEFT JOIN ".DB_FIXTABLE."resclass_list cl ON rl.class_id=cl.id ";
			$sql .= "LEFT JOIN ".DB_FIXTABLE."resclass_list rcl ON rx.root_class_id=rcl.id ";
			$sql .= "WHERE $sqlwhere $porderby $sqllimit";
		}
		if(!$admin->checkpopedom('CACO_GROUP3_SLICE')){
			$regex = "/^(SELECT)(.*?)/";
			if(!preg_match($regex,$sql)){$flib->alert('你的SQL太危险,系统禁止运行!','BACK',0);exit();};
			if(strpos($sql,DB_FIXTABLE.'manage_base')||strpos($sql,DB_FIXTABLE.'manage_info')){$flib->alert('你的SQL太危险,系统禁止运行!','BACK',0);exit();};
		}
		$result = $mysql->sql_query($sql);
		$XMLbody = $this->nodecommand->item(0)->getElementsByTagName('body');
		$strhtml = '';
		if(mysql_num_rows($result)){
			$startnum = 0;
			$endnum   = 0;
			$XMLnode = $XMLbody->item(0)->getElementsByTagName('loop');
			$isXMLnode = false;
			foreach($XMLnode as $value){$isXMLnode = true;}
			if($isXMLnode){
				$startnum = ($flib->isint($XMLnode->item(0)->getAttribute('start')))?$XMLnode->item(0)->getAttribute('start'):0;
				$endnum = ($flib->isint($XMLnode->item(0)->getAttribute('end')))?$XMLnode->item(0)->getAttribute('end'):0;
				$oddrowhtml = $XMLnode->item(0)->getElementsByTagName('oddrow')->item(0)->nodeValue;
				$evenrowhtml = $XMLnode->item(0)->getElementsByTagName('evenrow')->item(0)->nodeValue;
				$defaulthtml = $XMLnode->item(0)->getElementsByTagName('default')->item(0)->nodeValue;
				$rowtemplate = '';
				$i = 0;
				while($row= $mysql->sql_fetchrow($result)){
					$i++;
					if($i>=$startnum && $i<=$endnum){
						$rowtemplate = ($i%2==0)?$oddrowhtml:$evenrowhtml;
						$rowtemplate = ($rowtemplate=='')?$defaulthtml:$rowtemplate;
						$strhtml .= $this->tparser->parser($row,$rowtemplate); 
					}
				}
			}else{
				$strhtml = '';
			}
		}else{
			$strhtml = $XMLbody->item(0)->getElementsByTagName('empty')->item(0)->nodeValue;
		}
		$strhtml = $XMLbody->item(0)->getElementsByTagName('head')->item(0)->nodeValue.$strhtml.$XMLbody->item(0)->getElementsByTagName('foot')->item(0)->nodeValue;
		return $strhtml;
	}
}
?>