<?php
/*
	类名:Tcms标签库解析
	说明:
	所有CACO模板资源标签格式:
           <!--CACO:指令名([参数])-->
*/
class TagParser {
	private $resinfo;
	public function parser($res,$str){
		$this->resinfo = $res;
		$tempcontent = $str;
		$tempcontent1= '';
		preg_match_all ("/(\<\!\-\-(TSYS|CACO):(.*?)\-\-\>)/",$tempcontent,$cacotag,PREG_SET_ORDER);
		$count_cacotag = count($cacotag);
		for($i=0;$i<$count_cacotag;$i++){
			$tempcontent = str_replace($cacotag[$i][1],$this->forparser($cacotag[$i][3]),$tempcontent);
		}
		return $tempcontent;
	}
/*
	递归处理嵌套标签
*/
	private function forparser($myflag) {
		if(preg_match_all ("/([a-z0-9_]{1,50})\(((?:(?![a-z0-9_]{1,50}\(.*?\)).)*?)\)/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			switch($cacotag_name[0][1]){
				case 'data':$cacotag_parser_switch = $this->cacotag_data_field($cacotag_name[0][2]);break;
				case 'format_date':$cacotag_parser_switch = $this->cacotag_format_date($cacotag_name[0][2]);break;
				case 'filter_html':$cacotag_parser_switch = $this->cacotag_filter_html($cacotag_name[0][2]);break;
				case 'left':$cacotag_parser_switch = $this->cacotag_left($cacotag_name[0][2]);break;
				case 'left_title':$cacotag_parser_switch = $this->cacotag_left_title($cacotag_name[0][2]);break;
				case 'address_list':$cacotag_parser_switch = $this->cacotag_address_list($cacotag_name[0][2]);break;
				case 'photo_show_all':$cacotag_parser_switch = $this->cacotag_photo_show_all($cacotag_name[0][2]);break;
				//图片信息图片地址调用
				case 'photo_show_pic':$cacotag_parser_switch = $this->cacotag_photo_show_pic($cacotag_name[0][2]);break;
				//图片信息信息链接地址调用
				case 'photo_show_link':$cacotag_parser_switch = $this->cacotag_photo_show_link($cacotag_name[0][2]);break;
				//图片信息信息标题调用
				case 'photo_show_text':$cacotag_parser_switch = $this->cacotag_photo_show_text($cacotag_name[0][2]);break;
				//新信息图标调用
				case 'newres_ico':$cacotag_parser_switch = $this->cacotag_newres_ico($cacotag_name[0][2]);break;
				//相关内容列表调用
				case 'relate_list':$cacotag_parser_switch = $this->cacotag_relate_list($cacotag_name[0][2]);break;
				//安全字符调用
				case 'safe_str':$cacotag_parser_switch = $this->cacotag_safe_str($cacotag_name[0][2]);break;
				default:return $myflag;break;
			}
			$tempcontent = str_replace($cacotag_name[0][0],$cacotag_parser_switch,$myflag);
			return $this->forparser($tempcontent);
		}else{
			return $myflag;
		}
	}
	/*
		'方法:当前位置导航栏生成 CACO:address_list(栏目ID,'链接字符',Flag)
		'Flag =0 表示引用网站名称 <> 表示将网站名称改为首页
		'参数:CACO标签
		'返回:栏目ID位置导航
	*/
	private function cacotag_address_list($myflag){
		$re_cacotag_address_list = 'Err';
		if(preg_match_all ("/([0-9]{1,}),'(.*?)',([0-9]{1,})/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			$re_cacotag_address_list = $this->cacotag_address_list_classlist($cacotag_name[0][1],$cacotag_name[0][2],$cacotag_name[0][3]);
		}
		return $re_cacotag_address_list;
	}
	private function cacotag_address_list_classlist($id,$linkstr,$flag,$liststr=''){
		global $mysql,$flib;
		$re_cacotag_address_list_classlist = $liststr;
		$sql = "SELECT id,parent,title,home_url,isshow FROM ".DB_FIXTABLE."resclass_list WHERE id=$id LIMIT 0,1";
		$row = $mysql->sql_fetchrow($mysql->sql_query($sql));
		if(!$row)return $re_cacotag_address_list_classlist;
		$pid = $row['parent'];
		$title = $row['title'];
		$home_url = $flib->creat_url($row['home_url'],$row['id']);
		$isshow = $row['isshow'];
		if($pid==0){
			if($flag!=0)$title='首页';
		}
		if($isshow==1){
			$re_cacotag_address_list_classlist .= $this->cacotag_address_list_classlist($pid,$linkstr,$flag,$liststr).(($pid==0)?'':$linkstr)."<a href=\"".$home_url."\">". $title.'</a>';
		}else{
			$re_cacotag_address_list_classlist .= $this->cacotag_address_list_classlist($pid,$linkstr,$flag,$liststr);
		}
		return $re_cacotag_address_list_classlist;
	}
	/*
		方法:资源字段读取标签处理 CACO:data(字段名)
		参数:caco标签
		返回:内容字段数据
	*/
	private function cacotag_data_field($myflag){
		global $flib;
		$re_cacotag_data_field = '';
		if(!(is_null($myflag)||$myflag=='')){
			if($myflag=='home_url'){
				$re_cacotag_data_field = $flib->creat_url($this->resinfo[$myflag],$this->resinfo['class_id']);
			}else if($myflag=='file_path'){
				$re_cacotag_data_field = base64_encode($this->resinfo[$myflag]);
			}else{
				$re_cacotag_data_field = $this->resinfo[$myflag];
			}
		}
		return $re_cacotag_data_field;
	}
	/*
		方法:格式化时间格式 CACO:format_date(时间, '时间格式串')
		参数:caco标签
		返回:格式化后的时间
	*/
	private function cacotag_format_date($myflag){
		$re_cacotag_format_date = 'Err';
		if(preg_match_all ("/([0-9]{1,}),'(.*?)'/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			$re_cacotag_format_date = date($cacotag_name[0][2],$cacotag_name[0][1]);
		}
		return $re_cacotag_format_date;
	}
	/*
		方法:清除html标签 CACO:filter_html(字符串)
		参数:CACO标签
		返回:清除后字符串
	*/
	private function cacotag_filter_html($myflag){
		return preg_replace("/<.+?>/","",$myflag);
	}
	/*
		方法:字符串截取函数 CACO:left(字符串, 截取长度, '补给串')
		参数:CACO标签
		返回:截取后字符串
	*/
	private function cacotag_left($myflag){
		$re_cacotag_format_date = 'Err';
		if(preg_match_all ("/(.*?),([0-9]{1,}),'(.*?)'/",$myflag,$cacotag_name,PREG_SET_ORDER)){

			if(mb_strlen($cacotag_name[0][1])>($cacotag_name[0][2]/2)){
				$re_cacotag_format_date = $this->utf_substr($cacotag_name[0][1],$cacotag_name[0][2],$cacotag_name[0][3]);
				//$re_cacotag_format_date = mb_substr($cacotag_name[0][1],0,$cacotag_name[0][2]).$cacotag_name[0][3];
			}else{
				$re_cacotag_format_date = $cacotag_name[0][1];
			}
		}
		return $re_cacotag_format_date;
	}
	/*
		方法:Html字符截取函数 CACO:left_title(字符串, 截取长度, '补给串')
		参数:CACO标签
		返回:截取后字符串
	*/
	private function cacotag_left_title($myflag){
		$re_cacotag_format_date = 'Err';
		if(preg_match_all ("/(.*?),([0-9]{1,}),'(.*?)'/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			$tempstr = $this->cacotag_filter_html($cacotag_name[0][1]);
			if(mb_strlen($tempstr)>$cacotag_name[0][2]/2){
				$re_cacotag_format_date = str_replace($tempstr,$this->cacotag_left($tempstr.",".$cacotag_name[0][2].",'".$cacotag_name[0][3]."'"),$cacotag_name[0][1]);
			}else{
				$re_cacotag_format_date = $cacotag_name[0][1];
			}
		}
		return $re_cacotag_format_date;
	}
	/*
		方法:图片信息调用 CACO:photo_show_all(ClassID, 调用数量, 截取字数)
		参数:CACO标签
		返回:文章标题串+地址串+小图片串
	*/
	private function cacotag_photo_show_all($myflag){
		global $flib,$mysql;
		$re_cacotag_photo_show_all = 'Err';
		if(preg_match_all ("/([0-9]{1,}),([0-9]{1,}),([0-9]{1,})/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			$re_cacotag_photo_show_all = '';
			$classid = $cacotag_name[0][1];
			$topnum = $cacotag_name[0][2];
			$titlenum = $cacotag_name[0][3];
			$picstr_title = '';
			$picstr_url = '';
			$picstr_img = '';
			$classidlist = $flib->childenlist($classid);
			if($classidlist==''){
				$classidlist = $classid;
			}else{
				$classidlist = $classid.','.$classidlist;
			}
			$sql = "SELECT title,visit_url,small_img FROM ".DB_FIXTABLE."resource_list WHERE checked=1 AND created=1 AND deleted=0 AND small_isimg=1 AND class_id IN($classidlist) ORDER BY istop DESC,addtime DESC LIMIT 0,$topnum";
			$result = $mysql->sql_query($sql);
			while($row=$mysql->sql_fetchrow($result)){
				$temptitle = $this->cacotag_left($this->cacotag_filter_html($row['title']).",".$titlenum.",'...'");
				$tempurl = $row['visit_url'];
				$tempimg = $row['small_img'];
				$picstr_title .= ($picstr_title=='')?($temptitle):('|'.$temptitle);
				$picstr_url .=  ($picstr_url=='')?($tempurl):('|'.$tempurl);
				$picstr_img .=  ($picstr_img=='')?($tempimg):('|'.$tempimg);
			}
			$re_cacotag_photo_show_all = $picstr_title.'##CACOCMSPIC##'.$picstr_url.'##CACOCMSPIC##'.$picstr_img;
		}
		return $re_cacotag_photo_show_all;
	}
	/*
		方法:图片信息信息标题调用 CACO:photo_show_text(ClassID, 调用数量, 截取字数)
		参数:CACO标签
		返回:图片信息地址
	*/
	private function cacotag_photo_show_text($myflag){
		global $flib,$mysql;
		$re_cacotag_photo_show_text = 'Err';
		if(preg_match_all ("/([0-9]{1,}),([0-9]{1,}),([0-9]{1,})/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			$re_cacotag_photo_show_text = '';
			$classid = $cacotag_name[0][1];
			$topnum = $cacotag_name[0][2];
			$titlenum = $cacotag_name[0][3];
			$picsstr = '';
			$classidlist = $flib->childenlist($classid);
			if($classidlist==''){
				$classidlist = $classid;
			}else{
				$classidlist = $classid.','.$classidlist;
			}
			$sql = "SELECT title FROM ".DB_FIXTABLE."resource_list WHERE checked=1 AND created=1 AND deleted=0 AND small_isimg=1 AND class_id IN($classidlist) ORDER BY istop DESC,addtime DESC LIMIT 0,$topnum";
			$result = $mysql->sql_query($sql);
			while($row=$mysql->sql_fetchrow($result)){
				$temptitle = $this->cacotag_left($this->cacotag_filter_html($row['title']).",".$titlenum.",'...'");
				if($picsstr==''){
					$picsstr = $temptitle;
				}else{
					$picsstr.= '|'.$temptitle;
				}
			}
			$re_cacotag_photo_show_text = $picsstr;
		}
		return $re_cacotag_photo_show_text;
	}
	/*
		方法:图片信息信息链接地址调用 CACO:photo_show_link(ClassID, 调用数量)
		参数:CACO标签
		返回:图片信息地址
	*/
	private function cacotag_photo_show_link($myflag){
		global $flib,$mysql;
		$re_cacotag_photo_show_link = 'Err';
		if(preg_match_all ("/([0-9]{1,}),([0-9]{1,})/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			$re_cacotag_photo_show_link = '';
			$classid = $cacotag_name[0][1];
			$topnum = $cacotag_name[0][2];
			$picsstr = '';
			$classidlist = $flib->childenlist($classid);
			if($classidlist==''){
				$classidlist = $classid;
			}else{
				$classidlist = $classid.','.$classidlist;
			}
			$sql = "SELECT visit_url FROM ".DB_FIXTABLE."resource_list WHERE checked=1 AND created=1 AND deleted=0 AND small_isimg=1 AND class_id IN($classidlist) ORDER BY istop DESC,addtime DESC LIMIT 0,$topnum";
			$result = $mysql->sql_query($sql);
			while($row=$mysql->sql_fetchrow($result)){
				if($picsstr==''){
					$picsstr = $row['visit_url'];
				}else{
					$picsstr.= '|'.$row['visit_url'];
				}
			}
			$re_cacotag_photo_show_link = $picsstr;
		}
		return $re_cacotag_photo_show_link;
	}
	/*
		方法:图片信息地址调用 CACO:photo_show_pic(ClassID, 调用数量)
		参数:CACO标签
		返回:图片信息地址
	*/
	private function cacotag_photo_show_pic($myflag){
		global $flib,$mysql;
		$re_cacotag_photo_show_pic = 'Err';
		if(preg_match_all ("/([0-9]{1,}),([0-9]{1,})/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			$re_cacotag_photo_show_pic = '';
			$classid = $cacotag_name[0][1];
			$topnum = $cacotag_name[0][2];
			$picsstr = '';
			$classidlist = $flib->childenlist($classid);
			if($classidlist==''){
				$classidlist = $classid;
			}else{
				$classidlist = $classid.','.$classidlist;
			}
			$sql = "SELECT small_img FROM ".DB_FIXTABLE."resource_list WHERE checked=1 AND created=1 AND deleted=0 AND small_isimg =1 AND class_id IN($classidlist) ORDER BY istop DESC,addtime DESC LIMIT 0,$topnum";
			$result = $mysql->sql_query($sql);
			while($row=$mysql->sql_fetchrow($result)){
				if($picsstr==''){
					$picsstr = $row['small_img'];
				}else{
					$picsstr.= '|'.$row['small_img'];
				}
			}
			$re_cacotag_photo_show_pic = $picsstr;
		}
		return $re_cacotag_photo_show_pic;
	}
	/*
		方法:新信息图标调用 CACO:newres_ico(图片URL, 开始时间, 有效时间)
		参数:CACO标签,图片url访问地址,起始时间,有效显示 秒
		返回:图片信息地址
	*/
	private function cacotag_newres_ico($myflag){
		global $cfg;
		$re_cacotag_newres_ico = 'Err';
		if(preg_match_all ("/(.*?),([0-9]{1,}),([0-9]{1,})/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			if($cfg->nowtime - $cacotag_name[0][2] <= $cacotag_name[0][3] ){
				$re_cacotag_newres_ico = "<img src=".$cacotag_name[0][1]." />";
			}else{
				$re_cacotag_newres_ico = '';
			}
		}
		return $re_cacotag_newres_ico;
	}
	/*
		方法:相关资源列表 CACO:relate_list(数目, "相关列表样式模板")
		参数:Tsys标签
		返回:列表Html字符串
		说明:
		   相关列表样式模板:便用用户定义个性化的相关列表效果
		样式模板内部可用的动态变量有:
		   {id}            资源id
		   {title}         资源标题
		   {url}           资源访问地址
		   {author}        作者
		   {addtime}       添加时间
		   {class_title}   频道名称
		   {class_id}      频道id
		   {class_url}     频道地址
	*/
	private function cacotag_relate_list($myflag){
		$re_cacotag_relate_list = 'Err';
		if(is_null($this->resinfo['relate_list']) || $this->resinfo['relate_list']=='')return '';
		if(preg_match_all ("/(.*?),([0-9]{1,})/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			global $flib,$mysql;
			$re_cacotag_relate_list = '';
			$topnum = $cacotag_name[0][2];
			$strtemplate = $cacotag_name[0][1];
			$strtemplate2 = '';
			$sql = "SELECT rl.id,rl.class_id,rl.title,rl.author,rl.visit_url,rl.addtime,cl.title AS class_title,cl.home_url AS class_url FROM ".DB_FIXTABLE."resource_list AS rl LEFT JOIN ".DB_FIXTABLE."resclass_list AS cl ON rl.class_id=cl.id WHERE rl.id IN (".$this->resinfo['relate_list'].") AND rl.checked=1 AND rl.deleted=0 AND rl.created=1 ORDER BY rl.istop DESC,rl.id DESC LIMIT 0,$topnum";
			$result = $mysql->sql_query($sql);
			while($row=$mysql->sql_fetchrow($result)){
				$tmp_class_url = $row[7];
				if(strpos($tmp_class_url,'{class}')!==false)$tmp_class_url = str_replace('{class}',$row[1],$row[7]);
				if(strpos($strtemplate,'{title}')!==false)$strtemplate2 = str_replace('{title}',$row[2],$strtemplate);
				if(strpos($strtemplate2,'{id}')!==false)$strtemplate2 = str_replace('{id}',$row[0],$strtemplate2);
				if(strpos($strtemplate2,'{url}')!==false)$strtemplate2 = str_replace('{url}',$row[4],$strtemplate2);
				if(strpos($strtemplate2,'{author}')!==false)$strtemplate2 = str_replace('{author}',$row[3],$strtemplate2);
				if(strpos($strtemplate2,'{addtime}')!==false)$strtemplate2 = str_replace('{addtime}',date('Y-m-d H:i:s', $row[5]),$strtemplate2);
				if(strpos($strtemplate2,'{class_title}')!==false)$strtemplate2 = str_replace('{class_title}',$row[6],$strtemplate2);
				if(strpos($strtemplate2,'{class_id}')!==false)$strtemplate2 = str_replace('{class_id}',$row[1],$strtemplate2);
				if(strpos($strtemplate2,'{class_url}')!==false)$strtemplate2 = str_replace('{class_url}',$tmp_class_url,$strtemplate2);
				$re_cacotag_relate_list .= $strtemplate2;
			}
		}
		return $re_cacotag_relate_list;
	}
	/*
		方法:安全字符串 CACO:safe_str('时间格式串')
		参数:caco标签
		返回:格式化后的时间
	*/
	private function cacotag_safe_str($myflag){
		$re_cacotag_safe_str = 'Err';
		if(preg_match_all ("/(.*?)/",$myflag,$cacotag_name,PREG_SET_ORDER)){
			$re_cacotag_safe_str = addslashes($myflag);
		}
		return $re_cacotag_safe_str;
	}

	private function utf_substr($str,$len,$sadd='…'){ 
		$ok_str = $str;
		$ok_str_1 = '';
		$ok_str_1_len = $len-2;
		for($i=0;$i<$len;$i++) { 
			$temp_str=substr($str,0,1); 
			if(ord($temp_str) > 127) { 
				$i++; 
				if($i<$len) { 
					$new_str[]=substr($str,0,3); 
					$str=substr($str,3); 
				} 
			} else { 
				$new_str[]=substr($str,0,1); 
				$str=substr($str,1); 
			}
			if($i <= $ok_str_1_len)$re_str_1 = join($new_str);
		} 
		$re_str = join($new_str);
		return ($re_str == $ok_str)?($re_str):($re_str_1.$sadd);
	} 
}
?>
