<?php
//恢复数据表处理程序
require('../class/config_head.php');
require('../db/database_config.php');
require('../class/config_class.php');
require('../class/funlib_class.php');
require('../class/dbcontrol_class.php');
require('../class/manager_class.php');
$cfg = new Config();
$flib = new FunctionLib();
$mysql = new DbControl();
$admin = new Manager();
set_time_limit(100);
if(!$admin->logined){$flib->alert('对不起，你已经超时或未登录','index.php',1);exit();}
if(!$admin->checkpopedom('CACO_SYS_DB')){$flib->alert('没有权限','BACK',0);exit();}
$work = (isset($_GET['work']))?$_GET['work']:((isset($_POST['work']))?$_POST['work']:'');
$dirname = (isset($_GET['dirname']))?$_GET['dirname']:'';
if($dirname==''){$flib->alert('数据不完整!','BACK',0);exit();}
$mysql->DB_conn();
switch($work)
{
	case 'deletebak':
		deldir('../backup/'.$dirname);
		$flib->addlog("删除备份记录,ID：{$dirname}");
		$flib->alert('','BACK',0);
		break;
	case 'restorebak':
		$step = (isset($_GET['step']))?$_GET['step']:'1';
		$filename = '../backup/'.$dirname.'/backupall_'.$step.'_.sql';
		if(file_exists($filename))
	    {
			if(import($filename))
			{
				$msgs='数据文件'.$filename.'导入完成，程序将自动导入此分卷备份的下一部份，请勿手动中止程序的运行，以免数据库结构受损！';
				$intstep = intval($step);
				$intstep++;
				$redirectstr = 'db_restore_process.php?work=restorebak&dirname='.$dirname.'&step='.$intstep;
			}else{
				$msgs='数据文件'.$filename.'导入失败！';
				$redirectstr = 'db_restore.php';
			}
	    }
		else
	    {
    		$msgs='全部备份导入完成,程序将自己转入导入界面!!!';
			$redirectstr = 'db_restore.php';
	    }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Caco cms</title>
<link rel="stylesheet" type="text/css" href="style.css" />
</head>
<body>
<div class="box_nav">数据库管理 &gt;&gt; 备份数据表</div>
<div style="padding:10px; line-height:30px;"> 数据备份时，不要随意终止备份程序！<br />
  <?php echo $msgs.'<br />';?> <a href="<?php echo $redirectstr;?>">如果您的浏览器没有自动跳转，请点击这里</a>
</div>
<script>setTimeout("self.location.href = '<?php echo $redirectstr;?>';", 1250);</script>
</body>
</html>
<?php
		break;
}

function import($fname)
{
	global $mysql;
	$sqls=file($fname);
	foreach($sqls as $sql)
	{
		str_replace("\r","",$sql);
		str_replace("\n","",$sql);
		if(!$mysql->sql_query(trim($sql))) return false;
	}
	return true;
}

//删除指定目录（文件夹）中的所有文件函数
function delfile($dir)
{
	if (is_dir($dir))
	{
		$dh=opendir($dir);//打开目录
		//列出目录中的所有文件并去掉 . 和 ..
		while (false !== ( $file = readdir ($dh)))
		{
    		if($file!="." && $file!="..")
			{ 
		    	$fullpath = $dir."/".$file;
      			if(!is_dir($fullpath))
				{
					unlink($fullpath);
	      		} else {
    	    		delfile($fullpath);
				}
      		}
		}
		closedir($dh);
	}
}
//删除指定的目录
function deldir($dir)
{
	delfile($dir);
	if (is_dir($dir))rmdir($dir);//目录必须是空的
}
?>
