<?php
require('../config/config.php');
$cache_time = 3600 ; //设置记录总数缓存时间，单位：秒
/*
	获取浏览器提交的参数
	classid 频道ID  可选，默认为整个站群
	specialid 内容特性ID 可选，默认为无特性要求
	skey 关键字 可选，默认为不设置关键字
	showtype 显示项目 点、栏目、标题、时间、修饰线
	linenum 文字列表间隔行数 可选，默认为5行
	strnum 保留标题字节数 可选，默认为60字节
	pagesize 每页显示记录数 可选，默认为20个记录
	currpage 当前页 可选默认为第一页
*/
$classid	= htmlspecialchars((isset($_GET['classid']))?$_GET['classid']:((isset($_POST['classid']))?$_POST['classid']:''));
$specialid	= htmlspecialchars((isset($_GET['specialid']))?$_GET['specialid']:((isset($_POST['specialid']))?$_POST['specialid']:''));
$skey		= htmlspecialchars((isset($_GET['skey']))?$_GET['skey']:((isset($_POST['skey']))?$_POST['skey']:''));
$linenum	= htmlspecialchars((isset($_GET['linenum']))?$_GET['linenum']:((isset($_POST['linenum']))?$_POST['linenum']:''));
$strnum		= htmlspecialchars((isset($_GET['strnum']))?$_GET['strnum']:((isset($_POST['strnum']))?$_POST['strnum']:''));
$pagesize	= htmlspecialchars((isset($_GET['pagesize']))?$_GET['pagesize']:((isset($_POST['pagesize']))?$_POST['pagesize']:''));
$currpage	= htmlspecialchars((isset($_GET['currpage']))?$_GET['currpage']:((isset($_POST['currpage']))?$_POST['currpage']:''));
$showtype	= htmlspecialchars((isset($_GET['showtype']))?$_GET['showtype']:((isset($_POST['showtype']))?$_POST['showtype']:''));
$urltype	= htmlspecialchars((isset($_GET['urltype']))?$_GET['urltype']:((isset($_POST['urltype']))?$_POST['urltype']:''));
$target		= htmlspecialchars((isset($_GET['target']))?$_GET['target']:((isset($_POST['target']))?$_POST['target']:''));
//对参数进行验证
if($flib->str_len($skey)<2)$skey = '';
if(!$flib->isint($specialid))$specialid = 0;
if(!$flib->isint($linenum))$linenum = 5;
if(!$flib->isint($strnum))$strnum = 60;
if(!$flib->isint($pagesize))$pagesize = 20;
if(!$flib->isint($currpage))$currpage = 1;
if(!$flib->isint($urltype))$urltype = 1;
if(!$flib->isint($target))$target = 1;
if(!check_showtype($showtype))$showtype = '11111';
if(!check_classid($classid))$classid = '';

$get_str = 'classid='.$classid.'&specialid'.$specialid.'&skey'.$skey;
$cache_sql_filename = './cache/'.md5('pic_sql_'.$get_str).'.php';
$cache_num_filename = './cache/'.md5('pic_num_'.$get_str).'.php';

$mysql->DB_conn();
$sfrom	= "FROM ".DB_FIXTABLE."resource_list AS rl";
$sorder	= "ORDER BY rl.istop DESC,rl.addtime DESC";
if(file_exists($cache_sql_filename) && (filemtime($cache_sql_filename)+$cache_time>time()))
{
	$swhere = file_get_contents($cache_sql_filename);
}else{
	$swhere	= "WHERE rl.checked=1 AND rl.deleted=0 AND rl.created=1 AND small_isimg = 1";
	//指定频道
	if($classid)
	{	
		$arr_idlist = explode(',',$classid);
		$childlist = '';
		foreach($arr_idlist as $value)
		{
			if($value)
			{
				$childlist1 = $flib->childenlist($value);
				$childlist1 .= (($childlist1=='')?'':',').$value;
				$childlist .= (($childlist=='')?'':',').$childlist1;
			}
		}
		$swhere .= " AND rl.class_id IN ($childlist)";
	}
	//指定内容特性
	if($specialid>0)
	{
		$childspiciallist = $flib->childenlist_s($specialid);
		$childspiciallist .= (($childspiciallist=='')?'':',').$specialid;
		if($childspiciallist!='')
		{
			$arr_idlist = explode(',',$childspiciallist);
			foreach($arr_idlist as $value)
			{
				$tmpsql .= (($tmpsql=='')?'':' OR ')."concat(',',rl.special,',') LIKE '%,$value,%'";
			}
			$swhere .= " AND(".$tmpsql.")";
		}
	}
	//指定关键字
	if($skey!='')
	{
		$arr_skey = explode('+',$skey);
		$swhere1 = '';
		foreach($arr_skey as $value)
		{
			if(!empty($value))$swhere1 .= " AND (rl.title LIKE '%$value%' OR rl.keyword LIKE '%$value%' OR rl.short_content LIKE '%$value%')";
		}
		$swhere .= $swhere1;
	}
	file_put_contents($cache_sql_filename, $swhere);
}
if(file_exists($cache_num_filename) && (filemtime($cache_num_filename)+$cache_time>time()))
{
	$numrows = file_get_contents($cache_num_filename);
}else{
	$sql = "SELECT count(rl.id) $sfrom $swhere $sorder";
	$result = $mysql->sql_query($sql);
	$row	= $mysql->sql_fetchrow($result);
	$numrows = $row[0];
	file_put_contents($cache_num_filename, $numrows);
}
function check_showtype($str){return preg_match("/^[0,1]{5}$/",$str)?1:0;}
function check_classid($str){return preg_match("/^[1-9][0-9,]{0,200}$/",$str)?1:0;}

echo "var total_in = ".$numrows.";\n";
echo "var strtext_in = '';\n";
if($numrows>0){
	$pages=ceil($numrows/$pagesize);
	$offset=$pagesize*($currpage - 1);
	$sql	= "SELECT rl.title,rl.visit_url,rl.small_img $sfrom $swhere $sorder LIMIT $offset,$pagesize";
	$result = $mysql->sql_query($sql);
	while($row= $mysql->sql_fetchrow($result))
	{
		echo "strtext_in += \"<div class=\\\"tcmspiclistbox\\\">\";\n";
		if(substr($showtype,0,1)=='1')echo "strtext_in += \"<div class=\\\"tcmspiclistimg\\\"><a href=\\\"".$row['visit_url']."\\\"".(($target==1)?" target=\\\"_blank\\\"":'')."><img src=\\\"".$row['small_img']."\\\" /></a></div>\";\n";
		if(substr($showtype,1,1)=='1')
		{
			if($urltype==1)
			{
				echo "strtext_in += \"<div class=\\\"tcmspiclisttitle\\\"><a href=\\\"".$row['visit_url']."\\\"".(($target==1)?" target=\\\"_blank\\\"":'').">".addslashes($flib->utf_substr($flib->filterhtml($row['title']),$strnum))."</a></div>\";\n";
			}elseif($urltype==0){
				echo "strtext_in += \"<div class=\\\"tcmstextlisttitle\\\"><a href=\\\"view.php?a=".base64_encode($row['file_path'])."\\\"".(($target==1)?" target=\\\"_blank\\\"":'').">".addslashes($flib->utf_substr($flib->filterhtml($row['title']),$strnum))."</a></div>\";\n";
			}
		}
		echo "strtext_in += \"</div>\";\n";
	}
	echo "strtext_in += \"<div class=\\\"tcmspiclistline\\\"></div>\";\n";
}else{
	echo "strtext_in += \"<div class=\\\"tcmspiclistnodate\\\">没有找到记录！</div>\";\n";
}
echo "var ojb = {strtext:strtext_in,total:total_in};";
?>