<?php
class ZFxxgk
{
	public $applystate,$zfclassid,$subcatlist,$systemname;
	function __construct()
	{
		//设置政府主站ID
		$this->zfclassid = 1000;
		//设置是否显示主题分类的子分类  0 不显示  1 显示
		$this->subcatlist = 1;
		$this->applystate = '未办理,已办理,同意公开,同意部分公开,信息不存在,非本部门掌握,申请信息不明确';
	}
/*函数:Cookie写  参数:Cookie名, Cookie值, 有效时间 */
	public function setcookies($key,$val,$exptime)
	{
		if($exptime==0)
		{
			setcookie('CACO_'.$key,$val,0);
		}else{
			setcookie('CACO_'.$key,$val,time()+$exptime);
		}
	}
	
/*函数:Cookie读  参数:Cookie名  返回:cookie值*/
	public function getcookies($key)
	{	return (isset($_COOKIE["CACO_".$key]))?$_COOKIE["CACO_".$key]:'';	}
	
/*函数:整数判断*/
	public function isint ($x) {
    	return (is_numeric($x) ? intval($x) == $x : false);
	}
/*函数:验证YYYY-MM-DD的日期格式*/
	public function check_date($str)
	{
    	$regex = "/^(\d{4})\-(\d{2})\-(\d{2})$/";
		return preg_match($regex,$str)?1:0;
	}
/*函数:验证全数据字符串  参数:字符串  返回:bool (true:有效的权限标识名)*/
	public function check_numstr($str)
	{
		$regex = "/^[0-9_]{1,10}$/";
		return preg_match($regex,$str)?1:0;
	}
/*
    方法:获得信息公开状态
    参数:状态码
    返回:状态字符串
*/
	public function get_applystate($statenum=0)
	{
		$array_applystate = explode(',',$this->applystate);
		return $array_applystate[$statenum];
	}

/*
    方法:清除html标签 CACO:filter_html(字符串)
    参数:CACO标签
    返回:清除后字符串
*/
	private function cacotag_filter_html($myflag)
	{
		return preg_replace("/<.+?>/","",$myflag);
	}
/*
    方法:Html字符截取函数 CACO:left_title(字符串, 截取长度, '补给串')
    参数:CACO标签
    返回:截取后字符串
	public function left_title($string,$strnum,$strfull='...')
	{
		$re_cacotag_format_date = 'Err';
		$tempstr = $this->cacotag_filter_html($string);
		if(mb_strlen($tempstr)>$strnum)
		{
			$re_cacotag_format_date = str_replace($tempstr,$this->cacotag_left($tempstr,$strnum,$strfull),$string);
		}else{
			$re_cacotag_format_date = $string;
		}
		return $re_cacotag_format_date;
	}
*/
	public function left_title($string,$strnum,$strfull='...')
	{
		$re_cacotag_format_date = 'Err';
		$string = $this->cacotag_filter_html($string);
		if(mb_strlen($string)>$strnum)
		{
			$re_cacotag_format_date = mb_substr($string,0,$strnum).$strfull;
		}else{
			$re_cacotag_format_date = $string;
		}
		return $re_cacotag_format_date;
	}
/*
    方法:字符串截取函数 CACO:left(字符串, 截取长度, '补给串')
    参数:CACO标签
    返回:截取后字符串
*/
	private function cacotag_left($string,$strnum,$strfull='...')
	{
		$re_cacotag_format_date = 'Err';
		if(mb_strlen($string)>$strnum)
		{
			$re_cacotag_format_date = mb_substr($string,0,$strnum).$strfull;
		}else{
			$re_cacotag_format_date = $string;
		}
		return $re_cacotag_format_date;
	}

//获得所在频道的导航目录
	public function path_resclasslist($id)
	{
		global $mysql,$flib;
		if ($id==0)return '';
		$sql = "SELECT id, parent, title, home_url FROM ".DB_FIXTABLE."resclass_list WHERE id=$id LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		if(!$row)return;
		$pid = $row['parent'];
		$title = $row['title'];
		$home_url = $flib->creat_url($row['home_url'],$row['id']);
		$urltitle = "<a href=\"".$home_url."\">".$title.'</a>';
		return $this->path_resclasslist($pid).(($this->path_resclasslist($pid)=='')?'':" &gt;&gt; ").$urltitle;
	}
//获得根频道ID
	public function getrootclassid($id,$flag=1)
	{
		global $mysql;
		$sql = "SELECT id,parent,type_mode FROM ".DB_FIXTABLE."resclass_list WHERE id=$id LIMIT 0,1";
		$result = $mysql->sql_query($sql);
		$row = $mysql->sql_fetchrow($result);
		if(!$row)return array(0,0);
		if($row['parent']==0)return array($id,$flag);
		if($row['type_mode']!=1)return array(0,0);
		return $this->getrootclassid($row['parent'],2);
	}
//显示搜索范围列表
	public function showselect($rootclassid)
	{
		global $mysql;
		$sql = "SELECT id,title FROM ".DB_FIXTABLE."resclass_list WHERE parent=0 AND isshow=1 AND show_order>6000 ORDER BY show_order DESC";
		$result = $this->sql_query($sql);
		while($row=$this->sql_fetchrow($result))
		{
			$selected = ($rootclassid==$row['id'])?' selected':'';
			echo "<option value=\"".$row['id']."\"".$selected.">".$row['title']."</option>";
		}
	}
}
?>