<?php
/**
* Return skins select
* @return string
* @param string $sDirCurrent
*/
function throwSkinsSelect( $sDirCurrent = null ){

  if( empty( $sDirCurrent ) ){
    $sFileCurrent = $GLOBALS['config']['skin'];
  }

  foreach( new DirectoryIterator( DIR_TEMPLATES ) as $oFileDir ){
    if( $oFileDir->isDir( ) && !strstr( $oFileDir->getFilename( ), 'admin' ) && !strstr( $oFileDir->getFilename( ), '.' ) ){
      $aDirs[] = $oFileDir->getFilename( );
    }
  } // end foreach

  if( isset( $aDirs ) ){
    $content = null;
    sort( $aDirs );
    $iCount = count( $aDirs );
    for( $i = 0; $i < $iCount; $i++ ){
      $sSelected = ( $sDirCurrent == $aDirs[$i] ) ? ' selected="selected"' : null;
      $content .= '<option value="'.$aDirs[$i].'"'.$sSelected.'>'.$aDirs[$i].'</option>';
    } // end for

    return $content;
  }
} // end function throwCssSelect

/**
* Return themes select
* @return string
* @param string $sFileCurrent
*/
function throwThemesSelect( $sFileCurrent = null ){
  global $config;

  $sDefault = $config['default_pages_template'];
  
  foreach( new DirectoryIterator( DIR_TEMPLATES.$GLOBALS['config']['skin'] ) as $oFileDir ){
    $sFileName = $oFileDir->getFilename( );
    if( $oFileDir->isFile( ) && strstr( $sFileName, '.php' ) && $sFileName[0] != '_' ){
      if( $sFileCurrent == $sFileName )
        $bFound = true;
      $aFiles[] = $sFileName;
    }
  } // end foreach

  if( empty( $sFileCurrent ) || !isset( $bFound ) ){
    $sFileCurrent = $sDefault;
  }

  if( isset( $aFiles ) ){
    $content = null;
    sort( $aFiles );
    $iCount = count( $aFiles );
    for( $i = 0; $i < $iCount; $i++ ){
      $sSelected = ( $sFileCurrent == $aFiles[$i] ) ? ' selected="selected"' : null;
      $sValue = ( $aFiles[$i] == $sDefault ) ? null : $aFiles[$i];

      $content .= '<option value="'.$sValue.'"'.$sSelected.'>'.$aFiles[$i].'</option>';
    } // end for

    return $content;
  }
} // end function throwThemesSelect

/**
* Copy files from directory to another directory
* @return void
* @param string $sDirFrom
* @param string $sDifTo
*/
function copyDirToDir( $sDirFrom, $sDirTo ){
  if( is_dir( $sDirFrom ) && is_dir( $sDirTo ) ){
    foreach( new DirectoryIterator( $sDirFrom ) as $oFileDir ){
      if( $oFileDir->isFile( ) && !is_file( $sDirTo.$oFileDir->getFilename( ) ) ){
        copy( $sDirFrom.$oFileDir->getFilename( ), $sDirTo.$oFileDir->getFilename( ) );
      }
    } // end foreach
  }
} // end function copyDirToDir

/**
* Saves variables to config
* @return void
* @param array  $aForm
* @param string $sFile
* @param string $sVariable
*/
function saveVariables( $aForm, $sFile, $sVariable = 'config' ){
  $aFile = file( $sFile );
  $iCount = count( $aFile );
  $rFile = fopen( $sFile, 'w' );

  for( $i = 0; $i < $iCount; $i++ ){
    foreach( $aForm as $sKey => $sValue ){
      if( preg_match( '/'.$sVariable."\['".$sKey."'\]".' /', $aFile[$i] ) && strstr( $aFile[$i], '=' ) ){
        $sValue = changeSpecialChars( $sValue );
        $sValue = str_replace( '"', '&quot;', $sValue );
        $sValue = stripslashes( $sValue );
        if( preg_match( '/^(true|false|null)$/', $sValue ) == true ){
          $aFile[$i] = "\$".$sVariable."['".$sKey."'] = ".$sValue.";";
        }
        else
          $aFile[$i] = "\$".$sVariable."['".$sKey."'] = \"".$sValue."\";";
      }
    } // end foreach

    fwrite( $rFile, rtrim( $aFile[$i] ).( $iCount == ( $i + 1 ) ? null : "\r\n" ) );

  } // end for
  fclose( $rFile );
} // end function saveVariables

/**
* Log in and out actions
* @return void
* @param string $p
* @param string $sKey
* @date 2007-09-20 09:42:35
*/
function loginActions( $p, $sKey = 'bLogged' ){
  global $sLoginInfo, $sLoginPage, $config, $lang;
  $content = null;
  $sCheck = 'checkContent';
  
  if( !isset( $_SESSION[$sKey] ) || $_SESSION[$sKey] !== TRUE ){
    if( is_file( DB_FAILED_LOGS ) ){
      $iFailed = file_get_contents( DB_FAILED_LOGS );
      $iFailedLoginTime = filemtime( DB_FAILED_LOGS );
    }

    if( isset( $iFailed ) && isset( $iFailedLoginTime ) && $iFailed > 2 && time( ) - $iFailedLoginTime <= 900 ){
      $bLoginExceed = true;
      $p = null;
    }

    if( $p == 'login' && isset( $_POST['sLogin'] ) && isset( $_POST['sPass'] ) ){
      $iCheckLogin = checkLogin( $_POST['sLogin'], $_POST['sPass'], $sKey );
      if( $iCheckLogin == 1 ){
        if( !isset( $_COOKIE['sLogin'] ) || $_COOKIE['sLogin'] != $_POST['sLogin'] )
          @setCookie( 'sLogin', $_POST['sLogin'], time( ) + 2592000 );
        
        $sRedirect = !empty( $_POST['sLoginPageNext'] ) ? $_POST['sLoginPageNext'] : $_SERVER['PHP_SELF'];
        saveVariables( Array( 'last_login' => time( ), 'before_last_login' => $config['last_login'] ), DB_CONFIG );
        if( is_file( DB_FAILED_LOGS ) )
          unlink( DB_FAILED_LOGS );

        header( 'Location: '.$sRedirect );
        exit;
      }
      else{
        $sLoginPage = $_SERVER['PHP_SELF'];
        $content = '<div id="error">'.$lang['Wrong_login_or_pass'].'<div id="back"><a href="javascript:history.back()">&laquo; '.$lang['back'].'</a></div></div>';
      }
    }
    else{
      if( isset( $bLoginExceed ) ){
        $sLoginPage = $_SERVER['PHP_SELF'];
        $content = '<div id="error">'.$lang['Falied_login_wait_time'].'</div>';
      }
      else{
        $sLoginPage = '?p=login';
        if( !empty( $_SERVER['REQUEST_URI'] ) )
          $_SERVER['REQUEST_URI'] = htmlspecialchars( strip_tags( $_SERVER['REQUEST_URI'] ) );
        $content = '<script type="text/javascript"><!--
                      AddOnload( cursor );
                      //-->
                    </script><form method="post" action="'.$sLoginPage.'" name="form"><fieldset><input type="hidden" name="sLoginPageNext" value="'.$_SERVER['REQUEST_URI'].'" /><div id="login"><label>'.$lang['Login'].':</label><input type="text" name="sLogin" class="input" value="'.( isset( $_COOKIE['sLogin'] ) ? strip_tags( $_COOKIE['sLogin'] ) : null ).'" /></div><div id="pass"><label>'.$lang['Password'].':</label><input type="password" name="sPass" class="input" value="" /></div><div id="submit"><input type="submit" value="'.$lang['log_in'].' &raquo;" /></div></fieldset></form>';
      }
    }

    unset( $GLOBALS['aActions'] );
    require_once DIR_TEMPLATES.'admin/_header.php'; // include headers
    echo '<body id="bodyLogin"><div id="panelLogin"><div id="top"></div><div id="body"><div id="logo"><a href="?p="><img src="'.$config['dir_templates'].'admin/img/logo_os.jpg" /></a></div>'.$content.'</div><div id="bottom"><div id="home"><a href="">'.$lang['homepage'].'</a></div><div id="version"><a href="http://www.americaidc.com/">Americaidc Cms v'.$config['version'].'</a></div>';
    require_once DIR_TEMPLATES.'admin/_footer.php'; // include footer
    exit;
  }
  else{
    if( $p == 'logout' ){
      unset( $_SESSION[$sKey] );
      $sLoginPage = $_SERVER['PHP_SELF'];
      header( 'Location: '.$_SERVER['PHP_SELF'] );
      exit;
    }
    if( isset( $sCheck ) )
      $sCheck();
  }
} // end function loginActions

/**
* Check login and password saved in config/general.php
* @return int
* @param string $sLogin
* @param string $sPass
* @param string $sKey
*/
function checkLogin( $sLogin, $sPass, $sKey ){
  if( $GLOBALS['config']['login'] == $sLogin && $GLOBALS['config']['pass'] == $sPass ){
    $_SESSION[$sKey] = true;
    return 1;
  }
  else{
    file_put_contents( DB_FAILED_LOGS, ( ( is_file( DB_FAILED_LOGS ) ? file_get_contents( DB_FAILED_LOGS ) : 0 ) + 1 ) );
    chmod( DB_FAILED_LOGS, FILES_CHMOD );

    return 0;
  }
} // end function checkLogin

/**
* Return subpages show select
* @return string
* @param int  $iShow
*/
function throwSubpagesShowSelect( $iShow = null ){
  $aSubpages[1] = $GLOBALS['lang']['Subpage_show_1'];
  $aSubpages[2] = $GLOBALS['lang']['Subpage_show_2'];
  return throwSelectFromArray( $aSubpages, $iShow );
} // end function throwSubpagesShowSelect

/**
* Delete from address iPage=Something
* @return string
* @param string $sUrl
*/
function changeUri( $sUrl ){
  return preg_replace( "/&iPage=[0-9]*/", '', $sUrl );
} // end function changeUri

/**
* Return true/false or null select
* @return string
* @param bool $bFalseNull
* @param string $sFalseNull
*/
function throwTrueFalseOrNullSelect( $bFalseNull = false, $sFalseNull = 'false' ){
  
  $aSelect = Array( null, null );
  
  if( $bFalseNull == true )
    $aSelect[1] = 'selected="selected"';
  else
    $aSelect[0] = 'selected="selected"';
  
  return '<option value="true" '.$aSelect[1].'>'.LANG_YES_SHORT.'</option><option value="'.$sFalseNull.'" '.$aSelect[0].'>'.LANG_NO_SHORT.'</option>';
} // end function throwTrueFalseOrNullSelect

/**
* Save description to file
* @return int
* @param string $sDir
* @param int $iId
* @param string $sContent
*/
function saveFullDescription( $sDir, $iId, $sContent ){
  $sFileName = LANGUAGE.'_'.sprintf( '%04.0f', $iId ).'.txt';
  file_put_contents( $sDir.$sFileName, $sContent );
  chmod( $sDir.$sFileName, FILES_CHMOD );
} // end function saveFullDescription

/**
* Delete description file
* @return int
* @param string $sDir
* @param int $iId
*/
function deleteFullDescription( $sDir, $iId ){
  $sFileName = LANGUAGE.'_'.sprintf( '%04.0f', $iId ).'.txt';
  if( is_file( $sDir.$sFileName ) )
    unlink( $sDir.$sFileName );
} // end function deleteFullDescription
?>