<?php
$sValue = (float) phpversion( );
if( $sValue < '5.2' ){
  exit( '<h2><center>REQUIRED PHP VERSION IS 5.2.0, YOU HAVE '.phpversion( ).'</center></h2>' );
}

#error_reporting( E_ALL | E_STRICT );
unset( $config, $aMenuTypes, $aPhotoTypes, $lang );

/*
* Set true if logged administrator will be able
* to see hidden pages (in client-side)
*/
$config['hidden_shows'] = false;

/*
* Add minutes difference between your local time and server time
*/
$config['time_diff'] = 0;

/*
* Administrator login and password
*/
$config['login'] = "admin";
$config['pass'] = "admin";

/*
* Default language
*/
$config['default_lang'] = "en";

/*
* Admin panel language
*/
$config['admin_lang'] = "ch";

/*
* CSS styles file
*/
$config['style'] = "style.css";

/*
* Skin directory
*/
$config['skin'] = "default";

/*
* WYSIWYG editor
*/
$config['wysiwyg'] = true;

/*
* Inherit themes from their parents
*/
$config['inherit_from_parents'] = true;

/*
* Set default image size and location
*/
$config['pages_default_image_size_details'] = 1;
$config['pages_default_image_size_list'] = 1;
$config['pages_default_image_location'] = 1;

/*
* Set default subpages show
*/
$config['default_subpages_show'] = 2;

/*
* Set default menu
*/
$config['default_menu'] = 1;

/*
* If should be language parameter added to url
*/
$config['language_in_url'] = false;

/*
* Language separator in url
*/
$config['language_separator'] = '_';

/*
* Save full description to separate file
*/
$config['pages_full_description_to_file'] = false;

define( 'LANGUAGE_IN_URL', $config['language_in_url'] );
define( 'LANGUAGE_SEPARATOR', $config['language_separator'] );

$config['display_expanded_menu'] = true;
$config['change_files_names'] = false;
$config['delete_unused_files'] = true;

$config['images_sizes'] = Array( 0 => 100, 1 => 150, 2 => 200 );
$config['max_dimension_of_image'] = 900;

/*
* DONT CHANGE CODE BELOW!
*
* Directories
*/
$config['dir_core'] = 'core/';
$config['dir_database'] = 'database/';
$config['dir_database_pages'] = $config['dir_database'].'pages/';
$config['dir_libraries'] = $config['dir_core'].'libraries/';
$config['dir_lang'] = $config['dir_database'].'translations/';
$config['dir_templates'] = 'templates/';
$config['dir_skin'] = $config['dir_templates'].$config['skin'].'/';
$config['dir_files'] = 'files/';
$config['dir_plugins'] = 'plugins/';

require_once $config['dir_core'].'common.php';

$config['cookie_admin'] = defined( 'CUSTOMER_PAGE' ) ? null : 'A';

if( defined( 'CUSTOMER_PAGE' ) && !isset( $sLang ) && LANGUAGE_IN_URL === true )
  $sLang = getLanguageFromUrl( );

if( isset( $sLang ) && is_file( $config['dir_lang'].$sLang.'.php' ) && strlen( $sLang ) == 2 ){
  setCookie( 'sLanguage'.$config['cookie_admin'], $sLang, time( ) + 86400 );
  define( 'LANGUAGE', $sLang );
}
else{
  if( !empty( $_COOKIE['sLanguage'.$config['cookie_admin']] ) && is_file( $config['dir_lang'].$_COOKIE['sLanguage'.$config['cookie_admin']].'.php' ) && strlen( $_COOKIE['sLanguage'.$config['cookie_admin']] ) == 2 )
    define( 'LANGUAGE', $_COOKIE['sLanguage'.$config['cookie_admin']] );
  else
    define( 'LANGUAGE', $config['default_lang'] );
}

require_once defined( 'CUSTOMER_PAGE' ) ? $config['dir_lang'].LANGUAGE.'.php' : ( is_file( $config['dir_lang'].$config['admin_lang'].'.php' ) ? $config['dir_lang'].$config['admin_lang'].'.php' : $config['dir_lang'].LANGUAGE.'.php' );

$aMenuTypes = Array( 1 => $lang['Menu_1'], 2 => $lang['Menu_2'] );
$aPhotoTypes = Array( 1 => $lang['Left'], 2 => $lang['Right'] );

$config['config'] = $config['dir_database'].'config/general.php';
$config['config_lang'] = $config['dir_database'].'config/lang_'.LANGUAGE.'.php';

$config_db['pages'] = $config['dir_database'].LANGUAGE.'_pages.php';
$config_db['pages_files'] = $config['dir_database'].LANGUAGE.'_pages_files.php';

$config['language'] = LANGUAGE;
$config['version'] = '5.0';

$config['last_login'] = "1356085479";
$config['before_last_login'] = "1356083140";

$config['manual_link'] = 'http://www.americaidc.com/'.( ( $config['admin_lang']=='pl' ) ? 'pl' : 'en' ).'-';

$config['default_pages_template'] = "page.php";

define( 'DIR_CORE', $config['dir_core'] );
define( 'DIR_DATABASE', $config['dir_database'] );
define( 'DIR_DATABASE_PAGES', $config['dir_database_pages'] );
define( 'DIR_FILES', $config['dir_files'] );
define( 'DIR_LIBRARIES', $config['dir_libraries'] );
define( 'DIR_PLUGINS', $config['dir_plugins'] );
define( 'DIR_LANG', $config['dir_lang'] );
define( 'DIR_TEMPLATES', $config['dir_templates'] );
define( 'DIR_SKIN', $config['dir_skin'] );

define( 'DB_PAGES', $config_db['pages'] );
define( 'DB_PAGES_FILES', $config_db['pages_files'] );

define( 'DB_CONFIG', $config['config'] );
define( 'DB_CONFIG_LANG', $config['config_lang'] );
define( 'DB_FAILED_LOGS', DIR_DATABASE.'logs.txt' );

define( 'MAX_DIMENSION_OF_IMAGE', $config['max_dimension_of_image'] );
define( 'HIDDEN_SHOWS', $config['hidden_shows'] );
define( 'DISPLAY_EXPANDED_MENU', $config['display_expanded_menu'] );
define( 'WYSIWYG', $config['wysiwyg'] );
define( 'VERSION', $config['version'] );
define( 'TIME_DIFF', $config['time_diff'] );
define( 'SESSION_KEY_NAME', md5( dirname( $_SERVER['SCRIPT_FILENAME'] ) ) );
?>