---
title: 简介
order: 0
redirect_from:
  - /zh/docs/api
---

`markdown:docs/common/style.md`

# L7 地理空间数据可视分析引擎

✨ 2020.01.06 2.0 版本正式发布

⚠️ 1.x 版本的用户需求我们持续跟进 [旧版官网地址](https://antv-2018.alipay.com/zh-cn/l7/1.x/index.html)

L7 是由蚂蚁金服 AntV 数据可视化团队推出的基于 WebGL 的开源大规模地理空间数据可视分析开发框架。L7 中的 L 代表 Location，7 代表世界七大洲，寓意能为全球位置数据提供可视分析的能力。L7 以图形符号学为理论基础，将抽象复杂的空间数据转化成 2D、3D 符号，通过颜色、大小、体积、纹理等视觉变量实现丰富的可视化表达。

<video id="video" controls="" preload="none" poster="https://gw.alipayobjects.com/mdn/antv_site/afts/img/A*rjkiQLCoZxUAAAAAAAAAAABkARQnAQ">
<source id="mp4" src="https://gw.alipayobjects.com/mdn/antv_site/afts/file/A*viKwSJl2OGIAAAAAAAAAAABkARQnAQ"; type="video/map4">
      <source id="webm" src="https://gw.alipayobjects.com/os/basement_prod/65d5dbe8-d78d-4c6b-9318-fa06b1456784.webm" type="video/webm">
      <source id="ogv" src="https://media.w3.org/2010/05/sintel/trailer.ogv" type="video/ogg">
<p>Your user agent does not support the HTML5 Video element.</p>
</video>

## 核心特性

🌏 数据驱动可视化展示

数据驱动，从数到形，支持丰富的地图可视化类型，更好洞察数据。

🌏 2D，3D 一体化的海量数据高性能渲染

百万级空间数据实时，动态渲染。

🌏 简单灵活的数据接入

支持 CSV，JSON，geojson 等数据格式接入，可以根据需求自定义数据格式，无需复杂的空间数据转换。

🌏 多地图底图支持，支持离线内网部署

高德地图国内合法合规的地理底图，Mapbox 满足国际化业务需求。

## 支持丰富的图表类型

### 点图层

- 气泡图
- 散点图
- 符号地图
- 3D 柱状地图
- 聚合地图
- 复合图表地图
- 自定义 Marker

### 线图层

- 路径地图
- 弧线，支持 2D 弧线、3D 弧线以及大圆航线
- 等值线

### 面图层

- 填充图
- 3D 填充图

### 热力图

- 经典热力图
- 蜂窝热力图
- 网格热力图

### 栅格地图

- 图片
- Raster

更多技术细节，详细进展，请关注 [GitHub](https://github.com/antvis/L7)，欢迎大家来给点点 Star，让更多人看到这个开源的项目。

### 技术支持服务群

L7 相关技术问题，需求反馈，我们会及时响应

群号：30460926
![地理空间可视化L7支持群](https://gw.alipayobjects.com/mdn/antv_site/afts/img/A*W7IFQr6QSZYAAAAAAAAAAAAAARQnAQ)
