import { LineLayer, Scene } from '@antv/l7';
import { GaodeMap } from '@antv/l7-maps';
import * as React from 'react';

const data = [
  {
    n: '南路',
    lnglat: [115.789286, 28.552708],
  },
  {
    n: '',
    lnglat: [115.789273, 28.553421],
  },
  {
    n: '',
    lnglat: [115.789337, 28.558138],
  },
  {
    n: '大岗',
    lnglat: [115.789363, 28.56059],
  },
  {
    n: '',
    lnglat: [115.789332, 28.563834],
  },

  {
    n: '',
    lnglat: [115.789337, 28.563947],
  },

  {
    n: '',
    lnglat: [115.789343, 28.564178],
  },

  {
    n: '',
    lnglat: [115.789353, 28.564249],
  },

  {
    n: '',
    lnglat: [115.789439, 28.565144],
  },
  {
    n: '',
    lnglat: [115.790002, 28.568079],
  },

  {
    n: '',
    lnglat: [115.790684, 28.571047],
  },

  {
    n: '生米',
    lnglat: [115.790844, 28.571832],
  },
  {
    n: '',
    lnglat: [115.791392, 28.574256],
  },
  {
    n: '',
    lnglat: [115.792052, 28.576215],
  },
  {
    n: '',
    lnglat: [115.793023, 28.578778],
  },
  {
    n: '九龙湖南',
    lnglat: [115.793023, 28.578778],
  },
  {
    n: '',
    lnglat: [115.793827, 28.580743],
  },
  {
    n: '',
    lnglat: [115.793876, 28.580964],
  },
  {
    n: '',
    lnglat: [115.794412, 28.584275],
  },

  {
    n: '',
    lnglat: [115.795142, 28.589066],
  },

  {
    n: '',
    lnglat: [115.795903, 28.592264],
  },

  {
    n: '市民中心',
    lnglat: [115.79619, 28.593435],
  },
  {
    n: '',
    lnglat: [115.796526, 28.594803],
  },

  {
    n: '',
    lnglat: [115.796633, 28.595185],
  },
  {
    n: '',
    lnglat: [115.796767, 28.595491],
  },

  {
    n: '',
    lnglat: [115.79696, 28.595858],
  },

  {
    n: '',
    lnglat: [115.798301, 28.597959],
  },
  {
    n: '鹰潭街',
    lnglat: [115.799006, 28.599043],
  },
  {
    n: '',
    lnglat: [115.802067, 28.603936],
  },
  {
    n: '',
    lnglat: [115.802153, 28.604185],
  },
  {
    n: '',
    lnglat: [115.802223, 28.604416],
  },

  {
    n: '',
    lnglat: [115.802244, 28.60467],
  },
  {
    n: '',
    lnglat: [115.802239, 28.604854],
  },

  {
    n: '',
    lnglat: [115.80218, 28.605005],
  },

  {
    n: '',
    lnglat: [115.802078, 28.605155],
  },
  {
    n: '',
    lnglat: [115.801858, 28.605381],
  },

  {
    n: '',
    lnglat: [115.801552, 28.605603],
  },
  {
    n: '',
    lnglat: [115.801193, 28.605815],
  },

  {
    n: '国博',
    lnglat: [115.79587, 28.608219],
  },
  {
    n: '',
    lnglat: [115.789761, 28.610943],
  },
  {
    n: '',
    lnglat: [115.789375, 28.611136],
  },

  {
    n: '',
    lnglat: [115.789192, 28.611268],
  },
  {
    n: '',
    lnglat: [115.788801, 28.611659],
  },
  {
    n: '',
    lnglat: [115.78857, 28.611956],
  },
  {
    n: '',
    lnglat: [115.788372, 28.612281],
  },

  {
    n: '',
    lnglat: [115.788157, 28.612968],
  },

  {
    n: '',
    lnglat: [115.788114, 28.613194],
  },

  {
    n: '',
    lnglat: [115.788093, 28.613684],
  },
  {
    n: '',
    lnglat: [115.788195, 28.61416],
  },

  {
    n: '',
    lnglat: [115.788522, 28.614852],
  },
  {
    n: '西站南广场',
    lnglat: [115.790539, 28.618386],
  },
  {
    n: '南昌西站',
    lnglat: [115.793362, 28.623431],
  },
  {
    n: '',
    lnglat: [115.794101, 28.624802],
  },
  {
    n: '',
    lnglat: [115.794273, 28.625108],
  },
  {
    n: '',
    lnglat: [115.794407, 28.625268],
  },
  {
    n: '',
    lnglat: [115.794616, 28.625466],
  },
  {
    n: '',
    lnglat: [115.795018, 28.625786],
  },

  {
    n: '',
    lnglat: [115.795598, 28.626022],
  },
  {
    n: '',
    lnglat: [115.796161, 28.62605],
  },
  {
    n: '',
    lnglat: [115.796649, 28.625956],
  },

  {
    n: '龙岗',
    lnglat: [115.802987, 28.623161],
  },

  {
    n: '',
    lnglat: [115.811584, 28.619359],
  },
  {
    n: '',
    lnglat: [115.812592, 28.619217],
  },
  {
    n: '',
    lnglat: [115.813676, 28.619321],
  },

  {
    n: '',
    lnglat: [115.81455, 28.619533],
  },
  {
    n: '',
    lnglat: [115.814867, 28.619702],
  },
  {
    n: '',
    lnglat: [115.815231, 28.619966],
  },
  {
    n: '',
    lnglat: [115.815398, 28.620178],
  },
  {
    n: '国体中心',
    lnglat: [115.816739, 28.622378],
  },

  {
    n: '',
    lnglat: [115.821454, 28.630396],
  },
  {
    n: '卧龙山',
    lnglat: [115.822477, 28.631606],
  },

  {
    n: '',
    lnglat: [115.824088, 28.633306],
  },
  {
    n: '',
    lnglat: [115.827655, 28.636569],
  },

  {
    n: '',
    lnglat: [115.828578, 28.637637],
  },
  {
    n: '',
    lnglat: [115.829125, 28.638508],
  },
  {
    n: '',
    lnglat: [115.82978, 28.639944],
  },
  {
    n: '岭北',
    lnglat: [115.830145, 28.641038],
  },
  {
    n: '',
    lnglat: [115.83148, 28.645264],
  },
  {
    n: '',
    lnglat: [115.832676, 28.647915],
  },

  {
    n: '',
    lnglat: [115.833519, 28.649393],
  },

  {
    n: '前湖大道',
    lnglat: [115.834939, 28.651869],
  },
  {
    n: '学府大道东',
    lnglat: [115.839123, 28.659244],
  },
  {
    n: '翠苑路',
    lnglat: [115.846675, 28.67262],
  },

  {
    n: '地铁大厦',
    lnglat: [115.852386, 28.684076],
  },

  {
    n: '',
    lnglat: [115.854048, 28.686417],
  },

  {
    n: '',
    lnglat: [115.854794, 28.688695],
  },

  {
    n: '',
    lnglat: [115.855159, 28.689706],
  },
  {
    n: '',
    lnglat: [115.855572, 28.690403],
  },

  {
    n: '',
    lnglat: [115.856296, 28.691259],
  },

  {
    n: '雅苑路',
    lnglat: [115.857386, 28.692061],
  },
  {
    n: '',
    lnglat: [115.85937, 28.693306],
  },
  {
    n: '',
    lnglat: [115.863087, 28.694582],
  },

  {
    n: '',
    lnglat: [115.863404, 28.694572],
  },
  {
    n: '',
    lnglat: [115.863983, 28.69452],
  },
  {
    n: '',
    lnglat: [115.864509, 28.69437],
  },
  {
    n: '',
    lnglat: [115.865056, 28.694012],
  },
  {
    n: '红谷中大道',
    lnglat: [115.867006, 28.691703],
  },
  {
    n: '',
    lnglat: [115.869128, 28.689165],
  },

  {
    n: '',
    lnglat: [115.869562, 28.688873],
  },
  {
    n: '',
    lnglat: [115.870023, 28.688713],
  },

  {
    n: '',
    lnglat: [115.882029, 28.686248],
  },
  {
    n: '',
    lnglat: [115.882624, 28.686233],
  },

  {
    n: '',
    lnglat: [115.883231, 28.686299],
  },
  {
    n: '',
    lnglat: [115.885452, 28.68733],
  },

  {
    n: '',
    lnglat: [115.886315, 28.687598],
  },
  {
    n: '',
    lnglat: [115.887442, 28.687669],
  },
  {
    n: '',
    lnglat: [115.889555, 28.687777],
  },

  {
    n: '阳明公园',
    lnglat: [115.891286, 28.687954],
  },
  {
    n: '',
    lnglat: [115.894791, 28.688233],
  },
  {
    n: '',
    lnglat: [115.900021, 28.687753],
  },

  {
    n: '青山路口',
    lnglat: [115.901382, 28.686738],
  },

  {
    n: '',
    lnglat: [115.902832, 28.68548],
  },

  {
    n: '',
    lnglat: [115.903202, 28.684765],
  },
  {
    n: '',
    lnglat: [115.903251, 28.683852],
  },

  {
    n: '福州路',
    lnglat: [115.903284, 28.680642],
  },
  {
    n: '八一广场',
    lnglat: [115.902665, 28.67514],
  },

  {
    n: '',
    lnglat: [115.903379, 28.672778],
  },
  {
    n: '',
    lnglat: [115.90375, 28.6689],
  },

  {
    n: '',
    lnglat: [115.903884, 28.668415],
  },

  {
    n: '',
    lnglat: [115.904002, 28.668166],
  },
  {
    n: '',
    lnglat: [115.904275, 28.66785],
  },
  {
    n: '永叔路',
    lnglat: [115.90533, 28.666803],
  },
  {
    n: '',
    lnglat: [115.907757, 28.664447],
  },
  {
    n: '',
    lnglat: [115.908218, 28.664296],
  },

  {
    n: '',
    lnglat: [115.909339, 28.664226],
  },
  {
    n: '丁公路南',
    lnglat: [115.910889, 28.664118],
  },
  {
    n: '',
    lnglat: [115.916538, 28.663567],
  },

  {
    n: '南昌火车站',
    lnglat: [115.921001, 28.663184],
  },

  {
    n: '',
    lnglat: [115.922766, 28.663143],
  },

  {
    n: '',
    lnglat: [115.924236, 28.663313],
  },
  {
    n: '',
    lnglat: [115.925996, 28.663576],
  },
  {
    n: '顺外',
    lnglat: [115.928124, 28.663683],
  },

  {
    n: '',
    lnglat: [115.929933, 28.663718],
  },
  {
    n: '',
    lnglat: [115.931575, 28.663332],
  },
  {
    n: '',
    lnglat: [115.932991, 28.662979],
  },
  {
    n: '',
    lnglat: [115.933635, 28.662898],
  },
  {
    n: '',
    lnglat: [115.937873, 28.662851],
  },
  {
    n: '',
    lnglat: [115.938457, 28.662724],
  },
  {
    n: '',
    lnglat: [115.938897, 28.6624],
  },

  {
    n: '',
    lnglat: [115.939203, 28.661934],
  },
  {
    n: '',
    lnglat: [115.939391, 28.661505],
  },
  {
    n: '',
    lnglat: [115.939503, 28.661082],
  },
  {
    n: '',
    lnglat: [115.93953, 28.660663],
  },

  {
    n: '辛家庵',
    lnglat: [115.93957, 28.659337],
  },
];

export default class MultiLine extends React.Component {
  private scene: Scene;

  public componentWillUnmount() {
    this.scene.destroy();
  }

  public async componentDidMount() {
    const scene = new Scene({
      id: 'map',
      map: new GaodeMap({
        pitch: 50,
        style: 'light',
        center: [115.857963, 28.683016],
        zoom: 14,
        minZoom: 9,
        rotation: 0,
      }),
    });

    const lineData = {
      type: 'FeatureCollection',
      features: [],
    };

    const p = {
      type: 'Feature',
      properties: {},
      geometry: { type: 'LineString', coordinates: [] },
    };

    data.forEach((item) => {
      // @ts-ignore
      p.geometry.coordinates.push(item.lnglat as number[]);
    });
    // @ts-ignore
    lineData.features.push(p);

    const layer = new LineLayer({})
      .source(lineData)
      .size([2, 3])
      .shape('line')
      .color('rgb(255, 187, 0)');
    scene.addLayer(layer);
  }

  public render() {
    return (
      <div
        id="map"
        style={{
          position: 'absolute',
          top: 0,
          left: 0,
          right: 0,
          bottom: 0,
        }}
      />
    );
  }
}
