# Following the checklist saves the reviewers' time and gets your PR reviewed faster.

# Self Review
Have you reviewed every line of your changes by yourself?

# Test
Have you added enough test cases to cover the new feature or bug fix?
Also, add comments to describe your test cases.

# Naming
Do function names keep consistent with its behavior?
Is it easy to infer the function's behavior by its name?

# Comment
Is there any code that confuses the reviewer?
Add comments on them! You'll be asked to do so anyway.
Make sure there is no syntax or spelling error in your comments.
Some online syntax checking tools like Grammarly may be helpful.

# Refactor
Is there any way to refactor the code to make it more readable?
If the refactoring touches a lot of existing code, send another PR to do it.

# Single Purpose
Make sure the PR does only one thing and nothing else.

# Diff Size
Make sure the diff size is no more than 500, split it into small PRs if it is too large.
