<?php

class wpcollect {
	
	private		$ip;
	public		$post_id;
	public		$user_id;
	public		$collect_count;
	public		$is_loggedin;
	
	public function __construct($post_id, $user_id){
		$this->ip = $_SERVER['REMOTE_ADDR'];
		$this->post_id = $post_id;
		$this->user_id = $user_id;
		
		if( $user_id && $user_id > 0 ){
			$this->is_loggedin = true;
		}
		
		$this->collect_count();
	}

	public function collect_count(){
		global $wpdb, $wpcollect_table_name;
		
		// check in the db for collect
		$collect_count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(post_id) FROM $wpcollect_table_name WHERE post_id = %d", $this->post_id));
		
		// returns collect, return 0 if no collect were found
		$this->collect_count = $collect_count;
		
	}
	
	public function is_collect(){
		if( isset($_COOKIE['wp_collect_'.$this->post_id]) ){
			return true;
		}

		global $wpdb, $wpcollect_table_name;
		
		if($this->is_loggedin){
			// user is logged in	
			$collect_check = $wpdb->get_var($wpdb->prepare("SELECT COUNT(post_id) FROM $wpcollect_table_name
											WHERE	post_id = %d
											AND		user_id = %d", $this->post_id, $this->user_id));
		} else{
			// user not logged in, check by ip address
			$collect_check = $wpdb->get_var($wpdb->prepare("SELECT COUNT(post_id) FROM $wpcollect_table_name
											WHERE	post_id = %d
											AND		ip_address = %s
											AND		user_id = %d", $this->post_id, $this->ip, 0));
		}

		$collect_check = intval($collect_check);

		return $collect_check && $collect_check > 0;
	}
	
	public function add_collect(){
		global $wpdb, $wpcollect_table_name;
		
		if( !$this->is_collect() ){
			$wpdb->insert($wpcollect_table_name, array('post_id' => $this->post_id, 
													'user_id' => $this->user_id,
													'create_time' => date("Y-m-d H:i:s"),
													'ip_address' => $this->ip), array('%d', '%d', '%s'));

			$expire = time() + 365*24*60*60;
        	setcookie('wp_collect_'.$this->post_id, $this->post_id, $expire, '/', $_SERVER['HTTP_HOST'], false);
		}

		$this->collect_count();
	}
	
	public function remove_collect(){
		global $wpdb, $wpcollect_table_name;
		
		if( $this->is_collect() ){
			$wpdb->delete($wpcollect_table_name, array('post_id' => $this->post_id, 
													'user_id' => $this->user_id));

			$expire = time();
        	setcookie('wp_collect_'.$this->post_id, $this->post_id, $expire, '/', $_SERVER['HTTP_HOST'], false);
		}

		$this->collect_count();
	}
		
	public function collect_button($odc){
		$class = $this->is_collect() ? 'wp-collect collected is-favorite' : 'wp-collect';
		$userId = $this->is_loggedin ? $this->user_id : 0;	
		$postId = $this->post_id;

		$action = "wpcollect($postId, $userId)";
		if(is_user_logged_in()){
			$btn_html = $odc ? '<a id="wp-collect-%d" class="favorite-btn social-btn star-btn J_addFavorite %s" onclick="%s" href="javascript:void(0)"><span id="star-count">%d</span></a>' : '<a id="wp-collect-%d" class="favorite-btn social-btn star-btn J_addFavorite %s" onclick="%s" href="javascript:void(0)"><i class="icon icon-star"></i><i class="icon-star fly"></i><span id="star-count">%d</span></a>';
			$button = sprintf($btn_html, $postId, $class, $action, $this->collect_count);
		}else{
			$btn_html = $odc ? '<a id="wp-collect-%d" class="user-login favorite-btn social-btn star-btn J_addFavorite %s" href="javascript:void(0)"><span id="star-count">%d</span></a>' : '<a id="wp-collect-%d" class="user-login favorite-btn social-btn star-btn J_addFavorite %s" href="javascript:void(0)"><i class="icon icon-star"></i><i class="icon-star fly"></i><span id="star-count">%d</span></a>';
			$button = sprintf($btn_html, $postId, $class, $this->collect_count);
		}
		return $button;
	}
}

?>