<?php
	function wp_collect($odc=false){
		global $user_ID;
		get_currentuserinfo();

		$user_ID = $user_ID ? $user_ID : 0;
		$wpcollect = new wpcollect(get_the_ID(), $user_ID);

		echo $wpcollect->collect_button($odc);
	}

	function wpcollect_install(){
		global $wpdb, $wpcollect_table_name;

		if( $wpdb->get_var("show tables like '{$wpcollect_table_name}'") != $wpcollect_table_name ) {
			$wpdb->query("CREATE TABLE {$wpcollect_table_name} (
				id      BIGINT(20) NOT NULL AUTO_INCREMENT,
				post_id BIGINT(20) NOT NULL,
				user_id BIGINT(20) NOT NULL,
				ip_address VARCHAR(25) NOT NULL,
				create_time datetime,
				UNIQUE KEY id (id)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1");
		}
	}

	function wpcollect_uninstall(){
		global $wpdb, $wpcollect_table_name;

		$wpdb->query("DROP TABLE IF EXISTS {$wpcollect_table_name}");
	}

	function wpcollect_scripts(){

		wp_enqueue_script('jquery');
		wp_enqueue_script( 'wpcollect',  wpcollect_js_url('wp-collect'), array(), WPCOLLECT_VERSION );
        wp_localize_script( 'wpcollect', 'wpcollect_ajax_url', WPCOLLECT_ADMIN_URL . "admin-ajax.php");
	}
	add_action('wp_enqueue_scripts', 'wpcollect_scripts', 20, 1);


	function wpcollect_callback(){
		$user_id = $_POST['user_id'];
		$post_id = $_POST['post_id'];

		$wpcollect = new wpcollect($post_id, $user_id);
		if( $wpcollect->is_collect() ){
			$wpcollect->remove_collect();

			$result = array(
				'status' => 300,
				'count' => $wpcollect->collect_count
			);
		}else{
			$wpcollect->add_collect();

			$result = array(
				'status' => 200,
				'count' => $wpcollect->collect_count
			);
		}

		header('Content-type: application/json');
		echo json_encode($result);
		exit;
	}
	add_action( 'wp_ajax_wpcollect', 'wpcollect_callback');
	add_action( 'wp_ajax_nopriv_wpcollect', 'wpcollect_callback');


	function wpcollect_js_url($js_url){
		return WPCOLLECT_URL . "/static/js/{$js_url}.js";
	}