<?php
define('IN_MY', TRUE);
// error_reporting(E_ALL);
include_once('../data/config/site.config.php');
include_once('../data/config/database.config.php');
include_once('../lib/My/My.class.php');
include_once('../lib/My/DbDriver.class.php');
include_once('../lib/My/Model.class.php');
include_once('../lib/My/Common.class.php');
define("ROOT",str_replace('/','' ,str_replace('/api/weixin.php', '', strtolower($_SERVER['SCRIPT_NAME']))));
define("DEBUG",0);

class wechatCallbackapiTest extends Model
{
	private  $token ;
	private $appid;
	private $appsecret;
	private $root;
	private $sitename;
	private $wapdomain;
	private $sitedomain;
	private $apiopen;
	private $firstPic;
	private $listPic;
	private $regmsg;
	private $debug = 1;

	public final function __construct() {
		global $MyDB,$MySite;
		$this->connect();
		$this->sitename = $MySite['name'];
		$this->initConfig();
	}
	
	private function initConfig(){
		$sql = "SELECT * FROM ".$this->table("weixin_config");
		$cfg =  $this->db->fetch_first($sql);
		$this->token = $cfg['token'];
		$this->appid = $cfg['appid'];
		$this->appsecret = $cfg['appsecret'];
		$this->root = $cfg['site_domain'];
		$this->wapdomain = $cfg['wap_domain'];
		$this->sitedomain = $cfg['site_domain'];
		$this->apiopen = $cfg['apiopen'];
		$this->regmsg=$cfg['regmsg'];
		$this->firstPic = ROOT.DIRECTORY_SEPARATOR."upload".DIRECTORY_SEPARATOR.$cfg['first_pic'];
		$this->listPic = ROOT.DIRECTORY_SEPARATOR."upload".DIRECTORY_SEPARATOR.$cfg['default_pic'];
	}
	
	public function valid()
	{
		$echoStr = $_GET["echostr"];
		if($this->checkSignature())
		{
			exit($echoStr);
		}
	}
	public function responseMsg()
	{
		$wx_keywords_table = $this->table("weixin_keywords");
		if( !DEBUG)
		if( !$this->checkSignature() )
		{
			exit();
		};

		$postStr = $GLOBALS["HTTP_RAW_POST_DATA"];
		if (!empty($postStr))
		{
			if($this->check_php_version("5.2.11")){
				libxml_disable_entity_loader(true);
			}
			$postObj = simplexml_load_string($postStr, 'SimpleXMLElement', LIBXML_NOCDATA);
			$fromUsername = addslashes($postObj->FromUserName);
			$toUsername = addslashes($postObj->ToUserName);
			$keyword = trim($postObj->Content);
// 			$keyword = utf8_to_gbk($keyword);
			$keyword = addslashes($keyword);
			$time = time();
			$event = trim($postObj->Event);
// 				$this->exit_word_message($fromUsername, $fromUsername, $toUsername, $time);
			if ($event === "subscribe")
			{
// 				$word= "感谢您的关注预订易，随时随地低折扣订酒店订门票就找预订易酒店预订！<a href='".$this->wapdomain ."/wx_binding/".$fromUsername.".html'>立即绑定</a> ";
				$word = $this->regmsg ."  <a href='".$this->sitedomain ."?m=phoneWeb.wx_binding&from=".$fromUsername.".html'>立即绑定</a>";
				$this->exit_word_message($word,$fromUsername,$toUsername,$time);
			}
				
// 			$default_pic=$this->root."/data/images/".DEFAULT_PIC;
// 			$first_pic=$this->root."/data/images/".FIRST_PIC;
				
			if($event === "unsubscribe"){
				$sql = "update ".$this->table("member")." set weixin_openid='' where weixin_openid='".$fromUsername."'";
				$this->db->query($sql);
			}
			
// 			$word  = "MsgType:".$postObj->MsgType.", EventKey:". $postObj->EventKey.", Event:".$postObj->Event;
// 			$this->exit_word_message($word,$fromUsername,$toUsername,$time);

			//自定义菜单事件
			if($event === "CLICK"){
				if($this->apiopen=='0')
				{
					$word="网站微信接口已经关闭";
					$this->exit_word_message($word,$fromUsername,$toUsername,$time);
				}
				
				//绑定帐号
				if($postObj->EventKey=="binding"){
					$usinfo = $this->get_user_info($fromUsername);
					if(!empty($usinfo)){
						$word="您已绑定帐号";
					}else{
						$word="请先绑定帐号<a href='".$this->sitedomain ."?m=phoneWeb.wx_binding&from=".$fromUsername.".html'>点这里绑定</a>";
					}
					$this->exit_word_message($word,$fromUsername,$toUsername,$time);
				}

				//个人中心
				elseif($postObj->EventKey=="member"){
					$usinfo = $this->get_user_info($fromUsername);
					if(!empty($usinfo)){
						$word=implode(",",array_values($usinfo));
						if(empty($word)){
							$word = "没有找到对应的信息!";
						}
					}else{
						$word = "<a href='".$this->sitedomain ."?m=phoneWeb.wx_binding&from=".$fromUsername.".html'>请先绑定帐号</a>";
					}
					$this->exit_word_message($word,$fromUsername,$toUsername,$time);
				}

				//联系我们
				elseif($postObj->EventKey=="contactUs"){
					$word = "公司名称：珠海智达利企业管理咨询有限公司\n"
							."公司地址：珠海市软件园路1号南方软件园A2-409室\n"
									."联系电话：0756-8158050\n"
											."业务传真：0756-6210999\n";
					$this->exit_word_message($word,$fromUsername,$toUsername,$time);
				}

				else{
					switch ($postObj->EventKey)
					{
						case "newjobs":
							$type=1;
// 							$jobstable=table('jobs_search_rtime');
							break;
						case "emergencyjobs":
							$type=1;
// 							$jobstable=table('jobs_search_rtime');
							$wheresql=" where `emergency`=1 ";
							break;
						case "recommendjobs":
							$type=1;
// 							$jobstable=table('jobs_search_rtime');
							$wheresql=" where `recommend`=1 ";
							break;
						case "resume":
							$type=2;
// 							$jobstable=table('resume_search_rtime');
							break;
						default:
							$type=1;
// 							$jobstable=table('jobs_search_rtime');
							break;
					}

						$i=1;
						$strmiddle="";
						$strbegin="<xml>
								 <ToUserName><![CDATA[".$fromUsername."]]></ToUserName>
								 <FromUserName><![CDATA[".$toUsername."]]></FromUserName>
								 <CreateTime>".$time."</CreateTime>
								 <MsgType><![CDATA[news]]></MsgType>
								 <ArticleCount>".$count."</ArticleCount>
								 <Articles>";
						while($i==1)
						{
							if($i==1){
								$picurl=$first_pic;
							}else{
								$picurl=$default_pic;
							}
							$i++;
							$strmiddle.="<item>
										 <Title><![CDATA[title]]></Title>
										 <Description><![CDATA[description]]></Description>
										 <PicUrl><![CDATA[pic]]></PicUrl>
										 <Url><![CDATA[url]]></Url>
										 </item>";
						}
						$strend = "</Articles>
								 <FuncFlag>1</FuncFlag>
								 </xml>";
						$word = $strbegin.$strmiddle.$strend;
					}
					if(empty($word))
					{
						$word="没有找到相应的信息";
						$this->exit_word_message($word,$fromUsername,$toUsername,$time);
					}
					else
					{
						exit($word);
					}
				}elseif($event === "SCAN"){
				$event_key = $postObj->EventKey;
				$usinfo = $this->get_user_info($fromUsername);
				if(!empty($usinfo)){
					$word = "<a href='".$this->wapdomain."/wap_login.php?act=weixin_login&openid=".$fromUsername."&uid=".$usinfo['uid']."&event_key=".$event_key."'>点此立即登录".$this->sitename."网页</a>";
				}else{
					$word = "<a href='".$this->wapdomain."/wap-binding.php?from=".$fromUsername."'>请先绑定帐号</a>";
				}
				$this->exit_word_message($word,$fromUsername,$toUsername,$time);
				
				//获取用户地理位置
			}elseif($event === 'LOCATION'){
				$x = $postObj->Latitude;
				$y = $postObj->Longitude;
				$p = $postObj->Precision;
				$city = $this->getCityByLocation($x,$y);
				if($city){
					$city = str_replace( "市", "",$city);
					$word = $city;
				}
				$this->exit_word_message($word,$fromUsername,$toUsername,$time);
			}
				
			if (!empty($keyword))
			{
				$imageTpl = "<xml>
                         <ToUserName><![CDATA[%s]]></ToUserName>
                         <FromUserName><![CDATA[%s]]></FromUserName>
                         <CreateTime>%s</CreateTime>
                         <MsgType><![CDATA[%s]]></MsgType>
                         <ArticleCount>%s</ArticleCount>
                         <Articles>
                         %s
                         </Articles>
                         <FuncFlag>0</FuncFlag>
                         </xml>";
				$newsTpl = "<xml>
                         <ToUserName><![CDATA[%s]]></ToUserName>
                         <FromUserName><![CDATA[%s]]></FromUserName>
                         <CreateTime>%s</CreateTime>
                         <MsgType><![CDATA[%s]]></MsgType>
                         <ArticleCount>%s</ArticleCount>
                         <Articles>
                         %s
                         </Articles>
                         <FuncFlag>0</FuncFlag>
                         </xml>";
				if($this->apiopen=='0')
				{
					$word="网站微信接口已经关闭";
					$this->exit_word_message($word,$fromUsername,$toUsername,$time);
				}
				if(strstr($keyword,"/")){
					$key_arr = explode("/",$keyword);
					$username = $key_arr[0];
					$password = $key_arr[1];
					$usinfo = array();
					$sql = "select * from ".$this->table('member')." where `account` = '{$username}'";
					$usinfo = $this->db->fetch_first($sql);
					$word=$usinfo['password'];
					if(is_array($usinfo) && !empty($usinfo)){
						$success = false;
						$usname=$usinfo['name'];
						$pwd=md5($password);
						$word = $pwd;
						if ($usinfo['password']==$pwd)
						{
							$this->db->query("update ".$this->table('member')." set `weixin_openid`='".$fromUsername."',bindingtime=".time()." where id=".$usinfo['id']);
							$success = true;
						}
						else
						{
							$success = false;
						}
						if($success){
							$word="绑定成功!";
						}else{
							$word.="用户名或密码错误!";
						}
					}else{
						$word.="用户名或密码错误!";
					}
						
					$this->exit_word_message($word,$fromUsername,$toUsername,$time);
				}else{
					$auto_res = $ret = $this->db -> fetch_all("SELECT * FROM ".$wx_keywords_table);
					if(count($auto_res) > 0){
						foreach($auto_res as $k => $v){
							$res_ks = explode(' ', $v['keyword']);
								foreach($res_ks as $kk => $vv){
									if($vv == $keyword){
									
										if($v['type'] == 1){
											$msgType = "text";
											$contentStr = $v['contents'];
											$this->db -> query("UPDATE ".$wx_keywords_table." SET `count` = `count`+1 WHERE `id` =$v[id]");
											$this->exit_word_message($contentStr, $fromUsername, $toUsername, $time);
										}elseif($v['type'] == 2){
											$msgType = "news";
											$ArticleCount = 0;
											$items = "";
											$ArticleCount = 1;
											$v['images'] = ROOT .'/upload/weixin/'. $v['pic'];
											$items .= "<item>
						 <Title><![CDATA[" . $v['pic_tit'] . "]]></Title>
						 <Description><![CDATA[" . $v['desc'] . "]]></Description>
						 <PicUrl><![CDATA[" . $v['images'] . "]]></PicUrl>
						 <Url><![CDATA[" . $v['pic_url'] . "]]></Url>
                 </item>";
											$this->db -> query("UPDATE ".$wx_keywords_table." SET `count` = `count`+1 WHERE `id` =$v[id]");
											$resultStr = sprintf($imageTpl, $fromUsername, $toUsername, $time, $msgType, $ArticleCount, $items);
											exit($resultStr);
										}
									}
								}
						}
					}
					
					//酒店搜索
					
				}
					
			}
			else
			{
				$this->exit_word_message("找不到相关信息！", $fromUsername, $toUsername, $time);
			}
		}
	}
	
	private function getCityByLocation($lat,$lon){
		//http://api.map.baidu.com/geocoder?location=23.137466,113.352425&output=xml
		$city = null;
		if($lat && $lon){
			$url = "http://api.map.baidu.com/geocoder?location=%s,%s&output=xml";
			$result = file_get_contents(sprintf($url,$lat,$lon));
			$xmlres = simplexml_load_string($result);
			$city =  $xmlres->result->addressComponent->city;
		}
		if(!$city){
			$city = $MySite['defaultCity'];
		}
		$city = str_replace( "市", "",$city);
		$sql = "SELECT * FROM {$this->g_el_tablepre}poi where name='{$city}' AND poiType='3'";
		$rs = $this->db->fetch_first($sql);
		if($rs){
			$sql = "UPDATE {$this->table('member')} SET weixin_city='{$rs['name']}' AND weixin_city_id='{$rs['id']}'";
			$this->db->query($sql);
			return $rs['name']; 
		}
// 		$xmlres = Common::https_request(sprintf($url,$lat,$lon));
// 		if($xmlres){
// 			$arrayRes = simplexml_load_string($xmlres);
// 		return $arrayRes->result->addressComponent->city;
// 		}
	}
	
	
	private function checkSignature()
	{
		$signature = $_GET["signature"];
		$timestamp = $_GET["timestamp"];
		$nonce = $_GET["nonce"];
		$token = $this->token;
		$tmpArr = array($token, $timestamp, $nonce);
		sort($tmpArr, SORT_STRING);
		$tmpStr = implode( $tmpArr );
		$tmpStr = sha1( $tmpStr );
		if($tmpStr == $signature )
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	private function get_user_info($fromUsername){
		$usinfo = array();
		$usinfo_obj = $this->db->query("select * from ".$this->table("member")."  where weixin_openid='".$fromUsername."' limit 1");
		while($row = $this->db->fetch_array($usinfo_obj)){
			$usinfo = $row;
		}
		return $usinfo;
	}
	private function update_user_info($fromUsername,$record=true,$setcookie=true,$cookie_expire=NULL)
	{
		global $timestamp, $online_ip,$db,$QS_cookiepath,$QS_cookiedomain,$_CFG;
		$user = $this->get_user_info($fromUsername);
		if (empty($user))
		{
			return false;
		}
		else
		{
	 	$_SESSION['uid'] = intval($user['uid']);
	 	$_SESSION['username'] = addslashes($user['username']);
	 	$_SESSION['utype']=intval($user['utype']);
		}
		if ($setcookie)
		{
			$expire=intval($cookie_expire)>0?time()+3600*24*$cookie_expire:0;
			setcookie('BK[uid]',$user['uid'],$expire,$QS_cookiepath,$QS_cookiedomain);
			setcookie('BK[username]',addslashes($user['username']),$expire,$QS_cookiepath,$QS_cookiedomain);
			setcookie('BK[password]',$user['password'],$expire,$QS_cookiepath,$QS_cookiedomain);
			setcookie('BK[utype]',$user['utype'], $expire,$QS_cookiepath,$QS_cookiedomain);
		}
		return true;
	}
	private function exit_word_message($word,$fromUsername,$toUsername,$time){
// 		$word = gbk_to_utf8($word);
		$text="<xml>
		<ToUserName><![CDATA[".$fromUsername."]]></ToUserName>
		<FromUserName><![CDATA[".$toUsername."]]></FromUserName>
		<CreateTime>".$time."</CreateTime>
		<MsgType><![CDATA[text]]></MsgType>
		<Content><![CDATA[".$word."]]></Content>
		</xml> ";
		exit($text);
	}
	private function check_php_version($version) {
		$php_version = explode('-',phpversion());
		// strnatcasecmp( $php_version[0], $version ) 0表示等于，1表示大于，-1表示小于
		$is_pass = strnatcasecmp($php_version[0],$version)>=0?true:false;
		return $is_pass;
	}
}
//
$wechatObj = new wechatCallbackapiTest();

if(isset($_REQUEST['echostr']))
	$wechatObj->valid();
elseif(DEBUG || isset($_REQUEST['signature']))
{
	$wechatObj->responseMsg();
}
		
?>