
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


-- 导出  表 hotelcms.el_poi 结构
DROP TABLE IF EXISTS `el_poi`;
CREATE TABLE IF NOT EXISTS `el_poi` (
  `id` varchar(20) NOT NULL,
  `name` varchar(100) default NULL,
  `pinyin` varchar(50) NOT NULL,
  `poiType` int(11) default NULL,
  `parentId` varchar(20) default NULL,
  `isHot` tinyint(1) default '0',
  `orderIndex` int(11) default NULL,
  `classify` int(11) NOT NULL default '0',
  KEY `parentId` (`parentId`),
  KEY `poiType` (`poiType`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- 导出  表 hotelcms.my_activity 结构
DROP TABLE IF EXISTS `my_activity`;
CREATE TABLE IF NOT EXISTS `my_activity` (
  `id` int(4) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `activityTitle` varchar(50) NOT NULL,
  `provinceId` varchar(10) NOT NULL,
  `cityId` varchar(10) NOT NULL,
  `areaId` varchar(10) NOT NULL,
  `productType` varchar(15) NOT NULL,
  `productId` int(11) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `maxCount` int(11) NOT NULL,
  `cover` varchar(250) NOT NULL,
  `beginTime` DATETIME NOT NULL,
  `endTime` DATETIME NOT NULL,
  `introduction` text NOT NULL,
  `listTitle` varchar(10) NOT NULL,
  `title` varchar(10) NOT NULL,
  `updateData` varchar(20) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(100) NOT NULL,
  `status` varchar(10) NOT NULL,
  `date` varchar(20) NOT NULL,
  `isdel` int(4) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_activity_comment 结构
DROP TABLE IF EXISTS `my_activity_comment`;
CREATE TABLE IF NOT EXISTS `my_activity_comment` (
  `id` int(11) NOT NULL auto_increment,
  `activityId` int(11) NOT NULL,
  `orderCode` varchar(30) NOT NULL,
  `score` varchar(10) NOT NULL,
  `memberId` int(11) NOT NULL,
  `remark` varchar(500) NOT NULL,
  `takeMoney` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_admin 结构
DROP TABLE IF EXISTS `my_admin`;
CREATE TABLE IF NOT EXISTS `my_admin` (
  `id` int(11) NOT NULL auto_increment,
  `account` varchar(20) NOT NULL,
  `password` varchar(32) NOT NULL,
  `name` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `qq` varchar(15) NOT NULL,
  `date` datetime NOT NULL,
  `sex` varchar(2) NOT NULL,
  `email` varchar(100) NOT NULL,
  `address` varchar(400) NOT NULL,
  `remark` varchar(200) default NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_admin_log 结构
DROP TABLE IF EXISTS `my_admin_log`;
CREATE TABLE IF NOT EXISTS `my_admin_log` (
  `id` int(11) NOT NULL auto_increment,
  `content` varchar(400) NOT NULL,
  `model` varchar(50) NOT NULL,
  `adminId` int(11) NOT NULL,
  `ip` varchar(50) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_appmoney 结构
DROP TABLE IF EXISTS `my_appmoney`;
CREATE TABLE IF NOT EXISTS `my_appmoney` (
  `id` int(11) NOT NULL auto_increment,
  `memberId` int(11) NOT NULL,
  `bank` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `account` varchar(50) NOT NULL,
  `contact` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `date` datetime NOT NULL,
  `value` int(11) NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_area_blacklist 结构
DROP TABLE IF EXISTS `my_area_blacklist`;
CREATE TABLE IF NOT EXISTS `my_area_blacklist` (
  `id` int(11) NOT NULL auto_increment,
  `blackId` varchar(50) NOT NULL,
  `isdel` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_article 结构
DROP TABLE IF EXISTS `my_article`;
CREATE TABLE IF NOT EXISTS `my_article` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `cover` varchar(100) NOT NULL,
  `provinceid` varchar(10) NOT NULL,
  `cityid` varchar(10) NOT NULL,
  `areaid` varchar(10) NOT NULL,
  `typeId` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_authorize 结构
DROP TABLE IF EXISTS `my_authorize`;
CREATE TABLE IF NOT EXISTS `my_authorize` (
  `id` int(11) NOT NULL auto_increment,
  `memberId` int(11) NOT NULL,
  `moudule` varchar(50) NOT NULL,
  `power` text NOT NULL,
  `isdel` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_checkinfo 结构
DROP TABLE IF EXISTS `my_checkinfo`;
CREATE TABLE IF NOT EXISTS `my_checkinfo` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(250) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_comment 结构
DROP TABLE IF EXISTS `my_comment`;
CREATE TABLE IF NOT EXISTS `my_comment` (
  `id` int(11) NOT NULL auto_increment,
  `type` varchar(10) NOT NULL,
  `hotelId` int(11) NOT NULL,
  `roomId` int(11) NOT NULL,
  `roomNo` varchar(10) NOT NULL,
  `orderCode` varchar(30) NOT NULL,
  `score` varchar(10) NOT NULL,
  `memberId` int(11) NOT NULL,
  `indate` date NOT NULL,
  `outdate` date NOT NULL,
  `remark` varchar(500) NOT NULL,
  `takeMoney` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_comment_impression 结构
DROP TABLE IF EXISTS `my_comment_impression`;
CREATE TABLE IF NOT EXISTS `my_comment_impression` (
  `id` int(11) NOT NULL auto_increment,
  `commentId` int(11) NOT NULL,
  `hotelId` int(11) NOT NULL,
  `roomId` int(11) NOT NULL,
  `memberId` int(11) NOT NULL,
  `value` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_delta 结构
DROP TABLE IF EXISTS `my_delta`;
CREATE TABLE IF NOT EXISTS `my_delta` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_dict_roomprice 结构
DROP TABLE IF EXISTS `my_dict_roomprice`;
CREATE TABLE IF NOT EXISTS `my_dict_roomprice` (
  `hotelId` varchar(6) default NULL,
  `id` int(11) NOT NULL auto_increment,
  `typeId` int(11) NOT NULL,
  `roomId` int(11) NOT NULL,
  `marketPrice` decimal(9,2) NOT NULL,
  `costPrice` decimal(9,2) NOT NULL,
  `price` decimal(9,2) NOT NULL,
  `week` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `roomId` (`roomId`),
  KEY `week` (`week`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_elong_blacklist 结构
DROP TABLE IF EXISTS `my_elong_blacklist`;
CREATE TABLE IF NOT EXISTS `my_elong_blacklist` (
  `id` int(11) NOT NULL auto_increment,
  `hotelId` varchar(11) NOT NULL,
  `areaId` varchar(6) NOT NULL,
  `cityId` varchar(6) NOT NULL,
  `provinceId` varchar(6) NOT NULL,
  `isdel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_finance 结构
DROP TABLE IF EXISTS `my_finance`;
CREATE TABLE IF NOT EXISTS `my_finance` (
  `id` int(11) NOT NULL auto_increment,
  `memberId` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  `date` datetime NOT NULL,
  `value` int(11) NOT NULL,
  `relTableName` varchar(50) NOT NULL,
  `relId` int(11) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_hotel 结构
DROP TABLE IF EXISTS `my_hotel`;
CREATE TABLE IF NOT EXISTS `my_hotel` (
  `hotelPhone` varchar(20) default NULL,
  `scale` varchar(20) NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `shortName` varchar(50) NOT NULL,
  `enName` varchar(50) NOT NULL,
  `provinceid` varchar(11) NOT NULL,
  `cityid` varchar(11) NOT NULL,
  `areaId` varchar(11) NOT NULL,
  `levelId` varchar(11) NOT NULL,
  `landmarkId` varchar(11) NOT NULL,
  `shopareaId` varchar(11) NOT NULL,
  `memberId` int(11) NOT NULL,
  `merge` varchar(20) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `address` varchar(200) NOT NULL,
  `title` varchar(200) NOT NULL,
  `keywords` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `listTitle` varchar(10) NOT NULL,
  `cover` int(11) NOT NULL,
  `hotelview` varchar(500) NOT NULL,
  `hotelmove` varchar(500) NOT NULL,
  `service` varchar(100) NOT NULL,
  `detail` text NOT NULL,
  `catering` text NOT NULL,
  `facility` text NOT NULL,
  `meeting` text NOT NULL,
  `minCount` int(4) NOT NULL,
  `supportservice` varchar(250) NOT NULL,
  `otherservice` varchar(250) NOT NULL,
  `scenery` text NOT NULL,
  `traffic` text NOT NULL,
  `baiduMapX` varchar(20) default NULL,
  `baiduMapY` varchar(20) default NULL,
  `updateData` varchar(20) NOT NULL,
  `status` varchar(20) NOT NULL,
  `updateDate` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_level 结构
DROP TABLE IF EXISTS `my_level`;
CREATE TABLE IF NOT EXISTS `my_level` (
  `id` int(11) NOT NULL auto_increment,
  `type` varchar(10) NOT NULL,
  `name` varchar(20) NOT NULL,
  `picture` varchar(100) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `status` varchar(20) NOT NULL,
  `displayOrder` int(11) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



-- 导出  表 hotelcms.my_member 结构
DROP TABLE IF EXISTS `my_member`;
CREATE TABLE IF NOT EXISTS `my_member` (
  `id` int(11) NOT NULL auto_increment,
  `account` varchar(20) NOT NULL,
  `password` varchar(32) NOT NULL,
  `name` varchar(30) NOT NULL,
  `sex` varchar(2) NOT NULL,
  `mobile` varchar(15) NOT NULL,
  `qq` varchar(15) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `address` varchar(400) NOT NULL,
  `company` varchar(300) NOT NULL,
  `postcode` varchar(20) NOT NULL,
  `type` varchar(10) NOT NULL,
  `siteKey` varchar(20) default NULL,
  `hotelReturn` decimal(18,2) NOT NULL default '0.00',
  `status` varchar(20) NOT NULL,
  `remark` varchar(200) default NULL,
  `vipCode` varchar(25) NOT NULL,
  `Integral` int(11) NOT NULL default '999',
  `date` datetime NOT NULL,
  `birthday` varchar(100) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  	`weixin_openid` VARCHAR(50)  NULL DEFAULT NULL,
	`bindingtime` INT(10) NULL DEFAULT NULL,
	`weixin_city` VARCHAR(50) NULL DEFAULT NULL,
	`weixin_city_id` VARCHAR(20) NULL DEFAULT NULL,
  PRIMARY KEY  (`id`),
  KEY `account` (`account`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_module 结构
DROP TABLE IF EXISTS `my_module`;
CREATE TABLE IF NOT EXISTS `my_module` (
  `id` int(11) NOT NULL auto_increment,
  `chName` varchar(50) NOT NULL,
  `enName` varchar(150) NOT NULL,
  `isdel` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_msginfo 结构
DROP TABLE IF EXISTS `my_msginfo`;
CREATE TABLE IF NOT EXISTS `my_msginfo` (
  `id` int(11) NOT NULL auto_increment,
  `type` varchar(20) NOT NULL,
  `content` varchar(250) NOT NULL,
  `date` varchar(30) NOT NULL,
  `result` int(4) NOT NULL,
  `balance` int(4) NOT NULL,
  `isdel` int(4) NOT NULL,
  `orderNum` varchar(150) NOT NULL,
  `phone` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_msg_log 结构
DROP TABLE IF EXISTS `my_msg_log`;
CREATE TABLE IF NOT EXISTS `my_msg_log` (
  `id` int(8) NOT NULL auto_increment,
  `phone` varchar(250) NOT NULL,
  `content` varchar(250) NOT NULL,
  `sendType` int(4) NOT NULL,
  `UpdateTime` varchar(50) NOT NULL,
  `SendTime` varchar(50) NOT NULL,
  `isdel` varchar(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_msg_times 结构
DROP TABLE IF EXISTS `my_msg_times`;
CREATE TABLE IF NOT EXISTS `my_msg_times` (
  `id` int(11) NOT NULL auto_increment,
  `isopen` int(11) NOT NULL,
  `clock` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `content` varchar(250) NOT NULL,
  `isdel` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_nopay 结构
DROP TABLE IF EXISTS `my_nopay`;
CREATE TABLE IF NOT EXISTS `my_nopay` (
  `id` int(11) NOT NULL auto_increment,
  `categoryname` varchar(20) NOT NULL,
  `categoryid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `isdel` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_order_activity 结构
DROP TABLE IF EXISTS `my_order_activity`;
CREATE TABLE IF NOT EXISTS `my_order_activity` (
  `isPay` int(11) default NULL,
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(20) NOT NULL,
  `activityId` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `count` int(4) NOT NULL,
  `price` decimal(9,2) NOT NULL,
  `memberId` int(11) NOT NULL,
  `status` varchar(20) NOT NULL,
  `doState` varchar(20) NOT NULL,
  `doResult` varchar(20) NOT NULL,
  `remark` text NOT NULL,
  `date` varchar(100) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- 导出  表 hotelcms.my_order_room 结构
DROP TABLE IF EXISTS `my_order_room`;
CREATE TABLE IF NOT EXISTS `my_order_room` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(20) NOT NULL,
  `elOrderID` varchar(50) NOT NULL,
  `elCancel` varchar(50) NOT NULL,
  `elguarantee` varchar(50) NOT NULL,
  `personNum` int(11) NOT NULL,
  `certType` varchar(100) NOT NULL,
  `name` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `inTimeMin` varchar(5) NOT NULL,
  `inTimeMax` varchar(5) NOT NULL,
  `hotelId` varchar(11) NOT NULL default '0',
  `roomId` varchar(11) NOT NULL,
  `roomNum` varchar(11) NOT NULL,
  `indate` date NOT NULL,
  `outdate` date NOT NULL,
  `takeMoney` decimal(9,2) NOT NULL,
  `price` decimal(9,2) NOT NULL,
  `memberId` int(11) NOT NULL,
  `siteKey` varchar(25) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `doState` varchar(20) NOT NULL,
  `doResult` varchar(20) NOT NULL,
  `priceDetail` text NOT NULL,
  `remark` text NOT NULL,
  `returnRemark` varchar(200) NOT NULL,
  `integral` varchar(11) NOT NULL default '100',
  `hotel` varchar(100) NOT NULL,
  `room` varchar(100) NOT NULL,
  `isPay` int(11) NOT NULL default '0',
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `code` (`code`),
  KEY `roomId` (`roomId`),
  KEY `memberId` (`memberId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- 导出  表 hotelcms.my_pay 结构
DROP TABLE IF EXISTS `my_pay`;
CREATE TABLE IF NOT EXISTS `my_pay` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL,
  `ch_name` varchar(30) NOT NULL,
  `account` varchar(50) NOT NULL,
  `partnerid` varchar(50) NOT NULL,
  `key` varchar(50) NOT NULL,
  `modular` varchar(200) NOT NULL,
  `noPay` varchar(250) NOT NULL,
  `return` varchar(250) NOT NULL,
  `deposit` varchar(200) NOT NULL default '0',
  `date` datetime NOT NULL,
  `status` varchar(10) NOT NULL,
  `isdel` varchar(10) NOT NULL default '0',
  `type` tinyint(4) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_photo 结构
DROP TABLE IF EXISTS `my_photo`;
CREATE TABLE IF NOT EXISTS `my_photo` (
  `id` int(11) NOT NULL auto_increment,
  `uploader` varchar(10) NOT NULL,
  `uploaderId` int(11) NOT NULL,
  `categoryName` varchar(10) NOT NULL,
  `categoryRelId` int(11) NOT NULL,
  `typeRelId` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `content` varchar(200) NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `orderCode` varchar(20) NOT NULL,
  `takeMoney` int(11) NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_poi 结构
DROP TABLE IF EXISTS `my_poi`;
CREATE TABLE IF NOT EXISTS `my_poi` (
  `id` varchar(20) NOT NULL,
  `name` varchar(100) default NULL,
  `pinyin` varchar(50) NOT NULL,
  `poiType` int(11) default NULL,
  `parentId` varchar(20) default NULL,
  `isHot` tinyint(1) default '0',
  `orderIndex` int(11) default NULL,
  `classify` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;




-- 导出  表 hotelcms.my_publish 结构
DROP TABLE IF EXISTS `my_publish`;
CREATE TABLE IF NOT EXISTS `my_publish` (
  `id` int(11) NOT NULL auto_increment,
  `address` varchar(100) NOT NULL,
  `time` varchar(100) NOT NULL,
  `num` varchar(100) NOT NULL,
  `budget` varchar(100) NOT NULL,
  `detailed` text NOT NULL,
  `contacts` varchar(100) NOT NULL,
  `company` varchar(100) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `date` varchar(30) NOT NULL,
  `isdel` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_question 结构
DROP TABLE IF EXISTS `my_question`;
CREATE TABLE IF NOT EXISTS `my_question` (
  `id` int(11) NOT NULL auto_increment,
  `memberId` int(11) NOT NULL,
  `categoryName` varchar(10) NOT NULL,
  `categoryRelId` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `content` varchar(500) NOT NULL,
  `adminId` int(11) default '0',
  `adminReply` varchar(500) default NULL,
  `adminReplyDate` varchar(21) default NULL,
  `viewNum` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_raiders 结构
DROP TABLE IF EXISTS `my_raiders`;
CREATE TABLE IF NOT EXISTS `my_raiders` (
  `id` int(11) NOT NULL auto_increment,
  `areaId` varchar(10) NOT NULL,
  `memberId` int(11) NOT NULL,
  `cityId` varchar(10) NOT NULL,
  `provinceId` varchar(10) NOT NULL,
  `cover` varchar(250) NOT NULL,
  `name` varchar(100) NOT NULL,
  `introduction` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `hotelIds` varchar(500) NOT NULL,
  `scenicIds` varchar(500) NOT NULL,
  `lineIds` varchar(500) NOT NULL,
  `date` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `listTitle` varchar(20) NOT NULL,
  `author` varchar(20) NOT NULL,
  `browse` int(11) NOT NULL,
  `type` int(5) NOT NULL,
  `good` int(11) NOT NULL,
  `title` varchar(250) NOT NULL,
  `keywords` varchar(250) NOT NULL,
  `description` varchar(250) NOT NULL,
  `status` varchar(250) NOT NULL,
  `isdel` int(4) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_raiders_type 结构
DROP TABLE IF EXISTS `my_raiders_type`;
CREATE TABLE IF NOT EXISTS `my_raiders_type` (
  `id` int(4) NOT NULL auto_increment,
  `name` varchar(200) NOT NULL,
  `updateDate` varchar(30) NOT NULL,
  `isshow` varchar(1) NOT NULL,
  `images` varchar(250) NOT NULL,
  `isdel` varchar(1) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_reply 结构
DROP TABLE IF EXISTS `my_reply`;
CREATE TABLE IF NOT EXISTS `my_reply` (
  `id` int(11) NOT NULL auto_increment,
  `questionId` int(11) NOT NULL,
  `memberId` int(11) NOT NULL,
  `content` varchar(500) NOT NULL,
  `agree` int(11) NOT NULL,
  `accusation` tinyint(4) NOT NULL default '0',
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_room 结构
DROP TABLE IF EXISTS `my_room`;
CREATE TABLE IF NOT EXISTS `my_room` (
  `id` int(11) NOT NULL auto_increment,
  `hotelId` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `bed` varchar(50) NOT NULL,
  `canAddBed` varchar(50) NOT NULL,
  `size` int(11) NOT NULL,
  `internet` varchar(50) NOT NULL,
  `breakfast` varchar(50) NOT NULL,
  `remark` text NOT NULL,
  `status` varchar(20) NOT NULL,
  `photo` varchar(200) NOT NULL,
  `stock` int(4) NOT NULL,
  `isdel` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `tr_hotelId` (`hotelId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



-- 导出  表 hotelcms.my_service 结构
DROP TABLE IF EXISTS `my_service`;
CREATE TABLE IF NOT EXISTS `my_service` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `type` int(11) NOT NULL default '1',
  `isdel` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_special_price 结构
DROP TABLE IF EXISTS `my_special_price`;
CREATE TABLE IF NOT EXISTS `my_special_price` (
  `id` int(11) NOT NULL auto_increment,
  `hotelId` int(8) NOT NULL,
  `roomId` int(8) NOT NULL,
  `date` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `price` varchar(10) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_stock 结构
DROP TABLE IF EXISTS `my_stock`;
CREATE TABLE IF NOT EXISTS `my_stock` (
  `id` int(11) NOT NULL auto_increment,
  `hotelId` int(11) NOT NULL,
  `roomId` int(11) NOT NULL,
  `date` varchar(200) NOT NULL,
  `stock` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




-- 导出  表 hotelcms.my_trace 结构
DROP TABLE IF EXISTS `my_trace`;
CREATE TABLE IF NOT EXISTS `my_trace` (
  `id` int(11) NOT NULL auto_increment,
  `relTable` varchar(50) NOT NULL,
  `relId` int(11) NOT NULL,
  `adminId` int(11) NOT NULL,
  `adminName` varchar(50) NOT NULL,
  `adminAccount` varchar(50) NOT NULL,
  `content` varchar(200) NOT NULL,
  `statusRemark` varchar(50) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 导出  表 hotelcms.my_type 结构
DROP TABLE IF EXISTS `my_type`;
CREATE TABLE IF NOT EXISTS `my_type` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(20) NOT NULL,
  `rewrite` varchar(20) NOT NULL,
  `category` varchar(20) NOT NULL,
  `sort` varchar(20) NOT NULL,
  `date` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `isdel` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `my_weixin_config`;
CREATE TABLE `my_weixin_config` (
	`id` INT(1) NOT NULL,
	`apiopen` TINYINT(1) NOT NULL,
	`token` VARCHAR(100) NOT NULL,
	`appid` CHAR(18) NOT NULL,
	`appsecret` CHAR(32) NOT NULL,
	`access_token` CHAR(150) NOT NULL,
	`wap_domain` VARCHAR(100) NOT NULL,
	`site_domain` VARCHAR(100) NOT NULL,
	`regmsg` TEXT NOT NULL,
	`wxpay` TINYINT(1) NOT NULL,
	`first_pic` VARCHAR(50) NOT NULL,
	`default_pic` VARCHAR(50) NOT NULL,
	`dateline` INT(10) UNSIGNED NOT NULL,
	PRIMARY KEY (`id`)
)
COLLATE='utf8_general_ci'
ENGINE=MyISAM;

DROP TABLE IF EXISTS `my_weixin_keywords`;
CREATE TABLE `my_weixin_keywords` (
	`id` INT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
	`name` VARCHAR(100) NOT NULL,
	`keyword` VARCHAR(100) NOT NULL,
	`type` TINYINT(1) UNSIGNED NOT NULL,
	`contents` TEXT NOT NULL,
	`pic` VARCHAR(80) NOT NULL,
	`pic_tit` VARCHAR(80) NOT NULL,
	`desc` TEXT NOT NULL,
	`pic_url` VARCHAR(80) NOT NULL,
	`count` INT(10) UNSIGNED NOT NULL,
	`status` TINYINT(1) UNSIGNED NOT NULL,
	PRIMARY KEY (`id`)
)
COLLATE='utf8_general_ci'
ENGINE=MyISAM;


DROP TABLE IF EXISTS `my_weixin_menu`;
CREATE TABLE `my_weixin_menu` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`parentid` INT(10) UNSIGNED NOT NULL DEFAULT '0',
	`title` VARCHAR(30) NOT NULL,
	`key` VARCHAR(30) NOT NULL,
	`type` VARCHAR(10) NOT NULL,
	`url` VARCHAR(255) NOT NULL,
	`menu_order` SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0',
	`status` TINYINT(1) UNSIGNED NOT NULL,
	PRIMARY KEY (`id`)
)
COLLATE='utf8_general_ci'
ENGINE=MyISAM;

drop table if exists `my_payment_log`;
CREATE TABLE `my_payment_log` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`order_code` VARCHAR(20) NOT NULL,
	`order_type` varchar(2) NOT NULL,
	`pay_type` VARCHAR(10) NOT NULL,
	`pay_status` TINYINT(1) NOT NULL,
	`notify_id` varchar(80) null,
	`seller_email` VARCHAR(100)  null,
	`seller_id` VARCHAR(16)  NULL,
	`buyer_email` VARCHAR(100)  NULL,
	`buyer_id` VARCHAR(16)  NULL,
	`trade_no` VARCHAR(64) NULL,
	`gmt_create` int(10) NULL,
	`gmt_payment` int(10) NULL,
	`gmt_close` int(10) NULL,
	`date` int(10) NOT NULL,
	PRIMARY KEY (`id`),
	INDEX `code` (`order_code`)
)
COLLATE='utf8_general_ci'
ENGINE=MyISAM;

DROP TABLE IF EXISTS `my_line`;
CREATE TABLE IF NOT EXISTS `my_line` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(200) NOT NULL,
  `introduction` varchar(200) NOT NULL,
  `cover` varchar(250) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `lineType` varchar(250) NOT NULL,
  `lineInfo` text NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `minPrice` decimal(10,2) NOT NULL,
  `cityId` varchar(10) NOT NULL,
  `listTitle` varchar(10) NOT NULL,
  `package` text NOT NULL,
  `purchase` text NOT NULL,
  `trip` text NOT NULL,
  `traffic` text NOT NULL,
  `date` datetime NOT NULL,
  `updateData` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `title` varchar(200) NOT NULL,
  `keywords` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `status` varchar(10) NOT NULL,
  `isdel` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `my_scenic`;
CREATE TABLE IF NOT EXISTS `my_scenic` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) NOT NULL,
  `provinceId` varchar(11) NOT NULL default '0',
  `cityId` varchar(11) NOT NULL default '0',
  `areaid` varchar(11) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `scenictype` varchar(200) NOT NULL,
  `suitable` varchar(200) NOT NULL,
  `levelId` int(11) NOT NULL,
  `detail` text NOT NULL,
  `listTitle` varchar(10) NOT NULL,
  `introduction` varchar(200) NOT NULL,
  `address` varchar(100) NOT NULL,
  `status` varchar(10) NOT NULL,
  `date` varchar(200) NOT NULL,
  `cover` int(11) NOT NULL,
  `traffic` text NOT NULL,
  `ticket` text NOT NULL,
  `field` text character set utf8 collate utf8_unicode_ci NOT NULL,
  `landmarkid` int(11) NOT NULL default '0',
  `shopareaid` int(11) NOT NULL default '0',
  `memberId` int(4) NOT NULL default '0',
  `hotelIds` varchar(250) NOT NULL,
  `updateData` varchar(20) NOT NULL,
  `title` varchar(250) NOT NULL,
  `keywords` varchar(250) NOT NULL,
  `description` varchar(250) NOT NULL,
  `isdel` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;