<?php
class param {
	//路由配置
	public $route_config = '';
	public $route_rules = '';
	public function __construct($cfgtype="admin") {
		if(!MAGIC_QUOTES_GPC) {
			$_POST = uaddslashes($_POST);
			$_GET = uaddslashes($_GET);
			$_REQUEST = uaddslashes($_REQUEST);
			$_COOKIE = uaddslashes($_COOKIE);
		}
		$this->route_config = core::load_config('route', $cfgtype);
		$this->init_const();
		return true;
	 }
   //初始化系统常量
	private function  init_const(){
		define('URL_MODEL',0);
        define('URL_ROUTE',false); //路由开启	
		define('IS_CGI',substr(PHP_SAPI, 0,3)=='cgi' ? 1 : 0 );
		// 项目名称
		defined('SITE_ROOT') or define('SITE_ROOT', basename(dirname($_SERVER['SCRIPT_FILENAME'])));	
		if(!defined('_PHP_FILE_')) {
			if(IS_CGI) {
				//CGI/FASTCGI模式下
				$_temp  = explode('.php',$_SERVER['PHP_SELF']);
				define('_PHP_FILE_',    rtrim(str_replace($_SERVER['HTTP_HOST'],'',$_temp[0].'.php'),'/'));
			}else {
				define('_PHP_FILE_',    rtrim($_SERVER['SCRIPT_NAME'],'/'));
			}
		}
		// 当前文件名
		if(!defined('_PHP_FILE_')) {
			if(IS_CGI) {
				//CGI/FASTCGI模式下
				$_temp  = explode('.php',$_SERVER['PHP_SELF']);
				define('_PHP_FILE_',    rtrim(str_replace($_SERVER['HTTP_HOST'],'',$_temp[0].'.php'),'/'));
			}else {
				define('_PHP_FILE_',    rtrim($_SERVER['SCRIPT_NAME'],'/'));
			}
		}
		define('PHP_FILE',_PHP_FILE_);
		define('APP_IN',strip_tags(PHP_FILE));
	}
	
	public function route_g() {
		$g = isset($_GET['g']) && !empty($_GET['g']) ? $_GET['g'] : (isset($_POST['g']) && !empty($_POST['g']) ? $_POST['g'] : '');
		$g = $this->safe_deal($g);
		if (empty($g)) {
			return $this->route_config['g'];
		} else {
			if(is_string($g)) return $g;
		}
	 }
	/**
	 * 获取模型
	 */
	public function route_m() {
		$m = isset($_GET['m']) && !empty($_GET['m']) ? $_GET['m'] : (isset($_POST['m']) && !empty($_POST['m']) ? $_POST['m'] : '');
		$m = $this->safe_deal($m);
		if (empty($m)) {
			return $this->route_config['m'];
		} else {
			if(is_string($m)) return $m;
		}
	}
	/**
	 * 获取控制器
	 */
	public function route_c() {
		$c = isset($_GET['c']) && !empty($_GET['c']) ? $_GET['c'] : (isset($_POST['c']) && !empty($_POST['c']) ? $_POST['c'] : '');
		$c = $this->safe_deal($c);
		if (empty($c)) {
			return $this->route_config['c'];
		} else {
			if(is_string($c)) return $c;
		}
	}
	/**
	 * 获取事件
	 */
	public function route_a() {
		$a = isset($_GET['a']) && !empty($_GET['a']) ? $_GET['a'] : (isset($_POST['a']) && !empty($_POST['a']) ? $_POST['a'] : '');
		$a = $this->safe_deal($a);
		if (empty($a)) {
			return $this->route_config['a'];
		} else {
			if(is_string($a)) return $a;
		}
	}
	/**
	 * 安全处理函数
	 * 处理m,a,c
	 */
	private function safe_deal($str) {
		return str_replace(array('/', '.'), '', $str);
	}

}
?>