<?php
    //判断是否含有中文
	 function is_cnstr($str){
		 if (preg_match("/([\x81-\xfe][\x40-\xfe])/", $str, $match)) {
			 return true;
		 } else {
			return false;
		 }
	 }
 function getsubstr($string, $start = 0, $sublen, $append = true) {
	$pa = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xef][\x80-\xbf][\x80-\xbf]|\xf0[\x90-\xbf][\x80-\xbf][\x80-\xbf]|[\xf1-\xf7][\x80-\xbf][\x80-\xbf][\x80-\xbf]/";
	preg_match_all ( $pa, $string, $t_string );
	if (count ( $t_string [0] ) - $start > $sublen && $append == true) {
		return join ( '', array_slice ( $t_string [0], $start, $sublen ) ) . "...";
	} else {
		return join ( '', array_slice ( $t_string [0], $start, $sublen ) );
	}
}
//字符串截取函数
function strcut($sourcestr,$cutlength,$suffix='...')
{
    $str_length = strlen($sourcestr);
    if($str_length <= $cutlength) {
        return $sourcestr;
    }
    $returnstr='';
    $n = $i = $noc = 0;
    while($n < $str_length) {
        $t = ord($sourcestr[$n]);
        if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
            $i = 1; $n++; $noc++;
        } elseif(194 <= $t && $t <= 223) {
            $i = 2; $n += 2; $noc += 2;
        } elseif(224 <= $t && $t <= 239) {
            $i = 3; $n += 3; $noc += 2;
        } elseif(240 <= $t && $t <= 247) {
            $i = 4; $n += 4; $noc += 2;
        } elseif(248 <= $t && $t <= 251) {
            $i = 5; $n += 5; $noc += 2;
        } elseif($t == 252 || $t == 253) {
            $i = 6; $n += 6; $noc += 2;
        } else {
            $n++;
        }
        if($noc >= $cutlength) {
            break;
        }
    }
    if($noc > $cutlength) {
        $n -= $i;
    }
    $returnstr = substr($sourcestr, 0, $n);
    if ( substr($sourcestr, $n, 6)){
        $returnstr = $returnstr . $suffix;//超过长度时在尾处加上省略号
    }
    return $returnstr;
}

function yysubstr($string, $start = 0, $sublen, $append = true) {
	$pa = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xef][\x80-\xbf][\x80-\xbf]|\xf0[\x90-\xbf][\x80-\xbf][\x80-\xbf]|[\xf1-\xf7][\x80-\xbf][\x80-\xbf][\x80-\xbf]/";
	preg_match_all ( $pa, $string, $t_string );
	return join ( '', array_slice ( $t_string [0], $start, $sublen ) );
}

function is_letternum($string) 
{ 
	if (!preg_match("/^[a-zA-Z][a-zA-Z0-9_]+$/",$string)) 
	{ 
		return false;
	} else{
		return true;
	}
}

// 判断字符串是否是简体
function is_simplified($str)
{
    $len = mb_strlen($str, 'utf-8');

    return ($len != mb_strlen(iconv('UTF-8', 'cp950//IGNORE', $str), 'cp950')) ? true : false;
}
// 判断字符串是否是繁体
function is_traditional($str)
{
    $len = mb_strlen($str, 'utf-8');

    // gbk 包含 big5 内的字符，所以不能用 gbk
    return ($len != mb_strlen(iconv('UTF-8', 'gb2312//IGNORE', $str), 'gb2312')) ? true : false;
}

function is_gbk($str)
{
	$strGbk = iconv("UTF-8", "GBK//IGNORE", $str);
	$strGb2312 = iconv("UTF-8", "GB2312//IGNORE", $str);
	if ($strGbk == $strGb2312) {
		 return true;
	} else {
		 return false;
	}
}

	 function replace_cat($content){
		$content = str_ireplace(',','',$content);
		$content = str_ireplace('、','',$content);
		$content = str_ireplace('，','',$content);
		return $content;
      }

//获取英文首字母
function get_first_letter($content){ 
  $contentarr = explode(" ",$content); 
  foreach($contentarr as $var){ 
    $new_content .= $var{0}; 
  } 
  return strtolower($new_content); 
} 


//根据标题生成栏目目录
function get_catdir($title,$zhuanhuan){ 
    if(!empty($title)){
				   if(is_cnstr($title)){
					   //if(is_traditional($title)) $title=zhconvert::zh_hant_to_zh_hans($title);
					   if(is_traditional($title)) $title=$zhuanhuan->big5_gb2312($title);
					   $catlist[$key]['title']=$title;
					   if(is_traditional($title)) {
						   $ret_catdir=make_rand_letternum(8);
					   }else{
						   $pinyin=pinyin::encode($title);
						   if(strlen($pinyin)>16)$pinyin=pinyin::encode($title,'head');
					       $ret_catdir=$pinyin;
					   }
				     }else{
					   $title=replace_cat($title);
					   if(strlen($title)>16) {
						  $ret_catdir=get_first_letter($title);
					    }else{
						   $ret_catdir=str_ireplace(' ','',$title);
					    }
				   }
			   }else{
		     $ret_catdir=false;
	          }
	   return $ret_catdir;
} 


?>