<?php

if (!defined('IN_HANFOX')) exit('Access Denied');



function smarty_output($template, $cache_id = NULL, $compile_id = NULL) {

	global $smarty, $options;

	

	template_exists($template);

	

	#common

	$options = stripslashes_deep($options);

	$stats = get_stats();

	$labels = stripslashes_deep(get_labels());

	

	#user login

	$auth_cookie = $_COOKIE['auth_cookie'];

	$user_info = check_user_login($auth_cookie);

if (empty($user_info)) {

		$login_status = '<a href="'.$options['site_root'].'member/?mod=login" target="_blank" class="header_baidu">会员登录</a>
	<a href="'.$options['site_root'].'member/?mod=register" target="_blank" class="header_baidu">会员注册</a>';

	} else {

		$login_status = '<font color="#FFF">'.$user_info['nick_name'].'</font>，<a href="'.$options['site_root'].'member/?mod=home" class="header_baidu">我的账户</a> |  <a href="/member/?mod=article&amp;act=add" target="_blank" class="header_baidu">我要投稿</a> | <a href="'.$options['site_root'].'member/?mod=logout" class="header_baidu">安全退出</a>';

	}

	

	$smarty->assign('site_root', $options['site_root']);

	$smarty->assign('site_name', $options['site_name']);
	$smarty->assign('zz_kuaishen', $options['zz_kuaishen']);
	$smarty->assign('zz_haozhan', $options['zz_haozhan']);
	$smarty->assign('zz_zhiding', $options['zz_zhiding']);
	$smarty->assign('zz_qq', $options['zz_qq']);
	$smarty->assign('logo', $options['logo']);
	$smarty->assign('dblogo', $options['dblogo']);

	$smarty->assign('site_url', $options['site_url']);

	$smarty->assign('site_copyright', $options['site_copyright']);

	$smarty->assign('search_words', get_format_tags($options['search_words']));

	

	$smarty->assign('cfg', $options); #options

	$smarty->assign('stat', $stats); #stats

	$smarty->assign('label', $labels); #labels

	$smarty->assign('script_time', get_scripttime()); #script time

	$smarty->assign('login_status', $login_status); #user login

	

	#parse template and output

	$content = $smarty->fetch($template, $cache_id, $compile_id);

	if ($options['link_struct'] != 0) {

		$content = rewrite_output($content);

	}

	echo $content;

	

	#gzip

	$buffer = ob_get_contents();

	ob_end_clean();

	$options['is_enabled_gzip'] == 'yes' ? ob_start('ob_gzhandler') : ob_start();

	

	echo $buffer;

}



function msgbox($msg, $url = 'javascript: history.go(-1);') {

	global $smarty;

	

	$template = 'msgbox.html';

	template_exists($template);

	

	$smarty->assign('msg', $msg);

	$smarty->assign('url', $url);

	echo $smarty->fetch('msgbox.html');

	@ob_end_flush();

	exit();

}



function redirect($url) {

    header('location:'.$url, false, 301);

	exit;

}



function get_scripttime() {

	global $DB, $options, $start_time;

	

	$mtime = explode(' ', microtime());

	$end_time = $mtime[1] + $mtime[0];

	$exec_time = number_format(($end_time - $start_time), 6);

	$gzip = $options['is_enabled_gzip'] == 'yes' ? 'Enabled' : 'Disabled';

	

	return 'Processed in '.$exec_time.' second(s), '.$DB->queries.' Queries, Gzip '.$gzip;

}



function insert_script_time() {

	return get_scripttime();

}



/** rss link */

function get_rssfeed($module = 'webdir', $cate_id = 0) {

	global $options;

	

	return '<a href="?mod=rssfeed&type='.$module.($cate_id > 0 ? '&cid='.$cate_id : '').'" target="_blank"><img src="'.$options['site_root'].'public/images/rss.gif" alt="订阅RssFeed" border="0" /></a>';

}

	

/** site path */

function get_sitepath($module = '', $cate_id = 0) {

	global $options;

	

	if (in_array($module, array('webdir', 'article', 'weblink', 'shop', 'weixin', 'huoyuan'))) {

		$modstr = ' &raquo; ';

		switch ($module) {

			case 'webdir' :

				$modstr .= '<a href="?mod=webdir">网站百科</a>';

				break;
				

			case 'article' :

				$modstr .= '<a href="?mod=article">投稿专栏</a>';

				break;

			case 'weblink' :

				$modstr .= '<a href="?mod=weblink">链接交换</a>';

				break;
			case 'shop' :

				$modstr .= '<a href="?mod=shop">网购导航</a>';

				break;
			case 'weixin' :

				$modstr .= '<a href="?mod=weixin">微信导航</a>';

				break;
			case 'huoyuan' :

				$modstr .= '<a href="?mod=huoyuan">货源大全</a>';

				break;

		}

	}

	

	$strpath = $cate_id;

	

	return $strpath;

}

/** area path */

function get_areapath($module = '', $area_id = 0) {

	global $options;

	

	if (in_array($module, array('area'))) {

		$modstr = ' &raquo; ';

		switch ($module) {

			case 'area' :

				$modstr .= '<a href="?mod=area">地区分类</a>';

				break;
				
         
		

		}

	}

	

	$strpath = '当前位置：<a href="'.$options['site_url'].'">'.$options['site_name'].'</a>'.$modstr.($area_id > 0 ? get_city_path($area_id) : '');

	

	return $strpath;

}



/** cate path */

function get_sitecate($module = '', $cate_id = 0) {

	global $options;

	

	if (in_array($module, array('webdir', 'article', 'weblink', 'shop'))) {

		$modstr = ' ';

		switch ($module) {

			case 'webdir' :

				$modstr .= '<a href="?mod=webdir">网站百科</a>';

				break;

			case 'article' :

				$modstr .= '<a href="?mod=article">投稿专栏</a>';

				break;

			case 'weblink' :

				$modstr .= '<a href="?mod=weblink">链接交换</a>';

				break;
			case 'shop' :

				$modstr .= '<a href="?mod=shop">网上购物</a>';

				break;
				

		}

	}

	

	$strpath = ($cate_id > 0 ? get_category_path($cate_id) : '');

	

	return $strpath;

}
/** area path */

function get_sitearea($module = '', $area_id = 0) {

	global $options;

	

	if (in_array($module, array('area'))) {

		$modstr = ' ';

		switch ($module) {

			case 'area' :

				$modstr .= '<a href="?mod=area">地区分类</a>';

				break;

			

		}

	}

	

	$strpath = ($area_id > 0 ? get_city_path($area_id) : '');

	

	return $strpath;

}


/** format tags */

function get_format_tags($str) {

	$arrstr = !empty($str) && strpos($str, ',') > 0 ? explode(',', $str) : (array) $str;

	$count = count($arrstr);

	

	$newarr = array();

	for ($i = 0; $i < $count; $i++) {

		$tag = trim($arrstr[$i]);

		$newarr[$i]['tag_name'] = $tag;

		$newarr[$i]['tag_link'] = get_search_url('tags', $tag);

	}

	unset($arrstr);

	

	return $newarr;

}
/** wxformat tags */

function get_wxformat_tags($str) {

	$arrstr = !empty($str) && strpos($str, ',') > 0 ? explode(',', $str) : (array) $str;

	$count = count($arrstr);

	

	$newarr = array();

	for ($i = 0; $i < $count; $i++) {

		$tag = trim($arrstr[$i]);

		$newarr[$i]['tag_name'] = $tag;

		$newarr[$i]['tag_link'] = get_wxsearch_url('tags', $tag);

	}

	unset($arrstr);

	

	return $newarr;

}
/** hyformat tags */

function get_hyformat_tags($str) {

	$arrstr = !empty($str) && strpos($str, ',') > 0 ? explode(',', $str) : (array) $str;

	$count = count($arrstr);

	

	$newarr = array();

	for ($i = 0; $i < $count; $i++) {

		$tag = trim($arrstr[$i]);

		$newarr[$i]['tag_name'] = $tag;

		$newarr[$i]['tag_link'] = get_hysearch_url('tags', $tag);

	}

	unset($arrstr);

	

	return $newarr;

}
/** shopformat tags */

function get_shopformat_tags($str) {

	$arrstr = !empty($str) && strpos($str, ',') > 0 ? explode(',', $str) : (array) $str;

	$count = count($arrstr);

	

	$newarr = array();

	for ($i = 0; $i < $count; $i++) {

		$tag = trim($arrstr[$i]);

		$newarr[$i]['tag_name'] = $tag;

		$newarr[$i]['tag_link'] = get_shopsearch_url('tags', $tag);

	}

	unset($arrstr);

	

	return $newarr;

}

?>