<?php
if (!defined('IN_HANFOX')) exit('Access Denied');

require(APP_PATH.'module/category.php');
require(APP_PATH.'module/city.php');
require(APP_PATH.'module/shop.php');

$pageurl = '?mod=shop';
$tplfile = 'shop.html';
$table = $DB->table('shop');

$action = isset($_GET['act']) ? $_GET['act'] : 'list';
$smarty->assign('action', $action); 

if (!$smarty->isCached($tplfile)) {
	/** list */
	if ($action == 'list') {
		$pagename = '商品管理';
		$smarty->assign('site_title', $pagename.' - '.$options['site_name']);
		$smarty->assign('site_path', get_sitepath().' &raquo; '.$pagename);
		
		$pagesize = 10;
		$curpage = intval($_GET['page']);
		if ($curpage > 1) {
			$start = ($curpage - 1) * $pagesize;
		} else {
			$start = 0;
			$curpage = 1;
		}
		
		$where = "w.user_id='".$myself['user_id']."'";
	
		$shop = get_shop_list($where, 'ctime', 'DESC', $start, $pagesize);
		$total = $DB->get_count($table.' w', $where);
		$showpage = showpage($pageurl, $total, $curpage, $pagesize);
		
		$smarty->assign('pagename', $pagename);
		$smarty->assign('shop', $shop);
		$smarty->assign('total', $total);
		$smarty->assign('showpage', $showpage);
	}
	
	/** add */
	if ($action == 'add') {
		$pagename = '商品提交';
		
		#统计当日可提交的站点数量
		/*if ($options['submit_limit'] > 0) {
			$time = time() - (3600 * 12);
			$today_count = $DB->get_count($DB->table('shop'), "shop_ctime>='$time'");
			$submit_limit = $options['submit_limit'] - $today_count;
			$smarty->assign('submit_limit', $submit_limit);
		}*/
		
		$smarty->assign('pagename', $pagename);
		$smarty->assign('site_title', $pagename.' - '.$options['site_name']);
		$smarty->assign('site_path', get_sitepath().' &raquo; '.$pagename);
		$smarty->assign('category_option', get_category_option('shop', 0, 0, 0));	
		$smarty->assign('city_option', get_city_option('area', 0, 0, 0));	
		$smarty->assign('do', 'saveadd');
	}
	
	/** edit */
	if ($action == 'edit') {
		$pagename = '商品编辑';
		
		$shop_id = intval($_GET['wid']);
		$where = "w.user_id='$myself[user_id]' AND w.shop_id='$shop_id'";
		$shop = get_one_shop($where);
		if (!$shop) {
			msgbox('您要修改的内容不存在或无权限！');
		}
		$shop['jian_pic'] = get_webthumb($shop['web_pic'],$shop['shop_id']);
		$row['shop_content'] = str_replace('[upload_dir]', $options['site_root'].$options['upload_dir'].'/', $row['shop_content']);
		$smarty->assign('pagename', $pagename);
		$smarty->assign('site_title', $pagename.' - '.$options['site_title']);
		$smarty->assign('site_path', get_sitepath().' &raquo; '.$pagename);	
		$smarty->assign('category_option', get_category_option('shop', 0, $shop['cate_id'], 0));
		$smarty->assign('city_option', get_city_option('area', 0, $shop['area_id'], 0));
		$smarty->assign('shop', $shop);	
		$smarty->assign('do', 'saveedit');
	}
	
	/** save */
	if (in_array($_POST['do'], array('saveadd', 'saveedit'))) {
		$cate_id = intval($_POST['cate_id']);
		$area_id = intval($_POST['area_id']);
		$shop_name = trim($_POST['shop_name']);
		$shop_url = trim($_POST['shop_url']);
		$shop_tags = trim($_POST['shop_tags']);
		$shop_pic = trim($_POST['shop_pic']);
		$shop_intro = trim($_POST['shop_intro']);
		$shop_content = $_POST['shop_content'];
		$shop_oprice = intval($_POST['shop_oprice']);
		$shop_price = intval($_POST['shop_price']);
		$shop_from = trim($_POST['shop_from']);
		
		$shop_time = time();
		
		if ($cate_id <= 0) {
			msgbox('请选择商品所属分类！');
		} else {
			$cate = get_one_category($cate_id);
			if ($cate['cate_childcount'] > 0) {
				msgbox('指定的分类下有子分类，请选择子分类进行操作！');
			}
		}
		
	
		if (empty($shop_name)) {
			msgbox('请输入商品名称！');
		} else {
			if (!censor_words($options['filter_words'], $shop_name)) {
				msgbox('商品名称中含有非法关键词！');	
			}
		}
		
		if (empty($shop_url)) {
			msgbox('请输入商品域名！');
		} 
		
		
		if (!empty($shop_tags)) {
			if (!censor_words($options['filter_words'], $shop_tags)) {
				msgbox('TAG标签中含有非法关键词！');
			}
			
			$shop_tags = str_replace('，', ',', $shop_tags);
			$shop_tags = str_replace(',,', ',', $shop_tags);
			if (substr($shop_tags, -1) == ',') {
				$shop_tags = substr($shop_tags, 0, strlen($shop_tags) - 1);
			}
		}
			
		if (empty($shop_intro)) {
			msgbox('请输入商品简介！');
		} else {
			if (!censor_words($options['filter_words'], $shop_intro)) {
				msgbox('商品简介中含有非法关键词！');	
			}
		}
		if (empty($shop_content)) {
			msgbox('请输入商品详情！');
		} else {
			if (!censor_words($options['filter_words'], $shop_content)) {
				msgbox('商品详情中含有非法关键词！');	
			}
		}
		
		
		
		
		if ($myself['user_type'] == 'VIP会员') {
		$shop_data = array(
			'cate_id' => $cate_id,
			'area_id' => $area_id,
			'user_id' => $myself['user_id'],
			'shop_pic' => $shop_pic,
			'shop_name' => $shop_name,
			'shop_url' => $shop_url,
			'shop_tags' => $shop_tags,
			'shop_intro' => $shop_intro,
			'shop_content' => $shop_content,
			'shop_oprice' => $shop_oprice,
			'shop_price' => $shop_price,
			'shop_from' => $shop_from,
			
			'shop_status' => 3,
			'shop_ctime' => $shop_time,
		);}elseif ($myself['user_type']  == '管理员') {
		$shop_data = array(
			'cate_id' => $cate_id,
			'area_id' => $area_id,
			'user_id' => $myself['user_id'],
			'shop_pic' => $shop_pic,
			'shop_name' => $shop_name,
			'shop_url' => $shop_url,
			'shop_tags' => $shop_tags,
			'shop_intro' => $shop_intro,
			'shop_content' => $shop_content,
			'shop_oprice' => $shop_oprice,
			'shop_price' => $shop_price,
			'shop_from' => $shop_from,
			'shop_status' => 3,
			'shop_ctime' => $shop_time,
		);
		}elseif ($myself['user_type']  == '快速收录') {
		$shop_data = array(
			'cate_id' => $cate_id,
			'area_id' => $area_id,
			'user_id' => $myself['user_id'],
			'shop_pic' => $shop_pic,
			'shop_name' => $shop_name,
			'shop_url' => $shop_url,
			'shop_tags' => $shop_tags,
			'shop_intro' => $shop_intro,
			'shop_content' => $shop_content,
			'shop_oprice' => $shop_oprice,
			'shop_price' => $shop_price,
			'shop_from' => $shop_from,
			'shop_status' => 2,
			'shop_ctime' => $shop_time,
		);
		}else{
		$shop_data = array(
			'cate_id' => $cate_id,
			'area_id' => $area_id,
			'user_id' => $myself['user_id'],
			'shop_pic' => $shop_pic,
			'shop_name' => $shop_name,
			'shop_url' => $shop_url,
			'shop_tags' => $shop_tags,
			'shop_intro' => $shop_intro,
			'shop_content' => $shop_content,
			'shop_oprice' => $shop_oprice,
			'shop_price' => $shop_price,
			'shop_from' => $shop_from,
			'shop_status' => 2,
			'shop_ctime' => $shop_time,
		);
		}
		
		if ($_POST['do'] == 'saveadd') {
    		$query = $DB->query("SELECT shop_id FROM $table WHERE shop_url='$shop_url'");
    		if ($DB->num_rows($query)) {
        		msgbox('您所提交的商品已存在！');
    		}
			$DB->insert($table, $shop_data);
			$insert_id = $DB->insert_id();
		
			msgbox('商品提交成功！', '?mod=pay');	
		} elseif ($_POST['do'] == 'saveedit') {
			$shop_id = intval($_POST['shop_id']);
			$where = array('shop_id' => $shop_id);
			$DB->update($table, $shop_data, $where);
			
			
			msgbox('商品编辑成功！', '?mod=pay');
		}
	}
}

smarty_output($tplfile);
?>