<?php
if (!defined('IN_HANFOX')) exit('Access Denied');

require(APP_PATH.'module/category.php');
require(APP_PATH.'module/city.php');
require(APP_PATH.'module/weixin.php');

$pageurl = '?mod=weixin';
$tplfile = 'weixin.html';
$table = $DB->table('wx');

$action = isset($_GET['act']) ? $_GET['act'] : 'list';
$smarty->assign('action', $action); 

if (!$smarty->isCached($tplfile)) {
	/** list */
	if ($action == 'list') {
		$pagename = '微信管理';
		$smarty->assign('site_title', $pagename.' - '.$options['site_name']);
		$smarty->assign('site_path', get_sitepath().' &raquo; '.$pagename);
		
		$pagesize = 10;
		$curpage = intval($_GET['page']);
		if ($curpage > 1) {
			$start = ($curpage - 1) * $pagesize;
		} else {
			$start = 0;
			$curpage = 1;
		}
		
		$where = "w.user_id='".$myself['user_id']."'";
	
		$weixin = get_weixin_list($where, 'ctime', 'DESC', $start, $pagesize);
		$total = $DB->get_count($table.' w', $where);
		$showpage = showpage($pageurl, $total, $curpage, $pagesize);
		
		$smarty->assign('pagename', $pagename);
		$smarty->assign('weixin', $weixin);
		$smarty->assign('total', $total);
		$smarty->assign('showpage', $showpage);
	}
	
	/** add */
	if ($action == 'add') {
		$pagename = '微信提交';
		
		#统计当日可提交的站点数量
		/*if ($options['submit_limit'] > 0) {
			$time = time() - (3600 * 12);
			$today_count = $DB->get_count($DB->table('weixin'), "wx_ctime>='$time'");
			$submit_limit = $options['submit_limit'] - $today_count;
			$smarty->assign('submit_limit', $submit_limit);
		}*/
		
		$smarty->assign('pagename', $pagename);
		$smarty->assign('site_title', $pagename.' - '.$options['site_name']);
		$smarty->assign('site_path', get_sitepath().' &raquo; '.$pagename);
		$smarty->assign('category_option', get_category_option('weixin', 0, 0, 0));	
		$smarty->assign('city_option', get_city_option('area', 0, 0, 0));	
		$smarty->assign('do', 'saveadd');
	}
	
	/** edit */
	if ($action == 'edit') {
		$pagename = '微信编辑';
		
		$wx_id = intval($_GET['wid']);
		$where = "w.user_id='$myself[user_id]' AND w.wx_id='$wx_id'";
		$weixin = get_one_weixin($where);
		if (!$weixin) {
			msgbox('您要修改的内容不存在或无权限！');
		}
		$wx['jian_pic'] = get_webthumb($wx['web_pic'],$wx['wx_id']);
		$row['wx_content'] = str_replace('[upload_dir]', $options['site_root'].$options['upload_dir'].'/', $row['wx_content']);
		$smarty->assign('pagename', $pagename);
		$smarty->assign('site_title', $pagename.' - '.$options['site_title']);
		$smarty->assign('site_path', get_sitepath().' &raquo; '.$pagename);	
		$smarty->assign('category_option', get_category_option('weixin', 0, $weixin['cate_id'], 0));
		$smarty->assign('city_option', get_city_option('area', 0, $weixin['area_id'], 0));
		$smarty->assign('weixin', $weixin);	
		$smarty->assign('do', 'saveedit');
	}
	
	/** save */
	if (in_array($_POST['do'], array('saveadd', 'saveedit'))) {
		$cate_id = intval($_POST['cate_id']);
	$area_id = intval($_POST['area_id']);
	$wx_name = trim($_POST['wx_name']);
	$wx_lei = intval($_POST['wx_lei']);
	$wx_tags = strtolower(addslashes(trim($_POST['wx_tags'])));
	$wx_ma = trim($_POST['wx_ma']);
	$wx_intro = addslashes(trim($_POST['wx_intro']));
	$wx_content = $_POST['wx_content'];
	$wx_hao = trim($_POST['wx_hao']);
	$wx_yuan = trim($_POST['wx_yuan']);
	$wx_wang = trim($_POST['wx_wang']);
	$wx_weibo = trim($_POST['wx_weibo']);
		
		$wx_time = time();
		
		
	
		if (empty($wx_name)) {
			msgbox('请输入微信名称！');
		} else {
			if (!censor_words($options['filter_words'], $wx_name)) {
				msgbox('微信名称中含有非法关键词！');	
			}
		}
		
	
		
		if (!empty($wx_tags)) {
			if (!censor_words($options['filter_words'], $wx_tags)) {
				msgbox('TAG标签中含有非法关键词！');
			}
			
			$wx_tags = str_replace('，', ',', $wx_tags);
			$wx_tags = str_replace(',,', ',', $wx_tags);
			if (substr($wx_tags, -1) == ',') {
				$wx_tags = substr($wx_tags, 0, strlen($wx_tags) - 1);
			}
		}
			
		if (empty($wx_intro)) {
			msgbox('请输入微信简介！');
		} else {
			if (!censor_words($options['filter_words'], $wx_intro)) {
				msgbox('微信简介中含有非法关键词！');	
			}
		}
		if (empty($wx_content)) {
			msgbox('请输入微信详情！');
		} else {
			if (!censor_words($options['filter_words'], $wx_content)) {
				msgbox('微信详情中含有非法关键词！');	
			}
		}
		
		
		
		
		if ($myself['user_type'] == 'VIP会员') {
		$wx_data = array(
			'cate_id' => $cate_id,
		'area_id' => $area_id,
		'user_id' => $myself['user_id'],
		'wx_name' => $wx_name,
		'wx_lei' => $wx_lei,
		'wx_tags' => $wx_tags,
		'wx_ma' => $wx_ma,
		'wx_intro' => $wx_intro,
		'wx_content' => $wx_content,
		'wx_hao' => $wx_hao,
		'wx_yuan' => $wx_yuan,
		'wx_wang' => $wx_wang,
		'wx_weibo' => $wx_weibo,
			
			'wx_status' => 3,
			'wx_ctime' => $wx_time,
		);}elseif ($myself['user_type']  == '管理员') {
		$wx_data = array(
			'cate_id' => $cate_id,
		'area_id' => $area_id,
		'user_id' => $myself['user_id'],
		'wx_name' => $wx_name,
		'wx_lei' => $wx_lei,
		'wx_tags' => $wx_tags,
		'wx_ma' => $wx_ma,
		'wx_intro' => $wx_intro,
		'wx_content' => $wx_content,
		'wx_hao' => $wx_hao,
		'wx_yuan' => $wx_yuan,
		'wx_wang' => $wx_wang,
		'wx_weibo' => $wx_weibo,
			'wx_status' => 3,
			'wx_ctime' => $wx_time,
		);
		}elseif ($myself['user_type']  == '快速收录') {
		$wx_data = array(
			'cate_id' => $cate_id,
		'area_id' => $area_id,
		'user_id' => $myself['user_id'],
		'wx_name' => $wx_name,
		'wx_lei' => $wx_lei,
		'wx_tags' => $wx_tags,
		'wx_ma' => $wx_ma,
		'wx_intro' => $wx_intro,
		'wx_content' => $wx_content,
		'wx_hao' => $wx_hao,
		'wx_yuan' => $wx_yuan,
		'wx_wang' => $wx_wang,
		'wx_weibo' => $wx_weibo,
			'wx_status' => 2,
			'wx_ctime' => $wx_time,
		);
		}else{
		$wx_data = array(
			'cate_id' => $cate_id,
		'area_id' => $area_id,
		'user_id' => $myself['user_id'],
		'wx_name' => $wx_name,
		'wx_lei' => $wx_lei,
		'wx_tags' => $wx_tags,
		'wx_ma' => $wx_ma,
		'wx_intro' => $wx_intro,
		'wx_content' => $wx_content,
		'wx_hao' => $wx_hao,
		'wx_yuan' => $wx_yuan,
		'wx_wang' => $wx_wang,
		'wx_weibo' => $wx_weibo,
			'wx_status' => 2,
			'wx_ctime' => $wx_time,
		);
		}
		
		if ($_POST['do'] == 'saveadd') {
    		$query = $DB->query("SELECT wx_id FROM $table WHERE wx_hao='$wx_hao'");
    		if ($DB->num_rows($query)) {
        		msgbox('您所提交的微信已存在！');
    		}
			$DB->insert($table, $wx_data);
			$insert_id = $DB->insert_id();
		
			msgbox('微信提交成功！', '?mod=pay');	
		} elseif ($_POST['do'] == 'saveedit') {
			$wx_id = intval($_POST['wx_id']);
			$where = array('wx_id' => $wx_id);
			$DB->update($table, $wx_data, $where);
			
			
			msgbox('微信编辑成功！', '?mod=pay');
		}
	}
}

smarty_output($tplfile);
?>