<?php

/** city path */

function get_city_path($area_id = 0, $separator = ' &raquo; ') {

	global $DB;

	

	$area = get_one_city($area_id);

	if (!isset($area)) return '';

	

	$sql = "SELECT area_id, area_mod, area_name FROM ".$DB->table('areas')." WHERE area_id IN (".$area_id.','.$area['area_arrparentid'].")";

	$areas = $DB->fetch_all($sql);

	foreach ($areas as $row) {

		$strpath .= $separator.'<a href="'.get_city_url($row['area_mod'], $row['area_id']).'">'.$row['area_name'].'</a>';

	}

	unset($area, $areas);

	

	return $strpath;

}

	

/** city option */

function get_city_option($area_mod = 'area', $root_id = 0, $area_id = 0, $level_id = 0) {

	global $DB;

	

	if (!in_array($area_mod, array('area', 'article', 'weixin', 'huoyuan', 'shop'))) $area_mod = 'area';

	$where = "root_id=$root_id AND area_mod='$area_mod'";

	$sql = "SELECT area_id, area_name FROM ".$DB->table('areas')." WHERE $where ORDER BY area_order ASC, area_id ASC";

	$results = $DB->fetch_all($sql);

	$optstr = '';

	foreach ($results as $row) {

		$optstr .= '<option value="'.$row['area_id'].'"';

		if ($area_id > 0 && $area_id == $row['area_id']) $optstr .= ' selected';

		

		if ($level_id == 0) {

			$optstr .= ' style="background: #EEF3F7;">';

			$optstr .= '├'.$row['area_name'];

		} else {

			$optstr .= '>';

			for ($i = 2; $i <= $level_id; $i++) {

				$optstr .= '│&nbsp;&nbsp;';

			}

			$optstr .= '│&nbsp;&nbsp;├'.$row['area_name'];

		}

		$optstr .= '</option>';

		$optstr .= get_city_option($area_mod, $row['area_id'], $area_id, $level_id + 1);

	}

	unset($results);

		

	return $optstr;

}



/** areas */

function get_areas($area_id = 0, $top_num = 0) {

	global $DB;

	

	$sql = "SELECT area_id, area_mod, area_name, area_childcount, area_postcount FROM ".$DB->table('areas')." WHERE root_id=$area_id ORDER BY area_order ASC, area_id ASC";

	if ($top_num > 0) $sql .= " LIMIT $top_num";

	$results = $DB->fetch_all($sql);

	$areas = array();

	foreach ($results as $row) {

		$row['area_link'] = get_city_url($row['area_mod'], $row['area_id']);

		$areas[] = $row;

	}

	unset($results);

	

	return $areas;

}



/** best areas */

function get_best_areas($top_num = 0) {

	global $DB;

	

	$sql = "SELECT area_id, area_mod, area_name, area_childcount, area_postcount FROM ".$DB->table('areas')." WHERE area_isbest=1 ORDER BY area_order ASC, area_id ASC";

	if ($top_num > 0) $sql .= " LIMIT $top_num";

	$results = $DB->fetch_all($sql);

	$areas = array();

	foreach ($results as $row) {

		$row['area_link'] = get_city_url($row['area_mod'], $row['area_id']);

		$areas[] = $row;

	}

	unset($results);

	

	return $areas;

}



/** all city */

function get_all_city() {

	global $DB;

	

	$results = load_cache('areas') ? load_cache('areas') : $DB->fetch_all("SELECT area_id, root_id, area_mod, area_name, area_dir, area_arrparentid, area_arrchildid, area_childcount, area_postcount FROM ".$DB->table('areas')." ORDER BY area_order ASC, area_id ASC");

		

	$areas = array();

	foreach ($results as $row) {

		$row['area_link'] = get_city_url($row['area_mod'], $row['area_id']);

		$areas[$row['area_id']] = $row;

	}

	unset($results);

	

	return $areas;

}



/** one city */

function get_one_city($area_id = 0) {

	global $DB;

	

	$row = load_cache('city_'.$area_id) ? load_cache('city_'.$area_id) : $DB->fetch_one("SELECT area_id, root_id, area_mod, area_name, area_dir, area_arrparentid, area_arrchildid, area_childcount, area_postcount FROM ".$DB->table('areas')." WHERE area_id=$area_id LIMIT 1");

		

	return $row;

}

	

/** city name */

function get_city_name($area_id) {

	$city = get_one_city($area_id);

	return $city['area_name'];

}

	

/** city count */

function get_city_count($area_id = 0) {

	global $DB;

	

	if ($area_id > 0) $where = array('root_id' => $area_id);

	$count = $DB->get_count($DB->table('areas'), $where);

		

	return $count;

}

	

/** city parent ids */

function get_city_parent_ids($area_id) {

	global $DB;

	

	$sql = "SELECT root_id FROM ".$DB->table('areas')." WHERE area_id=$area_id";

	$results = $DB->fetch_all($sql);		

	$idstr = '';

	foreach ($results as $row) {

		if ($row['root_id'] > 0) {

			$idstr .= get_city_parent_ids($row['root_id']);

			$idstr .= ','.$row['root_id'];

		} else {

			$idstr = '0';

		}

	}

	unset($results);

		

	return $idstr;

}



/** city child ids */

function get_city_child_ids($area_id) {

	global $DB;

	

	$sql = "SELECT area_id FROM ".$DB->table('areas')." WHERE root_id=$area_id";

	$results = $DB->fetch_all($sql);	

	$idstr = '';

	foreach ($results as $row) {

		$idstr .= ','.$row['area_id'];

		$idstr .= get_city_child_ids($row['area_id']);

	}

	unset($results);

	

	return $idstr;

}



/** city model option */

function get_city_model_option($model = 'website') {

	global $city_modules;

	

	foreach ($city_modules as $key => $val) {

		$optstr .= '<option value="'.$key.'"';

		if (!empty($model) && $model == $key) $optstr .= ' selected';

		$optstr .= '>'.$val.'</option>';

	}

	unset($city_modules);

		

	return $optstr;

}

?>