<?php

require('common.php');

require(APP_PATH.'module/city.php');



$fileurl = 'city.php';

$tempfile = 'city.html';

$table = $DB->table('areas');



$root_id = intval($_GET['root_id']);

$area_mod = !empty($_GET['mod']) ? $_GET['mod'] : 'area';

$smarty->assign('root_id', $root_id);

$smarty->assign('area_mod', $area_mod);



if (!isset($action)) $action = 'list';



/** list */

if ($action == 'list') {

	$pagetitle = '地区列表';

	

	$sql = "SELECT * FROM $table WHERE root_id=$root_id AND area_mod='$area_mod' ORDER BY area_order ASC";

	$query = $DB->query($sql);

	$areas = array();

	while ($row = $DB->fetch_array($query)) {

		$row['area_mod'] = $city_modules[$row['area_mod']];

		$area_attr = empty($row['area_url']) ? '<span class="gre">内部</span>' : '<span class="red">外部</span>';

		$area_attr .= $row['area_isbest'] != 0 ? ' - <span class="gre">推荐</span>' : '';

		$row['area_attr'] = $area_attr;

		$row['area_operate'] = '<a href="'.$fileurl.'?mod='.$area_mod.'&act=edit&area_id='.$row['area_id'].'">编辑</a>&nbsp;|&nbsp;<a href="'.$fileurl.'?mod='.$area_mod.'&act=clear&area_id='.$row['area_id'].'" onClick="return confirm(\'注：该操作将清空此地区及其子地区下的内容！\n\n确定清空吗？\');">清空</a>&nbsp;|&nbsp;<a href="'.$fileurl.'?mod='.$area_mod.'&act=del&area_id='.$row['area_id'].'" onClick="return confirm(\'注：该操作将同时删除此地区下的子地区及相关内容！\n\n确定删除吗？\');">删除</a>&nbsp;|&nbsp;<a href="'.$fileurl.'?mod='.$area_mod.'&root_id='.$row['area_id'].'">进入子类</a>&nbsp;|&nbsp;<a href="'.$fileurl.'?mod='.$area_mod.'&act=add&root_id='.$row['area_id'].'">添加子类</a>';

		$areas[] = $row;

	}

	unset($row);

	$DB->free_result($query);

	

	$smarty->assign('area_mod', $area_mod);

	$smarty->assign('areas', $areas);

	unset($areas);

}



/** add */

if ($action == 'add') {

	$pagetitle = '添加地区';

	

	$smarty->assign('city_option', get_city_option($area_mod, 0, $root_id, 0));

	$smarty->assign('h_action', 'saveadd');

}



/** edit */

if ($action == 'edit') {

	$pagetitle = '编辑地区';

	

	$area_id = intval($_GET['area_id']);

	$row = get_one_city($area_id);;

	if (!$row) {

		msgbox('指定的内容不存在！');

	}

	

	$smarty->assign('city_option', get_city_option($row['area_mod'], 0, $row['root_id'], 0));

	$smarty->assign('row', $row);

	$smarty->assign('h_action', 'saveedit');

}



/** reset */

if ($action == 'reset') {

	$pagetitle = '复位地区';

	

	$smarty->assign('h_action', 'savereset');

}



/** merge */

if ($action == 'merge') {

	$pagetitle = '合并地区';

	$city_option = get_city_option($area_mod, 0, 0, 0);

	

	$smarty->assign('city_option', $city_option);

	$smarty->assign('h_action', 'saveunite');

}



/** save data */

if (in_array($action, array('saveadd', 'saveedit'))) {

	$root_id = intval(trim($_POST['root_id']));

	$area_mod = trim($_POST['area_mod']);

	$area_name = trim($_POST['area_name']);

	$area_dir = trim($_POST['area_dir']);

	$area_url = trim($_POST['area_url']);

	$area_isbest = intval($_POST['area_isbest']);

	$area_order = intval($_POST['area_order']);

	$area_keywords = trim($_POST['area_keywords']);

	$area_description = trim($_POST['area_description']);

	

	if (empty($area_mod)) $area_mod = 'area';



	if (empty($area_name)) {

		msgbox('请输入地区名称！');

	}

	

	if (!empty($area_dir)) {

		if (!is_valid_dir($area_dir)) {

			msgbox('目录名称只能是英文字母开头，数字，中划线，下划线组成！');

		}

	}

	

	$data = array(

		'root_id' => $root_id,

		'area_mod' => $area_mod,

		'area_name' => $area_name,

		'area_dir' => $area_dir,

		'area_url' => $area_url,

		'area_isbest' => $area_isbest,

		'area_order' => $area_order,

		'area_keywords' => $area_keywords,

		'area_description' => $area_description,

	);

	

	if ($action == 'saveadd') {

    	$query = $DB->query("SELECT area_id FROM $table WHERE root_id='$root_id' AND area_name='$area_name'");

    	if ($DB->num_rows($query)) {

        	msgbox('您所添加的地区已存在！');

    	}

		$DB->insert($table, $data);

		update_areas();

		update_cache('areas');

		

		$fileurl = empty($root_id) ? $fileurl .= '?mod='.$area_mod : $fileurl .= '?mod='.$area_mod.'&root_id='.$root_id;

		redirect($fileurl);

	} elseif ($action == 'saveedit') {

		$area_id = intval($_POST['area_id']);

		$where = array('area_id' => $area_id);

		

		$DB->update($table, $data, $where);

		update_areas();

		update_cache('areas');

		

		$fileurl = empty($root_id) ? $fileurl .= '?mod='.$area_mod : $fileurl .= '?mod='.$area_mod.'&root_id='.$root_id;

		redirect($fileurl);

	}

}



/** del */

if ($action == 'del') {

	$area_id = intval($_GET['area_id']);

	

	$sql = "SELECT area_arrchildid FROM $table WHERE area_mod='$area_mod' AND area_id=$area_id";

	$area = $DB->fetch_one($sql);

	if (!$area) {

		msgbox('指定的地区不存在！');

	} else {

		$child_area = $area['area_arrchildid'];

	}

	

	$DB->delete($table, 'area_id IN ('.$child_area.')');

	$DB->delete($DB->table('websites'), 'area_id IN ('.$child_area.')');

	$DB->delete($DB->table('articles'), 'area_id IN ('.$child_area.')');

	update_areas();

	update_cache('areas');

	

	msgbox('地区删除成功！', $fileurl.'?mod='.$area_mod);

}



/** clear */

if ($action == 'clear') {

	$area_id = intval($_GET['area_id']);

	

	$sql = "SELECT area_arrchildid FROM $table WHERE area_mod='$area_mod' AND area_id=$area_id";

	$area = $DB->fetch_one($sql);

	if (!$area) {

		msgbox('指定的地区不存在！');

	} else {

		$child_area = $area['area_arrchildid'];

	}

	

	if ($area_mod == 'area') {

		$DB->delete($DB->table('websites'), 'area_id IN ('.$child_area.')');

	} else {

		$DB->delete($DB->table('articles'), 'area_id IN ('.$child_area.')');

	}

	update_areas();

	

	msgbox('指定地区下的内容已清空！', $fileurl.'?mod='.$area_mod);

}



/** reset */

if ($action == 'savereset') {

	$area_mod = trim($_POST['area_mod']);

	$DB->update($table, array('root_id' => 0), array('area_mod' => $area_mod));

	update_areas();

	update_cache('areas');

	

	msgbox('地区复位成功，请重新对地区进行归属设置！', $fileurl);

}



/** unite */

if ($action == 'saveunite') {

	$source_id = (int) $_POST['source_id'];

	$target_id = (int) $_POST['target_id'];

	$area_mod = trim($_POST['area_mod']);

	

	if (empty($source_id)) {

		msgbox('请选择要合并的地区！');

	}

	

	if (empty($target_id)) {

		msgbox('请选择目标地区！');

	}

	

	if ($source_id == $target_id) {

		msgbox('请不要在相同的地区内操作！');

	}

	

	$sql = "SELECT area_childcount FROM $table WHERE area_mod='$area_mod' AND area_id=$target_id";

	$area = $DB->fetch_one($sql);

	if (!$area) {

		msgbox('指定的目标地区不存在！');

	} else {

		$target_child_count = $area['area_childcount'];

	}

	

	if ($target_child_count > 0) {

		msgbox('目标地区中含有子地区，不能进行操作！');

	}

	

	$DB->delete($table, array('area_id' => $source_id, 'area_mod' => $area_mod));

	if ($area_mod == 'area') {

		$DB->update($DB->table('websites'), array('area_id' => $target_id), array('area_id' => $source_id));

	} else {

		$DB->update($DB->table('articles'), array('area_id' => $target_id), array('area_id' => $source_id));

	}

	update_areas();

	update_cache('areas');

	

	msgbox('地区合并成功，且内容已转移到目标地区中！', $fileurl);

}



function update_areas() {

	global $DB, $table, $city;

	

	$sql = "SELECT area_id, area_mod FROM $table ORDER BY area_id ASC";

	$area_ids = $DB->fetch_all($sql);

	

	foreach ($area_ids as $id) {

		$parent_id = get_city_parent_ids($id['area_id']);

		$child_id = $id['area_id'].get_city_child_ids($id['area_id']);

		$child_count = get_city_count($id['area_id']);

		if ($id['area_mod'] == 'area') {

			$post_count = $DB->get_count($DB->table('websites'), 'area_id IN ('.$child_id.')');

		} else {

			$post_count = $DB->get_count($DB->table('articles'), 'area_id IN ('.$child_id.')');

		}

		

		$data = array(

			'area_arrparentid' => $parent_id,

			'area_arrchildid' => $child_id,

			'area_childcount' => $child_count,

			'area_postcount' => $post_count,

		);

		$where = array('area_id' => $id['area_id']);

		

		$DB->update($table, $data, $where);

	}

}



smarty_output($tempfile);

?>