<?php
require('common.php');
require(APP_PATH.'module/category.php');
require(APP_PATH.'module/city.php');
require(APP_PATH.'module/huoyuan.php');

$fileurl = 'huoyuan.php';
$tempfile = 'huoyuan.html';
$table = $DB->table('huoyuan');

if (!isset($action)) $action = 'list';

/** list */
if ($action == 'list') {
	$pagetitle = '货源列表';
	
	$status = intval(trim($_GET['status']));
	$cate_id = intval(trim($_GET['cate_id']));
	$sort = intval(trim($_GET['sort']));
	$order = strtoupper(trim($_GET['order']));
	$keywords = addslashes(trim($_POST['keywords'] ? $_POST['keywords'] : $_GET['keywords']));
	if (empty($order)) $order = 'DESC';
	
	$pageurl = $fileurl.'?status='.$status.'&cate_id='.$cate_id.'&sort='.$sort.'&order='.$order;
	$keyurl = !empty($keywords) ? '&keywords='.urlencode($keywords) : '';
	$pageurl .= $keyurl;
	
	$category_option = get_category_option('huoyuan', 0, $cate_id, 0);
	
	$smarty->assign('status', $status);
	$smarty->assign('cate_id', $cate_id);
	$smarty->assign('sort', $sort);
	$smarty->assign('order', $order);
	$smarty->assign('keywords', $keywords);
	$smarty->assign('keyurl', $keyurl);
	$smarty->assign('category_option', $category_option);
	
	$where = '';
	$sql = "SELECT a.huoyuan_id, a.cate_id, a.area_id, a.user_id, a.huoyuan_name, a.huoyuan_weixin, a.huoyuan_qq, a.huoyuan_tel, a.huoyuan_daifa, a.huoyuan_tags, a.huoyuan_intro, a.huoyuan_content, a.huoyuan_pic, a.huoyuan_wxpic, a.huoyuan_ispay, a.huoyuan_isbest, a.huoyuan_istop, a.huoyuan_status, a.huoyuan_ctime FROM $table a  WHERE";
	switch ($status) {
		case 1 :
			$where .= " a.huoyuan_status=1";
			break;
		case 2 :
			$where .= " a.huoyuan_status=2";
			break;
		case 3 :
			$where .= " a.huoyuan_status=3";
			break;
		default :
			$where .= " a.huoyuan_status>-1";
			break;
	}
	
	if ($cate_id > 0) {
		$cate = get_one_category($cate_id);
		$where .= " AND a.cate_id IN (".$cate['cate_arrchildid'].")";
	}
	
	if ($keywords) $where .= " AND a.huoyuan_name like '%$keywords%'";
	
	switch ($sort) {
		case 1 :
			$field = "a.huoyuan_ctime";
			break;
		
		case 8 :
			$field = "b.huoyuan_views";
			break;
		
		default :
			$field = "a.huoyuan_ctime";
			break;
	}
	
	$sql .= $where." ORDER BY a.huoyuan_istop DESC, $field $order LIMIT $start, $pagesize";
	$query = $DB->query($sql);
	
	$huoyuan = array();
	while ($web = $DB->fetch_array($query)) {
		switch ($web['huoyuan_status']) {
			case 1 :
				$huoyuan_status = '<font color="#333333">黑名单</font>';
				break;
			case 2 :
				$huoyuan_status = '<font color="#ff3300">待审核</font>';
				break;
			case 3 :
				$huoyuan_status = '<font color="#008800">已审核</font>';
				break;
		}
		$huoyuan_ispay = $web['huoyuan_ispay'] > 0 ? '<font color="#ff0000">付费</font>' : '<font color="#cccccc">付费</font>';
		$huoyuan_istop = $web['huoyuan_istop'] > 0 ? '<font color="#ff0000">置顶</font>' : '<font color="#cccccc">置顶</font>';
		$huoyuan_isbest = $web['huoyuan_isbest'] > 0 ? '<font color="#ff0000">推荐</font>' : '<font color="#cccccc">推荐</font>';
		$huoyuan_daifa = $web['huoyuan_daifa'] > 0 ? '<font color="#ff0000">代发</font>' : '<font color="#cccccc">代发</font>';
		$web['huoyuan_attr'] = $huoyuan_ispay.' - '.$huoyuan_istop.' - '.$huoyuan_isbest.' - '.$huoyuan_status.' - '.$huoyuan_islink;
		
		$web['huoyuan_cate'] = '<a href="'.$fileurl.'?cate_id='.$web['cate_id'].'">'.get_category_name($web['cate_id']).'</a>';
		$web['huoyuan_name'] = '<a href="'.$web['huoyuan_url'].'" target="_blank">'.$web['huoyuan_name'].'</a> '.($web['huoyuan_errors'] > 0 ? '<sup style="color: #f00;">error!</sup>' : '');
		
		$web['huoyuan_ctime'] = date('Y-m-d', $web['huoyuan_ctime']);
		$web['huoyuan_operate'] = '<a href="'.$fileurl.'?act=edit&huoyuan_id='.$web['huoyuan_id'].'">编辑</a>&nbsp;|&nbsp;<a href="'.$fileurl.'?act=del&huoyuan_id='.$web['huoyuan_id'].'" onClick="return confirm(\'确认删除此内容吗？\');">删除</a>';
		$huoyuan[] = $web;
	}
	unset($web);
	$DB->free_result($query);
	
	$total = $DB->get_count($table.' a', $where);
	$showpage = showpage($pageurl, $total, $curpage, $pagesize);
	
	$smarty->assign('huoyuan', $huoyuan);
	$smarty->assign('showpage', $showpage);
	unset($huoyuan);
}

/** add */
if ($action == 'add') {
	$pagetitle = '添加货源';

	$cate_id = intval($_GET['cate_id']);
	$area_id = intval($_GET['area_id']);
	$category_option = get_category_option('huoyuan', 0, $cate_id, 0);
	$city_option = get_city_option('city', 0, $area_id, 0);
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('city_option', $city_option);
	$smarty->assign('status', 3);
	$smarty->assign('h_action', 'saveadd');
}

/** edit */
if ($action == 'edit') {
	$pagetitle = '编辑货源';
	
	$huoyuan_id = intval($_GET['huoyuan_id']);
	
	$where = "w.huoyuan_id=$huoyuan_id";
	$row = get_one_huoyuan($where);
	if (!$row) {
		msgbox('指定的内容不存在！');
	}
	$category_option = get_category_option('huoyuan', 0, $row['cate_id'], 0);
	$city_option = get_city_option('area', 0, $row['area_id'], 0);
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('city_option', $city_option);
	$smarty->assign('ispay', $row['huoyuan_ispay']);
	$smarty->assign('istop', $row['huoyuan_istop']);
	$smarty->assign('isbest', $row['huoyuan_isbest']);
	$smarty->assign('status', $row['huoyuan_status']);
	$smarty->assign('row', $row);
	$smarty->assign('h_action', 'saveedit');
}

/** move */
if ($action == 'move') {
	$pagetitle = '移动货源';
			
	$huoyuan_ids = (array) ($_POST['huoyuan_id'] ? $_POST['huoyuan_id'] : $_GET['huoyuan_id']);
	if (empty($huoyuan_ids)) {
		msgbox('请选择要移动的货源！');
	} else {
		$wids = dimplode($huoyuan_ids);
	}
	
	$category_option = get_category_option('huoyuan', 0, 0, 0);
	$huoyuan = $DB->fetch_all("SELECT huoyuan_id, huoyuan_name FROM $table WHERE huoyuan_id IN ($wids)");
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('huoyuan', $huoyuan);
	$smarty->assign('h_action', 'savemove');
}
/** moarea */
if ($action == 'moarea') {
	$pagetitle = '更改地区';
			
	$huoyuan_ids = (array) ($_POST['huoyuan_id'] ? $_POST['huoyuan_id'] : $_GET['huoyuan_id']);
	if (empty($huoyuan_ids)) {
		msgbox('请选择要更改的货源！');
	} else {
		$wids = dimplode($huoyuan_ids);
	}
	
	$city_option = get_city_option('area', 0, 0, 0);
	$huoyuan = $DB->fetch_all("SELECT huoyuan_id, huoyuan_name FROM $table WHERE huoyuan_id IN ($wids)");
	
	$smarty->assign('city_option', $city_option);
	$smarty->assign('huoyuan', $huoyuan);
	$smarty->assign('h_action', 'savemoarea');
}
/** attr */
if ($action == 'attr') {
	$pagetitle = '属性设置';
	
	$huoyuan_ids = (array) ($_POST['huoyuan_id'] ? $_POST['huoyuan_id'] : $_GET['huoyuan_id']);
	if (empty($huoyuan_ids)) {
		msgbox('请选择要设置的货源！');
	} else {
		$wids = dimplode($huoyuan_ids);
	}
	
	$category_option = get_category_option('huoyuan', 0, 0, 0);
	$huoyuan = $DB->fetch_all("SELECT huoyuan_id, huoyuan_name FROM $table WHERE huoyuan_id IN ($wids)");
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('huoyuan', $huoyuan);
	$smarty->assign('h_action', 'saveattr');
}



/** save data */
if (in_array($action, array('saveadd', 'saveedit'))) {
	$cate_id = intval($_POST['cate_id']);
	$area_id = intval($_POST['area_id']);
	$huoyuan_name = trim($_POST['huoyuan_name']);
	$huoyuan_weixin = trim($_POST['huoyuan_weixin']);
	$huoyuan_tags = strtolower(addslashes(trim($_POST['huoyuan_tags'])));
	$huoyuan_pic = trim($_POST['huoyuan_pic']);
	$huoyuan_intro = addslashes(trim($_POST['huoyuan_intro']));
	$huoyuan_content = $_POST['huoyuan_content'];
	$huoyuan_qq = trim($_POST['huoyuan_qq']);
	$huoyuan_tel = trim($_POST['huoyuan_tel']);
	$huoyuan_wxpic = trim($_POST['huoyuan_wxpic']);
	$huoyuan_daifa = intval($_POST['huoyuan_daifa']);
	
	
	$huoyuan_ispay = intval($_POST['huoyuan_ispay']);
	$huoyuan_istop = intval($_POST['huoyuan_istop']);
	$huoyuan_isbest = intval($_POST['huoyuan_isbest']);
	$huoyuan_status = intval($_POST['huoyuan_status']);
	$huoyuan_time = time();
	
	if ($cate_id <= 0) {
		msgbox('请选择货源所属分类！');
	} else {
		$row = get_one_category($cate_id);
		if ($row['cate_mod'] == 'huoyuan' && $row['cate_childcount'] > 0) {
			msgbox('指定的分类下有子分类，请选择子分类进行操作！');
		}
	}
	
	
	if (empty($huoyuan_name)) {
		msgbox('请输入货源名称！');
	}
	
	
	
	if (empty($huoyuan_intro)) {
		msgbox('请输入货源简介！');
	}
	if (empty($huoyuan_content)) {
		msgbox('请输入货源详细介绍！');
	}
	
	// $huoyuan_url = str_replace('http://', '', $huoyuan_url);
	$huoyuan_tags = str_replace('，', ',', $huoyuan_tags);
	$huoyuan_tags = str_replace(',,', ',', $huoyuan_tags);
	if (substr($huoyuan_tags, -1) == ',') {
		$huoyuan_tags = substr($huoyuan_tags, 0, strlen($huoyuan_tags) - 1);
	}
	
	$huoyuan_ip = sprintf("%u", ip2long($huoyuan_ip));
	
	$huoyuan_data = array(
		'cate_id' => $cate_id,
		'area_id' => $area_id,
		'huoyuan_name' => $huoyuan_name,
		'huoyuan_weixin'=> $huoyuan_weixin,
		'huoyuan_qq'=> $huoyuan_qq,
		'huoyuan_tel'=> $huoyuan_tel,
		'huoyuan_wxpic' => $huoyuan_wxpic,
		'huoyuan_daifa' => $huoyuan_daifa,
		'huoyuan_tags' => $huoyuan_tags,
		'huoyuan_pic' => $huoyuan_pic,
		'huoyuan_intro' => $huoyuan_intro,
		'huoyuan_content' => $huoyuan_content,
		'huoyuan_ispay' => $huoyuan_ispay,
		'huoyuan_istop' => $huoyuan_istop,
		'huoyuan_isbest' => $huoyuan_isbest,
		'huoyuan_status' => $huoyuan_status,
		'huoyuan_ctime' => $huoyuan_time,
	);
	
	
	
	if ($action == 'saveadd') {
    	
		
		$huoyuan_data['user_id'] = $myself['user_id'];
		$DB->insert($table, $huoyuan_data);
		
		$stat_data['huoyuan_id'] = $DB->insert_id();
		
		
		$DB->query("UPDATE ".$DB->table('categories')." SET cate_postcount=cate_postcount+1 WHERE cate_id=$cate_id");
		$DB->query("UPDATE ".$DB->table('areas')." SET area_postcount=area_postcount+1 WHERE area_id=$area_id");
		update_cache('archives');
		
		msgbox('货源添加成功！', $fileurl.'?act=add&cate_id='.$cate_id);	
	} elseif ($action == 'saveedit') {
		$huoyuan_id = intval($_POST['huoyuan_id']);
		$where = array('huoyuan_id' => $huoyuan_id);
		unset($huoyuan_data['huoyuan_ctime']);
		
		$DB->update($table, $huoyuan_data, $where);
		
		
		$DB->query("UPDATE ".$DB->table('categories')." SET cate_postcount=cate_postcount+1 WHERE cate_id=$cate_id");
		$DB->query("UPDATE ".$DB->table('areas')." SET area_postcount=area_postcount+1 WHERE area_id=$area_id");
		update_cache('archives');
		
		msgbox('货源修改成功！', $fileurl);
	}
}

/** del */
if ($action == 'del') {
	$huoyuan_ids = (array) ($_POST['huoyuan_id'] ? $_POST['huoyuan_id'] : $_GET['huoyuan_id']);
	
	$DB->delete($table, 'huoyuan_id IN ('.dimplode($huoyuan_ids).')');
	
	update_cache('archives');
	unset($huoyuan_ids);
	
	msgbox('货源删除成功！', $fileurl);
}

/** move */
if ($action == 'savemove') {
	$huoyuan_ids = (array) $_POST['huoyuan_id'];
	$cate_id = intval($_POST['cate_id']);
	if (empty($huoyuan_ids)) {
		msgbox('请选择要移动的内容！');
	}
	if ($cate_id <= 0) {
		msgbox('请选择分类！');
	} else {
		$cate = get_one_category($cate_id);
		if ($cate['cate_childcount'] > 0) {
			msgbox('指定的分类下有子分类，请选择子分类进行操作！');
		}
	}
	
	$DB->update($table, array('cate_id' => $cate_id), 'huoyuan_id IN ('.dimplode($huoyuan_ids).')');
	update_cache('archives');
	
	msgbox('货源移动成功！', $fileurl);
}
/** moarea */
if ($action == 'savemoarea') {
	$huoyuan_ids = (array) $_POST['huoyuan_id'];
	$area_id = intval($_POST['area_id']);
	if (empty($huoyuan_ids)) {
		msgbox('请选择要更改的内容！');
	}
	if ($area_id <= 0) {
		msgbox('请选择地区！');
	} else {
		$cate = get_one_city($area_id);
		if ($cate['area_childcount'] > 0) {
			msgbox('指定的地区下有子分类，请选择二级地区类进行操作！');
		}
	}
	
	$DB->update($table, array('area_id' => $area_id), 'huoyuan_id IN ('.dimplode($huoyuan_ids).')');
	update_cache('archives');
	
	msgbox('货源移动成功！', $fileurl);
}

/** attr */
if ($action == 'saveattr') {
	$huoyuan_ids = (array) $_POST['huoyuan_id'];
	$huoyuan_ispay = intval($_POST['huoyuan_ispay']);
	$huoyuan_istop = intval($_POST['huoyuan_istop']);
	$huoyuan_isbest = intval($_POST['huoyuan_isbest']);
	$huoyuan_status = intval($_POST['huoyuan_status']);
	if (empty($huoyuan_ids)) {
		msgbox('请选择要设置的内容！');
	}
	
	require(APP_PATH.'include/sendmail.php');
	require(APP_PATH.'module/prelink.php');
	
	$huoyuan = $DB->fetch_all("SELECT w.huoyuan_id, w.huoyuan_name, u.user_email FROM $table w LEFT JOIN ".$DB->table("users")." u ON w.user_id=u.user_id WHERE w.huoyuan_id IN (".dimplode($huoyuan_ids).")");
	foreach ($huoyuan as $row) {
		/*if ($huoyuan_status == 3) {
			$site_link = get_website_url($row['huoyuan_id'], true);
			//发送邮件
			if (!empty($options['smtp_host']) && !empty($options['smtp_port']) && !empty($options['smtp_auth']) && !empty($options['smtp_user'])  && !empty($options['smtp_pass'])) {	
				$smarty->assign('site_name', $options['site_name']);
				$smarty->assign('site_url', $options['site_url']);
				$smarty->assign('huoyuan_name', $row['huoyuan_name']);
				$smarty->assign('site_link', $site_link);
				$mailbody = $smarty->fetch('audit_mail.html');
				sendmail($row['user_email'], '['.$options['site_name'].'] 货源已通过审核！', $mailbody);
			}
		}*/
		$DB->update($table, array('huoyuan_ispay' => $huoyuan_ispay, 'huoyuan_istop' => $huoyuan_istop, 'huoyuan_isbest' => $huoyuan_isbest, 'huoyuan_status' => $huoyuan_status), array('huoyuan_id' => $row['huoyuan_id']));
	}
	
	//$DB->update($table, array('huoyuan_istop' => $huoyuan_istop, 'huoyuan_isbest' => $huoyuan_isbest, 'huoyuan_status' => $huoyuan_status), 'huoyuan_id IN ('.dimplode($huoyuan_ids).')');
	
	msgbox('货源属性设置成功！', $fileurl);
}

/** metainfo */
if ($action == 'metainfo') {
	$url = trim($_GET['url']);
	if (empty($url)) {
		exit('请输入货源地址！');
	} else {
		if (!is_valid_domain($url)) {
			exit('请输入正确的货源地址！');
		}
	}
	
	$meta = get_sitemeta($url);	
	echo '<script type="text/javascript">';
	echo '$("#huoyuan_name").attr("value", "'.$meta['title'].'");';
	echo '$("#huoyuan_tags").attr("value", "'.$meta['keywords'].'");';
	echo '$("#huoyuan_intro").attr("value", "'.$meta['description'].'");';
	echo '</script>';
	unset($meta);
}



smarty_output($tempfile);
?>