<?php
require('common.php');
require(APP_PATH.'module/category.php');
require(APP_PATH.'module/city.php');
require(APP_PATH.'module/shop.php');

$fileurl = 'shop.php';
$tempfile = 'shop.html';
$table = $DB->table('shop');

if (!isset($action)) $action = 'list';

/** list */
if ($action == 'list') {
	$pagetitle = '商品列表';
	
	$status = intval(trim($_GET['status']));
	$cate_id = intval(trim($_GET['cate_id']));
	$sort = intval(trim($_GET['sort']));
	$order = strtoupper(trim($_GET['order']));
	$keywords = addslashes(trim($_POST['keywords'] ? $_POST['keywords'] : $_GET['keywords']));
	if (empty($order)) $order = 'DESC';
	
	$pageurl = $fileurl.'?status='.$status.'&cate_id='.$cate_id.'&sort='.$sort.'&order='.$order;
	$keyurl = !empty($keywords) ? '&keywords='.urlencode($keywords) : '';
	$pageurl .= $keyurl;
	
	$category_option = get_category_option('shop', 0, $cate_id, 0);
	
	$smarty->assign('status', $status);
	$smarty->assign('cate_id', $cate_id);
	$smarty->assign('sort', $sort);
	$smarty->assign('order', $order);
	$smarty->assign('keywords', $keywords);
	$smarty->assign('keyurl', $keyurl);
	$smarty->assign('category_option', $category_option);
	
	$where = '';
	$sql = "SELECT a.shop_id, a.cate_id, a.shop_name, a.shop_oprice , a.shop_price , a.shop_from, a.shop_outstat , a.shop_views ,a.shop_url, a.shop_ispay, a.shop_istop, a.shop_isbest, a.shop_status, shop_ctime FROM $table a  WHERE";
	switch ($status) {
		case 1 :
			$where .= " a.shop_status=1";
			break;
		case 2 :
			$where .= " a.shop_status=2";
			break;
		case 3 :
			$where .= " a.shop_status=3";
			break;
		default :
			$where .= " a.shop_status>-1";
			break;
	}
	
	if ($cate_id > 0) {
		$cate = get_one_category($cate_id);
		$where .= " AND a.cate_id IN (".$cate['cate_arrchildid'].")";
	}
	
	if ($keywords) $where .= " AND a.shop_name like '%$keywords%'";
	
	switch ($sort) {
		case 1 :
			$field = "a.shop_ctime";
			break;
		
		case 8 :
			$field = "b.shop_views";
			break;
		
		default :
			$field = "a.shop_ctime";
			break;
	}
	
	$sql .= $where." ORDER BY a.shop_istop DESC, $field $order LIMIT $start, $pagesize";
	$query = $DB->query($sql);
	
	$shop = array();
	while ($web = $DB->fetch_array($query)) {
		switch ($web['shop_status']) {
			case 1 :
				$shop_status = '<font color="#333333">黑名单</font>';
				break;
			case 2 :
				$shop_status = '<font color="#ff3300">待审核</font>';
				break;
			case 3 :
				$shop_status = '<font color="#008800">已审核</font>';
				break;
		}
		$shop_ispay = $web['shop_ispay'] > 0 ? '<font color="#ff0000">付费</font>' : '<font color="#cccccc">付费</font>';
		$shop_istop = $web['shop_istop'] > 0 ? '<font color="#ff0000">置顶</font>' : '<font color="#cccccc">置顶</font>';
		$shop_isbest = $web['shop_isbest'] > 0 ? '<font color="#ff0000">推荐</font>' : '<font color="#cccccc">推荐</font>';
		
		$web['shop_attr'] = $shop_ispay.' - '.$shop_istop.' - '.$shop_isbest.' - '.$shop_status.' - '.$shop_islink;
		
		$web['shop_cate'] = '<a href="'.$fileurl.'?cate_id='.$web['cate_id'].'">'.get_category_name($web['cate_id']).'</a>';
		$web['shop_name'] = '<a href="'.$web['shop_url'].'" target="_blank">'.$web['shop_name'].'</a> '.($web['shop_errors'] > 0 ? '<sup style="color: #f00;">error!</sup>' : '');
		
		$web['shop_ctime'] = date('Y-m-d', $web['shop_ctime']);
		$web['shop_operate'] = '<a href="'.$fileurl.'?act=edit&shop_id='.$web['shop_id'].'">编辑</a>&nbsp;|&nbsp;<a href="'.$fileurl.'?act=del&shop_id='.$web['shop_id'].'" onClick="return confirm(\'确认删除此内容吗？\');">删除</a>';
		$shop[] = $web;
	}
	unset($web);
	$DB->free_result($query);
	
	$total = $DB->get_count($table.' a', $where);
	$showpage = showpage($pageurl, $total, $curpage, $pagesize);
	
	$smarty->assign('shop', $shop);
	$smarty->assign('showpage', $showpage);
	unset($shop);
}

/** add */
if ($action == 'add') {
	$pagetitle = '添加商品';

	$cate_id = intval($_GET['cate_id']);
	$area_id = intval($_GET['area_id']);
	$category_option = get_category_option('shop', 0, $cate_id, 0);
	$city_option = get_city_option('city', 0, $area_id, 0);
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('city_option', $city_option);
	$smarty->assign('status', 3);
	$smarty->assign('h_action', 'saveadd');
}

/** edit */
if ($action == 'edit') {
	$pagetitle = '编辑商品';
	
	$shop_id = intval($_GET['shop_id']);
	
	$where = "w.shop_id=$shop_id";
	$row = get_one_shop($where);
	if (!$row) {
		msgbox('指定的内容不存在！');
	}
	$category_option = get_category_option('shop', 0, $row['cate_id'], 0);
	$city_option = get_city_option('area', 0, $row['area_id'], 0);
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('city_option', $city_option);
	$smarty->assign('ispay', $row['shop_ispay']);
	$smarty->assign('istop', $row['shop_istop']);
	$smarty->assign('isbest', $row['shop_isbest']);
	$smarty->assign('status', $row['shop_status']);
	$smarty->assign('row', $row);
	$smarty->assign('h_action', 'saveedit');
}

/** move */
if ($action == 'move') {
	$pagetitle = '移动商品';
			
	$shop_ids = (array) ($_POST['shop_id'] ? $_POST['shop_id'] : $_GET['shop_id']);
	if (empty($shop_ids)) {
		msgbox('请选择要移动的商品！');
	} else {
		$wids = dimplode($shop_ids);
	}
	
	$category_option = get_category_option('shop', 0, 0, 0);
	$shop = $DB->fetch_all("SELECT shop_id, shop_name FROM $table WHERE shop_id IN ($wids)");
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('shop', $shop);
	$smarty->assign('h_action', 'savemove');
}
/** moarea */
if ($action == 'moarea') {
	$pagetitle = '更改地区';
			
	$shop_ids = (array) ($_POST['shop_id'] ? $_POST['shop_id'] : $_GET['shop_id']);
	if (empty($shop_ids)) {
		msgbox('请选择要更改的商品！');
	} else {
		$wids = dimplode($shop_ids);
	}
	
	$city_option = get_city_option('area', 0, 0, 0);
	$shop = $DB->fetch_all("SELECT shop_id, shop_name FROM $table WHERE shop_id IN ($wids)");
	
	$smarty->assign('city_option', $city_option);
	$smarty->assign('shop', $shop);
	$smarty->assign('h_action', 'savemoarea');
}
/** attr */
if ($action == 'attr') {
	$pagetitle = '属性设置';
	
	$shop_ids = (array) ($_POST['shop_id'] ? $_POST['shop_id'] : $_GET['shop_id']);
	if (empty($shop_ids)) {
		msgbox('请选择要设置的商品！');
	} else {
		$wids = dimplode($shop_ids);
	}
	
	$category_option = get_category_option('shop', 0, 0, 0);
	$shop = $DB->fetch_all("SELECT shop_id, shop_name FROM $table WHERE shop_id IN ($wids)");
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('shop', $shop);
	$smarty->assign('h_action', 'saveattr');
}



/** save data */
if (in_array($action, array('saveadd', 'saveedit'))) {
	$cate_id = intval($_POST['cate_id']);
	$area_id = intval($_POST['area_id']);
	$shop_name = trim($_POST['shop_name']);
	$shop_url = trim($_POST['shop_url']);
	$shop_tags = strtolower(addslashes(trim($_POST['shop_tags'])));
	$shop_pic = trim($_POST['shop_pic']);
	$shop_intro = addslashes(trim($_POST['shop_intro']));
	$shop_content = $_POST['shop_content'];
	$shop_oprice = trim($_POST['shop_oprice']);
	$shop_price = trim($_POST['shop_price']);
	$shop_from = trim($_POST['shop_from']);
	
	
	$shop_ispay = intval($_POST['shop_ispay']);
	$shop_istop = intval($_POST['shop_istop']);
	$shop_isbest = intval($_POST['shop_isbest']);
	$shop_status = intval($_POST['shop_status']);
	$shop_time = time();
	
	if ($cate_id <= 0) {
		msgbox('请选择商品所属分类！');
	} else {
		$row = get_one_category($cate_id);
		if ($row['cate_mod'] == 'shop' && $row['cate_childcount'] > 0) {
			msgbox('指定的分类下有子分类，请选择子分类进行操作！');
		}
	}
	
	
	if (empty($shop_name)) {
		msgbox('请输入商品名称！');
	}
	
	if (empty($shop_url)) {
		msgbox('请输入商品地址！');
	} 
	
	if (empty($shop_intro)) {
		msgbox('请输入商品简介！');
	}
	if (empty($shop_content)) {
		msgbox('请输入商品详细介绍！');
	}
	
	// $shop_url = str_replace('http://', '', $shop_url);
	$shop_tags = str_replace('，', ',', $shop_tags);
	$shop_tags = str_replace(',,', ',', $shop_tags);
	if (substr($shop_tags, -1) == ',') {
		$shop_tags = substr($shop_tags, 0, strlen($shop_tags) - 1);
	}
	
	$shop_ip = sprintf("%u", ip2long($shop_ip));
	
	$shop_data = array(
		'cate_id' => $cate_id,
		'area_id' => $area_id,
		'shop_name' => $shop_name,
		'shop_oprice'=> $shop_oprice,
		'shop_price'=> $shop_price,
		'shop_from'=> $shop_from,
		'shop_url' => $shop_url,
		'shop_tags' => $shop_tags,
		'shop_pic' => $shop_pic,
		'shop_intro' => $shop_intro,
		'shop_content' => $shop_content,
		'shop_ispay' => $shop_ispay,
		'shop_istop' => $shop_istop,
		'shop_isbest' => $shop_isbest,
		'shop_status' => $shop_status,
		'shop_ctime' => $shop_time,
	);
	
	
	
	if ($action == 'saveadd') {
    	$query = $DB->query("SELECT shop_id FROM $table WHERE shop_url='$shop_url'");
    	if ($DB->num_rows($query)) {
        	msgbox('您所添加的商品已存在！');
    	}
		
		$shop_data['user_id'] = $myself['user_id'];
		$DB->insert($table, $shop_data);
		
		$stat_data['shop_id'] = $DB->insert_id();
		
		
		$DB->query("UPDATE ".$DB->table('categories')." SET cate_postcount=cate_postcount+1 WHERE cate_id=$cate_id");
		$DB->query("UPDATE ".$DB->table('areas')." SET area_postcount=area_postcount+1 WHERE area_id=$area_id");
		update_cache('archives');
		
		msgbox('商品添加成功！', $fileurl.'?act=add&cate_id='.$cate_id);	
	} elseif ($action == 'saveedit') {
		$shop_id = intval($_POST['shop_id']);
		$where = array('shop_id' => $shop_id);
		unset($shop_data['shop_ctime']);
		
		$DB->update($table, $shop_data, $where);
		
		
		$DB->query("UPDATE ".$DB->table('categories')." SET cate_postcount=cate_postcount+1 WHERE cate_id=$cate_id");
		$DB->query("UPDATE ".$DB->table('areas')." SET area_postcount=area_postcount+1 WHERE area_id=$area_id");
		update_cache('archives');
		
		msgbox('商品修改成功！', $fileurl);
	}
}

/** del */
if ($action == 'del') {
	$shop_ids = (array) ($_POST['shop_id'] ? $_POST['shop_id'] : $_GET['shop_id']);
	
	$DB->delete($table, 'shop_id IN ('.dimplode($shop_ids).')');
	
	update_cache('archives');
	unset($shop_ids);
	
	msgbox('商品删除成功！', $fileurl);
}

/** move */
if ($action == 'savemove') {
	$shop_ids = (array) $_POST['shop_id'];
	$cate_id = intval($_POST['cate_id']);
	if (empty($shop_ids)) {
		msgbox('请选择要移动的内容！');
	}
	if ($cate_id <= 0) {
		msgbox('请选择分类！');
	} else {
		$cate = get_one_category($cate_id);
		if ($cate['cate_childcount'] > 0) {
			msgbox('指定的分类下有子分类，请选择子分类进行操作！');
		}
	}
	
	$DB->update($table, array('cate_id' => $cate_id), 'shop_id IN ('.dimplode($shop_ids).')');
	update_cache('archives');
	
	msgbox('商品移动成功！', $fileurl);
}
/** moarea */
if ($action == 'savemoarea') {
	$shop_ids = (array) $_POST['shop_id'];
	$area_id = intval($_POST['area_id']);
	if (empty($shop_ids)) {
		msgbox('请选择要更改的内容！');
	}
	if ($area_id <= 0) {
		msgbox('请选择地区！');
	} else {
		$cate = get_one_city($area_id);
		if ($cate['area_childcount'] > 0) {
			msgbox('指定的地区下有子分类，请选择二级地区类进行操作！');
		}
	}
	
	$DB->update($table, array('area_id' => $area_id), 'shop_id IN ('.dimplode($shop_ids).')');
	update_cache('archives');
	
	msgbox('商品移动成功！', $fileurl);
}

/** attr */
if ($action == 'saveattr') {
	$shop_ids = (array) $_POST['shop_id'];
	$shop_ispay = intval($_POST['shop_ispay']);
	$shop_istop = intval($_POST['shop_istop']);
	$shop_isbest = intval($_POST['shop_isbest']);
	$shop_status = intval($_POST['shop_status']);
	if (empty($shop_ids)) {
		msgbox('请选择要设置的内容！');
	}
	
	require(APP_PATH.'include/sendmail.php');
	require(APP_PATH.'module/prelink.php');
	
	$shop = $DB->fetch_all("SELECT w.shop_id, w.shop_name, u.user_email FROM $table w LEFT JOIN ".$DB->table("users")." u ON w.user_id=u.user_id WHERE w.shop_id IN (".dimplode($shop_ids).")");
	foreach ($shop as $row) {
		/*if ($shop_status == 3) {
			$site_link = get_website_url($row['shop_id'], true);
			//发送邮件
			if (!empty($options['smtp_host']) && !empty($options['smtp_port']) && !empty($options['smtp_auth']) && !empty($options['smtp_user'])  && !empty($options['smtp_pass'])) {	
				$smarty->assign('site_name', $options['site_name']);
				$smarty->assign('site_url', $options['site_url']);
				$smarty->assign('shop_name', $row['shop_name']);
				$smarty->assign('site_link', $site_link);
				$mailbody = $smarty->fetch('audit_mail.html');
				sendmail($row['user_email'], '['.$options['site_name'].'] 商品已通过审核！', $mailbody);
			}
		}*/
		$DB->update($table, array('shop_ispay' => $shop_ispay, 'shop_istop' => $shop_istop, 'shop_isbest' => $shop_isbest, 'shop_status' => $shop_status), array('shop_id' => $row['shop_id']));
	}
	
	//$DB->update($table, array('shop_istop' => $shop_istop, 'shop_isbest' => $shop_isbest, 'shop_status' => $shop_status), 'shop_id IN ('.dimplode($shop_ids).')');
	
	msgbox('商品属性设置成功！', $fileurl);
}

/** metainfo */
if ($action == 'metainfo') {
	$url = trim($_GET['url']);
	if (empty($url)) {
		exit('请输入商品地址！');
	} else {
		if (!is_valid_domain($url)) {
			exit('请输入正确的商品地址！');
		}
	}
	
	$meta = get_sitemeta($url);	
	echo '<script type="text/javascript">';
	echo '$("#shop_name").attr("value", "'.$meta['title'].'");';
	echo '$("#shop_tags").attr("value", "'.$meta['keywords'].'");';
	echo '$("#shop_intro").attr("value", "'.$meta['description'].'");';
	echo '</script>';
	unset($meta);
}



smarty_output($tempfile);
?>