<?php
 namespace App\Http\Controllers\Admin; use App\Types\NoteTipStatus; use TechOnline\Laravel\Dao\ModelUtil; use TechSoft\Laravel\Admin\Cms\BasicCms; use TechSoft\Laravel\Admin\Cms\Field\FieldEmpty; use TechSoft\Laravel\Admin\Cms\Field\FieldSelect; use TechSoft\Laravel\Admin\Cms\Field\FieldText; use TechSoft\Laravel\Admin\Support\AdminCheckController; use TechSoft\Laravel\Admin\Util\AdminCmsUtil; class NoteTipController extends AdminCheckController { protected $cmsConfigBasic = [ 'model' => 'note_tip', 'pageTitle' => '文章打赏', 'group' => 'data', 'canAdd' => false, 'canEdit' => false, 'canDelete' => false, 'fields' => [ 'status' => ['type' => FieldSelect::class, 'title' => '状态', 'list' => true, 'edit' => true, 'add' => true,], 'noteId' => ['type' => FieldText::class, 'title' => '文章', 'list' => true, 'edit' => true, 'add' => true,], '_memberUser' => ['type' => FieldEmpty::class, 'title' => '收到打赏', 'list' => true, 'edit' => true, 'add' => true,], '_tipMemberUser' => ['type' => FieldEmpty::class, 'title' => '打赏用户', 'list' => true, 'edit' => true, 'add' => true,], 'money' => ['type' => FieldText::class, 'title' => '金额', 'list' => true, 'edit' => true, 'add' => true,], 'msg' => ['type' => FieldText::class, 'title' => '留言', 'list' => true, 'edit' => true, 'add' => true,], ] ]; public function dataPostAdd(&$data) { } public function dataPostEdit(&$data) { } public function dataPostDelete(&$data) { } public function dataProcessViewField($key, &$record) { switch ($key) { case '_memberUser': return AdminCmsUtil::memberUserId($record['memberUserId'], '\App\Http\Controllers\Admin\MemberController@dataView'); case '_tipMemberUser': return AdminCmsUtil::memberUserId($record['tipMemberUserId'], '\App\Http\Controllers\Admin\MemberController@dataView'); } } public function dataProcessView(&$item, &$record) { switch ($record['status']) { case NoteTipStatus::WAIT_PAY: $item['status'] = '<span class="uk-text-muted">等待支付</span>'; break; case NoteTipStatus::SUCCESS: $item['status'] = '<span class="uk-text-success">支付成功</span>'; break; } $note = ModelUtil::get('note', ['id' => $record['noteId']]); $item['noteId'] = '<a href="/n/' . $note['alias'] . '" target="_blank">' . htmlspecialchars($note['title']) . '</a>'; } public function dataList(BasicCms $basicCms) { return $basicCms->executeList($this, $this->cmsConfigBasic);; } public function dataDelete(BasicCms $basicCms) { return $basicCms->executeDelete($this, $this->cmsConfigBasic); } public function dataEdit(BasicCms $basicCms) { return $basicCms->executeEdit($this, $this->cmsConfigBasic); } public function dataAdd(BasicCms $basicCms) { return $basicCms->executeAdd($this, $this->cmsConfigBasic); } }