<?php
 namespace App\Http\Controllers\Admin; use App\Types\NoteTipOffStatus; use TechSoft\Laravel\Admin\Cms\BasicCms; use TechSoft\Laravel\Admin\Cms\Field\FieldSelect; use TechSoft\Laravel\Admin\Cms\Field\FieldText; use TechSoft\Laravel\Admin\Support\AdminCheckController; class NoteTipOffController extends AdminCheckController { protected $cmsConfigBasic = [ 'model' => 'note_tip_off', 'pageTitle' => '文章举报', 'group' => 'data', 'canAdd' => false, 'canEdit' => true, 'canDelete' => false, 'joinsSelect' => [ 'id' => 'note_tip_off.id', 'status' => 'note_tip_off.status', 'type' => 'note_tip_off.type', 'remark' => 'note_tip_off.remark', ], 'joins' => [ [ 'member_user', 'member_user.id', '=', 'note_tip_off.memberUserId', [ 'noteTipOffStatus' => 'note_tip_off.status', 'memberUserUsername' => 'member_user.username', ] ], [ 'note', 'note.id', '=', 'note_tip_off.noteId', [ 'noteTitle' => 'note.title', 'noteAlias' => 'note.alias', 'noteStatus' => 'note.status', ] ], ], 'fields' => [ 'noteTipOffStatus' => ['type' => FieldSelect::class, 'title' => '状态', 'list' => true, 'edit' => true, 'add' => true, 'search' => true, 'optionType' => NoteTipOffStatus::class,], 'memberUserUsername' => ['type' => FieldText::class, 'title' => '用户', 'list' => true, 'add' => true,], 'noteTitle' => ['type' => FieldText::class, 'title' => '文章', 'list' => true, 'add' => true,], 'type' => ['type' => FieldText::class, 'title' => '举报类型', 'list' => true, 'add' => true,], 'remark' => ['type' => FieldText::class, 'title' => '举报说明', 'list' => true, 'add' => true,], ] ]; public function dataProcessView(&$item, &$record) { switch ($record['status']) { case NoteTipOffStatus::WAIT_PROCESS: $item['status'] = '<span class="uk-text-danger">等待处理</span>'; break; case NoteTipOffStatus::PASS: $item['status'] = '<span class="uk-text-success">举报通过</span>'; break; case NoteTipOffStatus::REJECT: $item['status'] = '<span class="uk-text-warning">举报拒绝</span>'; break; } $item['noteTitle'] = '<a href="/n/' . $record['noteAlias'] . '" target="_blank">' . htmlspecialchars($record['noteTitle']) . '</a>'; } public function dataList(BasicCms $basicCms) { return $basicCms->executeList($this, $this->cmsConfigBasic);; } public function dataDelete(BasicCms $basicCms) { return $basicCms->executeDelete($this, $this->cmsConfigBasic); } public function dataEdit(BasicCms $basicCms) { return $basicCms->executeEdit($this, $this->cmsConfigBasic); } public function dataAdd(BasicCms $basicCms) { return $basicCms->executeAdd($this, $this->cmsConfigBasic); } }