<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use App\Util\NoteUtil; use App\Util\TopicUtil; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\MemberFollow\MemberFollowUtil; class FollowController extends BaseController implements MemberLoginCheck { public function index() { return Response::send(0, null, null, '/follow/topics'); } public function users() { $pageSize = 20; $option = []; $followedMemberUsers = MemberFollowUtil::getFollowedMemberUserIds($this->memberUserId()); $option['whereIn'] = ['memberUserId', $followedMemberUsers]; $option['order'] = ['id', 'desc']; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = NoteUtil::paginateNotes($page, $pageSize, $option); if (empty($paginateData['records'])) { $html = null; } else { MemberUtil::mergeMemberUsers($paginateData['records']); $html = $this->_viewRender('fragment.noteListItems', [ 'notes' => $paginateData['records'], ]); } return Response::send(0, null, [ 'html' => $html, 'page' => $page, 'pageSize' => $pageSize, 'total' => $paginateData['total'], ]); } $page = 1; $paginateData = NoteUtil::paginateNotes($page, $pageSize, $option); MemberUtil::mergeMemberUsers($paginateData['records']); $hotMemberUsers = ModelUtil::model('member_user')->orderBy('noteCount', 'desc')->limit(5)->get()->toArray(); MemberFollowUtil::mergeIsFollowed($hotMemberUsers, $this->memberUserId()); return $this->_view('follow.users', [ 'page' => $page, 'pageSize' => $pageSize, 'total' => $paginateData['total'], 'notes' => $paginateData['records'], 'hotMemberUsers' => $hotMemberUsers, ]); } public function topics() { $pageSize = 20; $option = []; $followedTopicIds = TopicUtil::getFollowedTopicIds($this->memberUserId()); if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = TopicUtil::paginateLatestTopicsNotes($followedTopicIds, $page, $pageSize, $option); if (empty($paginateData['records'])) { $html = null; } else { MemberUtil::mergeMemberUsers($paginateData['records']); $html = $this->_viewRender('fragment.noteListItems', [ 'notes' => $paginateData['records'], ]); } return Response::send(0, null, [ 'html' => $html, 'page' => $page, 'pageSize' => $pageSize, 'total' => $paginateData['total'], ]); } $page = 1; $paginateData = TopicUtil::paginateLatestTopicsNotes($followedTopicIds, $page, $pageSize, $option); MemberUtil::mergeMemberUsers($paginateData['records']); $hotTopics = ModelUtil::model('topic')->orderBy('followerCount', 'desc')->limit(5)->get()->toArray(); return $this->_view('follow.topics', [ 'page' => $page, 'pageSize' => $pageSize, 'total' => $paginateData['total'], 'notes' => $paginateData['records'], 'hotTopics' => $hotTopics, ]); } }