<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use App\Util\NoteUtil; use App\Util\TopicUtil; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\Util\HtmlUtil; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Utils\PageHtmlUtil; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\MemberFollow\MemberFollowUtil; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\View; use Illuminate\Support\Str; class MemberController extends BaseController { public function index() { if (!$this->memberUserId()) { return Response::send(0, null, null, '/login?redirect=' . urlencode('/member')); } if ($this->isMobile()) { return $this->_view('member.index'); } else { return Response::send(0, null, null, '/member/' . $this->memberUserId()); } } public function frameViewGlobal($memberUserId) { $memberUser = MemberUtil::get($memberUserId); if (empty($memberUser)) { return Response::generate(-1, '用户不存在'); } $memberUser['_isFollowed'] = MemberFollowUtil::isFollowed($this->memberUserId(), $memberUser['id']); View::share('memberUser', $memberUser); $topics = TopicUtil::listMemberUserTopics($memberUserId); View::share('topics', $topics); return Response::generate(0, null); } public function view($id) { $ret = $this->frameViewGlobal($id); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $pageSize = 20; $option = ['order' => ['id', 'desc']]; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = NoteUtil::paginateMemberUserNotes($id, $page, $pageSize, $option); MemberUtil::mergeMemberUsers($paginateData['records']); $html = $this->_viewRender('fragment.noteListItems', [ 'notes' => $paginateData['records'], ]); return Response::json(0, null, [ 'total' => $paginateData['total'], 'page' => $page, 'pageSize' => $pageSize, 'html' => $html, ]); } $page = 1; $paginateData = NoteUtil::paginateMemberUserNotes($id, $page, $pageSize, $option); MemberUtil::mergeMemberUsers($paginateData['records']); return $this->_view('member.view', [ 'notes' => $paginateData['records'], 'total' => $paginateData['total'], 'pageSize' => $pageSize, ]); } public function follow() { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $memberUserId = intval(Input::get('memberUserId')); if ($memberUserId == $this->memberUserId()) { return Response::send(-1, '不能自己关注自己'); } if (MemberFollowUtil::isFollowed($this->memberUserId(), $memberUserId)) { MemberFollowUtil::unfollow($this->memberUserId(), $memberUserId); return Response::send(0, 'ok', ['action' => 'unfollowed']); } else { MemberFollowUtil::follow($this->memberUserId(), $memberUserId); return Response::send(0, 'ok', ['action' => 'followed']); } } public function following($id) { $ret = $this->frameViewGlobal($id); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $pageSize = 20; $option = ['order' => ['id', 'desc']]; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = MemberFollowUtil::paginateFollowingMemberUsers($id, $page, $pageSize, $option); $memberUsers = $paginateData['records']; MemberFollowUtil::mergeIsFollowed($memberUsers, $this->memberUserId()); $html = $this->_viewRender('fragment.memberUserListItems', [ 'memberUsers' => $memberUsers, ]); return Response::json(0, null, [ 'total' => $paginateData['total'], 'page' => $page, 'pageSize' => $pageSize, 'html' => $html, ]); } $page = 1; $paginateData = MemberFollowUtil::paginateFollowingMemberUsers($id, $page, $pageSize, $option); $memberUsers = $paginateData['records']; MemberFollowUtil::mergeIsFollowed($memberUsers, $this->memberUserId()); return $this->_view('member.following', [ 'memberUsers' => $memberUsers, 'total' => $paginateData['total'], 'pageSize' => $pageSize, ]); } public function followers( $id) { $ret = $this->frameViewGlobal($id); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $pageSize = 20; $option = ['order' => ['id', 'desc']]; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = MemberFollowUtil::paginateFollowerMemberUsers($id, $page, $pageSize, $option); $memberUsers = $paginateData['records']; MemberFollowUtil::mergeIsFollowed($memberUsers, $this->memberUserId()); $html = $this->_viewRender('fragment.memberUserListItems', [ 'memberUsers' => $memberUsers, ]); return Response::json(0, null, [ 'total' => $paginateData['total'], 'page' => $page, 'pageSize' => $pageSize, 'html' => $html, ]); } $page = 1; $paginateData = MemberFollowUtil::paginateFollowerMemberUsers($id, $page, $pageSize, $option); $memberUsers = $paginateData['records']; MemberFollowUtil::mergeIsFollowed($memberUsers, $this->memberUserId()); return $this->_view('member.followers', [ 'memberUsers' => $memberUsers, 'total' => $paginateData['total'], 'pageSize' => $pageSize, ]); } public function likeNotes($id) { $ret = $this->frameViewGlobal($id); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $pageSize = 20; $option = ['order' => ['id', 'desc']]; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = NoteUtil::paginateLikeNotes($id, $page, $pageSize, $option); $notes = $paginateData['records']; MemberUtil::mergeMemberUsers($notes); $html = $this->_viewRender('fragment.noteListItems', [ 'notes' => $notes, ]); return Response::json(0, null, [ 'total' => $paginateData['total'], 'page' => $page, 'pageSize' => $pageSize, 'html' => $html, ]); } $page = 1; $paginateData = NoteUtil::paginateLikeNotes($id, $page, $pageSize, $option); $notes = $paginateData['records']; MemberUtil::mergeMemberUsers($notes); return $this->_view('member.likeNotes', [ 'notes' => $notes, 'total' => $paginateData['total'], 'pageSize' => $pageSize, ]); } public function followedTopics($id) { $ret = $this->frameViewGlobal($id); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $pageSize = 20; $option = ['order' => ['id', 'desc']]; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = TopicUtil::paginateMemberUserFollowedTopics($id, $page, $pageSize, $option); $topics = $paginateData['records']; TopicUtil::mergeIsFollowed($topics, $this->memberUserId()); $html = $this->_viewRender('fragment.topicListItems', [ 'topics' => $topics, ]); return Response::json(0, null, [ 'total' => $paginateData['total'], 'page' => $page, 'pageSize' => $pageSize, 'html' => $html, ]); } $page = 1; $paginateData = TopicUtil::paginateMemberUserFollowedTopics($id, $page, $pageSize, $option); $topics = $paginateData['records']; TopicUtil::mergeIsFollowed($topics, $this->memberUserId()); return $this->_view('member.followedTopics', [ 'topics' => $topics, 'total' => $paginateData['total'], 'pageSize' => $pageSize, ]); } }