<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\View; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Assets\AssetsUtil; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\MemberChat\MemberChatUtil; use TechSoft\Laravel\MemberMessage\MemberMessageStatus; use TechSoft\Laravel\MemberMessage\MemberMessageUtil; class MemberMessageController extends BaseController implements MemberLoginCheck { public function notification() { $memberUser = $this->memberUser(); $count = intval($memberUser['newMessageCount']) + intval($memberUser['newChatMsgCount']); return Response::send(0, null, [ 'count' => $count, ]); } public function index() { $pageSize = 10; $option = []; $option['order'] = ['id', 'desc']; $markRead = false; if (View::shared('request_path') == '/member/message') { $option['where'] = ['status' => MemberMessageStatus::UNREAD]; $markRead = true; } if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = MemberMessageUtil::paginate($this->memberUserId(), $page, $pageSize, $option); $messages = $paginateData['records']; if ($markRead) { MemberMessageUtil::setMemberMessageRead( $this->memberUserId(), array_build($messages, function ($k, $v) { return [$k, $v['id']]; }) ); MemberUtil::update($this->memberUserId(), ['newMessageCount' => MemberMessageUtil::getUnreadMessageCount($this->memberUserId())] ); } $html = $this->_viewRender('memberMessage.messageItems', [ 'messages' => $messages, ]); return Response::send(0, null, [ 'total' => $paginateData['total'], 'page' => $page, 'pageSize' => $pageSize, 'html' => $html, ]); } $page = 1; $paginateData = MemberMessageUtil::paginate($this->memberUserId(), $page, $pageSize, $option); $messages = $paginateData['records']; if ($markRead) { MemberMessageUtil::setMemberMessageRead( $this->memberUserId(), array_build($messages, function ($k, $v) { return [$k, $v['id']]; }) ); MemberUtil::update($this->memberUserId(), ['newMessageCount' => MemberMessageUtil::getUnreadMessageCount($this->memberUserId())] ); } return $this->_view('memberMessage.index', [ 'pageSize' => $pageSize, 'total' => $paginateData['total'], 'messages' => $messages, ]); } public function delete($id) { MemberMessageUtil::deleteMemberUserMessage($id, $this->memberUserId()); return Response::send(0, null, null, '[js]window.__refresh()'); } public function chat() { $pageSize = 10; $option = []; $option['order'] = ['updated_at', 'desc']; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = MemberChatUtil::paginateChat($this->memberUserId(), $page, $pageSize, $option); $chats = $paginateData['records']; $html = $this->_viewRender('memberMessage.chatItems', [ 'chats' => $chats, ]); return Response::send(0, null, [ 'page' => $page, 'pageSize' => $pageSize, 'total' => $paginateData['total'], 'html' => $html, ]); } $page = 1; $paginateData = MemberChatUtil::paginateChat($this->memberUserId(), $page, $pageSize, $option); $chats = $paginateData['records']; return $this->_view('memberMessage.chat', [ 'pageSize' => $pageSize, 'total' => $paginateData['total'], 'chats' => $chats, ]); } public function chatCreate($memberUserId) { $chatMemberUser = MemberUtil::get($memberUserId); if (empty($chatMemberUser)) { return Response::send(-1, '用户不存在'); } $chat = MemberChatUtil::create($this->memberUserId(), $memberUserId); return Response::send(0, null, null, '/member/message_chat_room/' . $chat['id']); } public function chatRoom( $chatId) { $chat = MemberChatUtil::getMemberUserChat($this->memberUserId(), $chatId); if (empty($chat)) { return Response::send(-1, '对话不存在'); } $chat['_memberUser'] = $this->memberUser(); $chat['_chatMemberUser'] = MemberUtil::get($chat['chatMemberUserId']); $action = trim(Input::get('action')); switch ($action) { case 'init': case 'history': $minMsgId = intval(Input::get('minMsgId', 0)); $page = 1; $pageSize = 50; $option = []; $option['order'] = ['id', 'desc']; if ($minMsgId > 0) { $option['whereOperate'] = ['id', '<', $minMsgId]; } $paginateData = MemberChatUtil::paginateChatMsg($chat['id'], $page, $pageSize, $option); MemberChatUtil::setChatMsgAsRead($chat['id'], array_pluck($paginateData['records'], 'id')); MemberUtil::updateNewChatMsgStatus($this->memberUserId()); return Response::send(0, null, [ 'msgs' => $this->msgsConvert($chat, $paginateData['records']), ]); case 'watch': $maxMsgId = intval(Input::get('maxMsgId')); $newMsgs = MemberChatUtil::listNewMsgsWithChatIdAndMaxId($chat['id'], $maxMsgId); MemberChatUtil::setChatMsgAsRead($chat['id'], array_pluck($newMsgs, 'id')); MemberUtil::updateNewChatMsgStatus($this->memberUserId()); return Response::send(0, null, [ 'msgs' => $this->msgsConvert($chat, $newMsgs), ]); case 'sendText': case 'sendImage': $content = trim(Input::get('content')); if (empty($content)) { return Response::send(-1, '内容为空'); } if ($action == 'sendImage') { $ret = MemberChatUtil::sendImage($this->memberUserId(), $chat['chatMemberUserId'], $content); } else { $ret = MemberChatUtil::sendText($this->memberUserId(), $chat['chatMemberUserId'], $content); } if ($ret['code']) { return Response::send(-1, $ret['msg']); } $maxMsgId = intval(Input::get('maxMsgId')); $newMsgs = MemberChatUtil::listNewMsgsWithChatIdAndMaxId($chat['id'], $maxMsgId); MemberChatUtil::setChatMsgAsRead($chat['id'], array_pluck($newMsgs, 'id')); MemberUtil::updateNewChatMsgStatus($chat['chatMemberUserId']); MemberUtil::updateNewChatMsgStatus($this->memberUserId()); return Response::send(0, null, [ 'msgs' => $this->msgsConvert($chat, $newMsgs), ]); } return $this->_view('memberMessage.chatRoom', [ 'chat' => $chat, ]); } private function msgsConvert($chat, $chatMsgs) { $msgs = []; foreach ($chatMsgs as $msg) { if ($msg['senderMemberUserId'] == $chat['memberUserId']) { $avatar = $chat['_memberUser']['avatar']; } else { $avatar = $chat['_chatMemberUser']['avatar']; } $msgs[] = [ 'id' => $msg['id'], 'time' => $msg['created_at'], 'type' => $msg['type'], 'senderMemberUserId' => $msg['senderMemberUserId'], 'senderMemberUserAvatar' => AssetsUtil::fixOrDefault($avatar, 'assets/lib/img/avatar.png'), 'content' => $msg['content'], ]; } return $msgs; } public function chatMarkAllRead() { MemberChatUtil::markReadAll($this->memberUserId()); MemberUtil::updateNewChatMsgStatus($this->memberUserId()); return Response::send(0, null, null, '[js]window.__refresh()'); } public function chatDelete($id) { MemberChatUtil::deleteMemberChat($this->memberUserId(), $id); MemberUtil::updateNewChatMsgStatus($this->memberUserId()); return Response::send(0, null, null, '[js]window.__refresh()'); } }