<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Config\ConfigUtil; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; use TechSoft\Laravel\MemberMoney\MemberMoneyUtil; use TechSoft\Laravel\MemberMoney\Types\MemberMoneyCashType; class MemberMoneyController extends BaseController implements MemberLoginCheck { public function index() { $pageSize = 10; $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $page = 1; $paginateData = MemberMoneyUtil::paginateLog($this->memberUserId(), $page, $pageSize, $option); return $this->_view('memberMoney.index', [ 'totalMoney' => MemberMoneyUtil::getTotal($this->memberUserId()), 'records' => $paginateData['records'], ]); } public function log() { $pageSize = 10; $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = MemberMoneyUtil::paginateLog($this->memberUserId(), $page, $pageSize, $option); $html = null; if (!empty($paginateData['records'])) { $html = $this->_viewRender('memberMoney.logItems', [ 'records' => $paginateData['records'], ]); } return Response::send(0, null, [ 'html' => $html, 'page' => $page, 'pageSize' => $pageSize, 'total' => $paginateData['total'], ]); } $page = 1; $paginateData = MemberMoneyUtil::paginateLog($this->memberUserId(), $page, $pageSize, $option); return $this->_view('memberMoney.log', [ 'total' => $paginateData['total'], 'page' => $page, 'pageSize' => $pageSize, 'records' => $paginateData['records'], ]); } public function cash() { if (Request::isPost()) { $money = trim(Input::get('money')); $alipayRealname = trim(Input::get('alipayRealname')); $alipayAccount = trim(Input::get('alipayAccount')); if (empty($money)) { return Response::send(-1, '提现金额不能为空'); } if (empty($alipayRealname)) { return Response::send(-1, '支付宝姓名不能为空'); } if (empty($alipayAccount)) { return Response::send(-1, '支付宝账号不能为空'); } if ($money < 100) { return Response::send(-1, '提现金额至少为100'); } $total = MemberMoneyUtil::getTotal($this->memberUserId()); if ($total < 100) { return Response::send(-1, '当前账户余额不满100,不能提现'); } $rate = 100 - intval(ConfigUtil::get('customTipCashRate', 0)); if ($rate < 0) { $rate = 0; } elseif ($rate > 100) { $rate = 100; } $moneyAfterTax = bcdiv(bcmul($money, $rate, 2), 100, 2); try { ModelUtil::transactionBegin(); MemberMoneyUtil::cash($this->memberUserId(), $money, $moneyAfterTax, MemberMoneyCashType::ALIPAY, $alipayRealname, $alipayAccount); ModelUtil::transactionCommit(); } catch (\Exception $e) { ModelUtil::transactionRollback(); throw $e; } return Response::send(0, '余额提现申请提交成功', null, '/member/money'); } return $this->_view('memberMoney.cash', [ 'total' => MemberMoneyUtil::getTotal($this->memberUserId()), ]); } public function cashLog() { $pageSize = 10; $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = MemberMoneyUtil::paginateCash($this->memberUserId(), $page, $pageSize, $option); $html = null; if (!empty($paginateData['records'])) { $html = $this->_viewRender('memberMoney.cashLogItems', [ 'records' => $paginateData['records'], ]); } return Response::send(0, null, [ 'html' => $html, 'page' => $page, 'pageSize' => $pageSize, 'total' => $paginateData['total'], ]); } $page = 1; $paginateData = MemberMoneyUtil::paginateCash($this->memberUserId(), $page, $pageSize, $option); return $this->_view('memberMoney.cashLog', [ 'total' => $paginateData['total'], 'page' => $page, 'pageSize' => $pageSize, 'records' => $paginateData['records'], ]); } }