<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Config\ConfigUtil; use TechSoft\Laravel\Html\HtmlType; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\Member\Traits\MemberProfileWebControllerTrait; use TechSoft\Laravel\Member\Type\Gender; use TechSoft\Laravel\Oauth\OauthType; class MemberProfileController extends BaseController implements MemberLoginCheck { public function index() { $isWechatAuth = false; if (ConfigUtil::get('oauthWechatEnable', false)) { $isWechatAuth = MemberUtil::getOauthOpenId($this->memberUserId(), OauthType::WECHAT); } $isQQAuth = false; if (ConfigUtil::get('oauthQQEnable', false)) { $isQQAuth = MemberUtil::getOauthOpenId($this->memberUserId(), OauthType::QQ); } $isWeiboAuth = false; if (ConfigUtil::get('oauthWeiboEnable', false)) { $isWeiboAuth = MemberUtil::getOauthOpenId($this->memberUserId(), OauthType::WEIBO); } return $this->_view('memberProfile.index', [ 'isQQAuth' => $isQQAuth, 'isWeiboAuth' => $isWeiboAuth, 'isWechatAuth' => $isWechatAuth, ]); } public function setting() { if (Request::isPost()) { $input = InputPackage::buildFromInput(); $data = []; $data['gender'] = $input->getType('gender', Gender::class, Gender::UNKNOWN); $data['signature'] = trim(Input::get('signature')); $data['noteEditorType'] = $input->getType('noteEditorType', HtmlType::class, HtmlType::RICH_TEXT); MemberUtil::update($this->memberUserId(), $data); return Response::send(0, '设置成功', null, '[reload]'); } return $this->_view('memberProfile.setting'); } }