<?php
 namespace App\Http\Controllers\Main; use App\Constant\PayConstant; use App\Events\CommentHasNewReplyEvent; use App\Events\NoteHasNewCommentEvent; use App\Events\NoteLikedEvent; use App\Http\Controllers\BaseController; use App\Types\NoteStatus; use App\Types\NoteTipOffStatus; use App\Types\NoteTipStatus; use App\Util\NoteUtil; use App\Util\TopicUtil; use Illuminate\Support\Facades\Event; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\Session; use Illuminate\Support\Facades\View; use Illuminate\Support\Str; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Config\ConfigUtil; use TechSoft\Laravel\Forum\Converter\AtMemberInterceptor; use TechSoft\Laravel\Html\HtmlConverter; use TechSoft\Laravel\Html\HtmlType; use TechSoft\Laravel\Html\SimpleEmotionConverterInterceptor; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\MemberFollow\MemberFollowUtil; use TechSoft\Laravel\Oauth\OauthType; use TechSoft\Laravel\Pay\PayUtil; use TechSoft\Laravel\Pay\Services\PayOrderUtil; use TechSoft\Laravel\Pay\Types\PayType; use TechSoft\Laravel\Util\HtmlUtil; class NoteController extends BaseController { public function view($alias) { $note = NoteUtil::getByAlias($alias); if (empty($note)) { return Response::send(-1, '文章不存在'); } if ($note['status'] != NoteStatus::VERIFY_PASS) { if (intval(Session::get('_adminUserId')) > 0) { } else { return Response::send(-1, '文章正在审核'); } } $note['_memberUser'] = MemberUtil::get($note['memberUserId']); $note['_memberUser']['_isFollowed'] = MemberFollowUtil::isFollowed($this->memberUserId(), $note['_memberUser']['id']); $note['_isLiked'] = NoteUtil::isLiked($this->memberUserId(), $note['id']); $d = HtmlUtil::extractTextAndImages($note['contentHtml']); $note['_summary'] = Str::limit($d['text'], 200); NoteUtil::update($note['id'], [ 'viewCount' => intval($note['viewCount']) + 1 ]); if (ConfigUtil::get('customTipEnable', false)) { $note['_noteTips'] = ModelUtil::all('note_tip', ['noteId' => $note['id'], 'status' => NoteTipStatus::SUCCESS], ['*'], ['id', 'desc']); ModelUtil::join($note['_noteTips'], 'tipMemberUserId', '_tipMemberUser', 'member_user', 'id'); } return $this->_view('note.view', compact( 'note' )); } public function like() { if (!$this->memberUserId()) { return Response::send(-1, '请先登录', null, '/login?redirect=' . urlencode(Request::currentPageUrl())); } $noteId = intval(Input::get('noteId')); $note = NoteUtil::get($noteId); if (empty($note)) { return Response::send(-1, '文章不存在'); } if (NoteUtil::isLiked($this->memberUserId(), $noteId)) { NoteUtil::unlike($this->memberUserId(), $noteId); return Response::send(0, null, [ 'action' => 'unliked', 'count' => max(intval($note['likeCount']) - 1, 0) ]); } else { NoteUtil::like($this->memberUserId(), $noteId); Event::fire(new NoteLikedEvent($note['id'], $this->memberUserId())); return Response::send(0, null, [ 'action' => 'liked', 'count' => intval($note['likeCount']) + 1 ]); } } public function fetchList() { $type = trim(Input::get('type')); $page = intval(Input::get('page', 1)); $pageSize = 20; $option = []; switch ($type) { case 'recommend': $option['order'] = ['id', 'desc']; $option['where'] = ['isRecommend' => true]; break; case 'comment': $option['order'] = ['commentCount', 'desc']; break; case 'hot': $option['order'] = ['viewCount', 'desc']; break; default: $option['order'] = ['id', 'desc']; break; } $paginateData = NoteUtil::paginateNotes($page, $pageSize, $option); MemberUtil::mergeMemberUsers($paginateData['records']); if (empty($paginateData['records'])) { $html = ''; } else { $html = $this->_viewRender('fragment.noteListItems', [ 'notes' => $paginateData['records'], ]); } return Response::json(0, null, [ 'total' => $paginateData['total'], 'page' => $page, 'pageSize' => $pageSize, 'html' => $html, ]); } public function commentList() { $noteId = intval(Input::get('noteId')); $page = intval(Input::get('page', 1)); $pageSize = 20; $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $option['where']['noteId'] = $noteId; $option['where']['rootCommentId'] = 0; $paginateData = ModelUtil::paginate('note_comment', $page, $pageSize, $option); $commentIds = []; $comments = $paginateData['records']; ModelUtil::join($comments, 'memberUserId', '_memberUser', 'member_user', 'id'); foreach ($comments as $i => $comment) { $commentIds[] = $comment['id']; $comments[$i]['_replies'] = []; $comments[$i]['_isLiked'] = false; } if (!empty($commentIds)) { $commentsReplies = ModelUtil::model('note_comment') ->whereIn('rootCommentId', $commentIds) ->orderBy('id', 'asc') ->get()->toArray(); if (!empty($commentsReplies)) { ModelUtil::join($commentsReplies, 'memberUserId', '_memberUser', 'member_user', 'id'); foreach ($comments as $i => $comment) { foreach ($commentsReplies as $j => $commentsReply) { if ($commentsReply['rootCommentId'] == $comments[$i]['id']) { $comments[$i]['_replies'][] = $commentsReply; unset($commentsReplies[$j]); } } } } $commentsLikes = ModelUtil::model('comment_like') ->whereIn('commentId', $commentIds) ->where(['memberUserId' => $this->memberUserId()]) ->get()->toArray(); $map = []; foreach ($commentsLikes as $commentsLike) { $map[$commentsLike['commentId']] = true; } foreach ($comments as $i => $comment) { if (!empty($map[$comment['id']])) { $comments[$i]['_isLiked'] = true; } } } $data = []; $data['total'] = $paginateData['total']; $data['page'] = $page; $data['pageSize'] = $pageSize; $data['html'] = $this->_viewRender('note.commentItem', compact('comments')); return Response::json(0, null, $data); } public function comment() { if (!$this->memberUserId()) { return Response::send(-1, '请先登录', null, '/login?redirect=' . urlencode(Request::currentPageUrl())); } $noteId = intval(Input::get('noteId')); $content = trim(Input::get('content')); if (empty($content)) { return Response::send(-1, '评论内容不能为空'); } $note = NoteUtil::get($noteId); if (empty($note)) { return Response::send(-1, '文章不存在'); } $content = HtmlConverter::convertToHtml(HtmlType::SIMPLE_TEXT, $content, [ SimpleEmotionConverterInterceptor::class, AtMemberInterceptor::class, ]); $data = []; $data['memberUserId'] = $this->memberUserId(); $data['noteId'] = $note['id']; $data['rootCommentId'] = 0; $data['content'] = $content; $comment = ModelUtil::insert('note_comment', $data); Event::fire(new NoteHasNewCommentEvent($note['id'], $comment['id'])); NoteUtil::updateNoteCommentStat($note['id']); return Response::send(0, null, [ ]); } public function commentReply() { if (!$this->memberUserId()) { return Response::send(-1, '请先登录', null, '/login?redirect=' . urlencode(Request::currentPageUrl())); } $noteId = intval(Input::get('noteId')); $commentId = intval(Input::get('commentId')); $content = trim(Input::get('content')); if (empty($content)) { return Response::send(-1, '回复内容不能为空'); } $note = NoteUtil::get($noteId); if (empty($note)) { return Response::send(-1, '文章不存在'); } $comment = ModelUtil::get('note_comment', ['id' => $commentId]); if (empty($comment)) { return Response::send(-1, '评论不存在'); } $content = HtmlConverter::convertToHtml(HtmlType::SIMPLE_TEXT, $content, [ SimpleEmotionConverterInterceptor::class, AtMemberInterceptor::class, ]); $data = []; $data['memberUserId'] = $this->memberUserId(); $data['noteId'] = $note['id']; $data['rootCommentId'] = $commentId; $data['content'] = $content; $reply = ModelUtil::insert('note_comment', $data); Event::fire(new CommentHasNewReplyEvent($comment['id'], $reply['id'])); $reply['_memberUser'] = $this->memberUser(); $html = $this->_viewRender('note.commentReplyItem', compact('comment', 'reply')); NoteUtil::updateNoteCommentStat($note['id']); return Response::send(0, null, [ 'html' => $html, ]); } public function commentLike() { if (!$this->memberUserId()) { return Response::send(-1, '请先登录', null, '/login?redirect=' . urlencode(Request::currentPageUrl())); } $commentId = intval(Input::get('commentId')); $comment = ModelUtil::get('note_comment', ['id' => $commentId]); if (empty($comment)) { return Response::send(-1, '评论不存在'); } if (NoteUtil::isCommentLiked($this->memberUserId(), $commentId)) { NoteUtil::unlikeComment($this->memberUserId(), $commentId); return Response::send(0, null, [ 'action' => 'unliked', 'count' => max(intval($comment['likeCount']) - 1, 0) ]); } else { NoteUtil::likeComment($this->memberUserId(), $commentId); return Response::send(0, null, [ 'action' => 'liked', 'count' => intval($comment['likeCount']) + 1 ]); } } public function commentDelete() { if (!$this->memberUserId()) { return Response::send(-1, '请先登录', null, '/login?redirect=' . urlencode(Request::currentPageUrl())); } $commentId = intval(Input::get('commentId')); $comment = ModelUtil::get('note_comment', ['id' => $commentId]); if (empty($comment)) { return Response::send(-1, '评论不存在'); } if ($comment['memberUserId'] != $this->memberUserId()) { return Response::send(-1, '评论删除失败'); } $replyComments = ModelUtil::all('note_comment', ['rootCommentId' => $commentId]); foreach ($replyComments as $replyComment) { ModelUtil::delete('comment_like', ['commentId' => $replyComment['id']]); } ModelUtil::delete('note_comment', ['rootCommentId' => $commentId]); ModelUtil::delete('note_comment', ['id' => $commentId]); NoteUtil::updateNoteCommentStat($comment['noteId']); return Response::send(0, null); } public function addToTopic($id) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $note = NoteUtil::get($id); if (empty($note)) { return Response::send(-1, '文章不存在'); } $pageSize = 5; $option = []; $option['order'] = ['id', 'desc']; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = TopicUtil::paginateMemberUserTopics($this->memberUserId(), $page, $pageSize, $option); $topics = $paginateData['records']; TopicUtil::mergeHasNote($topics, $note['id']); $html = $this->_viewRender('note.addToTopicListItems', [ 'note' => $note, 'topics' => $topics, ]); return Response::send(0, null, [ 'html' => $html, 'total' => $paginateData['total'], 'pageSize' => $pageSize, 'page' => $page, ]); } $paginateData = TopicUtil::paginateMemberUserTopics($this->memberUserId(), 1, $pageSize, $option); $topics = $paginateData['records']; TopicUtil::mergeHasNote($topics, $note['id']); return $this->_view('note.addToTopic', [ 'note' => $note, 'topics' => $topics, 'total' => $paginateData['total'], 'pageSize' => $pageSize, 'page' => 1, ]); } public function tip($id) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $note = NoteUtil::get($id); if (empty($note)) { return Response::send(-1, '文章不存在'); } $note['_memberUser'] = MemberUtil::get($note['memberUserId']); if (!$note['_memberUser']['tipEnable']) { return Response::send(-1, '用户已经关闭打赏'); } $input = InputPackage::buildFromInput(); $payType = $input->getType('payType', PayType::class, null); if (empty($payType)) { return Response::send(-1, '支付方式错误'); } if (!PayUtil::isPayEnable($payType)) { return Response::send(-1, '支付方式未开启'); } $money = trim(Input::get('money')); if ($money < 0.01) { return Response::send(-1, '打赏金额至少为0.01'); } $noteTip = ModelUtil::insert('note_tip', [ 'status' => NoteTipStatus::WAIT_PAY, 'memberUserId' => $note['memberUserId'], 'tipMemberUserId' => $this->memberUserId(), 'noteId' => $note['id'], 'money' => $money, 'msg' => trim(Input::get('msg')), ]); $data = []; $data['payType'] = $payType; switch ($payType) { case PayType::ALIPAY: $ret = PayOrderUtil::create( PayConstant::NOTE_TIP, $noteTip['id'], $payType, $noteTip['money'], '用户打赏-' . $noteTip['id'], '用户打赏-' . $noteTip['id'], '/n/' . $note['alias'], ['alipay_wap' => $this->isMobile() ? true : false] ); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $data['payRedirect'] = $ret['data']['link']; $data['successRedirect'] = '/n/' . $note['alias']; return Response::send(0, null, $data); case PayType::WECHAT_MOBILE: $openId = MemberUtil::getOauthOpenId($this->memberUserId(), OauthType::WECHAT_MOBILE); if (empty($openId)) { return Response::send(-1, null, null, '/oauth_login_' . OauthType::WECHAT_MOBILE . '?redirect=' . urlencode(View::shared('request_path'))); } $ret = PayOrderUtil::create( PayConstant::NOTE_TIP, $noteTip['id'], $payType, $noteTip['money'], '用户打赏-' . $noteTip['id'], '用户打赏-' . $noteTip['id'], '/n/' . $note['alias'], ['openId' => $openId] ); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $data['json'] = $ret['data']['json']; $data['successRedirect'] = $ret['data']['successRedirect']; return Response::send(0, null, $data); case PayType::WECHAT: $ret = PayOrderUtil::create( PayConstant::NOTE_TIP, $noteTip['id'], $payType, $noteTip['money'], '用户打赏-' . $noteTip['id'], '用户打赏-' . $noteTip['id'], '/n/' . $note['alias'], [] ); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $data['codeUrl'] = $ret['data']['codeUrl']; $data['successRedirect'] = $ret['data']['successRedirect']; $data['watchUrl'] = '/note/tip_watch/' . $noteTip['id']; return Response::send(0, null, $data); default: return Response::send(-1, '支付方式错误'); } } public function tipWatch($id) { $noteTip = ModelUtil::get('note_tip', ['id' => $id, 'tipMemberUserId' => $this->memberUserId()]); switch ($noteTip['status']) { case NoteTipStatus::WAIT_PAY: return Response::send(0, null, ['status' => 'new']); case NoteTipStatus::SUCCESS: return Response::send(0, null, ['status' => 'payed']); default: return Response::send(-1, 'order status error'); } } public function tipOff($id) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $note = NoteUtil::get($id); if (empty($note)) { return Response::send(-1, '文章不存在'); } if (Request::isPost()) { $type = trim(Input::get('type')); $remark = trim(Input::get('remark')); if (empty($type)) { return Response::send(-1, '请选择举报类型'); } if (empty($remark)) { return Response::send(-1, '请填写举报说明'); } ModelUtil::insert('note_tip_off', [ 'status' => NoteTipOffStatus::WAIT_PROCESS, 'memberUserId' => $this->memberUserId(), 'noteId' => $note['id'], 'type' => $type, 'remark' => $remark, ]); return Response::send(0, '举报成功', null, '[js]$.dialogClose();'); } return $this->_view('note.tipOff', [ 'note' => $note, ]); } }