<?php
 namespace App\Http\Controllers\Main; use App\Events\TopicHasNewNoteApplyAddedEvent; use App\Events\TopicHasNewNoteApplyEvent; use App\Events\TopicNoteApplyPassEvent; use App\Events\TopicNoteApplyRejectEvent; use App\Http\Controllers\BaseController; use App\Util\NoteUtil; use App\Util\TopicUtil; use Illuminate\Support\Facades\Event; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\View; use Illuminate\Support\Str; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\MemberFollow\MemberFollowUtil; class TopicController extends BaseController { public function frameViewGlobal($alias) { $topic = TopicUtil::getByAlias($alias); if (empty($topic)) { return Response::send(-1, '专题不存在'); } $topic['_memberUser'] = MemberUtil::get($topic['memberUserId']); $topic['_isFollowed'] = TopicUtil::isFollowed($this->memberUserId(), $topic['id']); View::share('topic', $topic); $option = []; $option['order'] = ['id', 'desc']; $paginateData = TopicUtil::paginateFollowerMemberUsers($topic['id'], 1, 15, $option); $latestFollowers = $paginateData['records']; View::share('latestFollowers', $latestFollowers); return Response::generate(0, null, [ 'topic' => $topic ]); } public function view($alias) { $ret = $this->frameViewGlobal($alias); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $topic = $ret['data']['topic']; $pageSize = 20; $option = ['order' => ['id', 'desc']]; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = TopicUtil::paginateTopicNotes($topic['id'], $page, $pageSize, $option); $notes = $paginateData['records']; MemberUtil::mergeMemberUsers($notes); $html = $this->_viewRender('fragment.noteListItems', [ 'topic' => $topic, 'notes' => $notes, ]); return Response::json(0, null, [ 'total' => $paginateData['total'], 'page' => $page, 'pageSize' => $pageSize, 'html' => $html, ]); } $page = 1; $paginateData = TopicUtil::paginateTopicNotes($topic['id'], $page, $pageSize, $option); $notes = $paginateData['records']; MemberUtil::mergeMemberUsers($notes); return $this->_view('topic.view', [ 'notes' => $notes, 'topic' => $topic, 'total' => $paginateData['total'], 'pageSize' => $pageSize, ]); } public function edit($id = 0) { if (!$this->memberUserId()) { return Response::send(0, null, null, '/member'); } if ($id) { $topic = ModelUtil::get('topic', ['id' => $id, 'memberUserId' => $this->memberUserId()]); if (empty($topic)) { return Response::send(-1, '专题不存在'); } } else { $topic = null; } if (Request::isPost()) { $saveTopic = []; $saveTopic['cover'] = trim(Input::get('cover')); $saveTopic['title'] = trim(Input::get('title')); $saveTopic['description'] = trim(Input::get('description')); $saveTopic['pushEnable'] = (Input::get('pushEnable') ? true : false); $saveTopic['pushVerify'] = (Input::get('pushVerify') ? true : false); if (empty($saveTopic['cover'])) { return Response::send(-1, '封面不能为空'); } if (empty($saveTopic['title'])) { return Response::send(-1, '名称不能为空'); } if (empty($saveTopic['description'])) { return Response::send(-1, '描述不能为空'); } if ($topic) { ModelUtil::update('topic', ['id' => $topic['id']], $saveTopic); $saveTopic = ModelUtil::get('topic', $topic['id']); } else { $saveTopic['alias'] = strtolower(Str::random(8)); $saveTopic['memberUserId'] = $this->memberUserId(); $saveTopic = ModelUtil::insert('topic', $saveTopic); } return Response::send(0, '操作成功', null, '/t/' . $saveTopic['alias']); } return $this->_view('topic.edit', compact( 'topic' )); } public function follow() { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $topicId = intval(Input::get('topicId')); if (TopicUtil::isFollowed($this->memberUserId(), $topicId)) { TopicUtil::unfollow($this->memberUserId(), $topicId); return Response::send(0, 'ok', ['action' => 'unfollowed']); } else { TopicUtil::follow($this->memberUserId(), $topicId); return Response::send(0, 'ok', ['action' => 'followed']); } } public function noteSelect($id) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $topic = TopicUtil::get($id); if (empty($topic)) { return Response::send(-1, '专题不存在'); } $pageSize = 10; $option = []; $option['order'] = ['id', 'desc']; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = NoteUtil::paginateMemberUserNotes($this->memberUserId(), $page, $pageSize, $option); $notes = $paginateData['records']; TopicUtil::mergeIsInTopic($notes, $topic['id']); $html = $this->_viewRender('topic.noteSelectListItems', [ 'topic' => $topic, 'notes' => $notes, ]); return Response::send(0, null, [ 'html' => $html, 'total' => $paginateData['total'], 'pageSize' => $pageSize, 'page' => $page, ]); } $paginateData = NoteUtil::paginateMemberUserNotes($this->memberUserId(), 1, $pageSize, $option); $notes = $paginateData['records']; TopicUtil::mergeIsInTopic($notes, $topic['id']); return $this->_view('topic.noteSelect', [ 'topic' => $topic, 'total' => $paginateData['total'], 'pageSize' => $pageSize, 'notes' => $notes, 'page' => 1, ]); } public function noteAdd($topicId, $noteId) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $topic = TopicUtil::get($topicId); if (empty($topic)) { return Response::send(-1, '专题不存在'); } if ($topic['memberUserId'] != $this->memberUserId()) { return Response::send(-1, '操作不被允许'); } $note = NoteUtil::get($noteId); if (empty($note)) { return Response::send(-1, '文章不存在'); } TopicUtil::addNote($topicId, $noteId); return Response::send(0, null, null, '[js]window.__refresh()'); } public function noteRemove($topicId, $noteId) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $topic = TopicUtil::get($topicId); if (empty($topic)) { return Response::send(-1, '专题不存在'); } $note = NoteUtil::get($noteId); if (empty($note)) { return Response::send(-1, '文章不存在'); } if ($note['memberUserId'] != $this->memberUserId() && $topic['memberUserId'] != $this->memberUserId()) { return Response::send(-1, '操作不被允许'); } TopicUtil::removeNote($topicId, $noteId); return Response::send(0, null, null, '[js]window.__refresh()'); } public function followers($alias) { $ret = $this->frameViewGlobal($alias); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $topic = $ret['data']['topic']; $pageSize = 20; $option = []; $option['order'] = ['id', 'desc']; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = TopicUtil::paginateFollowerMemberUsers($topic['id'], $page, $pageSize, $option); $memberUsers = $paginateData['records']; MemberFollowUtil::mergeIsFollowed($memberUsers, $this->memberUserId()); $html = $this->_viewRender('fragment.memberUserListItems', [ 'memberUsers' => $memberUsers, ]); return Response::send(0, null, [ 'html' => $html, 'total' => $paginateData['total'], 'pageSize' => $pageSize, 'page' => $page, ]); } $paginateData = TopicUtil::paginateFollowerMemberUsers($topic['id'], 1, $pageSize, $option); $memberUsers = $paginateData['records']; MemberFollowUtil::mergeIsFollowed($memberUsers, $this->memberUserId()); return $this->_view('topic.followers', [ 'total' => $paginateData['total'], 'pageSize' => $pageSize, 'memberUsers' => $memberUsers, 'page' => 1, ]); } public function noteContribute($id) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $topic = TopicUtil::get($id); if (empty($topic)) { return Response::send(-1, '专题不存在'); } if (!$topic['pushEnable']) { return Response::send(-1, '专题不允许投稿'); } $pageSize = 10; $option = []; $option['order'] = ['id', 'desc']; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = NoteUtil::paginateMemberUserNotes($this->memberUserId(), $page, $pageSize, $option); $notes = $paginateData['records']; TopicUtil::mergeIsInTopic($notes, $topic['id']); TopicUtil::mergeIsInTopicApply($notes, $topic['id']); $html = $this->_viewRender('topic.noteContributeListItems', [ 'topic' => $topic, 'notes' => $notes, ]); return Response::send(0, null, [ 'html' => $html, 'total' => $paginateData['total'], 'pageSize' => $pageSize, 'page' => $page, ]); } $paginateData = NoteUtil::paginateMemberUserNotes($this->memberUserId(), 1, $pageSize, $option); $notes = $paginateData['records']; TopicUtil::mergeIsInTopic($notes, $topic['id']); TopicUtil::mergeIsInTopicApply($notes, $topic['id']); return $this->_view('topic.noteContribute', [ 'topic' => $topic, 'total' => $paginateData['total'], 'pageSize' => $pageSize, 'notes' => $notes, 'page' => 1, ]); } public function noteApply($topicId, $noteId) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $topic = TopicUtil::get($topicId); if (empty($topic)) { return Response::send(-1, '专题不存在'); } if (!$topic['pushEnable']) { return Response::send(-1, '专题不允许投稿'); } $note = NoteUtil::get($noteId); if (empty($note)) { return Response::send(-1, '文章不存在'); } if ($note['memberUserId'] != $this->memberUserId()) { return Response::send(-1, '操作不被允许'); } if ($topic['pushVerify']) { TopicUtil::addNoteApply($topicId, $noteId); Event::fire(new TopicHasNewNoteApplyEvent($topicId, $noteId)); } else { TopicUtil::addNote($topicId, $noteId); Event::fire(new TopicHasNewNoteApplyAddedEvent($topicId, $noteId)); } return Response::send(0, null, null, '[js]window.__refresh()'); } public function noteApplyRevert($topicId, $noteId) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $topic = TopicUtil::get($topicId); if (empty($topic)) { return Response::send(-1, '专题不存在'); } $note = NoteUtil::get($noteId); if (empty($note)) { return Response::send(-1, '文章不存在'); } if ($note['memberUserId'] != $this->memberUserId()) { return Response::send(-1, '操作不被允许'); } TopicUtil::removeNoteApply($topicId, $noteId); return Response::send(0, null, null, '[js]window.__refresh()'); } public function noteContributeVerify($id) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $topic = TopicUtil::get($id); if (empty($topic)) { return Response::send(-1, '专题不存在'); } if (!$topic['pushEnable']) { return Response::send(-1, '专题不允许投稿'); } if ($topic['memberUserId'] != $this->memberUserId()) { return Response::send(-1, '操作不被允许'); } $pageSize = 10; $option = []; $option['order'] = ['id', 'desc']; if (Request::isPost()) { $page = intval(Input::get('page', 1)); $paginateData = TopicUtil::paginateTopicNoteApplies($topic['id'], $page, $pageSize, $option); $notes = $paginateData['records']; TopicUtil::mergeIsInTopic($notes, $topic['id']); $html = $this->_viewRender('topic.noteContributeVerifyListItems', [ 'topic' => $topic, 'notes' => $notes, ]); return Response::send(0, null, [ 'html' => $html, 'total' => $paginateData['total'], 'pageSize' => $pageSize, 'page' => $page, ]); } $paginateData = TopicUtil::paginateTopicNoteApplies($topic['id'], 1, $pageSize, $option); $notes = $paginateData['records']; TopicUtil::mergeIsInTopic($notes, $topic['id']); return $this->_view('topic.noteContributeVerify', [ 'topic' => $topic, 'total' => $paginateData['total'], 'pageSize' => $pageSize, 'notes' => $notes, 'page' => 1, ]); } public function noteContributeVerifyPass($id, $noteId) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $topic = TopicUtil::get($id); if (empty($topic)) { return Response::send(-1, '专题不存在'); } if ($topic['memberUserId'] != $this->memberUserId()) { return Response::send(-1, '操作不被允许'); } $note = NoteUtil::get($noteId); if (empty($note)) { return Response::send(-1, '文章不存在'); } TopicUtil::removeNoteApply($topic['id'], $note['id']); TopicUtil::addNote($topic['id'], $note['id']); Event::fire(new TopicNoteApplyPassEvent($topic['id'], $noteId)); return Response::send(0, null, null, '[js]window.__refresh()'); } public function noteContributeVerifyReject($id, $noteId) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录'); } $topic = TopicUtil::get($id); if (empty($topic)) { return Response::send(-1, '专题不存在'); } if ($topic['memberUserId'] != $this->memberUserId()) { return Response::send(-1, '操作不被允许'); } $note = NoteUtil::get($noteId); if (empty($note)) { return Response::send(-1, '文章不存在'); } TopicUtil::removeNoteApply($topic['id'], $note['id']); Event::fire(new TopicNoteApplyRejectEvent($topic['id'], $noteId)); return Response::send(0, null, null, '[js]window.__refresh()'); } public function fetchList() { $type = Input::get('type'); $pageSize = 10; $option = []; if ($type == 'hot') { $option['order'] = ['noteCount', 'desc']; } else { $option['order'] = ['id', 'desc']; } $page = intval(Input::get('page', 1)); $paginateData = TopicUtil::paginateTopics($page, $pageSize, $option); if (empty($paginateData['records'])) { $html = null; } else { TopicUtil::mergeIsFollowed($paginateData['records'], $this->memberUserId()); $html = $this->_viewRender('fragment.topicListItems', [ 'topics' => $paginateData['records'], ]); } return Response::send(0, null, [ 'html' => $html, 'page' => $page, 'pageSize' => $pageSize, 'total' => $paginateData['total'], ]); } }