<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use App\Types\NoteStatus; use App\Util\NoteUtil; use Illuminate\Support\Facades\Input; use Illuminate\Support\Str; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Config\ConfigUtil; use TechSoft\Laravel\Html\HtmlConverter; use TechSoft\Laravel\Html\HtmlType; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; use TechSoft\Laravel\Util\HtmlUtil; class WriterController extends BaseController implements MemberLoginCheck { public function index() { return $this->_view('writer.index'); } public function categoryList() { $categories = ModelUtil::all('member_note_category', ['memberUserId' => $this->memberUserId()]); $list = []; $list [] = [ 'id' => 0, 'title' => '全部' ]; foreach ($categories as $category) { $list[] = [ 'id' => $category['id'], 'title' => $category['title'], ]; } return Response::send(0, null, compact('list')); } public function categoryEdit() { $id = intval(Input::get('id')); if ($id) { $category = ModelUtil::get('member_note_category', [ 'id' => $id, 'memberUserId' => $this->memberUserId() ]); if (empty($category)) { return Response::send(-1, '文集不存在'); } } else { $category = null; } $data = []; $data['title'] = trim(Input::get('title')); if (empty($data['title'])) { return Response::send(-1, '名称不能为空'); } if ($category) { ModelUtil::update('member_note_category', ['id' => $id], $data); $category = ModelUtil::get('member_note_category', $id); } else { $data['memberUserId'] = $this->memberUserId(); $category = ModelUtil::insert('member_note_category', $data); } return Response::send(0, null, [ 'categoryId' => $category['id'] ]); } public function categoryDelete() { $id = intval(Input::get('id')); $category = ModelUtil::get('member_note_category', [ 'id' => $id, 'memberUserId' => $this->memberUserId() ]); if (empty($category)) { return Response::send(-1, '文集不存在'); } ModelUtil::delete('member_note_category', ['id' => $category['id']]); ModelUtil::update('member_note', ['categoryId' => $category['id']], ['categoryId' => 0]); return Response::send(0, null); } public function noteList() { $page = Input::get('page'); $pageSize = 20; $option = []; $option['where'] = []; $option['where']['memberUserId'] = $this->memberUserId(); $option['order'] = []; $option['order'][] = ['updated_at', 'desc']; $categoryId = intval(Input::get('categoryId')); if ($categoryId) { $option['where']['categoryId'] = $categoryId; } $paginateData = ModelUtil::paginate('member_note', $page, $pageSize, $option); $list = []; foreach ($paginateData['records'] as $record) { $list[] = [ 'id' => $record['id'], 'title' => $record['title'], 'time' => $record['updated_at'], 'summary' => HtmlUtil::text($record['content'], 100), 'isPublished' => ($record['isPublished'] ? true : false), ]; } $paginateData = ModelUtil::paginate('member_note', $page + 1, $pageSize, $option); $hasMore = empty($paginateData['records']) ? false : true; return Response::send(0, null, compact('list', 'page', 'hasMore')); } public function noteEditOperate() { $id = intval(Input::get('id')); $note = ModelUtil::get('member_note', [ 'id' => $id, 'memberUserId' => $this->memberUserId() ]); if (empty($note)) { return Response::send(-1, '文章不存在'); } $data = []; $data['categoryId'] = intval(Input::get('categoryId')); ModelUtil::update('member_note', ['id' => $id], $data); $note = ModelUtil::get('member_note', $id); return Response::send(0, null, [ 'note' => [ 'id' => $note['id'], 'categoryId' => $note['categoryId'], ] ]); } public function noteEdit() { $id = intval(Input::get('id')); if ($id) { $note = ModelUtil::get('member_note', [ 'id' => $id, 'memberUserId' => $this->memberUserId() ]); if (empty($note)) { return Response::send(-1, '文章不存在'); } } else { $note = null; } $data = []; $input = InputPackage::buildFromInput(); $data['categoryId'] = intval(Input::get('categoryId')); $data['title'] = trim(Input::get('title')); $data['contentType'] = $input->getType('contentType', HtmlType::class, ConfigUtil::get('editorType', HtmlType::RICH_TEXT)); $data['content'] = trim(Input::get('content')); $data['content'] = HtmlUtil::filter2($data['content']); if (empty($data['title'])) { return Response::send(-1, '标题不能为空'); } if (empty($data['content'])) { return Response::send(-1, '内容不能为空'); } if ($note) { if ($note['title'] != $data['title'] || $note['content'] != $data['content']) { ModelUtil::insert('member_note_history', [ 'memberNoteId' => $note['id'], 'title' => $note['title'], 'content' => $note['content'], ]); $limit = intval(ConfigUtil::get('customMemberNoteHistoryKeep', 50)); $oldHistory = ModelUtil::model('member_note_history') ->where(['memberNoteId' => $note['id'],]) ->select('id') ->orderBy('id', 'desc') ->limit($limit) ->get() ->toArray(); $minId = $oldHistory[count($oldHistory) - 1]['id']; ModelUtil::model('member_note_history') ->where(['memberNoteId' => $note['id'],]) ->where('id', '<', $minId) ->delete(); } ModelUtil::update('member_note', ['id' => $id], $data); } else { $data['memberUserId'] = $this->memberUserId(); $note = ModelUtil::insert('member_note', $data); } $note = ModelUtil::get('member_note', ['id' => $note['id']]); $publishNoteAlias = null; if ($publishNote = ModelUtil::get('note', ['memberNoteId' => $note['id'], 'isDeleted' => false])) { $publishNoteAlias = $publishNote['alias']; } return Response::send(0, null, [ 'note' => [ 'id' => $note['id'], 'categoryId' => $note['categoryId'], 'title' => $note['title'], 'isPublished' => $note['isPublished'] ? true : false, 'contentType' => intval($note['contentType']), 'content' => $note['content'], '_publishNoteAlias' => $publishNoteAlias, ] ]); } public function noteGet() { $id = intval(Input::get('id')); $note = ModelUtil::get('member_note', [ 'id' => $id, 'memberUserId' => $this->memberUserId() ]); if (empty($note)) { return Response::send(-1, '文章不存在'); } $publishNoteAlias = null; if ($publishNote = ModelUtil::get('note', ['memberNoteId' => $note['id'], 'isDeleted' => false])) { $publishNoteAlias = $publishNote['alias']; } return Response::send(0, null, [ 'note' => [ 'id' => $note['id'], 'categoryId' => $note['categoryId'], 'title' => $note['title'], 'isPublished' => $note['isPublished'] ? true : false, 'contentType' => intval($note['contentType']), 'content' => $note['content'], '_publishNoteAlias' => $publishNoteAlias ] ]); } public function noteDelete() { $id = intval(Input::get('id')); $memberNote = ModelUtil::get('member_note', [ 'id' => $id, 'memberUserId' => $this->memberUserId() ]); if (empty($memberNote)) { return Response::send(-1, '文章不存在'); } ModelUtil::delete('member_note', ['id' => $memberNote['id']]); ModelUtil::delete('member_note_history', ['memberNoteId' => $memberNote['id']]); NoteUtil::deleteByMemberNoteId($memberNote['id']); return Response::send(0, null); } public function noteHistory() { $id = intval(Input::get('id')); $note = ModelUtil::get('member_note', ['id' => $id, 'memberUserId' => $this->memberUserId()]); if (empty($note)) { return Response::send(-1, '文章不存在'); } $histories = []; $records = ModelUtil::all('member_note_history', ['memberNoteId' => $note['id']], ['*'], ['id', 'desc']); foreach ($records as $record) { $histories[] = [ 'id' => $record['id'], 'title' => $record['title'], 'time' => $record['created_at'], 'content' => $record['content'], ]; } return Response::send(0, null, compact('histories')); } public function notePublish() { $id = intval(Input::get('id')); $memberNote = ModelUtil::get('member_note', ['id' => $id, 'memberUserId' => $this->memberUserId()]); if (empty($memberNote)) { return Response::send(-1, '文章不存在'); } $note = ModelUtil::get('note', ['memberNoteId' => $memberNote['id']]); if (empty($note)) { $note['id'] = 0; $note['memberUserId'] = $this->memberUserId(); $note['memberNoteId'] = $memberNote['id']; $note['alias'] = strtolower(Str::random(8)); } $note['isDeleted'] = false; $note['title'] = $memberNote['title']; $note['contentHtml'] = HtmlConverter::convertToHtml( $memberNote['contentType'], $memberNote['content'] ); $note['wordCount'] = HtmlUtil::workCount($memberNote['content']); $note['status'] = NoteStatus::WAIT_VERIFY; if ($note['id']) { ModelUtil::update('note', ['id' => $note['id']], $note); $note = ModelUtil::get('note', $note['id']); } else { $note = ModelUtil::insert('note', $note); } ModelUtil::update('member_note', ['id' => $memberNote['id']], ['isPublished' => true]); ModelUtil::update('note_like', ['noteId' => $note['id']], ['isDeleted' => false]); ModelUtil::update('topic_note', ['noteId' => $note['id']], ['isDeleted' => false]); $this->updateMemberUserNoteStat(); return Response::send(0, '发布成功', [ 'alias' => $note['alias'], ]); } public function notePublishCancel() { $id = intval(Input::get('id')); $memberNote = ModelUtil::get('member_note', ['id' => $id, 'memberUserId' => $this->memberUserId()]); if (empty($memberNote)) { return Response::send(-1, '文章不存在'); } $note = ModelUtil::get('note', ['memberNoteId' => $memberNote['id']]); if (empty($note)) { return Response::send(-1, '发布文章不存在'); } ModelUtil::update('note', ['id' => $note['id']], ['isDeleted' => true]); ModelUtil::update('member_note', ['id' => $memberNote['id']], ['isPublished' => false]); ModelUtil::update('note_like', ['noteId' => $note['id']], ['isDeleted' => true]); ModelUtil::update('topic_note', ['noteId' => $note['id']], ['isDeleted' => true]); ModelUtil::delete('topic_note_apply', ['noteId' => $note['id']]); $this->updateMemberUserNoteStat(); return Response::send(0, '取消发布成功', []); } private function updateMemberUserNoteStat() { $noteCount = ModelUtil::count('note', ['memberUserId' => $this->memberUserId(), 'isDeleted' => false]); $wordCount = ModelUtil::sum('note', 'wordCount', ['memberUserId' => $this->memberUserId(), 'isDeleted' => false]); ModelUtil::update('member_user', ['id' => $this->memberUserId()], [ 'noteCount' => $noteCount, 'wordCount' => $wordCount, ]); } }