<?php
 namespace App\Listeners; use App\Events\CommentHasNewReplyEvent; use App\Events\NoteHasNewCommentEvent; use App\Events\NoteHasNewTipEvent; use App\Events\NoteLikedEvent; use App\Events\TopicHasNewNoteApplyAddedEvent; use App\Events\TopicHasNewNoteApplyEvent; use App\Events\TopicNoteApplyPassEvent; use App\Events\TopicNoteApplyRejectEvent; use App\Util\NoteUtil; use App\Util\TopicUtil; use TechOnline\Laravel\Dao\ModelUtil; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\MemberMessage\MemberMessageUtil; class NoteListener { public function onNoteLiked(NoteLikedEvent $event) { $note = NoteUtil::get($event->noteId); $memberUser = MemberUtil::get($event->memberUserId); MemberMessageUtil::sendTemplate($note['memberUserId'], 'noteLiked', [ 'memberUser' => $memberUser, 'note' => $note, ]); MemberUtil::updateNewMessageStatus($note['memberUserId']); } public function onNoteHasNewComment(NoteHasNewCommentEvent $event) { $note = NoteUtil::get($event->noteId); $comment = NoteUtil::getComment($event->commentId); $comment['_memberUser'] = MemberUtil::get($comment['memberUserId']); MemberMessageUtil::sendTemplate($note['memberUserId'], 'noteHasNewComment', [ 'comment' => $comment, 'note' => $note, ]); MemberUtil::updateNewMessageStatus($note['memberUserId']); } public function onNoteHasNewTip(NoteHasNewTipEvent $event) { $note = NoteUtil::get($event->noteId); $noteTip = ModelUtil::get('note_tip', ['id' => $event->tipId,]); $noteTip['_tipMemberUser'] = MemberUtil::get($noteTip['tipMemberUserId']); MemberMessageUtil::sendTemplate($note['memberUserId'], 'noteHasNewTip', [ 'noteTip' => $noteTip, 'note' => $note, ]); MemberUtil::updateNewMessageStatus($note['memberUserId']); } public function onCommentHasNewReply(CommentHasNewReplyEvent $event) { $comment = NoteUtil::getComment($event->commentId); $note = NoteUtil::get($comment['noteId']); $reply = NoteUtil::getComment($event->replyId); $reply['_memberUser'] = MemberUtil::get($reply['memberUserId']); MemberMessageUtil::sendTemplate($note['memberUserId'], 'commentHasNewReply', [ 'comment' => $comment, 'reply' => $reply, 'note' => $note, ]); MemberUtil::updateNewMessageStatus($note['memberUserId']); } public function onTopicHasNewNoteApply(TopicHasNewNoteApplyEvent $event) { $topic = TopicUtil::get($event->topicId); $note = NoteUtil::get($event->noteId); $note['_memberUser'] = MemberUtil::get($note['memberUserId']); MemberMessageUtil::sendTemplate($topic['memberUserId'], 'topicHasNewNoteApply', [ 'topic' => $topic, 'note' => $note, ]); MemberUtil::updateNewMessageStatus($topic['memberUserId']); } public function onTopicHasNewNoteApplyAdded(TopicHasNewNoteApplyAddedEvent $event) { $topic = TopicUtil::get($event->topicId); $note = NoteUtil::get($event->noteId); $note['_memberUser'] = MemberUtil::get($note['memberUserId']); MemberMessageUtil::sendTemplate($topic['memberUserId'], 'topicHasNewNoteApplyAdded', [ 'topic' => $topic, 'note' => $note, ]); MemberUtil::updateNewMessageStatus($topic['memberUserId']); } public function onTopicNoteApplyPass(TopicNoteApplyPassEvent $event) { $topic = TopicUtil::get($event->topicId); $note = NoteUtil::get($event->noteId); MemberMessageUtil::sendTemplate($note['memberUserId'], 'topicNoteApplyPass', [ 'topic' => $topic, 'note' => $note, ]); MemberUtil::updateNewMessageStatus($note['memberUserId']); } public function onTopicNoteApplyReject(TopicNoteApplyRejectEvent $event) { $topic = TopicUtil::get($event->topicId); $note = NoteUtil::get($event->noteId); MemberMessageUtil::sendTemplate($note['memberUserId'], 'topicNoteApplyReject', [ 'topic' => $topic, 'note' => $note, ]); MemberUtil::updateNewMessageStatus($note['memberUserId']); } public function subscribe($events) { $events->listen(NoteLikedEvent::class, '\App\Listeners\NoteListener@onNoteLiked'); $events->listen(NoteHasNewCommentEvent::class, '\App\Listeners\NoteListener@onNoteHasNewComment'); $events->listen(CommentHasNewReplyEvent::class, '\App\Listeners\NoteListener@onCommentHasNewReply'); $events->listen(TopicHasNewNoteApplyEvent::class, '\App\Listeners\NoteListener@onTopicHasNewNoteApply'); $events->listen(TopicHasNewNoteApplyAddedEvent::class, '\App\Listeners\NoteListener@onTopicHasNewNoteApplyAdded'); $events->listen(TopicNoteApplyPassEvent::class, '\App\Listeners\NoteListener@onTopicNoteApplyPass'); $events->listen(TopicNoteApplyRejectEvent::class, '\App\Listeners\NoteListener@onTopicNoteApplyReject'); $events->listen(NoteHasNewTipEvent::class, '\App\Listeners\NoteListener@onNoteHasNewTip'); } }