<?php
 namespace App\Util; use Illuminate\Support\Str; use TechOnline\Laravel\Dao\ModelUtil; use TechSoft\Laravel\Util\HtmlUtil; class NoteUtil { public static function getByAlias($alias) { return ModelUtil::get('note', ['alias' => $alias, 'isDeleted' => false,]); } public static function get($id) { return ModelUtil::get('note', ['id' => $id, 'isDeleted' => false,]); } public static function update($noteId, $data) { return ModelUtil::update('note', ['id' => $noteId], $data); } public static function paginateMemberUserNotes($memberUserId, $page, $pageSize, $option = []) { $option['where']['memberUserId'] = $memberUserId; $option['where']['isDeleted'] = false; $paginateData = ModelUtil::paginate('note', $page, $pageSize, $option); foreach ($paginateData['records'] as &$record) { $d = HtmlUtil::extractTextAndImages($record['contentHtml']); $record['_summary'] = Str::limit($d['text'], 200); $record['_cover'] = (empty($d['images'][0]) ? null : $d['images'][0]); } return $paginateData; } public static function paginateNotes($page, $pageSize, $option = []) { $option['where']['isDeleted'] = false; $paginateData = ModelUtil::paginate('note', $page, $pageSize, $option); foreach ($paginateData['records'] as &$record) { $d = HtmlUtil::extractTextAndImages($record['contentHtml']); $record['_summary'] = Str::limit($d['text'], 200); $record['_cover'] = (empty($d['images'][0]) ? null : $d['images'][0]); } return $paginateData; } private static function updateNoteLikeStat($noteId) { $count = ModelUtil::count('note_like', ['noteId' => $noteId]); ModelUtil::update('note', ['id' => $noteId], [ 'likeCount' => $count, ]); } public static function isLiked($memberUserId, $noteId) { $data = [ 'noteId' => $noteId, 'memberUserId' => $memberUserId, ]; if (ModelUtil::exists('note_like', $data)) { return true; } return false; } public static function like($memberUserId, $noteId) { $data = [ 'noteId' => $noteId, 'memberUserId' => $memberUserId, 'isDeleted' => false, ]; if (!ModelUtil::exists('note_like', $data)) { ModelUtil::insert('note_like', $data); self::updateNoteLikeStat($noteId); } } public static function unlike($memberUserId, $noteId) { $data = [ 'noteId' => $noteId, 'memberUserId' => $memberUserId, ]; ModelUtil::delete('note_like', $data); self::updateNoteLikeStat($noteId); } public static function paginateLikeNotes($memberUserId, $page, $pageSize, $option = []) { $option['where']['memberUserId'] = $memberUserId; $option['where']['isDeleted'] = false; $paginateData = ModelUtil::paginate('note_like', $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'noteId', '_note', 'note', 'id'); $notes = []; foreach ($paginateData['records'] as $item) { if (empty($item['_note'])) { ModelUtil::delete('note_like', ['id' => $item['id']]); continue; } $notes[] = $item['_note']; } foreach ($notes as &$note) { $d = HtmlUtil::extractTextAndImages($note['contentHtml']); $note['_summary'] = Str::limit($d['text'], 200); $note['_cover'] = (empty($d['images'][0]) ? null : $d['images'][0]); } $paginateData['records'] = $notes; return $paginateData; } public static function updateNoteCommentStat($noteId) { $commentCount = ModelUtil::count('note_comment', ['noteId' => $noteId]); ModelUtil::update('note', ['id' => $noteId], ['commentCount' => $commentCount]); } public static function updateNoteCommentLikeStat($commentId) { $likeCount = ModelUtil::count('comment_like', ['commentId' => $commentId]); ModelUtil::update('note_comment', ['id' => $commentId], ['likeCount' => $likeCount]); } public static function isCommentLiked($memberUserId, $commentId) { $data = [ 'commentId' => $commentId, 'memberUserId' => $memberUserId, ]; if (ModelUtil::exists('comment_like', $data)) { return true; } return false; } public static function likeComment($memberUserId, $commentId) { $data = [ 'commentId' => $commentId, 'memberUserId' => $memberUserId, ]; if (!ModelUtil::exists('comment_like', $data)) { ModelUtil::insert('comment_like', $data); self::updateNoteCommentLikeStat($commentId); } } public static function unlikeComment($memberUserId, $commentId) { $data = [ 'commentId' => $commentId, 'memberUserId' => $memberUserId, ]; ModelUtil::delete('comment_like', $data); self::updateNoteCommentLikeStat($commentId); } public static function getComment($commentId) { return ModelUtil::get('note_comment', ['id' => $commentId]); } public static function delete($id) { ModelUtil::delete('note', ['id' => $id]); ModelUtil::delete('topic_note_apply', ['noteId' => $id]); ModelUtil::delete('topic_note', ['noteId' => $id]); ModelUtil::delete('note_comment', ['noteId' => $id]); ModelUtil::delete('note_like', ['noteId' => $id]); ModelUtil::delete('note_tip', ['noteId' => $id]); ModelUtil::delete('note_tip_off', ['noteId' => $id]); } public static function deleteByMemberNoteId($memberNoteId) { $m = ModelUtil::get('note', ['memberNoteId' => $memberNoteId]); if (!empty($m)) { self::delete($m['id']); } } }