<?php
 namespace App\Util; use Illuminate\Support\Str; use TechOnline\Laravel\Dao\ModelUtil; use TechSoft\Laravel\Util\HtmlUtil; class TopicUtil { public static function listMemberUserTopics($memberUserId) { return ModelUtil::all('topic', ['memberUserId' => $memberUserId]); } public static function getByAlias($alias) { return ModelUtil::get('topic', ['alias' => $alias]); } public static function get($id) { return ModelUtil::get('topic', ['id' => $id]); } public static function isFollowed($followerMemberUserId, $topicId) { if (ModelUtil::exists('topic_follower', [ 'followerMemberUserId' => $followerMemberUserId, 'topicId' => $topicId, ]) ) { return true; } else { return false; } } private static function updateFollowStat($topicId) { $followerCount = ModelUtil::count('topic_follower', ['topicId' => $topicId]); ModelUtil::update('topic', ['id' => $topicId], ['followerCount' => $followerCount]); } public static function follow($followerMemberUserId, $topicId) { $data = [ 'followerMemberUserId' => $followerMemberUserId, 'topicId' => $topicId, ]; if (!ModelUtil::exists('topic_follower', $data)) { ModelUtil::insert('topic_follower', $data); self::updateFollowStat($topicId); } } public static function unfollow($followerMemberUserId, $topicId) { $data = [ 'followerMemberUserId' => $followerMemberUserId, 'topicId' => $topicId, ]; ModelUtil::delete('topic_follower', $data); self::updateFollowStat($topicId); } public static function mergeHasNote(&$topics, $noteId) { if (empty($topics)) { return; } $topicIds = array_pluck($topics, 'id');; $topicNotes = ModelUtil::model('topic_note') ->whereIn('topicId', $topicIds) ->where('noteId', $noteId) ->get()->toArray(); $topicIds = array_pluck($topicNotes, 'topicId'); $map = array_fill_keys($topicIds, true); foreach ($topics as &$topic) { if (empty($map[$topic['id']])) { $topic['_hasNote'] = false; } else { $topic['_hasNote'] = true; } } } public static function mergeIsInTopic(&$notes, $topicId) { if (empty($notes)) { return; } $noteIds = []; foreach ($notes as $note) { $noteIds[] = $note['id']; } $topicNotes = ModelUtil::model('topic_note') ->whereIn('noteId', $noteIds) ->where('topicId', $topicId) ->where('isDeleted', false) ->get()->toArray(); $map = []; foreach ($topicNotes as $topicNote) { $map[$topicNote['noteId']] = true; } foreach ($notes as &$note) { if (empty($map[$note['id']])) { $note['_isInTopic'] = false; } else { $note['_isInTopic'] = true; } } } public static function mergeIsInTopicApply(&$notes, $topicId) { if (empty($notes)) { return; } $topicNotes = ModelUtil::model('topic_note_apply') ->whereIn('noteId', array_pluck($notes, 'id')) ->where('topicId', $topicId) ->get()->toArray(); $noteIds = array_pluck($topicNotes, 'noteId'); $map = array_fill_keys($noteIds, true); foreach ($notes as &$note) { if (empty($map[$note['id']])) { $note['_isInTopicApply'] = false; } else { $note['_isInTopicApply'] = true; } } } private static function updateNoteStat($topicId) { $noteCount = ModelUtil::count('topic_note', ['topicId' => $topicId, 'isDeleted' => false,]); ModelUtil::update('topic', ['id' => $topicId], ['noteCount' => $noteCount]); } public static function addNote($topicId, $noteId) { $data = ['topicId' => $topicId, 'noteId' => $noteId]; if (!ModelUtil::exists('topic_note', $data)) { $data['isDeleted'] = false; ModelUtil::insert('topic_note', $data); self::updateNoteStat($topicId); } } public static function removeNote($topicId, $noteId) { $data = ['topicId' => $topicId, 'noteId' => $noteId]; ModelUtil::delete('topic_note', $data); self::updateNoteStat($topicId); } public static function addNoteApply($topicId, $noteId) { $data = ['topicId' => $topicId, 'noteId' => $noteId]; if (!ModelUtil::exists('topic_note_apply', $data)) { ModelUtil::insert('topic_note_apply', $data); } } public static function removeNoteApply($topicId, $noteId) { $data = ['topicId' => $topicId, 'noteId' => $noteId]; ModelUtil::delete('topic_note_apply', $data); } public static function paginateTopicNoteApplies($topicId, $page, $pageSize, $option = []) { $option['where']['topicId'] = $topicId; $paginateData = ModelUtil::paginate('topic_note_apply', $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'noteId', '_note', 'note', 'id'); $notes = []; foreach ($paginateData['records'] as $item) { if(empty($item)){ } $notes[] = $item['_note']; } $paginateData['records'] = $notes; return $paginateData; } public static function paginateTopicNotes($topicId, $page, $pageSize, $option = []) { $option['where']['topicId'] = $topicId; $option['where']['isDeleted'] = false; $paginateData = ModelUtil::paginate('topic_note', $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'noteId', '_note', 'note', 'id'); $notes = []; foreach ($paginateData['records'] as $item) { if (empty($item['_note'])) { ModelUtil::delete('topic_note', ['id' => $item['id']]); } $notes[] = $item['_note']; } foreach ($notes as &$note) { $d = HtmlUtil::extractTextAndImages($note['contentHtml']); $note['_summary'] = Str::limit($d['text'], 200); $note['_cover'] = (empty($d['images'][0]) ? null : $d['images'][0]); } $paginateData['records'] = $notes; return $paginateData; } public static function paginateLatestTopicsNotes($topicIds, $page, $pageSize, $option = []) { $option['whereIn'] = ['topicId', $topicIds];; $option['where']['isDeleted'] = false; $option['order'] = ['id', 'desc']; $paginateData = ModelUtil::paginate('topic_note', $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'noteId', '_note', 'note', 'id'); $notes = []; foreach ($paginateData['records'] as $item) { if (empty($item['_note'])) { ModelUtil::delete('topic_note', ['id' => $item['id']]); } $notes[] = $item['_note']; } foreach ($notes as &$note) { $d = HtmlUtil::extractTextAndImages($note['contentHtml']); $note['_summary'] = Str::limit($d['text'], 200); $note['_cover'] = (empty($d['images'][0]) ? null : $d['images'][0]); } $paginateData['records'] = $notes; return $paginateData; } public static function paginateTopicsNotes($topicIds, $page, $pageSize, $option = []) { $option['whereIn'] = ['topicId', $topicIds]; $option['where']['note.isDeleted'] = false; $option['joins'] = [ [ 'table' => ['topic_note', 'topic_note.noteId', '=', 'note.id'], 'fields' => [ 'topicId' => 'topic_note.topicId', ] ] ]; $paginateData = ModelUtil::paginate('note', $page, $pageSize, $option); foreach ($paginateData['records'] as &$note) { $d = HtmlUtil::extractTextAndImages($note['contentHtml']); $note['_summary'] = Str::limit($d['text'], 200); $note['_cover'] = (empty($d['images'][0]) ? null : $d['images'][0]); } return $paginateData; } public static function paginateFollowerMemberUsers($topicId, $page, $pageSize, $option = []) { $option['where']['topicId'] = $topicId; $paginateData = ModelUtil::paginate('topic_follower', $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'followerMemberUserId', '_followerMemberUser', 'member_user', 'id'); $memberUsers = []; foreach ($paginateData['records'] as $item) { $memberUsers[] = $item['_followerMemberUser']; } $paginateData['records'] = $memberUsers; return $paginateData; } public static function paginateMemberUserFollowedTopics($followerMemberUserId, $page, $pageSize, $option = []) { $option['where']['followerMemberUserId'] = $followerMemberUserId; $paginateData = ModelUtil::paginate('topic_follower', $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'topicId', '_topic', 'topic', 'id'); $topics = []; foreach ($paginateData['records'] as $item) { $topics[] = $item['_topic']; } $paginateData['records'] = $topics; return $paginateData; } public static function paginateTopics($page, $pageSize, $option = []) { $paginateData = ModelUtil::paginate('topic', $page, $pageSize, $option); return $paginateData; } public static function paginateMemberUserTopics($memberUserId, $page, $pageSize, $option = []) { $option['where']['memberUserId'] = $memberUserId; $paginateData = ModelUtil::paginate('topic', $page, $pageSize, $option); return $paginateData; } public static function mergeIsFollowed(&$topics, $memberUserId) { if (empty($topics)) { return; } if (!$memberUserId) { foreach ($topics as &$topic) { $topic['_isFollowed'] = false; } return; } $topicIds = []; foreach ($topics as $topic) { $topicIds[] = $topic['id']; } $memberFollowers = ModelUtil::model('topic_follower')->where([ 'followerMemberUserId' => $memberUserId ])->whereIn('topicId', $topicIds)->get()->toArray(); $map = []; foreach ($memberFollowers as $memberFollower) { $map[$memberFollower['topicId']] = true; } foreach ($topics as &$topic) { if (empty($map[$topic['id']])) { $topic['_isFollowed'] = false; } else { $topic['_isFollowed'] = true; } } } public static function getFollowedTopicIds($memberUserId) { $topicsFollowers = ModelUtil::all('topic_follower', ['followerMemberUserId' => $memberUserId]); return array_pluck($topicsFollowers, 'topicId'); } }