<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMemberUser extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_user', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->string('username', 50)->nullable()->comment('用户名');
            $table->string('phone', 20)->nullable()->comment('手机');
            $table->string('email', 200)->nullable()->comment('邮箱');
            $table->char('password', 32)->nullable()->comment('密码');
            $table->char('passwordSalt', 16)->nullable()->comment('密码Salt');
            $table->timestamp('lastLoginTime')->nullable()->comment('上次登录时间');
            $table->string('lastLoginIp', 20)->nullable()->comment('上次登录Ip');
            $table->boolean('phoneVerified')->nullable()->comment('手机已验证');
            $table->boolean('emailVerified')->nullable()->comment('邮箱已验证');

            $table->string('avatar', 100)->nullable()->comment('头像(小)');
            $table->string('avatarMedium', 100)->nullable()->comment('头像(中)');
            $table->string('avatarBig', 100)->nullable()->comment('头像(大)');

            //TODO 实际使用过程中按照需要再继续增删字段

            $table->integer('followerCount')->nullable()->comment('粉丝数');
            $table->integer('followCount')->nullable()->comment('关注数');

            $table->integer('noteCount')->nullable()->comment('文章数');
            $table->integer('wordCount')->nullable()->comment('文字数');

            $table->integer('newMessageCount')->nullable()->comment('新消息数');
            $table->integer('newChatMsgCount')->nullable()->comment('新消息数');

            /** @see \TechSoft\Laravel\Html\HtmlType */
            $table->tinyInteger('noteEditorType')->nullable()->comment('编辑器类型');

            /** @see \TechSoft\Laravel\Member\Type\Gender */
            $table->tinyInteger('gender')->nullable()->comment('性别');
            $table->string('signature', 400)->nullable()->comment('签名');

            // 这两个字段需要手动创建

            $table->tinyInteger('tipEnable')->nullable()->comment('打赏功能');
            $table->decimal('defaultTipValue', 20, 2)->nullable()->comment('默认打赏金额');

            $table->index('username');
            $table->index('phone');
            $table->index('email');

        });

        $DB_PREFIX = config('env.DB_PREFIX');
        \Illuminate\Support\Facades\DB::statement("ALTER TABLE ${DB_PREFIX}member_user AUTO_INCREMENT = 100000;");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
