<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMemberChat extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_chat', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('memberUserId')->nullable()->comment('用户ID');
            $table->integer('chatMemberUserId')->nullable()->comment('聊天用户ID');

            $table->integer('msgCount')->nullable()->comment('条数');
            $table->integer('unreadMsgCount')->nullable()->comment('未读消息条数');

            $table->integer('lastMsgId')->nullable()->comment('最近对话ID');

            $table->unique(['memberUserId', 'chatMemberUserId']);

        });

        Schema::create('member_chat_msg', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('chatId')->nullable()->comment('对话ID');
            $table->integer('senderMemberUserId')->nullable()->comment('发送者ID');
            $table->tinyInteger('isRead')->nullable()->comment('已读');
            /** @see \TechSoft\Laravel\MemberChat\Type\MemberChatMsgType */
            $table->tinyInteger('type')->nullable()->comment('类型');
            $table->string('content', 400)->nullable()->comment('对话内容');

            $table->index(['chatId']);

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
