<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMemberFollower extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_follower', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('memberUserId')->nullable()->comment('用户ID');
            $table->integer('followerMemberUserId')->nullable()->comment('用户ID');

            //意思是 followerMemberUserId 关注了 memberUserId

            $table->index(['memberUserId', 'followerMemberUserId']);
            $table->index(['followerMemberUserId', 'memberUserId']);
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
