<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMemberNote extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_note_category', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('memberUserId')->nullable()->comment('用户ID');
            $table->string('title', 100)->nullable()->comment('文章分类');

            $table->index(['memberUserId']);
        });

        Schema::create('member_note', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('memberUserId')->nullable()->comment('用户ID');
            $table->integer('categoryId')->nullable()->comment('分类');
            $table->string('title', 200)->nullable()->comment('标题');

            $table->tinyInteger('isPublished')->nullable()->comment('已发布');

            /** @see \TechSoft\Laravel\Html\HtmlType */
            $table->tinyInteger('contentType')->nullable()->comment('类型');
            $table->text('content')->nullable()->comment('内容');

            $table->index(['memberUserId']);
            $table->index(['categoryId']);
        });

        Schema::create('member_note_history', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('memberNoteId')->nullable()->comment('文章');

            $table->string('title', 200)->nullable()->comment('标题');
            $table->text('content')->nullable()->comment('内容');

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
