<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNote extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('note', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->string('alias', 16)->nullable()->comment('Alias');

            $table->integer('memberUserId')->nullable()->comment('用户');
            $table->integer('memberNoteId')->nullable()->comment('用户文章');

            $table->integer('wordCount')->nullable()->comment('文字数');
            $table->integer('viewCount')->nullable()->comment('阅读数');

            $table->integer('commentCount')->nullable()->comment('评论数');
            $table->integer('likeCount')->nullable()->comment('喜欢数');

            $table->string('title', 200)->nullable()->comment('标题');
            $table->text('contentHtml')->nullable()->comment('内容');

            $table->tinyInteger('isDeleted')->nullable()->comment('已删除');

            $table->unique(['alias']);
            $table->index(['memberUserId']);
            $table->unique(['memberNoteId']);
        });

        Schema::create('note_like', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('noteId')->nullable()->comment('文章');
            $table->integer('memberUserId')->nullable()->comment('用户');

            $table->tinyInteger('isDeleted')->nullable()->comment('已删除');

            $table->unique(['noteId', 'memberUserId']);
            $table->index(['memberUserId']);

        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
